/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.sun.identity.authentication.spi.AMAuthCallBackImpl;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.authentication.spi.UserNamePasswordValidationException;
import com.sun.identity.sm.ServiceConfig;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class LDAP
extends AMLoginModule {
    private static HashMap orgMap = new HashMap();
    private static final long DEFAULT_SERVER_CHECK_INTERVAL = 15L;
    private static final String USER_CREATION_ATTR = "iplanet-am-ldap-user-creation-attr-list";
    private static final String INVALID_CHARS = "iplanet-am-auth-ldap-invalid-chars";
    private static final String PIPE_SEPARATOR = "|";
    private static boolean ldapSSL = false;
    ResourceBundle bundle = null;
    protected String validatedUserID;
    private String userName;
    private String userPassword;
    private String regEx;
    private String currentConfigName;
    private Iterator subConfigNamesIter = null;
    private ServiceConfig sc;
    private boolean firstTry = true;
    private int currentState;
    private boolean primary = true;
    private int previousScreen;
    private final int PASSWORD_CHANGE = 2;
    private final int PASSWORD_EXPIRED_SCREEN = 3;
    private final int USER_INACTIVE = 4;
    private LDAPAuthUtils ldapUtil;
    private volatile FailbackManager fMgr;
    private boolean isReset;
    private int primaryServerPort;
    private String primaryServerHost;
    private boolean isProfileCreationEnabled;
    private boolean getCredentialsFromSharedState;
    private AMAuthCallBackImpl callbackImpl = null;
    private long interval = 15L;
    private Set userCreationAttrs = new HashSet();
    private HashMap userAttrMap = new HashMap();
    private Map sharedState;
    public Map currentConfig;
    protected Debug debug = Debug.getInstance((String)this.amAuthLDAP);
    protected String amAuthLDAP = "amAuthLDAP";
    protected Principal userPrincipal;

    public void init(Subject subject, Map map, Map map2) {
        this.sc = (ServiceConfig)map2.get("ServiceConfig");
        this.currentConfig = map2;
        this.currentConfigName = (String)map2.get("moduleInstanceName");
        this.primary = this.getPrimaryFlag(this.currentConfigName);
        java.util.Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(this.amAuthLDAP, locale);
        if (this.debug.messageEnabled()) {
            this.debug.message("LDAP resbundle locale=" + locale);
        }
        this.sharedState = map;
        if (this.debug.messageEnabled()) {
            this.debug.message("Host: " + AuthD.directoryHostName + "\nPORT : " + AuthD.directoryPort);
        }
    }

    public boolean initializeLDAP() throws AuthLoginException {
        block22: {
            this.debug.message("LDAP initialize()");
            String string = null;
            try {
                String string2;
                if (this.currentConfig == null) break block22;
                try {
                    string2 = "iplanet-am-auth-ldap-server-check";
                    this.interval = Long.parseLong(Misc.getServerMapAttr((Map)this.currentConfig, (String)string2));
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("Server Check Interval is not set.\nSetting it to default value 15 min");
                    }
                    this.interval = 15L;
                }
                this.setInterval(this.interval);
                if (this.primary) {
                    if (this.fMgr != null && this.fMgr.isAlive()) {
                        this.fMgr = null;
                    }
                    if ((string = Misc.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server")) == null) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("No primary server for confing " + this.currentConfigName);
                        }
                        return false;
                    }
                } else {
                    string = Misc.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server2");
                    if (string == null) {
                        if (this.debug.messageEnabled()) {
                            this.debug.message("No secondary server for confing " + this.currentConfigName);
                        }
                        return false;
                    }
                }
                if ((string2 = Misc.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-base-dn")) == null) {
                    this.debug.error("BaseDN for search is invalid: " + string2);
                }
                String string3 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-dn", (String)"");
                String string4 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-passwd", (String)"");
                String string5 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-user-naming-attribute", (String)"uid");
                Set set = (Set)this.currentConfig.get("iplanet-am-auth-ldap-user-search-attributes");
                String string6 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-filter", (String)"");
                boolean bl = Boolean.valueOf(Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-ssl-enabled", (String)"false"));
                this.getUserCreationAttrs(this.currentConfig);
                String string7 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-scope", (String)"SUBTREE");
                String string8 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-auth-level");
                if (string8 != null) {
                    try {
                        this.setAuthLevel(Integer.parseInt(string8));
                    }
                    catch (Exception exception) {
                        this.debug.error("Unable to set auth level " + string8);
                    }
                }
                int n = 2;
                if (string7.equalsIgnoreCase("OBJECT")) {
                    n = 0;
                } else if (string7.equalsIgnoreCase("ONELEVEL")) {
                    n = 1;
                }
                String string9 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-return-user-dn", (String)"true");
                this.regEx = Misc.getMapAttr((Map)this.currentConfig, (String)INVALID_CHARS);
                int n2 = string.indexOf(58);
                int n3 = 389;
                if (n2 != -1) {
                    n3 = Integer.parseInt(string.substring(n2 + 1));
                    string = string.substring(0, n2);
                }
                if (this.primary) {
                    this.primaryServerHost = string;
                    this.primaryServerPort = n3;
                }
                this.isProfileCreationEnabled = this.isDynamicProfileCreationEnabled();
                this.ldapUtil = new LDAPAuthUtils(string, n3, bl, this.bundle, string2, this.debug);
                this.ldapUtil.setScope(n);
                this.ldapUtil.setFilter(string6);
                this.ldapUtil.setUserNamingAttribute(string5);
                this.ldapUtil.setUserSearchAttribute(set);
                this.ldapUtil.setAuthPassword(string4);
                this.ldapUtil.setAuthDN(string3);
                this.ldapUtil.setReturnUserDN(string9);
                this.ldapUtil.setUserAttributes(this.userCreationAttrs);
                this.ldapUtil.setDynamicProfileCreationEnabled(this.isProfileCreationEnabled);
                if (this.debug.messageEnabled()) {
                    this.debug.message("bindDN-> " + string3 + "\nbaseDN-> " + string2 + "\nuserNamingAttr-> " + string5 + "\nuserSearchAttr(s)-> " + set + "\nuserCreationAttrs-> " + this.userCreationAttrs + "\nsearchFilter-> " + string6 + "\nsearchScope-> " + n + "\nssl-> " + bl + "\nauthLevel: " + string8 + "\nHost: " + string + "\nPORT : " + n3 + "\nPattern : " + this.regEx);
                }
                return true;
            }
            catch (Exception exception) {
                this.debug.error("Init Exception", (Throwable)exception);
                throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null, exception);
            }
        }
        return false;
    }

    private boolean getPrimaryFlag(String string) {
        HashMap hashMap = orgMap;
        synchronized (hashMap) {
            String string2 = this.getRequestOrg();
            HashMap<String, String> hashMap2 = (HashMap<String, String>)orgMap.get(string2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, String>();
                hashMap2.put(string, "true");
                orgMap.put(string2, hashMap2);
                boolean bl = true;
                return bl;
            }
            String string3 = (String)hashMap2.get(string);
            if (string3 == null) {
                hashMap2.put(string, "true");
                boolean bl = true;
                return bl;
            }
            boolean bl = string3.equals("true");
            return bl;
        }
    }

    private void setPrimaryFlag(String string, boolean bl) {
        HashMap hashMap = orgMap;
        synchronized (hashMap) {
            String string2 = this.getRequestOrg();
            HashMap<String, String> hashMap2 = (HashMap<String, String>)orgMap.get(string2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, String>();
                orgMap.put(string2, hashMap2);
            }
            if (bl) {
                hashMap2.put(string, "true");
            } else {
                hashMap2.put(string, "false");
            }
        }
    }

    private boolean getSubConfig() {
        block7: {
            this.firstTry = true;
            try {
                Object object;
                if (this.subConfigNamesIter == null && this.sc != null) {
                    object = this.sc.getSubConfigNames();
                    if (object == null || object.size() == 0) {
                        return false;
                    }
                    this.subConfigNamesIter = object.iterator();
                }
                if (this.subConfigNamesIter != null) {
                    while (this.subConfigNamesIter.hasNext()) {
                        object = (String)this.subConfigNamesIter.next();
                        ServiceConfig serviceConfig = this.sc.getSubConfig((String)object);
                        if (serviceConfig == null) continue;
                        if (this.debug.messageEnabled()) {
                            this.debug.message("LDAP.getSubConfig subConfigName = " + (String)object);
                        }
                        this.currentConfig = serviceConfig.getAttributes();
                        this.currentConfigName = object;
                        this.primary = this.getPrimaryFlag((String)object);
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                if (!this.debug.warningEnabled()) break block7;
                this.debug.warning("LDAP.getSubConfig unable to get sub config", (Throwable)exception);
            }
        }
        return false;
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        this.currentState = n;
        int n2 = 0;
        try {
            if (this.currentState == 1) {
                if (callbackArray != null && callbackArray.length == 0) {
                    this.userName = (String)this.sharedState.get(this.getUserKey());
                    this.userPassword = (String)this.sharedState.get(this.getPwdKey());
                    if (this.userName == null || this.userPassword == null) {
                        return 1;
                    }
                    this.getCredentialsFromSharedState = true;
                } else {
                    this.userName = ((NameCallback)callbackArray[0]).getName();
                    this.userPassword = this.charToString(((PasswordCallback)callbackArray[1]).getPassword(), callbackArray[1]);
                }
                this.storeUsernamePasswd(this.userName, this.userPassword);
                if (this.isSuperAdmin(this.userName)) {
                    this.ldapUtil = new LDAPAuthUtils(AuthD.directoryHostName, AuthD.directoryPort, ldapSSL, this.bundle, this.debug);
                    this.ldapUtil.authenticateSuperAdmin(this.userName, this.userPassword);
                    if (this.ldapUtil.getState() == 26) {
                        this.validatedUserID = this.userName;
                        return -1;
                    }
                    this.debug.message("Invalid adminID or admin Password");
                    this.setFailureID(this.ldapUtil.getUserId(this.userName));
                    throw new AuthLoginException(this.amAuthLDAP, "InvalidUP", null);
                }
                if (this.initializeLDAP()) {
                    this.validateUserName(this.userName, this.regEx);
                    this.validatePassword(this.userPassword);
                    this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                    n2 = this.ldapUtil.getState();
                } else {
                    n2 = 31;
                }
                this.processLoginScreen(n2);
                return this.currentState;
            }
            if (this.currentState == 2) {
                int n3;
                if (this.debug.messageEnabled()) {
                    this.debug.message("you are in PWd Screen:" + this.currentState);
                }
                if ((n3 = ((ConfirmationCallback)callbackArray[3]).getSelectedIndex()) == 0) {
                    String string = this.charToString(((PasswordCallback)callbackArray[0]).getPassword(), callbackArray[0]);
                    String string2 = this.charToString(((PasswordCallback)callbackArray[1]).getPassword(), callbackArray[1]);
                    String string3 = this.charToString(((PasswordCallback)callbackArray[2]).getPassword(), callbackArray[2]);
                    this.validatePassword(string2);
                    this.ldapUtil.changePassword(string, string2, string3);
                    n2 = this.ldapUtil.getState();
                    this.processPasswordScreen(n2);
                    if (this.debug.messageEnabled()) {
                        this.debug.message("Password change state :" + n2);
                    }
                    return this.currentState;
                }
                if (this.isReset) {
                    this.isReset = false;
                    return 1;
                }
                this.validatedUserID = this.ldapUtil.getUserId();
                return -1;
            }
            this.setFailureID(this.ldapUtil.getUserId(this.userName));
            throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
        }
        catch (LDAPUtilException lDAPUtilException) {
            if (this.getCredentialsFromSharedState) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            this.setFailureID(this.ldapUtil.getUserId(this.userName));
            switch (lDAPUtilException.getLDAPResultCode()) {
                case 32: {
                    this.debug.message("The specified user does not exist.");
                    throw new AuthLoginException(this.amAuthLDAP, "NoUser", null);
                }
                case 49: {
                    this.debug.message("Invalid password.");
                    String string = this.ldapUtil.getUserId();
                    throw new InvalidPasswordException(this.amAuthLDAP, "InvalidUP", null, string, null);
                }
                case 53: {
                    this.debug.message("Unwilling to perform. Account inactivated.");
                    this.currentState = 4;
                    return this.currentState;
                }
                case 48: {
                    this.debug.message("Inappropriate authentication.");
                    throw new AuthLoginException(this.amAuthLDAP, "InappAuth", null);
                }
            }
            throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
        }
        catch (UserNamePasswordValidationException userNamePasswordValidationException) {
            this.debug.message("Invalid Characters detected");
            throw new AuthLoginException(userNamePasswordValidationException);
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new LDAPPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.validatedUserID = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.userName = null;
        this.userPassword = null;
        this.regEx = null;
        this.subConfigNamesIter = null;
        this.sc = null;
        this.fMgr = null;
        this.userCreationAttrs = null;
        this.userAttrMap = null;
        this.sharedState = null;
        this.currentConfig = null;
        this.amAuthLDAP = null;
    }

    private void processLoginScreen(int n) throws AuthLoginException {
        try {
            switch (n) {
                case 26: {
                    this.validatedUserID = this.ldapUtil.getUserId();
                    if (this.isProfileCreationEnabled && this.userCreationAttrs.size() > 0) {
                        Map map = this.ldapUtil.getUserAttributeValues();
                        if (this.debug.messageEnabled()) {
                            this.debug.message("user creation attributes: " + map);
                        }
                        Map map2 = this.getAttributeMap(map);
                        this.setUserAttributes(map2);
                    }
                    this.currentState = -1;
                    break;
                }
                case 21: {
                    String string = this.bundle.getString("PasswordExp");
                    String string2 = Locale.formatMessage((String)string, (Object)this.ldapUtil.getExpTime());
                    this.replaceHeader(2, string2);
                    this.currentState = 2;
                    break;
                }
                case 32: {
                    this.isReset = true;
                    String string = this.bundle.getString("PasswordReset");
                    this.replaceHeader(2, string);
                    this.currentState = 2;
                    break;
                }
                case 20: {
                    this.currentState = 3;
                    break;
                }
                case 1: {
                    if (!this.getSubConfig()) {
                        throw new LDAPUtilException("noUserMatchFound", null);
                    }
                    if (this.initializeLDAP()) {
                        this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                        n = this.ldapUtil.getState();
                    } else {
                        n = 31;
                    }
                    this.processLoginScreen(n);
                    break;
                }
                case 31: {
                    if (this.firstTry) {
                        this.firstTry = false;
                        this.primary = !this.primary;
                        this.setPrimaryFlag(this.currentConfigName, this.primary);
                        if (this.fMgr == null || !this.fMgr.isAlive()) {
                            this.fMgr = new FailbackManager();
                        }
                        this.fMgr.start();
                        if (this.initializeLDAP()) {
                            this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                            n = this.ldapUtil.getState();
                            this.processLoginScreen(n);
                            break;
                        }
                    }
                    if (!this.getSubConfig()) {
                        throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
                    }
                    if (this.initializeLDAP()) {
                        this.ldapUtil.authenticateUser(this.userName, this.userPassword);
                        n = this.ldapUtil.getState();
                    } else {
                        n = 31;
                    }
                    this.processLoginScreen(n);
                }
            }
        }
        catch (LDAPUtilException lDAPUtilException) {
            if (this.getCredentialsFromSharedState) {
                this.getCredentialsFromSharedState = false;
                this.currentState = 1;
                return;
            }
            if (n != 1) {
                this.debug.error("Unknown Login State:", (Throwable)((Object)lDAPUtilException));
            }
            throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null, (Throwable)((Object)lDAPUtilException));
        }
    }

    private void processPasswordScreen(int n) throws AuthLoginException {
        switch (n) {
            case 28: {
                this.validatedUserID = this.ldapUtil.getUserId();
                this.currentState = -1;
                try {
                    this.callbackImpl = AMAuthCallBackImpl.getInstance(this.getRequestOrg());
                    Long l = new Long(System.currentTimeMillis());
                    this.callbackImpl.processedPasswordChange(l, this.validatedUserID);
                }
                catch (AMAuthCallBackException aMAuthCallBackException) {
                    if (!this.debug.errorEnabled()) break;
                    this.debug.error("process : unable to get AMAuthCallBackImpl instance or callback module raised an exception.", (Throwable)((Object)aMAuthCallBackException));
                }
                break;
            }
            case 25: {
                this.replaceHeader(2, this.bundle.getString("PInvalid"));
                this.currentState = 2;
                break;
            }
            case 23: {
                this.replaceHeader(2, this.bundle.getString("PasswdMismatch"));
                this.currentState = 2;
                break;
            }
            case 24: {
                this.replaceHeader(2, this.bundle.getString("UPSame"));
                this.currentState = 2;
                break;
            }
            case 27: {
                this.replaceHeader(2, this.bundle.getString("PasswdSame"));
                this.currentState = 2;
                break;
            }
            case 30: {
                this.replaceHeader(2, this.bundle.getString("PasswdMinChars"));
                this.currentState = 2;
                break;
            }
            case 29: {
                this.replaceHeader(2, this.bundle.getString("UPsame"));
                this.currentState = 2;
                break;
            }
        }
    }

    private String charToString(char[] cArray, Callback callback) {
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callback).clearPassword();
        return new String(cArray2);
    }

    private void setReplaceText(int n, int n2, String string) throws AuthLoginException {
        this.debug.message("Entered in setReplaceText");
        Callback[] callbackArray = this.getCallback(2);
        this.resetCallback(n, 0);
        String string2 = ((PasswordCallback)callbackArray[0]).getPrompt();
        int n3 = string2.indexOf("#REPLACE#");
        String string3 = string + string2.substring(n3 + 9);
        this.replaceCallback(n, 0, new PasswordCallback(string3, ((PasswordCallback)callbackArray[0]).isEchoOn()));
        if (this.debug.messageEnabled()) {
            this.debug.message("origmessage:" + string2 + ":::+setMsg" + string3);
        }
    }

    private void setInterval(long l) {
        this.interval = l * 60000L;
    }

    private void getUserCreationAttrs(Map map) {
        Set set = (Set)map.get(USER_CREATION_ATTR);
        if (this.debug.messageEnabled()) {
            this.debug.message("attrs is : " + set);
        }
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = string.indexOf(PIPE_SEPARATOR);
                if (n != -1) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1, string.length());
                    if (string3 == null || string3.equals("")) {
                        this.userCreationAttrs.add(string2);
                        this.userAttrMap.put(string2, string2);
                        continue;
                    }
                    this.userCreationAttrs.add(string3);
                    this.userAttrMap.put(string2, string3);
                    continue;
                }
                this.userCreationAttrs.add(string);
                this.userAttrMap.put(string, string);
            }
        }
    }

    private Map getAttributeMap(Map map) {
        if (this.debug.messageEnabled()) {
            this.debug.message("In getAttribute Map: " + map);
        }
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        Iterator iterator = this.userAttrMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.userAttrMap.get(string);
            Set set = (Set)map.get(string2);
            if (this.debug.messageEnabled()) {
                this.debug.message("key is : " + string);
                this.debug.message("value is : " + set);
            }
            if (set == null) continue;
            hashMap.put(string, set);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("New attr map is : " + hashMap);
        }
        return hashMap;
    }

    static {
        ldapSSL = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.directory.ssl.enabled", (String)"false"));
    }

    class FailbackManager
    extends Thread {
        public void run() {
            Thread thread = Thread.currentThread();
            while (!LDAP.this.primary) {
                try {
                    if (LDAP.this.ldapUtil.isServerRunning(LDAP.this.primaryServerHost, LDAP.this.primaryServerPort)) {
                        LDAP.this.debug.message("primary is up");
                        LDAP.this.primary = true;
                        LDAP.this.setPrimaryFlag(LDAP.this.currentConfigName, LDAP.this.primary);
                        LDAP.this.fMgr = null;
                        continue;
                    }
                    Thread.sleep(LDAP.this.interval);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    if (!LDAP.this.debug.messageEnabled()) continue;
                    LDAP.this.debug.message("Primary server checking failed", (Throwable)exception);
                }
            }
        }
    }
}

