/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ad;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.modules.ad.ADPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAP;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.security.Principal;
import java.util.Map;

public class AD
extends LDAP {
    private ADPrincipal userPrincipal;

    public AD() {
        this.amAuthLDAP = "amAuthAD";
        this.debug = Debug.getInstance((String)this.amAuthLDAP);
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new ADPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        super.destroyModuleState();
        this.userPrincipal = null;
    }

    public boolean initializeLDAP() throws AuthLoginException {
        boolean bl = super.initializeLDAP();
        String string = Misc.getMapAttr((Map)this.currentConfig, (String)AMAuthConfigUtils.getAuthLevelAttribute(this.currentConfig, "AD"));
        if (string != null) {
            try {
                this.setAuthLevel(Integer.parseInt(string));
            }
            catch (Exception exception) {
                this.debug.error("Unable to set auth level " + string);
            }
        }
        return bl;
    }
}

