/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.AuthLoginThread;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.AuthSSOToken;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.authentication.internal.LoginContext;
import com.sun.identity.authentication.internal.server.AuthSPrincipal;
import com.sun.identity.authentication.internal.util.AuthI18n;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.login.LoginException;
import netscape.ldap.util.DN;

public final class AuthContext {
    public static final int AUTH_NOT_STARTED = 1;
    public static final int AUTH_IN_PROGRESS = 2;
    public static final int AUTH_SUCCESS = 3;
    public static final int AUTH_FAILED = 4;
    public static final int AUTH_COMPLETED = 5;
    protected final String authComponentName = "Authentication";
    protected static final String authKeyName = "authContext";
    protected static final String authDebugName = "amAuthInternal";
    protected static Debug authDebug = Debug.getInstance((String)"amAuthInternal");
    protected String organizationName = null;
    protected String applicationName = null;
    protected int loginStatus;
    protected LoginException loginException;
    protected Callback[] informationRequired;
    protected Callback[] submittedInformation;
    protected AuthLoginThread loginThread;
    protected LoginContext loginContext;
    protected SSOToken token;
    protected static I18n myAuthI18n = AuthI18n.authI18n;
    private static boolean isEnableHostLookUp = Boolean.valueOf(SystemProperties.get((String)"com.sun.am.session.enableHostLookUp"));

    public AuthContext() throws LoginException {
        this("");
    }

    public AuthContext(Principal principal, char[] cArray) throws LoginException {
        this(null, principal, cArray);
    }

    public AuthContext(Principal principal, char[] cArray, String string, int n) throws LoginException {
        this("ldap://" + string + ":" + n, principal, cArray);
    }

    public AuthContext(String string, Principal principal, char[] cArray) throws LoginException {
        if (principal == null) {
            throw new LoginException(myAuthI18n.getString("com.iplanet.auth.invalid-username"));
        }
        if (cArray == null) {
            throw new LoginException(myAuthI18n.getString("com.iplanet.auth.invalid-password"));
        }
        AuthSubject authSubject = new AuthSubject();
        authSubject.getPrincipals().add(principal);
        if (string != null) {
            this.organizationName = string;
        }
        this.reset(authSubject);
        this.loginContext.updateSharedState(principal.getName(), cArray);
        boolean bl = false;
        boolean bl2 = false;
        if (authDebug.messageEnabled()) {
            authDebug.message("Instantiated AuthContext with parameters organization name: " + this.organizationName + "; " + (principal == null ? "principal is null" : "principal: ") + principal + "; " + (cArray.length == 0 ? "password is empty\n" : "password present\n"));
        }
        this.startLogin();
        while (this.hasMoreRequirements()) {
            authDebug.message("AuthContext::init() Has requirements");
            Callback[] callbackArray = this.getRequirements();
            int n = 0;
            while (n < callbackArray.length) {
                Callback callback;
                if (callbackArray[n] instanceof NameCallback) {
                    authDebug.message("Got NameCallback");
                    callback = (NameCallback)callbackArray[n];
                    Set set = authSubject.getPrincipals();
                    AuthSPrincipal[] authSPrincipalArray = set.toArray(new AuthSPrincipal[0]);
                    if (authSPrincipalArray.length == 1) {
                        ((NameCallback)callback).setName(authSPrincipalArray[0].getName());
                        authDebug.message("Set namecallback name = " + authSPrincipalArray[0].getName());
                        bl = true;
                    }
                } else if (callbackArray[n] instanceof PasswordCallback) {
                    authDebug.message("Got PasswordCallback");
                    callback = (PasswordCallback)callbackArray[n];
                    ((PasswordCallback)callback).setPassword(cArray);
                    bl2 = true;
                } else if (callbackArray[n] instanceof TextOutputCallback) {
                    authDebug.message("AuthContext::init() Got TextOutputCallback");
                } else if (callbackArray[n] instanceof TextInputCallback) {
                    authDebug.message("AuthContext::init() Got TextInputCallback");
                } else if (callbackArray[n] instanceof ChoiceCallback) {
                    authDebug.message("AuthContext::init() Got ChoiceCallback");
                    callback = (ChoiceCallback)callbackArray[n];
                    ((ChoiceCallback)callback).setSelectedIndex(0);
                } else {
                    authDebug.message("AuthContext::init() Got Unknown Callback");
                }
                ++n;
            }
            this.submitRequiredInformation(callbackArray);
        }
        if (authDebug.messageEnabled() && bl && bl2) {
            authDebug.message("AuthContext::init() Got name and password callbacks");
        }
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContext::init() Login status: " + this.getLoginStatus());
        }
        if (this.getLoginStatus() == 4) {
            throw this.getLoginException();
        }
    }

    protected AuthContext(String string, AuthSubject authSubject) throws LoginException {
        String string2 = string;
        if (authDebug.messageEnabled()) {
            authDebug.message("Instantiating AuthContext with parameters organization name: " + string + "; " + (authSubject == null ? "subject is null" : "subject: " + authSubject));
        }
        if (string != null) {
            if (string.startsWith("auth://")) {
                String string3 = null;
                int n = 7;
                String string4 = string.substring(n);
                int n2 = string4.indexOf("/");
                if (n2 != -1) {
                    string2 = string4.substring(0, n2);
                    authDebug.message("AuthContext::init() auth:// form, orgname = " + string2);
                    string4 = string4.substring(n2 + 1);
                    string3 = string4.length() > 0 ? ((n2 = string4.indexOf("?")) != -1 ? string4.substring(0, n2) : string4) : null;
                } else {
                    string2 = string4;
                }
                if (string3 != null) {
                    this.applicationName = string3;
                }
            } else if (string.startsWith("local://")) {
                authDebug.message("local form AuthContext specified; " + string);
                int n = 8;
                string2 = string.substring(n);
            }
        }
        this.organizationName = string2;
        this.reset(authSubject);
    }

    public AuthContext(String string) throws LoginException {
        this(string, null);
        authDebug.message("Instantiated AuthContext with organization name: " + string);
    }

    protected AuthContext(byte[] byArray) throws LoginException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            String string = (String)objectInputStream.readObject();
            int n = objectInputStream.readInt();
            AuthSubject authSubject = (AuthSubject)objectInputStream.readObject();
            this.organizationName = string;
            this.reset(authSubject);
            this.setLoginStatus(n);
        }
        catch (IOException iOException) {
            authDebug.message("AuthContext::bArray constructor():IOException" + iOException);
            throw new LoginException(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            authDebug.message("AuthContext::bArray constructor():ClassNotFoundException" + classNotFoundException);
            throw new LoginException(classNotFoundException.getMessage());
        }
    }

    protected void reset() throws LoginException {
        authDebug.message("AuthContext::reset()");
        this.reset(null);
        authDebug.message("AuthContext::reset() exiting");
    }

    protected void reset(AuthSubject authSubject) throws LoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContext::reset(" + this.organizationName + ", " + (authSubject == null ? "null" : authSubject.toString()) + ")");
        }
        this.loginStatus = 1;
        this.informationRequired = null;
        this.submittedInformation = null;
        this.loginException = null;
        this.loginThread = new AuthLoginThread(this);
        authDebug.message("AuthLoginThread isAlive = " + this.loginThread.isAlive());
        String string = null;
        string = this.applicationName == null ? this.organizationName : this.organizationName + "%" + this.applicationName;
        authDebug.message("AuthContext::reset:using contextName=" + string);
        this.loginContext = authSubject == null ? new LoginContext(string, this.loginThread) : new LoginContext(string, authSubject, this.loginThread);
        if (authDebug.messageEnabled()) {
            authDebug.message("Successfully reset AuthContext for organization: " + this.organizationName + (authSubject == null ? " with no subject name " : " with subjects: " + authSubject));
        }
    }

    protected AuthSubject getSubject() {
        authDebug.message("AuthContext::getSubject()");
        return this.loginContext.getSubject();
    }

    public void startLogin() throws LoginException {
        authDebug.message("AuthContext::startLogin() called");
        if (this.getLoginStatus() != 1) {
            authDebug.message("AuthContext::startLogin called when the current login state is" + this.getLoginStatus());
            throw new LoginException(myAuthI18n.getString("authError-invalidMethod" + this.getLoginStatus()));
        }
        this.loginStatus = 2;
        authDebug.message("AuthContext::startLogin() starting a new thread to run the login process");
        try {
            this.loginThread.start();
        }
        catch (Exception exception) {
            authDebug.message("exception starting thread: " + exception);
            throw new LoginException(exception.getMessage());
        }
    }

    public boolean hasMoreRequirements() {
        authDebug.message("AuthContext::requiresMoreInformation()");
        return this.getRequirements() != null;
    }

    /*
     * Unable to fully structure code
     */
    public Callback[] getRequirements() {
        AuthContext.authDebug.message("AuthContext::getInformationRequired()");
        if (this.getLoginStatus() == 2) ** GOTO lbl19
        AuthContext.authDebug.message("AuthContext:getInformationRequired() called when the current login state is: " + this.getLoginStatus());
        return null;
lbl-1000:
        // 1 sources

        {
            try {
                AuthContext.authDebug.message("AuthContext::getInformationRequired() waiting for Callback array");
                var1_1 = this.loginThread;
                synchronized (var1_1) {
                    if (this.informationRequired == null && this.getLoginStatus() == 2) {
                        this.loginThread.wait();
                    }
                }
                AuthContext.authDebug.message("AuthContext::getInformationRequired() returned from waiting for Callback array");
                continue;
            }
            catch (InterruptedException var1_2) {
                // empty catch block
            }
lbl19:
            // 3 sources

            ** while (this.informationRequired == null && this.getLoginStatus() == 2)
        }
lbl20:
        // 1 sources

        return this.informationRequired;
    }

    public void submitRequiredInformation(Callback[] callbackArray) {
        authDebug.message("AuthContext::submitRequestedInformation()");
        this.informationRequired = null;
        AuthLoginThread authLoginThread = this.loginThread;
        synchronized (authLoginThread) {
            this.submittedInformation = callbackArray;
            this.loginThread.notify();
        }
        authDebug.message("AuthContext::submitRequestedInformation() sending notify to sleeping threads");
    }

    public void logout() throws LoginException {
        authDebug.message("AuthContext::logout()");
        this.loginContext.logout();
        authDebug.message("Called LoginContext::logout()");
        this.loginStatus = 5;
    }

    public LoginException getLoginException() {
        authDebug.message("AuthContext::getLoginException()");
        return this.loginException;
    }

    public int getLoginStatus() {
        authDebug.message("AuthContext::getLoginStatus()");
        return this.loginStatus;
    }

    protected void setLoginStatus(int n) {
        authDebug.message("AuthContext::setLoginStatus()");
        this.loginStatus = n;
    }

    public Principal getPrincipal() {
        Iterator iterator;
        Set set = this.getSubject().getPrincipals();
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContext::getAuthPrincipal(): " + set);
        }
        if ((iterator = set.iterator()).hasNext()) {
            return (Principal)iterator.next();
        }
        return null;
    }

    public AuthPrincipal getAuthPrincipal() {
        authDebug.message("AuthContext::getAuthPrincipal()");
        Set set = this.getSubject().getPrincipals();
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            return (AuthPrincipal)iterator.next();
        }
        return null;
    }

    protected Set getPrincipals() {
        authDebug.message("AuthContext::getAuthPrincipals()");
        return this.getSubject().getPrincipals();
    }

    protected byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.organizationName == null ? " " : this.organizationName);
            objectOutputStream.writeInt(this.loginStatus);
            objectOutputStream.writeObject(this.loginContext.getSubject());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            authDebug.message("AuthContext::toByteArray():IOException" + iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            authDebug.message("AuthContext::toByteArray():Exception" + exception);
        }
        return null;
    }

    public String getOrganizationName() {
        if (this.organizationName == null) {
            String string = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
            this.organizationName = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
            if (string != null && this.organizationName != null) {
                string = new DN(string).toRFCString().toLowerCase();
                this.organizationName = new DN(this.organizationName).toRFCString().toLowerCase();
                if (!this.organizationName.equals(string) && !this.organizationName.endsWith(string)) {
                    this.organizationName = this.organizationName + "," + string;
                }
            }
        }
        return this.organizationName;
    }

    protected String getApplicationName() {
        return this.applicationName;
    }

    public SSOToken getSSOToken() throws InvalidAuthContextException {
        if (this.token != null) {
            return this.token;
        }
        this.token = new AuthSSOToken(this);
        try {
            if (this.getOrganizationName() != null) {
                this.token.setProperty("Organization", this.getOrganizationName());
            }
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostAddress();
            String string2 = inetAddress.getHostName();
            if (authDebug.messageEnabled()) {
                authDebug.message("Complete Host : " + inetAddress.toString());
                authDebug.message("getSSOToken : HOST Name : " + string2);
                authDebug.message("getSSOToken : IP : " + string);
            }
            if (string != null) {
                if (isEnableHostLookUp) {
                    if (string2 != null) {
                        this.token.setProperty("HostName", string2);
                    }
                } else {
                    this.token.setProperty("HostName", string);
                }
                this.token.setProperty("Host", string);
            }
            this.token.setProperty("AuthType", "ldap");
            if (this.getPrincipal() != null) {
                this.token.setProperty("Principal", this.getPrincipal().getName());
            }
            this.token.setProperty("AuthLevel", Integer.toString(0));
            if (authDebug.messageEnabled()) {
                authDebug.message("SSOToken : Organization : " + this.token.getProperty("Organization"));
                authDebug.message("SSOToken : Principal : " + this.token.getProperty("Principal"));
                authDebug.message("SSOToken : HostName : " + this.token.getProperty("HostName"));
                authDebug.message("SSOToken : Host : " + this.token.getProperty("Host"));
                authDebug.message("SSOToken : getIPAddress : " + this.token.getIPAddress());
                authDebug.message("SSOToken : getHostName : " + this.token.getHostName());
            }
        }
        catch (Exception exception) {
            authDebug.message("getSSOToken: setProperty exception : ", (Throwable)exception);
            exception.printStackTrace();
        }
        return this.token;
    }
}

