/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigType;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthLevelManager;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMSDKEventListener;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.security.auth.login.ConfigFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class AMConfiguration
extends Configuration {
    private static Map jaasConfig = new HashMap();
    private static Map listenersMap = new HashMap();
    private static ConfigFile configFile = null;
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    private Configuration defConfig = null;
    private SSOToken adminToken = null;
    private AMAuthenticationManager amAM = null;
    private static ServiceConfigManager scm = null;

    public AMConfiguration(Configuration configuration) {
        this.defConfig = configuration;
        this.adminToken = AuthD.getAuth().getSSOAuthSession();
    }

    private void initialize() {
        debug.message("inside AMConfiguration.initialize()");
        Map map = jaasConfig;
        synchronized (map) {
            jaasConfig = new HashMap();
        }
        Map map2 = listenersMap;
        synchronized (map2) {
            listenersMap = new HashMap();
        }
    }

    private AppConfigurationEntry[] cloneConfigurationEntry(AppConfigurationEntry[] appConfigurationEntryArray, String string) {
        int n;
        if (debug.messageEnabled()) {
            debug.message("AMConfiguration.cloneConfigurationEntry, orgDN=" + string + ", entries=" + appConfigurationEntryArray);
        }
        ArrayList<AppConfigurationEntry> arrayList = new ArrayList<AppConfigurationEntry>();
        Set set = null;
        if (AuthD.revisionNumber < 30 && (set = this.amAM.getAllowedModuleNames()).isEmpty()) {
            return null;
        }
        AppConfigurationEntry[] appConfigurationEntryArray2 = appConfigurationEntryArray;
        synchronized (appConfigurationEntryArray2) {
            n = appConfigurationEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = appConfigurationEntryArray[n2].getLoginModuleName();
                if (AuthD.revisionNumber < 30 && !string2.equals("Application") && !set.contains(AMAuthConfigUtils.getModuleName(string2))) {
                    if (debug.messageEnabled()) {
                        debug.message("skip module " + string2);
                    }
                } else {
                    arrayList.add(new AppConfigurationEntry(appConfigurationEntryArray[n2].getLoginModuleName(), appConfigurationEntryArray[n2].getControlFlag(), appConfigurationEntryArray[n2].getOptions()));
                }
                ++n2;
            }
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        AppConfigurationEntry[] appConfigurationEntryArray3 = new AppConfigurationEntry[n];
        int n3 = 0;
        while (n3 < n) {
            appConfigurationEntryArray3[n3] = (AppConfigurationEntry)arrayList.get(n3);
            ++n3;
        }
        return appConfigurationEntryArray3;
    }

    private String getOrganization(String string) {
        return new AMAuthConfigType(string).getOrganization();
    }

    private AppConfigurationEntry[] newConfiguration(String string) {
        if (debug.messageEnabled()) {
            debug.message("newConfig, name = " + string);
        }
        AMAuthConfigType aMAuthConfigType = new AMAuthConfigType(string);
        AppConfigurationEntry[] appConfigurationEntryArray = null;
        try {
            switch (aMAuthConfigType.getIndexType()) {
                case 1: {
                    appConfigurationEntryArray = this.getUserBasedConfig(aMAuthConfigType.getOrganization(), aMAuthConfigType.getIndexName(), string);
                    break;
                }
                case 2: {
                    appConfigurationEntryArray = this.getOrgBasedConfig(aMAuthConfigType.getOrganization(), string, false);
                    break;
                }
                case 3: {
                    appConfigurationEntryArray = this.getRoleBasedConfig(aMAuthConfigType.getOrganization(), aMAuthConfigType.getIndexName(), string);
                    break;
                }
                case 4: {
                    if (aMAuthConfigType.getIndexName().equals("adminconsoleservice")) {
                        appConfigurationEntryArray = this.getOrgBasedConfig(aMAuthConfigType.getOrganization(), string, true);
                        break;
                    }
                    appConfigurationEntryArray = this.getServiceBasedConfig(aMAuthConfigType.getOrganization(), aMAuthConfigType.getIndexName(), string);
                    break;
                }
                case 5: {
                    appConfigurationEntryArray = this.getModuleBasedConfig(aMAuthConfigType.getOrganization(), aMAuthConfigType.getIndexName(), string);
                    break;
                }
                default: {
                    if (debug.messageEnabled()) {
                        debug.message("Unable to find config " + string + " in Access Manager config");
                    }
                    debug.message("Getting default configuration.");
                    if (this.defConfig != null) {
                        appConfigurationEntryArray = this.defConfig.getAppConfigurationEntry(string);
                    }
                    if (appConfigurationEntryArray == null) {
                        if (configFile == null) {
                            configFile = new ConfigFile();
                        }
                        debug.message("Getting configuration from confFile.");
                        appConfigurationEntryArray = configFile.getAppConfigurationEntry(string);
                    }
                    if (appConfigurationEntryArray == null) {
                        debug.error("newConfiguration, invalid config " + string);
                    }
                    return appConfigurationEntryArray;
                }
            }
        }
        catch (Exception exception) {
            debug.error("newConfiguration.switch", (Throwable)exception);
        }
        if (appConfigurationEntryArray == null) {
            if (debug.messageEnabled()) {
                debug.message("newConfig, config not defined " + string);
            }
            return null;
        }
        Map map = jaasConfig;
        synchronized (map) {
            jaasConfig.put(string, appConfigurationEntryArray);
        }
        return this.cloneConfigurationEntry(appConfigurationEntryArray, aMAuthConfigType.getOrganization());
    }

    private String getServiceNameForModule(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n != -1 ? string.substring(n + 1) : string;
        return AuthUtils.getModuleServiceName(string2);
    }

    private String getLoginModuleClassName(String string) {
        return AuthD.getAuth().getAuthenticatorForName(string);
    }

    private AppConfigurationEntry[] getOrgBasedConfig(String string, String string2, boolean bl) {
        if (debug.messageEnabled()) {
            debug.message("getOrgBasedConfig,  START " + string);
        }
        try {
            Object object;
            if (scm == null) {
                object = jaasConfig;
                synchronized (object) {
                    scm = new ServiceConfigManager("iPlanetAMAuthService", this.adminToken);
                }
            }
            object = scm.getOrganizationConfig(string, null);
            Map map = ((ServiceConfig)object).getAttributes();
            Set set = bl ? (Set)map.get("iplanet-am-auth-admin-auth-module") : (Set)map.get("iplanet-am-auth-org-config");
            String string3 = null;
            if (set != null) {
                string3 = (String)set.iterator().next();
            }
            if (debug.messageEnabled()) {
                debug.message("org auth config = " + string3);
            }
            AppConfigurationEntry[] appConfigurationEntryArray = this.parseInstanceConfiguration(string, string3, string2);
            this.addServiceListener("iPlanetAMAuthService", string2);
            return appConfigurationEntryArray;
        }
        catch (Exception exception) {
            debug.error("getOrgBasedConfig org=" + string, (Throwable)exception);
            return null;
        }
    }

    private AppConfigurationEntry[] parseInstanceConfiguration(String string, String string2, String string3) throws SMSException, SSOException {
        String string4 = string2.trim();
        if (string4 == null || string4.length() == 0 || string4.equals("[Empty]")) {
            return null;
        }
        if (string4.indexOf(32) != -1) {
            if (debug.messageEnabled()) {
                debug.message("Old DIT with chain config");
            }
            return this.parseXMLConfig(string4, string3);
        }
        if (debug.messageEnabled()) {
            debug.message("New DIT with named service config");
        }
        return this.getServiceBasedConfig(string, string4, string3);
    }

    private AppConfigurationEntry[] parseXMLConfig(String string, String string2) throws SMSException, SSOException {
        AppConfigurationEntry[] appConfigurationEntryArray = AMAuthConfigUtils.parseValues(string);
        if (appConfigurationEntryArray == null) {
            return null;
        }
        int n = appConfigurationEntryArray.length;
        AppConfigurationEntry[] appConfigurationEntryArray2 = new AppConfigurationEntry[n];
        int n2 = 0;
        while (n2 < n) {
            AMAuthenticationInstance aMAuthenticationInstance;
            String string3 = appConfigurationEntryArray[n2].getLoginModuleName();
            int n3 = string3.lastIndexOf(46);
            String string4 = string3;
            if (n3 != -1) {
                string4 = string3.substring(n3 + 1);
            }
            if ((aMAuthenticationInstance = this.amAM.getAuthenticationInstance(string4)) == null) {
                return null;
            }
            Map map = aMAuthenticationInstance.getAttributeValues();
            if (map == null) {
                return null;
            }
            if (n3 == -1) {
                String string5 = aMAuthenticationInstance.getType();
                string3 = this.getLoginModuleClassName(string5);
            }
            map.putAll(appConfigurationEntryArray[n2].getOptions());
            map.put("moduleInstanceName", string4);
            appConfigurationEntryArray2[n2] = new AppConfigurationEntry(string3, appConfigurationEntryArray[n2].getControlFlag(), map);
            this.addServiceListener(AuthUtils.getModuleServiceName(aMAuthenticationInstance.getType()), string2);
            ++n2;
        }
        return appConfigurationEntryArray2;
    }

    private AppConfigurationEntry[] getUserBasedConfig(String string, String string2, String string3) {
        if (debug.messageEnabled()) {
            debug.message("getUserBasedConfig,  START " + string + "|" + string2);
        }
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(this.adminToken, string2);
            if (aMIdentity != null) {
                Set set = aMIdentity.getAttribute("iplanet-am-user-auth-config");
                if (set == null || set.isEmpty()) {
                    return null;
                }
                String string4 = (String)set.iterator().next();
                if (debug.messageEnabled()) {
                    debug.message("Named config for user " + string2 + " = " + string4);
                }
                AppConfigurationEntry[] appConfigurationEntryArray = this.parseInstanceConfiguration(string, string4, string3);
                return appConfigurationEntryArray;
            }
            if (debug.warningEnabled()) {
                debug.warning("User Based Config, user not exist " + string2);
            }
            return null;
        }
        catch (Exception exception) {
            debug.error("getUserBasedConfig " + string2 + "|" + string, (Throwable)exception);
            return null;
        }
    }

    private AppConfigurationEntry[] getServiceBasedConfig(String string, String string2, String string3) {
        if (debug.messageEnabled()) {
            debug.message("ServiceBasedConfig,  START " + string + "|" + string2 + ", name = " + string3);
        }
        if (string2 == null) {
            return null;
        }
        try {
            Map map = AMAuthConfigUtils.getNamedConfig(string2, string, this.adminToken);
            Set set = (Set)map.get("iplanet-am-auth-configuration");
            String string4 = null;
            if (set != null && !set.isEmpty()) {
                string4 = (String)set.iterator().next();
            }
            if (string4 == null) {
                return null;
            }
            AppConfigurationEntry[] appConfigurationEntryArray = this.parseXMLConfig(string4, string3);
            if (debug.messageEnabled()) {
                debug.message("serviceBased, add SM listener on " + string2);
            }
            this.addServiceListener("iPlanetAMAuthConfiguration", string3);
            if (debug.messageEnabled()) {
                debug.message("ServiceBasedConfig, return config " + string2 + ", org=" + string);
            }
            return appConfigurationEntryArray;
        }
        catch (Exception exception) {
            debug.error("getServiceBasedConfig " + string2 + "|" + string, (Throwable)exception);
            return null;
        }
    }

    private AppConfigurationEntry[] getRoleBasedConfig(String string, String string2, String string3) {
        if (debug.messageEnabled()) {
            debug.message("RoleBasedConfig,  START " + string + "|" + string2);
        }
        try {
            AMIdentity aMIdentity = IdUtils.getIdentity(this.adminToken, string2);
            if (aMIdentity != null) {
                Set set = (Set)aMIdentity.getServiceAttributes("iPlanetAMAuthConfiguration").get("iplanet-am-auth-configuration");
                if (set == null) {
                    return null;
                }
                String string4 = (String)set.iterator().next();
                if (debug.messageEnabled()) {
                    debug.message("Named config for role " + string2 + " = " + string4);
                }
                AppConfigurationEntry[] appConfigurationEntryArray = this.parseInstanceConfiguration(string, string4, string3);
                return appConfigurationEntryArray;
            }
            if (debug.warningEnabled()) {
                debug.warning("RoleBaseConfig, role not exist " + string2);
            }
            return null;
        }
        catch (Exception exception) {
            debug.error("getRoleBasedConfig " + string + "|" + string2, (Throwable)exception);
            return null;
        }
    }

    private AppConfigurationEntry[] getModuleBasedConfig(String string, String string2, String string3) {
        if (debug.messageEnabled()) {
            debug.message("ModuleBasedConfig,  START " + string + "|" + string2 + ", name = " + string3);
        }
        try {
            AMAuthenticationInstance aMAuthenticationInstance = this.amAM.getAuthenticationInstance(string2);
            if (aMAuthenticationInstance == null) {
                return null;
            }
            Map map = aMAuthenticationInstance.getAttributeValues();
            map.put("moduleInstanceName", string2);
            String string4 = aMAuthenticationInstance.getType();
            AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[]{new AppConfigurationEntry(this.getLoginModuleClassName(string4), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map)};
            this.addServiceListener(AuthUtils.getModuleServiceName(string4), string3);
            if (debug.messageEnabled()) {
                debug.message("ModuleBaseConfig, return config " + string2 + ", " + string);
            }
            return appConfigurationEntryArray;
        }
        catch (Exception exception) {
            debug.error("getModuleBasedConfig " + string + "|" + string2, (Throwable)exception);
            return null;
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        if (debug.messageEnabled()) {
            debug.message("retrieving configuration: " + string);
            debug.message("cached configs " + jaasConfig);
        }
        if (string == null) {
            return null;
        }
        AMAuthConfigType aMAuthConfigType = new AMAuthConfigType(string);
        String string2 = aMAuthConfigType.getOrganization();
        try {
            this.amAM = new AMAuthenticationManager(this.adminToken, string2);
        }
        catch (Exception exception) {
            debug.error("Failed to obtain AMAuthenticationManager: " + exception.getMessage());
            if (debug.messageEnabled()) {
                debug.message("Stack trace: ", (Throwable)exception);
            }
            return null;
        }
        AppConfigurationEntry[] appConfigurationEntryArray = (AppConfigurationEntry[])jaasConfig.get(string);
        if (appConfigurationEntryArray != null) {
            if (debug.messageEnabled()) {
                debug.message("getAppConfigurationEntry[], found " + string);
            }
            return this.cloneConfigurationEntry(appConfigurationEntryArray, this.getOrganization(string));
        }
        if (debug.messageEnabled()) {
            debug.message("getAppConfigurationEntry[], new " + string);
        }
        return this.newConfiguration(string);
    }

    public void refresh() {
        this.initialize();
    }

    public void processListenerEvent(String string) {
        Map map = jaasConfig;
        synchronized (map) {
            if (debug.messageEnabled()) {
                debug.message("pLE, remove config " + string);
            }
            jaasConfig.remove(string);
        }
    }

    private void removeListenersMap(String string) {
        Map map = listenersMap;
        synchronized (map) {
            Set set = (Set)listenersMap.get(string);
            if (set == null) {
                if (debug.messageEnabled()) {
                    debug.message("remove, no listeners for " + string);
                }
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMSDKEventListener aMSDKEventListener = (AMSDKEventListener)iterator.next();
                if (debug.messageEnabled()) {
                    debug.message("remove SDK listener on " + string + " for dn=" + aMSDKEventListener.getListenedObject().getDN());
                }
                aMSDKEventListener.getListenedObject().removeEventListener(aMSDKEventListener);
                aMSDKEventListener.setListenedObject(null);
            }
            listenersMap.remove(string);
        }
        AMAuthLevelManager.getInstance().removeAuthConfigListener(string);
    }

    private void addServiceListener(String string, String string2) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("addServiceListener for " + string + ", name=" + string2);
        }
        AMAuthLevelManager.getInstance().addAuthConfigListener(string, string2);
    }

    public void addToListenersMap(String string, Object object) {
        Map map = listenersMap;
        synchronized (map) {
            HashSet<Object> hashSet = (HashSet<Object>)listenersMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                hashSet.add(object);
                listenersMap.put(string, hashSet);
            } else {
                hashSet.add(object);
            }
        }
    }
}

