/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMAuthConfigUtils {
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    private static DocumentBuilderFactory factory = null;
    protected static final String SERVICE_NAME = "iPlanetAMAuthConfiguration";
    protected static final String NAMED_CONFIGURATION = "Configurations";
    protected static final String NAMED_CONFIGURATION_ID = "NamedConfiguration";
    protected static final String SERVICE_VERSION = "1.0";
    protected static final String ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
    protected static final String ATTR_VALUE_NODE = "Value";
    public static final String ATTR_NAME = "iplanet-am-auth-configuration";
    protected static final String MODULE_KEY = "MODULE";
    protected static final String USER_KEY = "USER";
    protected static final String ORG_KEY = "ORGANIZATION";
    protected static final String SERVICE_KEY = "SERVICE";
    protected static final String ROLE_KEY = "ROLE";
    protected static final String CLIENT_KEY = "CLIENT";
    private static final String AUTH_SERVICE = "iPlanetAMAuthService";
    private static final String AUTH_MODULES_ATTR = "iplanet-am-auth-allowed-modules";
    private static final String AUTH_AUTHENTICATOR_ATTR = "iplanet-am-auth-authenticators";
    private static final String APPLICATION_CLASS_NAME = "com.sun.identity.authentication.modules.application.Application";
    protected static String bundleName = "amAuthConfig";

    public static AppConfigurationEntry[] parseValues(String string) {
        Document document;
        if (debug.messageEnabled()) {
            debug.message("AuthConfigUtil.AppConfigurationEntry, xml=" + string);
        }
        if ((document = XMLUtils.toDOMDocument((String)string, (Debug)debug)) == null) {
            AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[]{};
            return appConfigurationEntryArray;
        }
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[n];
        int n2 = 0;
        while (n2 < n) {
            appConfigurationEntryArray[n2] = AMAuthConfigUtils.processValue(nodeList.item(n2));
            ++n2;
        }
        return appConfigurationEntryArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static AppConfigurationEntry processValue(Node node) {
        String string;
        if (debug.messageEnabled()) {
            debug.message("ConfigUtils.processValue, value=" + node.toString());
        }
        if ((string = node.getFirstChild().getNodeValue()) == null || string.equals("")) {
            debug.error("ConfigUtils.processValue, invalid value=" + string);
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 2) {
            debug.error("ConfigUtils.processValue, wrong config : " + string);
            return null;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        HashMap hashMap = new HashMap();
        AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = null;
        if (string3.equals("REQUIRED")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (string3.equals("OPTIONAL")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else if (string3.equals("REQUISITE")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else {
            if (!string3.equals("SUFFICIENT")) {
                debug.error("ConfigUtils.processValue, invalid flag : " + string);
                return null;
            }
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.indexOf("=");
            if (n2 == -1) continue;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string4.substring(n2 + 1));
            hashMap.put(string4.substring(0, n2), hashSet);
        }
        return new AppConfigurationEntry(string2, loginModuleControlFlag, hashMap);
    }

    public static String getAuthConfigName(AuthContext.IndexType indexType, String string, String string2, String string3) throws AMConfigurationException {
        if (indexType == AuthContext.IndexType.MODULE_INSTANCE) {
            return "MODULE=" + string + ";" + ORG_KEY + "=" + string2.toLowerCase() + ";" + CLIENT_KEY + "=" + string3;
        }
        if (indexType == AuthContext.IndexType.ROLE) {
            return "ROLE=" + string + ";" + ORG_KEY + "=" + string2.toLowerCase() + ";" + CLIENT_KEY + "=" + string3;
        }
        if (indexType == AuthContext.IndexType.SERVICE) {
            return "SERVICE=" + string + ";" + ORG_KEY + "=" + string2.toLowerCase() + ";" + CLIENT_KEY + "=" + string3;
        }
        if (indexType == AuthContext.IndexType.USER) {
            return "USER=" + string + ";" + ORG_KEY + "=" + string2.toLowerCase() + ";" + CLIENT_KEY + "=" + string3;
        }
        throw new AMConfigurationException(bundleName, "invalidIndexType");
    }

    public static String getAuthConfigName(String string, String string2) {
        return "ORGANIZATION=" + string + ";" + CLIENT_KEY + "=" + string2;
    }

    public static String convertToXMLString(List list) {
        if (debug.messageEnabled()) {
            debug.message("convertToXMLString : " + list.toString());
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        Iterator iterator = list.iterator();
        if (iterator != null) {
            stringBuffer.append("<AttributeValuePair>");
            while (iterator.hasNext()) {
                stringBuffer.append("<Value>" + iterator.next() + "</" + ATTR_VALUE_NODE + ">");
            }
            stringBuffer.append("</AttributeValuePair>");
        }
        if (debug.messageEnabled()) {
            debug.message("convertToXMLString : return " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static void createNamedConfig(String string, int n, Map map, String string2, SSOToken sSOToken) throws SMSException, SSOException, AMConfigurationException {
        ServiceConfig serviceConfig;
        if (debug.messageEnabled()) {
            debug.message("createNamedConfig name=" + string + ", value=" + map);
        }
        if (string == null || string.length() == 0) {
            throw new AMConfigurationException(bundleName, "null-name");
        }
        ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, SERVICE_NAME, SERVICE_VERSION);
        ServiceConfig serviceConfig2 = serviceConfigManager.getOrganizationConfig(string2, null);
        if (serviceConfig2 == null) {
            serviceConfig2 = serviceConfigManager.createOrganizationConfig(string2, null);
        }
        if ((serviceConfig = serviceConfig2.getSubConfig(NAMED_CONFIGURATION)) == null) {
            serviceConfig2.addSubConfig(NAMED_CONFIGURATION, null, 0, null);
            serviceConfig = serviceConfig2.getSubConfig(NAMED_CONFIGURATION);
        }
        debug.message("Got auth config");
        serviceConfig.addSubConfig(string, NAMED_CONFIGURATION_ID, n, map);
    }

    public static void replaceNamedConfig(String string, int n, Map map, String string2, SSOToken sSOToken) throws SMSException, SSOException, AMConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("replaceNamedConfig name=" + string + ", value=" + map + ",org=" + string2);
        }
        if (string == null) {
            throw new AMConfigurationException(bundleName, "null-name");
        }
        ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, SERVICE_NAME, SERVICE_VERSION);
        ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string2, null);
        if (serviceConfig == null) {
            throw new AMConfigurationException(bundleName, "service-not-registered");
        }
        ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(NAMED_CONFIGURATION);
        if (serviceConfig2 == null) {
            throw new AMConfigurationException(bundleName, "named-config-not-defined");
        }
        ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig(string);
        if (serviceConfig3 == null) {
            throw new AMConfigurationException(bundleName, "config-not-exists");
        }
        serviceConfig3.setAttributes(map);
    }

    public static void removeNamedConfig(String string, String string2, SSOToken sSOToken) throws SMSException, SSOException, AMConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("removeNamedConfig name=" + string + ",org=" + string2);
        }
        if (string == null) {
            throw new AMConfigurationException(bundleName, "null-name");
        }
        ServiceConfigManager serviceConfigManager = new ServiceConfigManager(SERVICE_NAME, sSOToken);
        ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string2, null);
        if (serviceConfig == null) {
            throw new AMConfigurationException(bundleName, "service-not-registered");
        }
        ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(NAMED_CONFIGURATION);
        if (serviceConfig2 == null) {
            throw new AMConfigurationException(bundleName, "named-config-not-defined");
        }
        ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig(string);
        if (serviceConfig3 == null) {
            throw new AMConfigurationException(bundleName, "config-not-exists");
        }
        serviceConfig2.removeSubConfig(string);
    }

    public static Set getAllNamedConfig(String string, SSOToken sSOToken) throws SMSException, SSOException {
        ServiceConfigManager serviceConfigManager;
        ServiceConfig serviceConfig;
        if (debug.messageEnabled()) {
            debug.message("getAllNamedConfig org=" + string);
        }
        if ((serviceConfig = (serviceConfigManager = new ServiceConfigManager(sSOToken, SERVICE_NAME, SERVICE_VERSION)).getOrganizationConfig(string, null)) == null) {
            return Collections.EMPTY_SET;
        }
        ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(NAMED_CONFIGURATION);
        if (serviceConfig2 == null) {
            return Collections.EMPTY_SET;
        }
        return serviceConfig2.getSubConfigNames("*");
    }

    public static Map getNamedConfig(String string, String string2, SSOToken sSOToken) throws SMSException, SSOException, AMConfigurationException {
        if (debug.messageEnabled()) {
            debug.message("getNamedConfig name=" + string + ",org=" + string2);
        }
        if (string == null) {
            throw new AMConfigurationException(bundleName, "null-name");
        }
        ServiceConfigManager serviceConfigManager = new ServiceConfigManager(sSOToken, SERVICE_NAME, SERVICE_VERSION);
        ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(string2, null);
        if (serviceConfig == null) {
            throw new AMConfigurationException(bundleName, "service-not-registered");
        }
        ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(NAMED_CONFIGURATION);
        if (serviceConfig2 == null) {
            throw new AMConfigurationException(bundleName, "named-config-not-defined");
        }
        ServiceConfig serviceConfig3 = serviceConfig2.getSubConfig(string);
        if (serviceConfig3 == null) {
            throw new AMConfigurationException(bundleName, "config-not-exists");
        }
        Map map = serviceConfig3.getAttributes();
        return map;
    }

    public static String getModuleName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        if (n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String getModuleServiceName(String string) {
        if (string.equals("RADIUS")) {
            return "iPlanetAMAuthRadiusService";
        }
        return "iPlanetAMAuth" + string + "Service";
    }

    public static String getNewModuleServiceName(String string) {
        return "sunAMAuth" + string + "Service";
    }

    public static String getAuthLevelAttribute(Map map, String string) {
        String string2 = "iplanet-am-auth-" + string.toLowerCase() + "-auth-level";
        if (map.get(string2) == null) {
            string2 = "sunAMAuth" + string + "AuthLevel";
        }
        return string2;
    }

    public static ServiceSchema getServiceSchema(SSOToken sSOToken) throws AMConfigurationException {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(SERVICE_NAME, sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getOrganizationSchema();
            ServiceSchema serviceSchema2 = serviceSchema.getSubSchema(NAMED_CONFIGURATION);
            ServiceSchema serviceSchema3 = serviceSchema2.getSubSchema(NAMED_CONFIGURATION_ID);
            return serviceSchema3;
        }
        catch (Exception exception) {
            debug.error("getServiceSubSchema", (Throwable)exception);
            throw new AMConfigurationException(exception);
        }
    }

    public static Map getAllAuthModules(SSOToken sSOToken) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(AUTH_SERVICE, sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            Set set = (Set)map.get(AUTH_AUTHENTICATOR_ATTR);
            if (set == null) {
                return hashMap;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n;
                String string = (String)iterator.next();
                if (string.equals(APPLICATION_CLASS_NAME)) continue;
                if (debug.messageEnabled()) {
                    debug.message("getAllAuthModules. process " + string);
                }
                if ((n = string.lastIndexOf(46)) > -1) {
                    String string2 = string.substring(n + 1, string.length());
                    hashMap.put(string2, string);
                    continue;
                }
                hashMap.put(string, string);
            }
        }
        catch (Exception exception) {
            debug.error("getAllAuthModules", (Throwable)exception);
        }
        return hashMap;
    }

    public static Map getAllAuthModules(String string, SSOToken sSOToken) {
        Object object;
        Map map = new HashMap();
        Set set = null;
        try {
            object = new AMStoreConnection(sSOToken);
            AMOrganization aMOrganization = ((AMStoreConnection)object).getOrganization(string);
            AMTemplate aMTemplate = aMOrganization.getTemplate(AUTH_SERVICE, 302);
            Map map2 = aMTemplate.getAttributes();
            set = (Set)map2.get(AUTH_MODULES_ATTR);
        }
        catch (Exception exception) {
            debug.error("getAllAuthModules", (Throwable)exception);
        }
        object = AMAuthConfigUtils.getGlobalAuthenticators(sSOToken);
        map = set != null && !set.isEmpty() ? AMAuthConfigUtils.constructModulesList(set, (Set)object, sSOToken) : AMAuthConfigUtils.constructModulesList((Set)object, null, sSOToken);
        if (debug.messageEnabled()) {
            debug.message("Returning modules : " + map);
        }
        return map;
    }

    public static List xmlToAuthConfigurationEntry(String string) {
        if (debug.messageEnabled()) {
            debug.message("AuthConfUtil.xmltoentries, xml=" + string);
        }
        ArrayList<AuthConfigurationEntry> arrayList = new ArrayList<AuthConfigurationEntry>();
        Document document = XMLUtils.toDOMDocument((String)string, (Debug)debug);
        if (document == null) {
            return arrayList;
        }
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            try {
                arrayList.add(new AuthConfigurationEntry(nodeList.item(n2)));
            }
            catch (Exception exception) {
                debug.error("parseValue", (Throwable)exception);
            }
            ++n2;
        }
        return arrayList;
    }

    public static String authConfigurationEntryToXMLString(List list) {
        if (debug.messageEnabled()) {
            debug.message("convertToXMLString : " + list);
        }
        if (list != null) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("<AttributeValuePair>");
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                AuthConfigurationEntry authConfigurationEntry = (AuthConfigurationEntry)list.get(n2);
                stringBuffer.append("<").append(ATTR_VALUE_NODE).append(">").append(authConfigurationEntry.getLoginModuleName()).append(" ").append(authConfigurationEntry.getControlFlag().toString()).append(" ");
                String string = authConfigurationEntry.getOptions();
                if (string != null) {
                    stringBuffer.append(string.toString());
                }
                stringBuffer.append("</").append(ATTR_VALUE_NODE).append(">");
                ++n2;
            }
            stringBuffer.append("</AttributeValuePair>");
            if (debug.messageEnabled()) {
                debug.message("convertToXMLString : return " + stringBuffer.toString());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    private static Map constructModulesList(Set set, Set set2, SSOToken sSOToken) {
        if (debug.messageEnabled()) {
            debug.message("constructModulesList : classes : " + set);
        }
        Iterator iterator = set.iterator();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String string;
            int n;
            String string2 = (String)iterator.next();
            if (string2.equals(APPLICATION_CLASS_NAME)) continue;
            if (debug.messageEnabled()) {
                debug.message("getAllAuthModules. process " + string2);
            }
            if ((n = string2.lastIndexOf(46)) > -1) {
                string = string2.substring(n + 1, string2.length());
                hashMap.put(string, string2);
                continue;
            }
            if (set2 != null && !set2.isEmpty()) {
                string = AMAuthConfigUtils.getAuthenticatorClassName(string2, set2);
                if (debug.messageEnabled()) {
                    debug.message("className : " + string);
                }
                hashMap.put(string2, string);
                continue;
            }
            hashMap.put(string2, string2);
        }
        return hashMap;
    }

    private static String getAuthenticatorClassName(String string, Set set) {
        String string2 = null;
        if (set == null) {
            return string;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3;
            string2 = null;
            String string4 = (String)iterator.next();
            if (string4.equals(APPLICATION_CLASS_NAME)) continue;
            int n = string4.lastIndexOf(46);
            if (n > -1 && (string3 = string4.substring(n + 1, string4.length())).equals(string)) {
                string2 = string4;
            }
            if (string2 != null) break;
        }
        if (debug.messageEnabled()) {
            debug.message("fullClassName is : " + string2);
        }
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static Set getGlobalAuthenticators(SSOToken sSOToken) {
        Set set = null;
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(AUTH_SERVICE, sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            set = (Set)map.get(AUTH_AUTHENTICATOR_ATTR);
        }
        catch (Exception exception) {
            debug.error("getAllAuthModules", (Throwable)exception);
        }
        return set;
    }
}

