/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.util.Debug;

public class AMAuthConfigType {
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    protected static final int USER = 1;
    protected static final int ORGANIZATION = 2;
    protected static final int ROLE = 3;
    protected static final int SERVICE = 4;
    protected static final int MODULE = 5;
    private String configName;
    private String orgDN;
    private String indexName;
    private String clientType;
    private int indexType = 0;

    AMAuthConfigType(String string) {
        if (string.startsWith("MODULE")) {
            int n = string.indexOf(";ORGANIZATION=");
            int n2 = string.indexOf(";CLIENT=");
            if (n == -1 || n2 == -1) {
                debug.error("Invalid module config name " + string);
                return;
            }
            this.indexType = 5;
            this.indexName = string.substring("MODULE".length() + 1, n);
            this.orgDN = string.substring(n + "ORGANIZATION".length() + 2, n2);
            this.clientType = string.substring(n2 + "CLIENT".length() + 2);
        } else if (string.startsWith("USER")) {
            int n = string.indexOf(";ORGANIZATION=");
            int n3 = string.indexOf(";CLIENT=");
            if (n == -1 || n3 == -1) {
                debug.error("Invalid module config name " + string);
                return;
            }
            this.indexType = 1;
            this.indexName = string.substring("USER".length() + 1, n);
            this.orgDN = string.substring(n + "ORGANIZATION".length() + 2, n3);
            this.clientType = string.substring(n3 + "CLIENT".length() + 2);
        } else if (string.startsWith("ORGANIZATION")) {
            int n = string.indexOf(";CLIENT=");
            if (n == -1) {
                debug.error("Invalid module config name " + string);
                return;
            }
            this.indexType = 2;
            this.orgDN = this.indexName = string.substring("ORGANIZATION".length() + 1, n);
            this.clientType = string.substring(n + "CLIENT".length() + 2);
        } else if (string.startsWith("SERVICE")) {
            int n = string.indexOf(";ORGANIZATION=");
            int n4 = string.indexOf(";CLIENT=");
            if (n == -1 || n4 == -1) {
                debug.error("Invalid module config name " + string);
                return;
            }
            this.indexType = 4;
            this.indexName = string.substring("SERVICE".length() + 1, n);
            this.orgDN = string.substring(n + "ORGANIZATION".length() + 2, n4);
            this.clientType = string.substring(n4 + "CLIENT".length() + 2);
        } else if (string.startsWith("ROLE")) {
            int n = string.indexOf(";ORGANIZATION=");
            int n5 = string.indexOf(";CLIENT=");
            if (n == -1 || n5 == -1) {
                debug.error("Invalid module config name " + string);
                return;
            }
            this.indexType = 3;
            this.indexName = string.substring("ROLE".length() + 1, n);
            this.orgDN = string.substring(n + "ORGANIZATION".length() + 2, n5);
            this.clientType = string.substring(n5 + "CLIENT".length() + 2);
        } else {
            debug.message("Invalid index type in config name " + string);
        }
        if (debug.messageEnabled()) {
            debug.message("indexType = " + this.indexType + "\nindexName=" + this.indexName + "\norgDN=" + this.orgDN + "\nclientType=" + this.clientType);
        }
    }

    String getOrganization() {
        return this.orgDN;
    }

    String getClientType() {
        return this.clientType;
    }

    String getIndexName() {
        return this.indexName;
    }

    int getIndexType() {
        return this.indexType;
    }
}

