/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaElement;
import com.netscape.jndi.ldap.schema.SchemaManager;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPAttributeSchema;

public class SchemaAttribute
extends SchemaElement {
    LDAPAttributeSchema m_ldapAttribute;
    private static String[] m_allAttrIds = new String[]{"NUMERICOID", "NAME", "DESC", "OBSOLETE", "SUP", "EQUALITY", "ORDERING", "SUBSTRING", "SYNTAX", "SINGLE-VALUE", "COLLECTIVE", "NO-USER-MODIFICATION", "USAGE"};

    public SchemaAttribute(Attributes attributes, SchemaManager schemaManager) throws NamingException {
        super(schemaManager);
        this.m_ldapAttribute = SchemaAttribute.parseDefAttributes(attributes);
        this.m_path = "AttributeDefinition/" + this.m_ldapAttribute.getName();
    }

    public SchemaAttribute(LDAPAttributeSchema lDAPAttributeSchema, SchemaManager schemaManager) {
        super(schemaManager);
        this.m_ldapAttribute = lDAPAttributeSchema;
        this.m_path = "AttributeDefinition/" + this.m_ldapAttribute.getName();
    }

    Attributes extractAttributeIds(String[] stringArray) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes();
        String string = null;
        String[] stringArray2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("NUMERICOID")) {
                string = this.m_ldapAttribute.getID();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("NUMERICOID", string));
                }
            } else if (stringArray[n].equals("NAME")) {
                string = this.m_ldapAttribute.getName();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("NAME", string));
                }
            } else if (stringArray[n].equals("DESC")) {
                string = this.m_ldapAttribute.getDescription();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("DESC", string));
                }
            } else if (stringArray[n].equals("SYNTAX")) {
                string = this.m_ldapAttribute.getSyntaxString();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("SYNTAX", string));
                }
            } else if (stringArray[n].equals("SINGLE-VALUE")) {
                if (this.m_ldapAttribute.isSingleValued()) {
                    basicAttributes.put(new BasicAttribute("SINGLE-VALUE", "true"));
                }
            } else if (stringArray[n].equals("SUP")) {
                string = this.m_ldapAttribute.getSuperior();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("SUP", string));
                }
            } else if (stringArray[n].equals("USAGE")) {
                stringArray2 = this.m_ldapAttribute.getQualifier("USAGE");
                if (stringArray2 != null) {
                    basicAttributes.put(new BasicAttribute("USAGE", stringArray2));
                }
            } else if (stringArray[n].equals("OBSOLETE")) {
                if (this.m_ldapAttribute.getQualifier("OBSOLETE") != null) {
                    basicAttributes.put(new BasicAttribute("OBSOLETE", "true"));
                }
            } else if (stringArray[n].equals("COLLECTIVE")) {
                if (this.m_ldapAttribute.getQualifier("COLLECTIVE") != null) {
                    basicAttributes.put(new BasicAttribute("COLLECTIVE", "true"));
                }
            } else if (stringArray[n].equals("NO-USER-MODIFICATION")) {
                if (this.m_ldapAttribute.getQualifier("NO-USER-MODIFICATION") != null) {
                    basicAttributes.put(new BasicAttribute("NO-USER-MODIFICATION", "true"));
                }
            } else if (stringArray[n].equals("EQUALITY")) {
                stringArray2 = this.m_ldapAttribute.getQualifier("EQUALITY");
                if (stringArray2 != null) {
                    basicAttributes.put(new BasicAttribute("EQUALITY", stringArray2));
                }
            } else if (stringArray[n].equals("ORDERING")) {
                stringArray2 = this.m_ldapAttribute.getQualifier("ORDERING");
                if (stringArray2 != null) {
                    basicAttributes.put(new BasicAttribute("ORDERING", stringArray2));
                }
            } else if (stringArray[n].equals("SUBSTRING")) {
                stringArray2 = this.m_ldapAttribute.getQualifier("SUBSTRING");
                if (stringArray2 != null) {
                    basicAttributes.put(new BasicAttribute("SUBSTRING", stringArray2));
                }
            } else {
                throw new NamingException("Invalid schema attribute type for attribute definition " + stringArray[n]);
            }
            ++n;
        }
        return basicAttributes;
    }

    public Attributes getAttributes(String string) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        return this.extractAttributeIds(m_allAttrIds);
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        return this.extractAttributeIds(stringArray);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.getAttributes(name.toString(), stringArray);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        Attributes attributes2 = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(attributes2, n, attributes);
        LDAPAttributeSchema lDAPAttributeSchema = SchemaAttribute.parseDefAttributes(attributes2);
        this.m_schemaMgr.modifyAttribute(this.m_ldapAttribute, lDAPAttributeSchema);
        this.m_ldapAttribute = lDAPAttributeSchema;
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        Attributes attributes = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(attributes, modificationItemArray);
        LDAPAttributeSchema lDAPAttributeSchema = SchemaAttribute.parseDefAttributes(attributes);
        this.m_schemaMgr.modifyAttribute(this.m_ldapAttribute, lDAPAttributeSchema);
        this.m_ldapAttribute = lDAPAttributeSchema;
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes(name.toString(), n, attributes);
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes(name.toString(), modificationItemArray);
    }

    static LDAPAttributeSchema parseDefAttributes(Attributes attributes) throws NamingException {
        Attribute attribute;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            attribute = (Attribute)namingEnumeration.nextElement();
            String string10 = attribute.getID();
            if (string10.equals("NAME")) {
                string = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string10.equals("NUMERICOID")) {
                string2 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string10.equals("SYNTAX")) {
                string4 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string10.equals("DESC")) {
                string3 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string10.equals("SINGLE-VALUE")) {
                bl = SchemaElement.parseTrueFalseValue(attribute);
                continue;
            }
            if (string10.equals("SUP")) {
                string6 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string10.equals("USAGE")) {
                string5 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string10.equals("OBSOLETE")) {
                bl3 = SchemaElement.parseTrueFalseValue(attribute);
                continue;
            }
            if (string10.equals("COLLECTIVE")) {
                bl2 = SchemaElement.parseTrueFalseValue(attribute);
                continue;
            }
            if (string10.equals("NO-USER-MODIFICATION")) {
                bl4 = SchemaElement.parseTrueFalseValue(attribute);
                continue;
            }
            if (string10.equals("EQUALITY")) {
                string7 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string10.equals("ORDERING")) {
                string8 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string10.equals("SUBSTRING")) {
                string9 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            throw new NamingException("Invalid schema attribute type for attribute definition " + string10);
        }
        attribute = new LDAPAttributeSchema(string, string2, string3, string4, bl, string6, null);
        if (bl3) {
            attribute.setQualifier("OBSOLETE", "");
        }
        if (bl2) {
            attribute.setQualifier("COLLECTIVE", "");
        }
        if (bl4) {
            attribute.setQualifier("NO-USER-MODIFICATION", "");
        }
        if (string7 != null) {
            attribute.setQualifier("EQUALITY", string7);
        }
        if (string8 != null) {
            attribute.setQualifier("ORDERING", string8);
        }
        if (string9 != null) {
            attribute.setQualifier("SUBSTRING", string9);
        }
        if (string5 != null) {
            attribute.setQualifier("USAGE", string5);
        }
        return attribute;
    }
}

