/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.common;

import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;

public class ExceptionMapper {
    public static NamingException getNamingException(Exception exception) {
        Throwable throwable;
        if (exception instanceof NamingException) {
            return (NamingException)exception;
        }
        if (exception instanceof LDAPReferralException) {
            return new NamingException("Provider internal error, LDAPReferralException not captured");
        }
        if (exception instanceof LDAPException) {
            throwable = (LDAPException)((Object)exception);
            int n = throwable.getLDAPResultCode();
            if (n == 1) {
                NamingException namingException = new NamingException(throwable.toString());
                namingException.setRootCause(throwable);
                return namingException;
            }
            if (n == 2) {
                return new CommunicationException(throwable.toString());
            }
            if (n == 3) {
                return new TimeLimitExceededException(throwable.toString());
            }
            if (n == 4) {
                return new SizeLimitExceededException(throwable.toString());
            }
            if (n == 5) {
                NamingException namingException = new NamingException(throwable.toString());
                namingException.setRootCause(throwable);
                return namingException;
            }
            if (n == 6) {
                NamingException namingException = new NamingException(throwable.toString());
                namingException.setRootCause(throwable);
                return namingException;
            }
            if (n == 7) {
                return new AuthenticationNotSupportedException(throwable.toString());
            }
            if (n == 8) {
                return new AuthenticationNotSupportedException(throwable.toString());
            }
            if (n == 9) {
                return new PartialResultException(throwable.toString());
            }
            if (n == 10) {
                LDAPReferralException lDAPReferralException = (LDAPReferralException)throwable;
            } else {
                if (n == 11) {
                    return new LimitExceededException(throwable.toString());
                }
                if (n == 12) {
                    return new OperationNotSupportedException(throwable.toString());
                }
                if (n == 13) {
                    return new AuthenticationNotSupportedException("A secure connection is required for this operation");
                }
                if (n == 14) {
                    NamingException namingException = new NamingException(throwable.toString());
                    namingException.setRootCause(throwable);
                    return namingException;
                }
                if (n == 16) {
                    return new NoSuchAttributeException(throwable.toString());
                }
                if (n == 17) {
                    return new InvalidAttributeIdentifierException(throwable.toString());
                }
                if (n == 18) {
                    return new InvalidSearchFilterException(throwable.toString());
                }
                if (n == 19) {
                    return new InvalidSearchControlsException(throwable.toString());
                }
                if (n == 20) {
                    return new AttributeInUseException(throwable.toString());
                }
                if (n == 21) {
                    return new InvalidAttributeValueException(throwable.toString());
                }
                if (n == 32) {
                    return new NameNotFoundException(throwable.toString());
                }
                if (n == 33) {
                    return new NamingException(throwable.toString());
                }
                if (n == 34) {
                    return new InvalidNameException(throwable.toString());
                }
                if (n == 35) {
                    NamingException namingException = new NamingException(throwable.toString());
                    namingException.setRootCause(throwable);
                    return namingException;
                }
                if (n == 36) {
                    NamingException namingException = new NamingException(throwable.toString());
                    namingException.setRootCause(throwable);
                    return namingException;
                }
                if (n == 48) {
                    return new AuthenticationException(throwable.toString());
                }
                if (n == 49) {
                    return new AuthenticationException(throwable.toString());
                }
                if (n == 50) {
                    return new NoPermissionException(throwable.toString());
                }
                if (n == 51) {
                    return new ServiceUnavailableException(throwable.toString());
                }
                if (n == 52) {
                    return new ServiceUnavailableException(throwable.toString());
                }
                if (n == 53) {
                    return new OperationNotSupportedException(throwable.toString());
                }
                if (n == 54) {
                    NamingException namingException = new NamingException(throwable.toString());
                    namingException.setRootCause(throwable);
                    return namingException;
                }
                if (n == 64) {
                    return new InvalidNameException(throwable.toString());
                }
                if (n == 65) {
                    return new SchemaViolationException(throwable.toString());
                }
                if (n == 66) {
                    return new ContextNotEmptyException(throwable.toString());
                }
                if (n == 67) {
                    return new SchemaViolationException(throwable.toString());
                }
                if (n == 68) {
                    return new NameAlreadyBoundException(throwable.toString());
                }
                if (n == 69) {
                    return new SchemaViolationException(throwable.toString());
                }
                if (n == 81) {
                    return new CommunicationException(throwable.toString());
                }
                if (n == 91) {
                    return new CommunicationException(throwable.toString());
                }
                NamingException namingException = new NamingException(throwable.toString());
                namingException.setRootCause(throwable);
                return namingException;
            }
        }
        throwable = new NamingException(exception.toString());
        ((NamingException)throwable).setRootCause(exception);
        return throwable;
    }
}

