/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;

class ProviderUtils {
    public static final String DEFAULT_FILTER = "(objectclass=*)";
    static final String hexDigits = "0123456789abcdef";

    ProviderUtils() {
    }

    static String attributesToFilter(Attributes attributes) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            return DEFAULT_FILTER;
        }
        String string = "";
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = namingEnumeration.next();
            if (attribute.size() == 0) {
                string = String.valueOf(string) + "(" + attribute.getID() + "=*)";
                continue;
            }
            String string2 = "";
            NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
            while (namingEnumeration2.hasMore()) {
                Object obj = namingEnumeration2.next();
                if (obj instanceof String) {
                    string2 = String.valueOf(string2) + "(" + attribute.getID() + "=" + ProviderUtils.escapeString((String)obj) + ")";
                    continue;
                }
                if (obj instanceof byte[]) {
                    string2 = String.valueOf(string2) + "(" + attribute.getID() + "=" + ProviderUtils.escapeBytes((byte[])obj) + ")";
                    continue;
                }
                if (obj == null) {
                    string2 = String.valueOf(string2) + "(" + attribute.getID() + "=*)";
                    continue;
                }
                throw new NamingException("Wrong Attribute value, expecting String or byte[]");
            }
            string = String.valueOf(string) + (attribute.size() > 1 ? "(|" + string2 + ")" : string2);
        }
        return attributes.size() > 1 ? "(&" + string + ")" : string;
    }

    static String escapeBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xF;
            int n3 = (byArray[n] & 0xF0) >> 4;
            stringBuffer.append("\\");
            stringBuffer.append(hexDigits.charAt(n3));
            stringBuffer.append(hexDigits.charAt(n2));
            ++n;
        }
        return stringBuffer.toString();
    }

    static String escapeString(String string) {
        String string2 = "\\*()\u0000";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        if (stringTokenizer.countTokens() == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("*")) {
                stringBuffer.append("\\2a");
                continue;
            }
            if (string3.equals("(")) {
                stringBuffer.append("\\28");
                continue;
            }
            if (string3.equals(")")) {
                stringBuffer.append("\\29");
                continue;
            }
            if (string3.equals("\\")) {
                stringBuffer.append("\\5c");
                continue;
            }
            if (string3.equals("\u0000")) {
                stringBuffer.append("\\00");
                continue;
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    static String expandFilterExpr(String string, Object[] objectArray) throws InvalidSearchFilterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
        if (stringTokenizer.countTokens() == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        Object object = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                bl = false;
                try {
                    int n = Integer.parseInt(string2);
                    object = objectArray[n];
                    bl2 = true;
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new InvalidSearchFilterException("Filter expression variable index out of bounds");
                }
                catch (Exception exception) {
                    throw new InvalidSearchFilterException("Invalid filter expression");
                }
            }
            if (bl2) {
                bl2 = false;
                if (!string2.equals("}")) {
                    throw new InvalidSearchFilterException("Invalid filter expression");
                }
                if (object instanceof String) {
                    stringBuffer.append(ProviderUtils.escapeString((String)object));
                } else if (object instanceof byte[]) {
                    stringBuffer.append(ProviderUtils.escapeBytes((byte[])object));
                } else {
                    throw new InvalidSearchFilterException("Invalid filter argument type");
                }
                object = null;
                continue;
            }
            if (string2.equals("{")) {
                bl = true;
                continue;
            }
            stringBuffer.append(string2);
        }
        if (bl || bl2) {
            throw new InvalidSearchFilterException("Invalid filter expression");
        }
        return stringBuffer.toString();
    }

    static int jndiSearchScopeToLdap(int n) throws NamingException {
        int n2 = -1;
        if (n == 2) {
            n2 = 2;
        } else if (n == 1) {
            n2 = 1;
        } else if (n == 0) {
            n2 = 0;
        } else {
            throw new InvalidSearchControlsException("Illegal value for the search scope");
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        ProviderUtils.testFilterExpr();
    }

    private static void testAttributesToFilter() {
        try {
            System.out.println(ProviderUtils.attributesToFilter(null));
            BasicAttributes basicAttributes = new BasicAttributes(true);
            System.out.println(String.valueOf(String.valueOf(basicAttributes)) + " = " + ProviderUtils.attributesToFilter(basicAttributes));
            basicAttributes.put(new BasicAttribute("attr1", "val1"));
            basicAttributes.put(new BasicAttribute("attr2", "(val2)\\*x"));
            basicAttributes.put(new BasicAttribute("attr3"));
            BasicAttribute basicAttribute = new BasicAttribute("attr4", "val41");
            basicAttribute.add("val42");
            basicAttributes.put(basicAttribute);
            byte[] byArray = new byte[5];
            byArray[0] = 35;
            byArray[1] = 3;
            byArray[3] = -85;
            byArray[4] = -1;
            basicAttributes.put("attr5", byArray);
            System.out.println(String.valueOf(String.valueOf(basicAttributes)) + " = " + ProviderUtils.attributesToFilter(basicAttributes));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private static void testFilterExpr() {
        try {
            String string = "(&(attr0={0})(attr1={1}))";
            Object[] objectArray = new Object[]{"val*0", new byte[]{-16, 58}};
            String string2 = null;
            string2 = ProviderUtils.expandFilterExpr(string, objectArray);
            System.out.println(String.valueOf(string) + " -> " + string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

