/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributesImpl;
import com.netscape.jndi.ldap.BindingEnum;
import com.netscape.jndi.ldap.ContextEnv;
import com.netscape.jndi.ldap.EventService;
import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapReferralException;
import com.netscape.jndi.ldap.NameClassPairEnum;
import com.netscape.jndi.ldap.ObjectMapper;
import com.netscape.jndi.ldap.ProviderUtils;
import com.netscape.jndi.ldap.SearchResultEnum;
import com.netscape.jndi.ldap.common.Debug;
import com.netscape.jndi.ldap.common.ExceptionMapper;
import com.netscape.jndi.ldap.schema.SchemaRoot;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSSLSocketFactory;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPUrl;

class LdapService {
    public static final String DEFAULT_FILTER = "(objectclass=*)";
    public static final int DEFAULT_SCOPE = 2;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    private LDAPConnection m_ld = new LDAPConnection();
    private EventService m_eventSvc;
    private int m_clientCount = 1;

    LdapContextImpl addEntry(LdapContextImpl ldapContextImpl, String string, LDAPAttributeSet lDAPAttributeSet) throws NamingException {
        Debug.println(1, "ADD");
        String string2 = ldapContextImpl.getDN();
        this.connect(ldapContextImpl);
        if (string.length() == 0) {
            throw new IllegalArgumentException("Name can not be empty");
        }
        string2 = string2.length() > 0 ? String.valueOf(string) + "," + string2 : string;
        try {
            this.m_ld.add(new LDAPEntry(string2, lDAPAttributeSet));
            return new LdapContextImpl(string2, ldapContextImpl);
        }
        catch (LDAPReferralException lDAPReferralException) {
            throw new LdapReferralException(ldapContextImpl, lDAPReferralException);
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    void changeRDN(LdapContextImpl ldapContextImpl, String string, String string2) throws NamingException {
        Debug.println(1, "RENAME");
        String string3 = ldapContextImpl.getDN();
        this.connect(ldapContextImpl);
        if (string.length() == 0 || string2.length() == 0) {
            throw new IllegalArgumentException("Name can not be empty");
        }
        string3 = string3.length() > 0 ? String.valueOf(string) + "," + string3 : string;
        try {
            this.m_ld.rename(string3, string2, ldapContextImpl.m_ctxEnv.getDeleteOldRDNFlag());
        }
        catch (LDAPReferralException lDAPReferralException) {
            throw new LdapReferralException(ldapContextImpl, lDAPReferralException);
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    void connect(LdapContextImpl ldapContextImpl) throws NamingException {
        if (this.m_ld.isConnected()) {
            return;
        }
        LDAPUrl lDAPUrl = ldapContextImpl.m_ctxEnv.getDirectoryServerURL();
        String string = lDAPUrl != null ? lDAPUrl.getHost() : DEFAULT_HOST;
        int n = lDAPUrl != null ? lDAPUrl.getPort() : 389;
        String string2 = ldapContextImpl.m_ctxEnv.getUserDN();
        String string3 = ldapContextImpl.m_ctxEnv.getUserPassword();
        String string4 = ldapContextImpl.m_ctxEnv.getSocketFactory();
        Object object = ldapContextImpl.m_ctxEnv.getCipherSuite();
        int n2 = ldapContextImpl.m_ctxEnv.getLdapVersion();
        boolean bl = ldapContextImpl.m_ctxEnv.isSSLEnabled();
        String[] stringArray = ldapContextImpl.m_ctxEnv.getSaslMechanisms();
        LDAPControl[] lDAPControlArray = ldapContextImpl.m_ctxEnv.getConnectControls();
        Object object2 = ldapContextImpl.m_ctxEnv.getProperty("com.netscape.ldap.trace");
        if (bl && lDAPUrl == null) {
            n = 636;
        }
        if (bl && string4 == null) {
            this.m_ld = new LDAPConnection((LDAPSocketFactory)new LDAPSSLSocketFactory());
        }
        if (string4 != null) {
            try {
                LDAPSSLSocketFactory lDAPSSLSocketFactory = null;
                if (object != null) {
                    Debug.println(1, "CIPHERS=" + object);
                    lDAPSSLSocketFactory = new LDAPSSLSocketFactory(string4, object);
                } else {
                    lDAPSSLSocketFactory = new LDAPSSLSocketFactory(string4);
                }
                this.m_ld = new LDAPConnection((LDAPSocketFactory)lDAPSSLSocketFactory);
                Debug.println(1, "SSL CONNECTION");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.factory.socket: " + exception);
            }
        }
        if (object2 != null) {
            this.setTraceOutput(object2);
        }
        try {
            if (lDAPControlArray != null) {
                this.m_ld.setOption(12, (Object)lDAPControlArray);
            }
            if (stringArray != null) {
                this.m_ld.authenticate(ldapContextImpl.m_ctxEnv.getSaslAuthId(), stringArray, ldapContextImpl.m_ctxEnv.getSaslProps(), ldapContextImpl.m_ctxEnv.getSaslCallback());
            } else {
                this.m_ld.connect(n2, string, n, string2, string3);
            }
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 2 && n2 == 3 && stringArray == null) {
                ContextEnv cfr_ignored_0 = ldapContextImpl.m_ctxEnv;
                if (ldapContextImpl.m_ctxEnv.getProperty("java.naming.ldap.version") == null) {
                    try {
                        this.m_ld.connect(2, string, n, string2, string3);
                    }
                    catch (LDAPException lDAPException2) {
                        throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException2));
                    }
                }
            }
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    void delEntry(LdapContextImpl ldapContextImpl, String string) throws NamingException {
        Debug.println(1, "DELETE");
        String string2 = ldapContextImpl.getDN();
        this.connect(ldapContextImpl);
        if (string.length() == 0) {
            throw new IllegalArgumentException("Name can not be empty");
        }
        string2 = string2.length() > 0 ? String.valueOf(string) + "," + string2 : string;
        try {
            this.m_ld.delete(string2);
        }
        catch (LDAPReferralException lDAPReferralException) {
            throw new LdapReferralException(ldapContextImpl, lDAPReferralException);
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    synchronized void disconnect() {
        try {
            if (this.m_clientCount > 0) {
                --this.m_clientCount;
            }
            if (this.m_clientCount == 0 && this.isConnected()) {
                this.m_ld.disconnect();
            }
        }
        catch (Exception exception) {}
    }

    protected void finalize() {
        try {
            this.m_ld.disconnect();
        }
        catch (Exception exception) {}
    }

    LDAPConnection getConnection() {
        return this.m_ld;
    }

    EventService getEventService(LdapContextImpl ldapContextImpl) throws NamingException {
        this.connect(ldapContextImpl);
        if (this.m_eventSvc == null) {
            this.m_eventSvc = new EventService(this);
        }
        return this.m_eventSvc;
    }

    DirContext getSchema(LdapContextImpl ldapContextImpl, String string) throws NamingException {
        this.connect(ldapContextImpl);
        return new SchemaRoot(this.m_ld);
    }

    synchronized void incrementClientCount() {
        ++this.m_clientCount;
    }

    boolean isConnected() {
        return this.m_ld.isConnected();
    }

    NamingEnumeration listEntries(LdapContextImpl ldapContextImpl, String string, boolean bl) throws NamingException {
        Debug.println(1, "LIST " + (bl ? "BINDINGS" : ""));
        String string2 = ldapContextImpl.getDN();
        this.connect(ldapContextImpl);
        if (string.length() > 0) {
            string2 = string2.length() > 0 ? String.valueOf(string) + "," + string2 : string;
        }
        try {
            String[] stringArray = null;
            if (!bl) {
                stringArray = new String[]{"javaclassname"};
            }
            LDAPSearchConstraints lDAPSearchConstraints = ldapContextImpl.getSearchConstraints();
            LDAPSearchResults lDAPSearchResults = this.m_ld.search(string2, 1, DEFAULT_FILTER, stringArray, false, lDAPSearchConstraints);
            if (bl) {
                return new BindingEnum(lDAPSearchResults, ldapContextImpl);
            }
            return new NameClassPairEnum(lDAPSearchResults, ldapContextImpl);
        }
        catch (LDAPReferralException lDAPReferralException) {
            throw new LdapReferralException(ldapContextImpl, lDAPReferralException);
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    Object lookup(LdapContextImpl ldapContextImpl, String string) throws NamingException {
        Debug.println(1, "LOOKUP");
        String string2 = ldapContextImpl.getDN();
        this.connect(ldapContextImpl);
        if (string.length() > 0) {
            string2 = string2.length() > 0 ? String.valueOf(string) + "," + string2 : string;
        }
        try {
            String[] stringArray = null;
            LDAPSearchConstraints lDAPSearchConstraints = ldapContextImpl.getSearchConstraints();
            LDAPSearchResults lDAPSearchResults = this.m_ld.search(string2, 0, DEFAULT_FILTER, stringArray, false, lDAPSearchConstraints);
            if (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                return ObjectMapper.entryToObject(lDAPEntry, ldapContextImpl);
            }
            return null;
        }
        catch (LDAPReferralException lDAPReferralException) {
            throw new LdapReferralException(ldapContextImpl, lDAPReferralException);
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    void modifyEntry(LdapContextImpl ldapContextImpl, String string, LDAPModificationSet lDAPModificationSet) throws NamingException {
        Debug.println(1, "MODIFY");
        String string2 = ldapContextImpl.getDN();
        if (lDAPModificationSet.size() == 0) {
            return;
        }
        this.connect(ldapContextImpl);
        if (string.length() > 0) {
            string2 = string2.length() > 0 ? String.valueOf(string) + "," + string2 : string;
        }
        try {
            this.m_ld.modify(string2, lDAPModificationSet);
        }
        catch (LDAPReferralException lDAPReferralException) {
            throw new LdapReferralException(ldapContextImpl, lDAPReferralException);
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    Attributes readAttrs(LdapContextImpl ldapContextImpl, String string, String[] stringArray) throws NamingException {
        Debug.println(1, "READ ATTRS");
        String string2 = ldapContextImpl.getDN();
        int n = 0;
        this.connect(ldapContextImpl);
        if (string.length() > 0) {
            string2 = string2.length() > 0 ? String.valueOf(string) + "," + string2 : string;
        }
        try {
            LDAPSearchConstraints lDAPSearchConstraints = ldapContextImpl.getSearchConstraints();
            LDAPSearchResults lDAPSearchResults = this.m_ld.search(string2, n, DEFAULT_FILTER, stringArray, false, lDAPSearchConstraints);
            if (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                return new AttributesImpl(lDAPEntry.getAttributeSet(), ldapContextImpl.m_ctxEnv.getUserDefBinaryAttrs());
            }
            return null;
        }
        catch (LDAPReferralException lDAPReferralException) {
            throw new LdapReferralException(ldapContextImpl, lDAPReferralException);
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    NamingEnumeration search(LdapContextImpl ldapContextImpl, String string, String string2, String[] stringArray, SearchControls searchControls) throws NamingException {
        int n;
        Debug.println(1, "SEARCH");
        String string3 = ldapContextImpl.getDN();
        int n2 = 2;
        LDAPSearchConstraints lDAPSearchConstraints = ldapContextImpl.getSearchConstraints();
        boolean bl = false;
        this.connect(ldapContextImpl);
        if (string.length() > 0) {
            string3 = string3.length() > 0 ? String.valueOf(string) + "," + string3 : string;
        }
        if (searchControls != null) {
            n = (int)searchControls.getCountLimit();
            int n3 = searchControls.getTimeLimit();
            int n4 = n3 / 1000;
            if (n3 > 0 && n3 < 1000) {
                n4 = 1;
            }
            if (lDAPSearchConstraints.getServerTimeLimit() != n4 || lDAPSearchConstraints.getMaxResults() != n) {
                lDAPSearchConstraints = (LDAPSearchConstraints)lDAPSearchConstraints.clone();
                lDAPSearchConstraints.setMaxResults(n);
                lDAPSearchConstraints.setServerTimeLimit(n4);
            }
            if ((stringArray = searchControls.getReturningAttributes()) != null && stringArray.length == 0) {
                stringArray = new String[]{"1.1"};
            }
            n2 = ProviderUtils.jndiSearchScopeToLdap(searchControls.getSearchScope());
            bl = searchControls.getReturningObjFlag();
        }
        try {
            n = ldapContextImpl.m_ctxEnv.getAttrsOnlyFlag() ? 1 : 0;
            LDAPSearchResults lDAPSearchResults = this.m_ld.search(string3, n2, string2, stringArray, n != 0, lDAPSearchConstraints);
            return new SearchResultEnum(lDAPSearchResults, bl, ldapContextImpl);
        }
        catch (LDAPReferralException lDAPReferralException) {
            throw new LdapReferralException(ldapContextImpl, lDAPReferralException);
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException((Exception)((Object)lDAPException));
        }
    }

    void setTraceOutput(Object object) throws NamingException {
        try {
            this.m_ld.setProperty("com.netscape.ldap.trace", object);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can not open trace output " + exception);
        }
    }
}

