/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributesImpl;
import com.netscape.jndi.ldap.ContextEnv;
import com.netscape.jndi.ldap.EventService;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.LdapService;
import com.netscape.jndi.ldap.ObjectMapper;
import com.netscape.jndi.ldap.ProviderUtils;
import com.netscape.jndi.ldap.common.Debug;
import com.netscape.jndi.ldap.controls.NetscapeControlFactory;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPUrl;

public class LdapContextImpl
implements EventDirContext,
LdapContext {
    protected ContextEnv m_ctxEnv;
    protected String m_ctxDN;
    protected LdapService m_ldapSvc;
    protected LDAPSearchConstraints m_searchCons;

    public LdapContextImpl(String string, LdapContextImpl ldapContextImpl) throws NamingException {
        this.m_ctxEnv = (ContextEnv)ldapContextImpl.m_ctxEnv.clone();
        this.m_ldapSvc = ldapContextImpl.m_ldapSvc;
        ldapContextImpl.m_ldapSvc.incrementClientCount();
        if (ldapContextImpl.getSearchConstraints().getServerControls() == null) {
            this.m_searchCons = ldapContextImpl.getSearchConstraints();
        } else {
            this.m_searchCons = (LDAPSearchConstraints)ldapContextImpl.getSearchConstraints().clone();
            this.m_searchCons.setServerControls(null);
        }
        this.m_ctxDN = string;
    }

    public LdapContextImpl(Hashtable hashtable) throws NamingException {
        this.m_ctxEnv = new ContextEnv(hashtable);
        this.m_ldapSvc = new LdapService();
        this.m_ldapSvc.connect(this);
        this.getDN();
        this.getSearchConstraints();
    }

    public void addNamingListener(String string, int n, NamingListener namingListener) throws NamingException {
        EventService eventService = this.m_ldapSvc.getEventService(this);
        String string2 = "(objectclass=*)";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(n);
        eventService.addListener(this, string, string2, searchControls, namingListener);
    }

    public void addNamingListener(String string, String string2, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        EventService eventService = this.m_ldapSvc.getEventService(this);
        eventService.addListener(this, string, string2, searchControls, namingListener);
    }

    public void addNamingListener(String string, String string2, Object[] objectArray, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        EventService eventService = this.m_ldapSvc.getEventService(this);
        String string3 = ProviderUtils.expandFilterExpr(string2, objectArray);
        eventService.addListener(this, string, string3, searchControls, namingListener);
    }

    public void addNamingListener(Name name, int n, NamingListener namingListener) throws NamingException {
        this.addNamingListener(name.toString(), n, namingListener);
    }

    public void addNamingListener(Name name, String string, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener(name.toString(), string, searchControls, namingListener);
    }

    public void addNamingListener(Name name, String string, Object[] objectArray, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener(name.toString(), string, objectArray, searchControls, namingListener);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (string.equalsIgnoreCase("com.netscape.ldap.trace")) {
            this.m_ldapSvc.setTraceOutput(object);
        }
        return this.m_ctxEnv.updateProperty(string, object, this.getSearchConstraints());
    }

    public void bind(String string, Object object) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        this.m_ldapSvc.addEntry(this, string.toString(), ObjectMapper.objectToAttrSet(object, string, this, null));
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        this.m_ldapSvc.addEntry(this, string.toString(), ObjectMapper.objectToAttrSet(object, string, this, attributes));
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.bind(name.toString(), object, attributes);
    }

    String checkLdapUrlAsName(String string) throws NamingException {
        if (string.startsWith("ldap://")) {
            this.m_ctxEnv.setProperty("java.naming.provider.url", string);
            this.close();
            this.m_ldapSvc = new LdapService();
            return "";
        }
        return string;
    }

    public void close() throws NamingException {
        this.m_ldapSvc.disconnect();
        this.m_ldapSvc = null;
    }

    public String composeName(String string, String string2) throws NamingException {
        return String.valueOf(string) + "," + string2;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        String string = this.composeName(name.toString(), name2.toString());
        return LdapNameParser.getParser().parse(string);
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        return this.m_ldapSvc.addEntry(this, string, AttributesImpl.jndiAttrsToLdapAttrSet(attributes));
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        return this.m_ldapSvc.addEntry(this, name.toString(), AttributesImpl.jndiAttrsToLdapAttrSet(attributes));
    }

    public void destroySubcontext(String string) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        this.m_ldapSvc.delEntry(this, string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.m_ldapSvc.delEntry(this, name.toString());
    }

    public ExtendedResponse extendedOperation(ExtendedRequest extendedRequest) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected void finalize() {
        Debug.println(1, "finalize ctx");
        try {
            this.close();
        }
        catch (Exception exception) {}
    }

    public Attributes getAttributes(String string) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        return this.m_ldapSvc.readAttrs(this, string, null);
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        return this.m_ldapSvc.readAttrs(this, string, stringArray);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.m_ldapSvc.readAttrs(this, name.toString(), null);
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.m_ldapSvc.readAttrs(this, name.toString(), stringArray);
    }

    public Control[] getConnectControls() {
        return (Control[])this.m_ctxEnv.getProperty("java.naming.ldap.control.connect");
    }

    String getDN() throws NamingException {
        if (this.m_ctxDN == null) {
            LDAPUrl lDAPUrl = this.m_ctxEnv.getDirectoryServerURL();
            this.m_ctxDN = lDAPUrl != null && lDAPUrl.getDN() != null ? lDAPUrl.getDN() : "";
        }
        return this.m_ctxDN;
    }

    ContextEnv getEnv() {
        return this.m_ctxEnv;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.m_ctxEnv.getAllProperties();
    }

    public String getNameInNamespace() throws NamingException {
        return new String(this.m_ctxDN);
    }

    public NameParser getNameParser(String string) throws NamingException {
        return LdapNameParser.getParser();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return LdapNameParser.getParser();
    }

    public Control[] getRequestControls() throws NamingException {
        LDAPControl[] lDAPControlArray = this.m_searchCons.getServerControls();
        if (lDAPControlArray == null) {
            return null;
        }
        Control[] controlArray = new Control[lDAPControlArray.length];
        int n = 0;
        while (n < lDAPControlArray.length) {
            controlArray[n] = (Control)lDAPControlArray[n];
            ++n;
        }
        return controlArray;
    }

    public Control[] getResponseControls() throws NamingException {
        LDAPControl[] lDAPControlArray = this.m_ldapSvc.getConnection().getResponseControls();
        if (lDAPControlArray == null) {
            return null;
        }
        Control[] controlArray = new Control[lDAPControlArray.length];
        int n = 0;
        while (n < lDAPControlArray.length) {
            controlArray[n] = NetscapeControlFactory.getControlInstance(lDAPControlArray[n]);
            if (controlArray[n] == null) {
                throw new NamingException("Unsupported control " + lDAPControlArray[n].getID());
            }
            ++n;
        }
        return controlArray;
    }

    public DirContext getSchema(String string) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        return this.m_ldapSvc.getSchema(this, string);
    }

    public DirContext getSchema(Name name) throws NamingException {
        return this.m_ldapSvc.getSchema(this, name.toString());
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition(name.toString());
    }

    LDAPSearchConstraints getSearchConstraints() throws NamingException {
        if (this.m_searchCons == null) {
            LDAPSearchConstraints lDAPSearchConstraints = new LDAPSearchConstraints();
            this.m_ctxEnv.updateSearchCons(lDAPSearchConstraints);
            this.m_searchCons = lDAPSearchConstraints;
        }
        return this.m_searchCons;
    }

    public NamingEnumeration list(String string) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        return this.m_ldapSvc.listEntries(this, string, false);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.m_ldapSvc.listEntries(this, name.toString(), false);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        return this.m_ldapSvc.listEntries(this, string, true);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.m_ldapSvc.listEntries(this, name.toString(), true);
    }

    public Object lookup(String string) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        return this.m_ldapSvc.lookup(this, string);
    }

    public Object lookup(Name name) throws NamingException {
        return this.m_ldapSvc.lookup(this, name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        this.m_ldapSvc.modifyEntry(this, string, AttributesImpl.jndiAttrsToLdapModSet(n, attributes));
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        this.m_ldapSvc.modifyEntry(this, string, AttributesImpl.jndiModsToLdapModSet(modificationItemArray));
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.m_ldapSvc.modifyEntry(this, name.toString(), AttributesImpl.jndiAttrsToLdapModSet(n, attributes));
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.m_ldapSvc.modifyEntry(this, name.toString(), AttributesImpl.jndiModsToLdapModSet(modificationItemArray));
    }

    public LdapContext newInstance(Control[] controlArray) throws NamingException {
        LdapContextImpl ldapContextImpl = new LdapContextImpl(this.m_ctxDN, this);
        ldapContextImpl.m_ctxEnv.setProperty("java.naming.ldap.control.connect", controlArray);
        return ldapContextImpl;
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(string, object, null);
    }

    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        try {
            this.bind(string, object, attributes);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            this.unbind(string);
            this.bind(string, object, attributes);
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object, null);
    }

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.rebind(name.toString(), object, attributes);
    }

    public void reconnect(Control[] controlArray) throws NamingException {
        this.close();
        this.m_ldapSvc = new LdapService();
        if (controlArray != null) {
            this.m_ctxEnv.setProperty("java.naming.ldap.control.connect", controlArray);
        }
        this.m_ldapSvc.connect(this);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (string.equalsIgnoreCase("com.netscape.ldap.trace")) {
            this.m_ldapSvc.setTraceOutput(null);
        }
        return this.m_ctxEnv.removeProperty(string);
    }

    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        EventService eventService = this.m_ldapSvc.getEventService(this);
        eventService.removeListener(namingListener);
    }

    public void rename(String string, String string2) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        LdapNameParser ldapNameParser = LdapNameParser.getParser();
        Name name = ldapNameParser.parse(string);
        Name name2 = ldapNameParser.parse(string2);
        this.rename(name, name2);
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name2.size() != name.size()) {
            throw new InvalidNameException("Invalid name " + name2);
        }
        Name name3 = name.getPrefix(name.size() - 1);
        Name name4 = name2.getPrefix(name.size() - 1);
        if (!name4.equals(name3)) {
            throw new InvalidNameException("Invalid name " + name2);
        }
        this.m_ldapSvc.changeRDN(this, name.toString(), name2.get(name2.size() - 1));
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        return this.m_ldapSvc.search(this, string, string2, null, searchControls);
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        String string3 = ProviderUtils.expandFilterExpr(string2, objectArray);
        return this.m_ldapSvc.search(this, string, string3, null, searchControls);
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        String string2 = ProviderUtils.attributesToFilter(attributes);
        return this.m_ldapSvc.search(this, string, string2, null, null);
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        String string2 = ProviderUtils.attributesToFilter(attributes);
        return this.m_ldapSvc.search(this, string, string2, stringArray, null);
    }

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        return this.m_ldapSvc.search(this, name.toString(), string, null, searchControls);
    }

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        String string2 = ProviderUtils.expandFilterExpr(string, objectArray);
        return this.m_ldapSvc.search(this, name.toString(), string2, null, searchControls);
    }

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        String string = ProviderUtils.attributesToFilter(attributes);
        return this.m_ldapSvc.search(this, name.toString(), string, null, null);
    }

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        String string = ProviderUtils.attributesToFilter(attributes);
        return this.m_ldapSvc.search(this, name.toString(), string, stringArray, null);
    }

    public void setRequestControls(Control[] controlArray) throws NamingException {
        LDAPControl[] lDAPControlArray = new LDAPControl[controlArray.length];
        int n = 0;
        while (n < controlArray.length) {
            try {
                lDAPControlArray[n] = (LDAPControl)controlArray[n];
            }
            catch (ClassCastException classCastException) {
                throw new NamingException("Unsupported control type " + controlArray[n].getClass().getName());
            }
            ++n;
        }
        this.getSearchConstraints().setServerControls(lDAPControlArray);
    }

    public boolean targetMustExist() {
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.m_ctxDN;
    }

    public void unbind(String string) throws NamingException {
        string = this.checkLdapUrlAsName(string);
        this.destroySubcontext(string);
    }

    public void unbind(Name name) throws NamingException {
        this.destroySubcontext(name);
    }
}

