/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.cos;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.ICOSDefinition;
import java.util.ArrayList;
import java.util.Collection;

public class DirectCOSDefinition
extends PersistentObject
implements ICOSDefinition {
    private static final String[] OBJECTCLASSES = new String[]{"top", "LDAPSubentry", "cosSuperDefinition", "cosClassicDefinition"};
    private static final String[] ATTRIBUTE_NAMES = new String[]{"objectclass", "cn", "cosTemplateDn", "cosSpecifier", "cosAttribute"};
    private static final Class _class = class$com$iplanet$ums$cos$DirectCOSDefinition == null ? (class$com$iplanet$ums$cos$DirectCOSDefinition = DirectCOSDefinition.class$("com.iplanet.ums.cos.DirectCOSDefinition")) : class$com$iplanet$ums$cos$DirectCOSDefinition;
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    static /* synthetic */ Class class$com$iplanet$ums$cos$DirectCOSDefinition;

    public DirectCOSDefinition() {
    }

    public DirectCOSDefinition(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public DirectCOSDefinition(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    public void setName(String string) {
        this.setAttribute(new Attr("cn", string));
    }

    public String getName() {
        String string = null;
        Attr attr = this.getAttribute(this.getNamingAttribute());
        if (attr != null) {
            string = attr.getValue();
        }
        return string;
    }

    public void addCOSAttribute(String string, int n) throws UMSException {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0 || n > 2) {
            String string2 = i18n.getString("cos-bad_cos_attr_qualifier");
            throw new UMSException(string2);
        }
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(ICOSDefinition.qualifiers[n]);
        this.modify("cosAttribute", stringBuffer.toString(), 0);
    }

    public void removeCOSAttribute(String string) {
        this.modify(new Attr("cosAttribute", string), 1);
    }

    public String[] getCOSAttributes() {
        Attr attr = this.getAttribute("cosAttribute");
        return attr.getStringValues();
    }

    public void setCOSSpecifier(String string) {
        this.setAttribute(new Attr("cosSpecifier", string));
    }

    public String getCOSSpecifier() {
        String string = null;
        Attr attr = this.getAttribute("cosSpecifier");
        if (attr != null) {
            string = attr.getValue();
        }
        return string;
    }

    public void addCOSTemplate(COSTemplate cOSTemplate) throws UMSException {
        if (this.getGuid() == null) {
            String string = i18n.getString("cos-definition_not_persistent");
            throw new UMSException(string);
        }
        if (this.getAttribute("cosTemplateDn") == null) {
            this.modify(new Attr("cosTemplateDn", this.getGuid().getDn()), 0);
            this.save();
        }
        this.addChild(cOSTemplate);
    }

    public void removeCOSTemplate(String string) throws UMSException {
        Guid guid = new Guid("cn=" + string + "," + this.getGuid());
        this.removeChild(guid);
    }

    public void removeCOSTemplates() throws UMSException {
        ArrayList arrayList = (ArrayList)this.getCOSTemplates();
        int n = 0;
        while (n < arrayList.size()) {
            COSTemplate cOSTemplate = (COSTemplate)arrayList.get(n);
            cOSTemplate.remove();
            ++n;
        }
    }

    public COSTemplate getCOSTemplate(String string) throws COSNotFoundException, UMSException {
        COSTemplate cOSTemplate = null;
        String[] stringArray = new String[]{"*"};
        SearchResults searchResults = this.search("(cn=" + string + ")", stringArray, null);
        while (searchResults.hasMoreElements()) {
            cOSTemplate = (COSTemplate)searchResults.next();
            searchResults.abandon();
        }
        if (cOSTemplate == null) {
            String string2 = i18n.getString("cos-cos_template_not_found");
            throw new COSNotFoundException(string2);
        }
        return cOSTemplate;
    }

    public Collection getCOSTemplates() throws UMSException {
        COSTemplate cOSTemplate = null;
        ArrayList<COSTemplate> arrayList = new ArrayList<COSTemplate>();
        String[] stringArray = new String[]{"*"};
        SearchResults searchResults = this.search("(objectclass=costemplate)", stringArray, null);
        while (searchResults.hasMoreElements()) {
            cOSTemplate = (COSTemplate)searchResults.next();
            arrayList.add(cOSTemplate);
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

