/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.cos;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SchemaManager;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.DirectCOSDefinition;
import com.iplanet.ums.cos.ICOSDefinition;
import java.security.Principal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class COSManager {
    private static final String[] DEF_ATTRIBUTE_NAMES = new String[]{"objectclass", "cn", "cosTemplateDn", "cosSpecifier", "cosAttribute", "cosIndirectSpecifier"};
    private PersistentObject _parentObject;
    private SchemaManager _schemaManager;
    private static I18n i18n = I18n.getInstance((String)"amSDK");

    protected COSManager(SSOToken sSOToken, Guid guid) throws UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), sSOException);
        }
        this._parentObject = UMSObject.getObject(sSOToken, guid);
        try {
            this._schemaManager = SchemaManager.getSchemaManager(sSOToken.getPrincipal());
        }
        catch (SSOException sSOException) {
            throw new UMSException("Bad Authentication Token " + sSOException.getMessage());
        }
    }

    protected COSManager(Principal principal, Guid guid) throws UMSException {
        this._parentObject = UMSObject.getObject(principal, guid);
        this._schemaManager = SchemaManager.getSchemaManager(principal);
    }

    public static COSManager getCOSManager(SSOToken sSOToken, Guid guid) throws UMSException {
        return new COSManager(sSOToken, guid);
    }

    public static COSManager getCOSManager(Principal principal, Guid guid) throws UMSException {
        return new COSManager(principal, guid);
    }

    public void addDefinition(ICOSDefinition iCOSDefinition) throws UMSException {
        Object object;
        if (!(iCOSDefinition instanceof DirectCOSDefinition)) {
            String string = i18n.getString("cos-invalid_cosdefinition");
            throw new UMSException(string);
        }
        String[] stringArray = iCOSDefinition.getCOSAttributes();
        AbstractCollection abstractCollection = (AbstractCollection)((Object)Arrays.asList(ICOSDefinition.qualifiers));
        int n = 0;
        while (n < stringArray.length) {
            object = null;
            String string = null;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n]);
            if (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
            }
            if (object == null) {
                String string2 = i18n.getString("cos-cos_invalid_cos_attribute_qualifier");
                throw new UMSException(string2);
            }
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            if (string == null) {
                string = ICOSDefinition.qualifiers[0];
                iCOSDefinition.removeCOSAttribute((String)object);
                iCOSDefinition.addCOSAttribute((String)object, 0);
            }
            if (!abstractCollection.contains(string)) {
                String string3 = i18n.getString("cos-cos_invalid_cos_attribute_qualifier");
                throw new UMSException(string3);
            }
            ++n;
        }
        object = (PersistentObject)((Object)iCOSDefinition);
        this._parentObject.addChild((PersistentObject)object);
    }

    public void removeDefinition(String string) throws UMSException {
        Guid guid = new Guid("cn=" + string + "," + this._parentObject.getGuid().getDn());
        this._parentObject.removeChild(guid);
    }

    public void updateDefinition(ICOSDefinition iCOSDefinition) throws UMSException {
        PersistentObject persistentObject = (PersistentObject)((Object)iCOSDefinition);
        if (persistentObject.getGuid() == null) {
            String string = i18n.getString("cos-replace_definition_not_persistent");
            throw new UMSException(string);
        }
        persistentObject.save();
    }

    public ICOSDefinition getDefinition(String string) throws UMSException, COSNotFoundException {
        ICOSDefinition iCOSDefinition = null;
        SearchResults searchResults = this._parentObject.getChildren("(&(objectclass=ldapsubentry)(objectclass=cossuperdefinition)(cn=" + string + ")", DEF_ATTRIBUTE_NAMES, null);
        while (searchResults.hasMoreElements()) {
            iCOSDefinition = (ICOSDefinition)((Object)searchResults.next());
            if (iCOSDefinition.getName().equals(string)) break;
            iCOSDefinition = null;
        }
        if (iCOSDefinition == null) {
            String string2 = i18n.getString("cos-cos_definition_not_found");
            throw new COSNotFoundException(string2);
        }
        searchResults.abandon();
        return iCOSDefinition;
    }

    public Collection getDefinitions() throws UMSException {
        ArrayList<PersistentObject> arrayList = new ArrayList<PersistentObject>();
        SearchResults searchResults = this._parentObject.search("&(objectclass=ldapsubentry)(objectclass=cossuperdefinition)", DEF_ATTRIBUTE_NAMES, null);
        while (searchResults.hasMoreElements()) {
            arrayList.add(searchResults.next());
        }
        return arrayList;
    }

    public void assignCOSDef(PersistentObject persistentObject, ICOSDefinition iCOSDefinition, COSTemplate cOSTemplate) throws UMSException {
        if (persistentObject == null || iCOSDefinition == null) {
            String string = i18n.getString("cos-cos_def_or_target_object_null");
            throw new UMSException(string);
        }
        if (persistentObject.getGuid() == null) {
            String string = i18n.getString("cos-cos_target_object_not_persistent");
            throw new UMSException(string);
        }
        if (!(iCOSDefinition instanceof DirectCOSDefinition)) {
            String string = i18n.getString("cos-invalid_cosdefinition");
            throw new UMSException(string);
        }
        if (iCOSDefinition instanceof DirectCOSDefinition) {
            this.assignDirectCOSDef(persistentObject, (DirectCOSDefinition)iCOSDefinition, cOSTemplate, this._schemaManager);
        }
    }

    public void removeCOSAssignment(PersistentObject persistentObject, ICOSDefinition iCOSDefinition, COSTemplate cOSTemplate) throws UMSException {
        if (persistentObject == null || iCOSDefinition == null) {
            String string = i18n.getString("cos-cos_def_or_target_object_null");
            throw new UMSException(string);
        }
        if (persistentObject.getGuid() == null) {
            String string = i18n.getString("cos-cos_target_object_not_persistent");
            throw new UMSException(string);
        }
        if (!(iCOSDefinition instanceof DirectCOSDefinition)) {
            String string = i18n.getString("cos-invalid_cosdefinition");
            throw new UMSException(string);
        }
        if (iCOSDefinition instanceof DirectCOSDefinition) {
            this.removeDirectCOSAssignment(persistentObject, (DirectCOSDefinition)iCOSDefinition, cOSTemplate, this._schemaManager);
        }
    }

    private void removeDirectCOSAssignment(PersistentObject persistentObject, DirectCOSDefinition directCOSDefinition, COSTemplate cOSTemplate, SchemaManager schemaManager) throws UMSException {
        block7: {
            AttrSet attrSet = new AttrSet();
            try {
                Object object;
                ArrayList arrayList;
                String string;
                if (persistentObject.getAttribute(directCOSDefinition.getCOSSpecifier()) != null) {
                    attrSet.add(new Attr(directCOSDefinition.getCOSSpecifier(), cOSTemplate.getName()));
                }
                if (this.objectClassExists(string = (String)(arrayList = (ArrayList)schemaManager.getObjectClasses(directCOSDefinition.getCOSSpecifier())).get(0), persistentObject)) {
                    attrSet.add(new Attr("objectclass", string));
                }
                String[] stringArray = directCOSDefinition.getCOSAttributes();
                String string2 = null;
                int n = 0;
                while (n < stringArray.length) {
                    object = new StringTokenizer(stringArray[n]);
                    string2 = object.nextToken();
                    arrayList = (ArrayList)schemaManager.getObjectClasses(string2);
                    String string3 = (String)arrayList.get(0);
                    if (this.objectClassExists(string3, persistentObject)) {
                        attrSet.add(new Attr("objectclass", string3));
                    }
                    ++n;
                }
                if (attrSet.size() > 0) {
                    object = new ModSet(attrSet, 1);
                    persistentObject.modify((ModSet)((Object)object));
                    persistentObject.save();
                }
            }
            catch (UMSException uMSException) {
                LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
                if (lDAPException.getLDAPResultCode() == 65) break block7;
                throw uMSException;
            }
        }
    }

    private void assignDirectCOSDef(PersistentObject persistentObject, DirectCOSDefinition directCOSDefinition, COSTemplate cOSTemplate, SchemaManager schemaManager) throws UMSException {
        Object object;
        DN dN;
        if (directCOSDefinition.getGuid() == null) {
            String string = i18n.getString("cos-cos_definition_not_persistent");
            throw new UMSException(string);
        }
        DN dN2 = new DN(persistentObject.getGuid().getDn());
        if (!dN2.isDescendantOf(dN = new DN(directCOSDefinition.getParentGuid().getDn()))) {
            String string = i18n.getString("cos-cos_target_object_different_tree");
            throw new UMSException(string);
        }
        if (directCOSDefinition.getCOSSpecifier().equalsIgnoreCase("nsrole")) {
            return;
        }
        AttrSet attrSet = new AttrSet();
        ArrayList arrayList = (ArrayList)schemaManager.getObjectClasses(directCOSDefinition.getCOSSpecifier());
        String string = (String)arrayList.get(0);
        if (!this.objectClassExists(string, persistentObject)) {
            attrSet.add(new Attr("objectclass", string));
        }
        String[] stringArray = directCOSDefinition.getCOSAttributes();
        String string2 = null;
        String string3 = null;
        AbstractCollection abstractCollection = (AbstractCollection)((Object)Arrays.asList(ICOSDefinition.qualifiers));
        Attr attr = cOSTemplate.getAttribute("objectclass");
        String[] stringArray2 = attr.getStringValues();
        int n = 0;
        while (n < stringArray.length) {
            object = new StringTokenizer(stringArray[n]);
            string2 = object.nextToken();
            string3 = object.nextToken();
            if (!string3.equals(ICOSDefinition.qualifiers[2])) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (!(stringArray2[n2].equalsIgnoreCase("top") || stringArray2[n2].equalsIgnoreCase("costemplate") || this.objectClassExists(stringArray2[n2], persistentObject) || attrSet.contains("objectclass", stringArray2[n2]))) {
                        attrSet.add(new Attr("objectclass", stringArray2[n2]));
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (persistentObject.getAttribute(directCOSDefinition.getCOSSpecifier()) == null) {
            attrSet.add(new Attr(directCOSDefinition.getCOSSpecifier(), cOSTemplate.getName()));
        }
        if (attrSet.size() > 0) {
            object = new ModSet(attrSet);
            persistentObject.modify((ModSet)((Object)object));
            persistentObject.save();
        }
    }

    private boolean objectClassExists(String string, PersistentObject persistentObject) {
        Attr attr = persistentObject.getAttribute("objectclass");
        String[] stringArray = attr.getStringValues();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

