/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IAssignableMembership;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import java.security.Principal;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPDN;

public class StaticGroup
extends PersistentObject
implements IAssignableMembership {
    public static final int LEVEL_DIRECT = 0;
    public static final int LEVEL_ALL = -1;
    static final int DEFAULT_MAX = 5;
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private static final String MEMBER_ATTR_NAME = "uniquemember";
    private static final Class _class = new StaticGroup().getClass();

    protected StaticGroup() {
    }

    StaticGroup(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    StaticGroup(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public StaticGroup(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    public void addMember(Guid guid) throws UMSException {
        Object object;
        String string = LDAPDN.normalize((String)guid.getDn());
        PersistentObject persistentObject = null;
        try {
            object = new UMSObject();
            persistentObject = UMSObject.getObject(this.getPrincipal(), guid);
        }
        catch (UMSException uMSException) {
            // empty catch block
        }
        if (persistentObject != null && persistentObject instanceof StaticGroup) {
            object = (StaticGroup)persistentObject;
            if (string.equalsIgnoreCase(this.getDN()) || ((StaticGroup)object).hasMember(this.getGuid(), -1)) {
                throw new UMSException(i18n.getString("ums-recursionnotallow"));
            }
        }
        this.modify(new Attr(MEMBER_ATTR_NAME, string), 0);
        this.save();
    }

    public void addMember(PersistentObject persistentObject) throws UMSException {
        this.addMember(persistentObject.getGuid());
    }

    public void addMembers(Guid[] guidArray) throws UMSException {
        if (guidArray == null) {
            String string = i18n.getString("ums-badguid");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        while (n < guidArray.length) {
            this.addMember(guidArray[n]);
            ++n;
        }
    }

    public SearchResults getMemberIDs() throws UMSException {
        return this.getMembers(0);
    }

    static int getMaxNestingLevel() {
        return 5;
    }

    public SearchResults getMembers(int n) throws UMSException {
        Attr attr = this.getAttribute(MEMBER_ATTR_NAME);
        if (attr == null) {
            return null;
        }
        if (n == -1) {
            n = StaticGroup.getMaxNestingLevel();
        }
        if (n == 0) {
            return new SearchResults(this.getAttribute(MEMBER_ATTR_NAME));
        }
        Attr attr2 = new Attr(MEMBER_ATTR_NAME);
        LDAPAttribute lDAPAttribute = attr.toLDAPAttribute();
        Enumeration enumeration = lDAPAttribute.getStringValues();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            PersistentObject persistentObject = null;
            try {
                object = new UMSObject();
                persistentObject = UMSObject.getObject(this.getPrincipal(), new Guid(string));
            }
            catch (UMSException uMSException) {
                // empty catch block
            }
            if (persistentObject != null && persistentObject instanceof StaticGroup) {
                object = ((StaticGroup)persistentObject).getMembers(n - 1);
                while (((SearchResults)object).hasMoreElements()) {
                    PersistentObject persistentObject2 = null;
                    try {
                        persistentObject2 = ((SearchResults)object).next();
                        attr2.addValue(persistentObject2.getDN());
                    }
                    catch (UMSException uMSException) {
                        // empty catch block
                    }
                }
            } else {
                attr2.addValue(string);
            }
            persistentObject = null;
        }
        return new SearchResults(attr2);
    }

    public int getMemberCount() throws UMSException {
        return this.getMemberCount(0);
    }

    public int getMemberCount(int n) throws UMSException {
        if (n == -1) {
            n = StaticGroup.getMaxNestingLevel();
        }
        if (n == 0) {
            Attr attr = this.getAttribute(MEMBER_ATTR_NAME);
            return attr != null ? attr.size() : 0;
        }
        SearchResults searchResults = this.getMembers(n);
        if (searchResults == null) {
            return 0;
        }
        int n2 = 0;
        while (searchResults.hasMoreElements()) {
            searchResults.next();
            ++n2;
        }
        return n2;
    }

    public Guid getMemberIDAt(int n) throws UMSException {
        Attr attr = this.getAttribute(MEMBER_ATTR_NAME);
        String string = attr.getStringValues()[n];
        return string != null ? new Guid(string) : null;
    }

    public Guid getMemberIDAt(int n, int n2) throws UMSException {
        SearchResults searchResults = this.getMembers(n2);
        if (searchResults == null) {
            return null;
        }
        int n3 = 0;
        while (searchResults.hasMoreElements()) {
            PersistentObject persistentObject = searchResults.next();
            if (n3++ != n) continue;
            return new Guid(persistentObject.getDN());
        }
        return null;
    }

    public void removeMember(Guid guid) throws UMSException {
        String string = guid.getDn();
        super.modify(new Attr(MEMBER_ATTR_NAME, LDAPDN.normalize((String)string)), 1);
        this.save();
    }

    public void removeMember(PersistentObject persistentObject) throws UMSException {
        this.removeMember(persistentObject.getGuid());
    }

    public void removeAllMembers() throws UMSException {
        if (this.getMemberCount() == 0) {
            return;
        }
        ModSet modSet = new ModSet();
        modSet.add(1, new LDAPAttribute(MEMBER_ATTR_NAME));
        this.modify(modSet);
        this.save();
    }

    public boolean hasMember(Guid guid) throws UMSException {
        return this.isMemberAtLevel(guid.getDn(), 0);
    }

    private boolean isMemberAtLevel(String string, int n) throws UMSException {
        if (n == -1) {
            n = StaticGroup.getMaxNestingLevel();
        }
        SearchResults searchResults = this.getMembers(n);
        while (searchResults.hasMoreElements()) {
            PersistentObject persistentObject = searchResults.next();
            String string2 = persistentObject.getDN();
            if (!Guid.equals(string, string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMember(Guid guid, int n) throws UMSException {
        if (n == -1) {
            n = StaticGroup.getMaxNestingLevel();
        }
        String string = guid.getDn();
        int n2 = 0;
        while (n2 <= n) {
            if (this.isMemberAtLevel(string, n2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

