/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.BaseRole;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IAssignableMembership;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import java.security.Principal;
import netscape.ldap.util.DN;

public class ManagedRole
extends BaseRole
implements IAssignableMembership {
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    public static final String MEMBER_ATTR_NAME = "nsRoleDN";
    public static final String COMPUTED_MEMBER_ATTR_NAME = "nsRole";
    public static final String[] MANAGEDROLE_OBJECTCLASSES = new String[]{"top", "ldapsubentry", "nsroledefinition", "nssimpleroledefinition", "nsmanagedroledefinition"};
    public static final String[] MANAGEDROLE_ATTRIBUTES = new String[]{"cn"};
    private static final Class _class = class$com$iplanet$ums$ManagedRole == null ? (class$com$iplanet$ums$ManagedRole = ManagedRole.class$("com.iplanet.ums.ManagedRole")) : class$com$iplanet$ums$ManagedRole;
    static /* synthetic */ Class class$com$iplanet$ums$ManagedRole;

    public ManagedRole() {
    }

    ManagedRole(String string) throws UMSException {
        this(new AttrSet(new Attr("cn", string)));
    }

    ManagedRole(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public ManagedRole(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    public void addMember(PersistentObject persistentObject) throws UMSException {
        persistentObject.modify(new Attr(MEMBER_ATTR_NAME, this.getDN()), 0);
        String string = this.getDN();
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        DataLayer.getInstance().addAttributeValue(principal, persistentObject.getGuid(), MEMBER_ATTR_NAME, this.getDN());
        persistentObject.getAttrSet().remove(COMPUTED_MEMBER_ATTR_NAME);
    }

    public void addMember(Guid guid) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        DataLayer.getInstance().addAttributeValue(principal, guid, MEMBER_ATTR_NAME, this.getDN());
    }

    public void addMembers(Guid[] guidArray) throws UMSException {
        if (guidArray == null) {
            String string = i18n.getString("ums-badguid");
            throw new IllegalArgumentException(string);
        }
        if (guidArray == null) {
            throw new IllegalArgumentException(i18n.getString("ums-nullguids"));
        }
        int n = 0;
        while (n < guidArray.length) {
            this.addMember(guidArray[n]);
            ++n;
        }
    }

    protected SearchResults getMemberIDs(String[] stringArray) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        String string = this.getGuid().getDn();
        DN dN = new DN(string);
        dN = dN.getParent();
        Guid guid = new Guid(dN.toString());
        return DataLayer.getInstance().search(principal, guid, 2, "(nsRoleDN=" + this.getDN() + ")", stringArray, false, null);
    }

    protected SearchResults getMemberIDs(String[] stringArray, String string) throws InvalidSearchFilterException, UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        DN dN = new DN(this.getDN());
        dN = dN.getParent();
        Guid guid = new Guid(dN.toString());
        return DataLayer.getInstance().search(principal, guid, 2, "( &  ( nsRoleDN=" + this.getDN() + " ) " + " ( " + string + " ) " + " ) ", stringArray, false, null);
    }

    public SearchResults getMemberIDs() throws UMSException {
        String[] stringArray = new String[]{"objectclass"};
        return this.getMemberIDs(stringArray);
    }

    public SearchResults getMemberIDs(String string) throws UMSException {
        String[] stringArray = new String[]{"objectclass"};
        return this.getMemberIDs(stringArray);
    }

    public int getMemberCount() throws UMSException {
        int n = 0;
        SearchResults searchResults = this.getMemberIDs();
        while (searchResults.hasMoreElements()) {
            searchResults.next().getDN();
            ++n;
        }
        return n;
    }

    public Guid getMemberIDAt(int n) throws UMSException {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        SearchResults searchResults = this.getMemberIDs();
        int n2 = 0;
        while (searchResults.hasMoreElements()) {
            String string = searchResults.next().getDN();
            if (n2 == n) {
                searchResults.abandon();
                return new Guid(string);
            }
            ++n2;
        }
        throw new ArrayIndexOutOfBoundsException(Integer.toString(n));
    }

    public void removeMember(PersistentObject persistentObject) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        persistentObject.modify(new Attr(MEMBER_ATTR_NAME, this.getDN()), 1);
        DataLayer.getInstance().removeAttributeValue(principal, persistentObject.getGuid(), MEMBER_ATTR_NAME, this.getDN());
    }

    public void removeMember(Guid guid) throws UMSException {
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        DataLayer.getInstance().removeAttributeValue(principal, guid, MEMBER_ATTR_NAME, this.getDN());
    }

    public void removeAllMembers() throws UMSException {
        SearchResults searchResults = this.getMemberIDs();
        while (searchResults.hasMoreElements()) {
            this.removeMember(searchResults.next());
        }
    }

    public boolean hasMember(Guid guid) throws UMSException {
        boolean bl = false;
        Principal principal = this.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException(i18n.getString("ums-bad-principal-hdl"));
        }
        PersistentObject persistentObject = UMSObject.getObject(principal, guid);
        return this.hasMember(persistentObject);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

