/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.Template;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.validation.DataConstraintException;
import com.iplanet.ums.validation.Validation;
import com.iplanet.ums.validation.ValidationElement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class CreationTemplate
extends Template {
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private AttrSet m_required = null;
    private AttrSet m_optional = null;
    private ArrayList m_classes = null;
    private AttrSet m_validated = null;
    private String m_namingAttribute = null;

    public CreationTemplate() {
    }

    public CreationTemplate(String string, AttrSet attrSet, AttrSet attrSet2, ArrayList arrayList) {
        super(string);
        this.setRequiredAttributeSet(attrSet);
        this.setOptionalAttributeSet(attrSet2);
        this.setCreationClasses(arrayList);
    }

    public CreationTemplate(String string, AttrSet attrSet, AttrSet attrSet2, Class clazz) {
        this(string, attrSet, attrSet2);
        ArrayList<Class> arrayList = new ArrayList<Class>();
        arrayList.add(clazz);
        this.setCreationClasses(arrayList);
    }

    public CreationTemplate(String string, AttrSet attrSet, AttrSet attrSet2) {
        super(string);
        this.setRequiredAttributeSet(attrSet);
        this.setOptionalAttributeSet(attrSet2);
    }

    public Attr getAttribute(String string) {
        if (string == null) {
            return null;
        }
        Attr attr = null;
        if (this.m_required != null) {
            attr = this.m_required.getAttribute(string);
        }
        if (attr == null && this.m_optional != null) {
            attr = this.m_optional.getAttribute(string);
        }
        return attr;
    }

    public String[] getRequiredAttributeNames() {
        return this.m_required == null ? new String[]{} : this.m_required.getAttributeNames();
    }

    public String[] getOptionalAttributeNames() {
        return this.m_optional == null ? new String[]{} : this.m_optional.getAttributeNames();
    }

    public AttrSet getRequiredAttributeSet() {
        return this.m_required;
    }

    public AttrSet getOptionalAttributeSet() {
        return this.m_optional;
    }

    public ArrayList getCreationClasses() {
        return this.m_classes;
    }

    public Enumeration getValidation(String string) {
        Attr attr;
        Vector<ValidationElement> vector = new Vector<ValidationElement>();
        if (string != null && this.m_validated != null && (attr = this.m_validated.getAttribute(string)) != null) {
            String[] stringArray = attr.getStringValues();
            int n = 0;
            while (n < stringArray.length) {
                vector.add(CreationTemplate.decodeValidationString(stringArray[n]));
                ++n;
            }
        }
        return vector.elements();
    }

    AttrSet getValidation() {
        return this.m_validated;
    }

    public String[] getValidatedAttributeNames() {
        return this.m_validated == null ? new String[]{} : this.m_validated.getAttributeNames();
    }

    public Enumeration getAttributes() {
        int n;
        Vector<Attr> vector = new Vector<Attr>();
        if (this.m_required != null) {
            n = 0;
            while (n < this.m_required.size()) {
                vector.add(this.m_required.elementAt(n));
                ++n;
            }
        }
        if (this.m_optional != null) {
            n = 0;
            while (n < this.m_optional.size()) {
                vector.add(this.m_optional.elementAt(n));
                ++n;
            }
        }
        return vector.elements();
    }

    public void setRequiredAttributeSet(AttrSet attrSet) {
        this.m_required = attrSet;
    }

    public void setOptionalAttributeSet(AttrSet attrSet) {
        this.m_optional = attrSet;
    }

    public void setCreationClasses(ArrayList arrayList) {
        this.m_classes = arrayList;
    }

    public void addRequiredAttribute(Attr attr) {
        if (this.m_required == null) {
            this.m_required = new AttrSet();
        }
        this.m_required.add(attr);
    }

    public void addOptionalAttribute(Attr attr) {
        if (this.m_optional == null) {
            this.m_optional = new AttrSet();
        }
        this.m_optional.add(attr);
    }

    void setValidation(AttrSet attrSet) {
        this.m_validated = attrSet;
    }

    public void addValidation(String string, String string2, String string3) {
        String string4;
        if (string2 != null && string != null && (string4 = CreationTemplate.encodeValidationString(string2, string3)) != null) {
            if (this.m_validated == null) {
                this.m_validated = new AttrSet();
            }
            if (!this.m_validated.contains(string, string4)) {
                this.m_validated.add(new Attr(string, string4));
            }
        }
    }

    public void removeValidation(String string) {
        if (this.m_validated != null) {
            this.m_validated.remove(string);
        }
    }

    void setNamingAttribute(String string) {
        this.m_namingAttribute = string;
    }

    public String getNamingAttribute() {
        return this.m_namingAttribute;
    }

    public Object clone() {
        CreationTemplate creationTemplate = (CreationTemplate)super.clone();
        if (this.m_required != null) {
            creationTemplate.setRequiredAttributeSet((AttrSet)this.m_required.clone());
        }
        if (this.m_optional != null) {
            creationTemplate.setOptionalAttributeSet((AttrSet)this.m_optional.clone());
        }
        if (this.m_validated != null) {
            creationTemplate.setValidation((AttrSet)this.m_validated.clone());
        }
        return creationTemplate;
    }

    static Attr encodeAttrSet(String string, AttrSet attrSet, String string2) {
        if (attrSet == null || attrSet.size() == 0) {
            return null;
        }
        Enumeration enumeration = attrSet.getAttributes();
        Attr attr = new Attr(string);
        while (enumeration.hasMoreElements()) {
            Attr attr2 = (Attr)enumeration.nextElement();
            String[] stringArray = attr2.getStringValues();
            String[] stringArray2 = new String[stringArray.length];
            if (stringArray.length == 0) {
                attr.addValue(attr2.getName());
                continue;
            }
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = attr2.getName() + string2 + stringArray[n];
                ++n;
            }
            attr.addValues(stringArray2);
        }
        return attr;
    }

    private static String encodeValidationString(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("(");
        stringBuffer.append(string2);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static ValidationElement decodeValidationString(String string) {
        int n = string.indexOf(40);
        if (n < 0) {
            return new ValidationElement(string, null);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        return new ValidationElement(string2, string3);
    }

    public String toString() {
        return "CreationTemplate: " + this.getName() + " { Required " + this.m_required + " Optional " + this.m_optional + " Validation " + this.m_validated + " Naming Attribute " + this.m_namingAttribute + " }";
    }

    boolean validateAttrSet(AttrSet attrSet) throws UMSException {
        AttrSet attrSet2 = this.getRequiredAttributeSet();
        AttrSet attrSet3 = this.getOptionalAttributeSet();
        if (attrSet2 == null && attrSet3 == null) {
            throw new UMSException(i18n.getString("ums-templatenoattribute"));
        }
        String[] stringArray = attrSet.getAttributeNames();
        int n = stringArray != null ? stringArray.length : -1;
        String string = null;
        if (attrSet2 != null) {
            Enumeration enumeration = attrSet2.getAttributes();
            while (enumeration.hasMoreElements()) {
                Attr attr = (Attr)enumeration.nextElement();
                if (attrSet.contains(attr.getName())) continue;
                if (attr.size() > 0) {
                    attrSet.add((Attr)attr.clone());
                    continue;
                }
                string = attr.getName();
                Object[] objectArray = new String[]{string};
                String string2 = i18n.getString("ums-novalue", objectArray);
                throw new UMSException(string2);
            }
        }
        if (attrSet3 != null && attrSet3.contains("*")) {
            return true;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            bl = false;
            string = stringArray[n2];
            if (attrSet2 != null && attrSet2.contains(string)) {
                bl = true;
            } else if (attrSet3 != null && attrSet3.contains(string)) {
                bl = true;
            }
            if (!bl) {
                Object[] objectArray = new String[]{string};
                String string3 = i18n.getString("ums-attrnotallowed", objectArray);
                throw new UMSException(string3);
            }
            ++n2;
        }
        return true;
    }

    boolean validateAttributes(AttrSet attrSet) throws UMSException, DataConstraintException {
        Enumeration enumeration = attrSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            Attr attr = (Attr)enumeration.nextElement();
            Enumeration enumeration2 = this.getValidation(attr.getName());
            while (enumeration2.hasMoreElements()) {
                ValidationElement validationElement = (ValidationElement)enumeration2.nextElement();
                Validation.validateAttribute(attr, validationElement.getValidator(), validationElement.getRule());
            }
        }
        return true;
    }
}

