/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming.service;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.naming.share.NamingRequest;
import com.iplanet.services.naming.share.NamingResponse;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NamingService
implements RequestHandler,
ServiceListener {
    private static final String sccsID = "$Id: NamingService.java,v 1.44 2005/06/24 16:55:38 vs125812 Exp $ $Date: 2005/06/24 16:55:38 $  Sun Microsystems, Inc.";
    public static final int SERVICE_REV_NUMBER_70 = 20;
    public static int serviceRevNumber;
    private static Debug namingDebug;
    public static final String NAMING_SERVICE = "com.iplanet.am.naming";
    private static Hashtable namingTable;
    private static Properties platformProperties;
    private static String server_proto;
    private static String server_host;
    private static String server_port;
    private static SSOTokenManager ssom;
    private static AuthPrincipal ap;
    private static SSOToken sso;
    private static ServiceSchemaManager scmNaming;
    private static ServiceSchemaManager scmPlatform;
    private static ServiceConfig sessionServiceConfig;
    private static Set sessionConfig;
    private static String delimiter;

    public static Hashtable getNamingTable(boolean bl) throws SMSException {
        return NamingService.updateNamingTable(bl);
    }

    public static Hashtable getNamingTable() throws SMSException {
        try {
            if (namingTable != null) {
                return namingTable;
            }
            NamingService.updateNamingTable();
        }
        catch (Exception exception) {
            throw new SMSException(exception.getMessage());
        }
        return namingTable;
    }

    private static void updateNamingTable() throws SMSException {
        namingTable = NamingService.updateNamingTable(false);
    }

    private static Hashtable updateNamingTable(boolean bl) throws SMSException {
        Hashtable hashtable = null;
        try {
            ServiceSchema serviceSchema = scmNaming.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            serviceSchema = scmPlatform.getGlobalSchema();
            Map map2 = serviceSchema.getAttributeDefaults();
            Set set = NamingService.getSites(map2);
            Set set2 = NamingService.getServers(map2, set);
            if (set != null && !set.isEmpty()) {
                if (!bl) {
                    NamingService.registFQDNMapping(set);
                }
                set.addAll(set2);
            } else {
                set = set2;
            }
            if (bl) {
                NamingService.storeServerListForClient(set, map);
            } else {
                NamingService.storeServerList(set, map);
            }
            hashtable = NamingService.convertToHash(map);
            if (bl && namingTable != null) {
                String string = (String)namingTable.get("iplanet-am-platform-site-id-list");
                hashtable.put("iplanet-am-platform-site-id-list", string);
            }
        }
        catch (Exception exception) {
            namingDebug.error("Can't get naming table", (Throwable)exception);
            throw new SMSException(exception.getMessage());
        }
        return hashtable;
    }

    static Hashtable convertToHash(Map map) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = (Set)map.get(string);
            hashtable.put(string, NamingService.setToString(set2));
        }
        return hashtable;
    }

    static void storeServerList(Set set, Map map) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(delimiter);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                hashSet2.add(string3);
                n = string3.indexOf(delimiter);
                if (n != -1) {
                    string3 = string3.substring(0, 2);
                }
                HashSet<String> hashSet3 = new HashSet<String>();
                hashSet3.add(string2);
                hashSet.add(string2);
                map.put(string3, hashSet3);
                continue;
            }
            namingDebug.error("Platform Server List entry is invalid:" + string);
        }
        map.put("iplanet-am-platform-server-list", hashSet);
        map.put("iplanet-am-platform-site-id-list", hashSet2);
    }

    static void storeServerListForClient(Set set, Map map) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(delimiter);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                if ((n = string3.indexOf(delimiter)) != -1) continue;
                HashSet<String> hashSet2 = new HashSet<String>();
                hashSet2.add(string2);
                hashSet.add(string2);
                map.put(string3, hashSet2);
                continue;
            }
            namingDebug.error("Platform Server List entry is invalid:" + string);
        }
        map.put("iplanet-am-platform-server-list", hashSet);
    }

    static String setToString(Set set) {
        StringBuffer stringBuffer = new StringBuffer(100);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletContext servletContext) {
        ResponseSet responseSet = new ResponseSet(NAMING_SERVICE);
        int n = 0;
        while (n < vector.size()) {
            Request request = (Request)vector.elementAt(n);
            Response response = this.processRequest(request);
            responseSet.addResponse(response);
            ++n;
        }
        return responseSet;
    }

    private Response processRequest(Request request) {
        String string = request.getContent();
        NamingRequest namingRequest = NamingRequest.parseXML((String)string);
        NamingResponse namingResponse = new NamingResponse(namingRequest.getRequestID());
        float f = Float.valueOf(namingRequest.getRequestVersion()).floatValue();
        boolean bl = (double)f > 1.0;
        String string2 = namingRequest.getSessionId();
        try {
            if (string2 == null) {
                namingResponse.setNamingTable(NamingService.getNamingTable(bl));
            } else {
                Hashtable hashtable = new Hashtable();
                hashtable = this.transferTable(NamingService.getNamingTable(bl));
                Hashtable hashtable2 = this.replaceTable(hashtable, string2);
                if (hashtable2 == null) {
                    namingResponse.setException("SessionID ---" + string2 + "---is Invalid");
                } else {
                    namingResponse.setNamingTable(hashtable2);
                }
            }
        }
        catch (Exception exception) {
            namingResponse.setException(exception.getMessage());
        }
        return new Response(namingResponse.toXMLString());
    }

    private Hashtable replaceTable(Hashtable hashtable, String string) {
        Object object;
        Object object2;
        SessionID sessionID = new SessionID(string);
        namingDebug.message("SessionId received is --" + string);
        String string2 = sessionID.getSessionServerProtocol();
        String string3 = sessionID.getSessionServer();
        String string4 = sessionID.getSessionServerPort();
        if (string2.equalsIgnoreCase("") || string3.equalsIgnoreCase("") || string4.equalsIgnoreCase("")) {
            return null;
        }
        if (!(string2.equals(server_proto) && string3.equals(server_host) && string4.equals(server_port))) {
            object2 = string2 + "://" + string3 + ":" + string4;
            object = (String)hashtable.get("iplanet-am-platform-server-list");
            if (((String)object).indexOf((String)object2) == -1) {
                return null;
            }
        }
        object2 = hashtable;
        object = ((Hashtable)object2).keys();
        while (object.hasMoreElements()) {
            Object k = object.nextElement();
            String string5 = k.toString();
            String string6 = ((Hashtable)object2).get(k).toString();
            int n = string6.indexOf("%protocol");
            if (n != -1) {
                string6 = string6.substring(0, n) + string2 + string6.substring(n + "%protocol".length(), string6.length());
            }
            if ((n = string6.indexOf("%host")) != -1) {
                string6 = string6.substring(0, n) + string3 + string6.substring(n + "%host".length(), string6.length());
            }
            if ((n = string6.indexOf("%port")) != -1) {
                string6 = string6.substring(0, n) + string4 + string6.substring(n + "%port".length(), string6.length());
            }
            ((Hashtable)object2).put(string5, string6);
        }
        return object2;
    }

    private Hashtable transferTable(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = k.toString();
            String string2 = hashtable.get(k).toString();
            hashtable2.put(string, string2);
        }
        return hashtable2;
    }

    public void schemaChanged(String string, String string2) {
        if (string == null || !string.equals("iPlanetAMPlatformService")) {
            return;
        }
        try {
            NamingService.updateNamingTable();
        }
        catch (SMSException sMSException) {
            namingDebug.error("Error occured in updating naming table", (Throwable)sMSException);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    private static void registFQDNMapping(Set set) {
        Iterator iterator = null;
        MessageFormat messageFormat = null;
        if (set == null) {
            return;
        }
        iterator = set.iterator();
        messageFormat = new MessageFormat("com.sun.identity.server.fqdnMap[{0}]");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            URL uRL = null;
            try {
                uRL = new URL(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string2 = uRL.getHost();
            if (string2 == null) continue;
            Object[] objectArray = new Object[]{string2};
            messageFormat.format(objectArray);
            SystemProperties.initializeProperties((String)messageFormat.format(objectArray), (String)string2);
        }
    }

    private static Set getSites(Map map) throws Exception {
        Set set = null;
        Set set2 = (Set)map.get("iplanet-am-platform-server-list");
        set = serviceRevNumber < 20 ? NamingService.getSitesFromSessionConfig(set2) : (Set)map.get("iplanet-am-platform-site-list");
        if (namingDebug.messageEnabled() && set != null) {
            namingDebug.message("Sites : " + set.toString());
        }
        return set;
    }

    private static Set getServers(Map map, Set set) throws Exception {
        Set set2 = null;
        set2 = (Set)map.get("iplanet-am-platform-server-list");
        if (set != null && serviceRevNumber < 20) {
            set2 = NamingService.getServersFromSessionConfig(set, set2);
        }
        if (namingDebug.messageEnabled() && set2 != null) {
            namingDebug.message("servers : " + set2.toString());
        }
        return set2;
    }

    private static Set getSitesFromSessionConfig(Set set) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n;
            String string = (String)iterator.next();
            String string2 = string.substring(0, n = string.indexOf(delimiter));
            if (!sessionConfig.contains(string2)) continue;
            hashSet.add(string);
        }
        return hashSet.isEmpty() ? null : hashSet;
    }

    private static Set getServersFromSessionConfig(Set set, Set set2) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        Hashtable hashtable = NamingService.getClusterInfo(set);
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set.contains(string)) continue;
            int n = string.indexOf(delimiter);
            String string2 = string.substring(n + 1, string.length());
            Iterator iterator2 = hashtable.keySet().iterator();
            boolean bl = false;
            while (!bl && iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                String string4 = (String)hashtable.get(string3);
                if (string4.indexOf(string2) < 0) continue;
                hashSet.add(string + delimiter + string3);
                bl = true;
            }
            if (bl) continue;
            hashSet.add(string);
        }
        return hashSet.isEmpty() ? null : hashSet;
    }

    private static Hashtable getClusterInfo(Set set) throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(delimiter);
            String string2 = string.substring(n + 1, string.length());
            string = string.substring(0, n);
            ServiceConfig serviceConfig = sessionServiceConfig.getSubConfig(string);
            Map map = serviceConfig.getAttributes();
            String string3 = Misc.getMapAttr((Map)map, (String)"iplanet-am-session-cluster-serverlist", (String)"");
            hashtable.put(string2, string3);
        }
        return hashtable;
    }

    static {
        namingDebug = null;
        namingTable = null;
        platformProperties = null;
        server_proto = null;
        server_host = null;
        server_port = null;
        ssom = null;
        ap = null;
        sso = null;
        scmNaming = null;
        scmPlatform = null;
        sessionServiceConfig = null;
        sessionConfig = null;
        delimiter = "|";
        namingDebug = Debug.getInstance((String)"amNaming");
        platformProperties = SystemProperties.getAll();
        server_proto = platformProperties.getProperty("com.iplanet.am.server.protocol", "");
        server_host = platformProperties.getProperty("com.iplanet.am.server.host", "");
        server_port = platformProperties.getProperty("com.iplanet.am.server.port", "");
        try {
            Object object;
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            sso = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            scmNaming = new ServiceSchemaManager("iPlanetAMNamingService", sso);
            scmPlatform = new ServiceSchemaManager("iPlanetAMPlatformService", sso);
            serviceRevNumber = scmPlatform.getRevisionNumber();
            if (serviceRevNumber < 20) {
                object = new ServiceConfigManager("iPlanetAMSessionService", sso);
                sessionServiceConfig = ((ServiceConfigManager)object).getGlobalConfig(null);
                sessionConfig = sessionServiceConfig.getSubConfigNames();
            }
            object = scmPlatform.addListener(new NamingService());
        }
        catch (Exception exception) {
            namingDebug.error("Naming Initialization failed.", (Throwable)exception);
        }
    }
}

