/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.BindRule;
import java.util.ArrayList;

class BindRuleBuilder {
    String _previousToken;
    String _previousTokenType = "";
    String _previousKeyword;
    String _previousKeywordSet;
    String _previousExpressionConnector;
    String _token;
    String _tokenType;
    String _keyword;
    String _keywordSet;
    ArrayList _doneKeywordSets = new ArrayList();
    String _operator;
    String _value;
    String _expressionConnector;
    int _parenthCount;
    int _keywordCount;
    int _previousKeywordCount;
    BindRule br = new BindRule();

    BindRuleBuilder() {
    }

    void addToken(String string) throws ACIParseException {
        this._tokenType = this.getTokenType(string);
        if (this._previousTokenType.equals("keyword") && !this._tokenType.equals("operator")) {
            throw new ACIParseException("keyword not followed by operator : " + this._previousToken);
        }
        if (this._previousTokenType.equals("operator") && !this._tokenType.equals("value")) {
            throw new ACIParseException("operator not followed by value");
        }
        if (this._previousTokenType.equals("value") && !this._tokenType.equals("expressionconnector") && !this._tokenType.equals("(") && !this._tokenType.equals(")")) {
            throw new ACIParseException("value not followed by connector : " + this._previousToken);
        }
        if (this._previousTokenType.equals("expressionconnector") && !this._tokenType.equals("keyword") && !this._tokenType.equals("(")) {
            throw new ACIParseException("expressionconnector not followed by keyword : " + string);
        }
        if (this._tokenType.equals("(")) {
            ++this._parenthCount;
        } else if (this._tokenType.equals(")")) {
            --this._parenthCount;
        } else if (this._tokenType.equals("keyword")) {
            this._keyword = string.toLowerCase();
            this._keywordSet = this.getKeywordSet(string);
            if (this._doneKeywordSets.contains(this._keywordSet)) {
                throw new ACIParseException("keywords from diffrent sets overlap");
            }
            if (this._previousKeywordSet != null && !this._keywordSet.equals(this._previousKeywordSet)) {
                this._doneKeywordSets.add(this._previousKeywordSet);
                this._keywordCount = 0;
                if (!this._expressionConnector.equals("and")) {
                    throw new ACIParseException("sets of of keywords have to be  connected  by logical and ");
                }
            } else {
                ++this._keywordCount;
                if (this._keywordCount > 1 && !this._keywordSet.equals("tod") && !"or".equals(this._expressionConnector)) {
                    throw new ACIParseException("keywords from the same set has to  be connected  by logical OR : " + string);
                }
            }
            this._previousKeyword = this._keyword;
            this._previousKeywordSet = this._keywordSet;
            this._previousKeywordCount = this._keywordCount;
        } else if (this._tokenType.equals("operator")) {
            this._operator = string.toLowerCase();
        } else if (this._tokenType.equals("value")) {
            this._value = string.substring(1, string.length() - 1);
            if (this._keyword == null) {
                throw new ACIParseException("keyword is null");
            }
            this.addParameter(this._keyword, this._operator, this._value);
            this._value = null;
        } else if (this._tokenType.equals("expressionconnector")) {
            this._expressionConnector = string.toLowerCase();
            if (this._expressionConnector.equals("and") && !"timeofday".equals(this._keyword)) {
                if (this._parenthCount != 0) {
                    throw new ACIParseException("Can not enclose keywords from  different sets in the same parenthesis ");
                }
                if (this._previousKeywordCount > 1 && !")".equals(this._previousTokenType)) {
                    throw new ACIParseException("preceding set of expressions  not enclosed in parenthesis");
                }
            }
        } else if (!this._tokenType.equals("||")) {
            throw new ACIParseException("Unknown token type for : " + string);
        }
        this._previousTokenType = this._tokenType;
    }

    String getKeywordSet(String string) throws ACIParseException {
        String string2 = null;
        if (string.equals("userdn") || string.equals("userdnattr") || string.equals("groupdn") || string.equals("groupdnattr") || string.equals("roledn") || string.equals("userattr")) {
            string2 = "principal";
        } else if (string.equals("ip") || string.equals("dns")) {
            string2 = "IP";
        } else if (string.equals("authmethod")) {
            string2 = "authmethod";
        } else if (string.equals("timeofday")) {
            string2 = "tod";
        } else if (string.equals("dayofweek")) {
            string2 = "dow";
        } else {
            throw new ACIParseException("can not determine keyword set for : " + string);
        }
        return string2;
    }

    String getTokenType(String string) throws ACIParseException {
        string = string.toLowerCase();
        String string2 = null;
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string2 = "value";
        } else if (string.equals("userdn") || string.equals("userdnattr") || string.equals("groupdn") || string.equals("groupdnattr") || string.equals("roledn") || string.equals("userattr") || string.equals("ip") || string.equals("dns") || string.equals("authmethod") || string.equals("timeofday") || string.equals("dayofweek")) {
            string2 = "keyword";
        } else if (string.equals("=") || string.equals("!=") || string.equals("<") || string.equals("<=") || string.equals(">") || string.equals(">=")) {
            string2 = "operator";
        } else if (string.equals("and") || string.equals("or")) {
            string2 = "expressionconnector";
        } else if (string.equals("(")) {
            string2 = "(";
        } else if (string.equals(")")) {
            string2 = ")";
        } else if (string.equals("||")) {
            string2 = "||";
        } else {
            throw new ACIParseException("tokentype unknown for " + string);
        }
        return string2;
    }

    void addParameter(String string, String string2, String string3) throws ACIParseException {
        if (!string.equals("timeofday") && !string2.equals("=")) {
            throw new ACIParseException(" keyword " + string + " does not allow operator " + string2);
        }
        if (string.equals("timeofday") && string2.equals(">=") && this._keywordCount > 1 && !"or".equals(this._expressionConnector)) {
            throw new ACIParseException(" illegal operator for timeofday : " + string2);
        }
        if (string.equals("timeofday") && string2.equals("<=") && !"and".equals(this._expressionConnector)) {
            throw new ACIParseException(" illegal operator for timeofday : " + string2);
        }
        if (string.equals("userdn")) {
            this.br.addUsers(string3);
        } else if (string.equals("userdnattr")) {
            this.br.addUserDNAttr(string3);
        } else if (string.equals("groupdn")) {
            this.br.addGroups(string3);
        } else if (string.equals("groupdnattr")) {
            this.br.addGroupDNAttr(string3);
        } else if (string.equals("roledn")) {
            this.br.addRoles(string3);
        } else if (string.equals("userattr")) {
            this.br.addUserAttr(string3);
        } else if (string.equals("authmethod")) {
            this.br.addAuthMethod(string3);
        } else if (string.equals("ip")) {
            this.br.addClientIP(string3);
        } else if (string.equals("dns")) {
            this.br.addClientHostName(string3);
        } else if (string.equals("timeofday")) {
            this.br.addTimeOfDay(string3, string2);
        } else if (string.equals("dayofweek")) {
            this.br.addDaysOfWeek(string3);
        } else {
            throw new ACIParseException("Unknown keyword : " + string);
        }
    }

    BindRule getBindRule() {
        return this.br;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }
}

