/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.ACIParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class BindRule {
    Collection _users;
    Collection _groups;
    Collection _roles;
    Collection _authMethods;
    Collection _clientIP;
    Collection _clientHostNames;
    Collection _timesOfDay;
    String _todOp;
    Collection _daysOfWeek;
    String _previousTodOperator;
    Collection _userDNAttrs;
    Collection _groupDNAttrs;
    Collection _userAttrs;

    BindRule() {
    }

    void addUsers(String string) throws ACIParseException {
        if (this._users == null) {
            this._users = new ArrayList();
        }
        Iterator iterator = ACIParser.getTokens(string, "||").iterator();
        while (iterator.hasNext()) {
            String string2 = ((String)iterator.next()).trim();
            if (string2.indexOf("ldap:///") == 0) {
                this._users.add(string2.substring("ldap:///".length()));
                continue;
            }
            if (string2.toLowerCase().indexOf("ldap:///") == 0) {
                this._users.add(string2.substring("ldap:///".length()));
                continue;
            }
            throw new ACIParseException("Malformed userDN : " + string2);
        }
    }

    Collection getUsers() {
        return this._users;
    }

    void addGroups(String string) throws ACIParseException {
        if (this._groups == null) {
            this._groups = new ArrayList();
        }
        Iterator iterator = ACIParser.getTokens(string, "||").iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.indexOf("ldap:///") == 0) {
                this._groups.add(string2.substring("ldap:///".length()));
                continue;
            }
            if (string2.toLowerCase().indexOf("ldap:///") == 0) {
                this._groups.add(string2.substring("ldap:///".length()));
                continue;
            }
            throw new ACIParseException("Malformed groupDN : " + string);
        }
    }

    Collection getGroups() {
        return this._groups;
    }

    void addRoles(String string) throws ACIParseException {
        if (this._roles == null) {
            this._roles = new ArrayList();
        }
        Iterator iterator = ACIParser.getTokens(string, "||").iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.indexOf("ldap:///") == 0) {
                this._roles.add(string2.substring("ldap:///".length()));
                continue;
            }
            if (string2.toLowerCase().indexOf("ldap:///") == 0) {
                this._roles.add(string2.substring("ldap:///".length()));
                continue;
            }
            throw new ACIParseException("Malformed roleDN : " + string);
        }
    }

    Collection getRoles() {
        return this._roles;
    }

    void addUserDNAttr(String string) {
        if (this._userDNAttrs == null) {
            this._userDNAttrs = new ArrayList();
        }
        this._userDNAttrs.add(string);
    }

    Collection getUserDNAttrs() {
        return this._userDNAttrs;
    }

    void addGroupDNAttr(String string) {
        if (this._groupDNAttrs == null) {
            this._groupDNAttrs = new ArrayList();
        }
        this._groupDNAttrs.add(string);
    }

    Collection getGroupDNAttrs() {
        return this._groupDNAttrs;
    }

    void addAuthMethod(String string) {
        if (this._authMethods == null) {
            this._authMethods = new ArrayList();
        }
        this._authMethods.add(string);
    }

    Collection getAuthMethods() {
        return this._authMethods;
    }

    void addClientIP(String string) {
        if (this._clientIP == null) {
            this._clientIP = new ArrayList();
        }
        this._clientIP.add(string);
    }

    Collection getClientIP() {
        return this._clientIP;
    }

    void addClientHostName(String string) {
        if (this._clientHostNames == null) {
            this._clientHostNames = new ArrayList();
        }
        this._clientHostNames.add(string);
    }

    Collection getClientHostNames() {
        return this._clientHostNames;
    }

    void addTimeOfDay(String string, String string2) throws ACIParseException {
        if (this._timesOfDay == null) {
            this._timesOfDay = new ArrayList();
        }
        if (!string2.equals(">=") && !string2.equals("<=")) {
            throw new ACIParseException("Illegal operator for timeofday : " + string2);
        }
        if (this._previousTodOperator == null && !string2.equals(">=")) {
            throw new ACIParseException("Illegal first operator for timeofday : " + string2);
        }
        if (string2.equals(this._previousTodOperator)) {
            throw new ACIParseException("Illegal operator sequence for timeofday : " + string2);
        }
        this._timesOfDay.add(string);
        this._previousTodOperator = string2;
    }

    Collection getTimesOfDay() {
        return this._timesOfDay;
    }

    void addDaysOfWeek(String string) {
        if (this._daysOfWeek == null) {
            this._daysOfWeek = new ArrayList();
        }
        this._daysOfWeek.addAll(ACIParser.getTokens(string, ","));
    }

    Collection getDaysOfWeek() {
        return this._daysOfWeek;
    }

    void addUserAttr(String string) {
        if (this._userAttrs == null) {
            this._userAttrs = new ArrayList();
        }
        this._userAttrs.add(string);
    }

    Collection getUserAttrs() {
        return this._userAttrs;
    }
}

