/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;

public class ServerInstance {
    ServerGroup serverGroup = null;
    Server server = null;
    LDAPUser user = null;
    boolean status;

    ServerInstance(ServerGroup serverGroup, Server server, LDAPUser lDAPUser) {
        this.serverGroup = serverGroup;
        this.server = server;
        this.user = lDAPUser;
    }

    public synchronized void setActiveStatus(boolean bl) {
        this.server.setActiveStatus(bl);
    }

    public synchronized boolean getActiveStatus() {
        return this.server.getActiveStatus();
    }

    public synchronized String getServerName() {
        return this.server.getServerName();
    }

    public synchronized int getPort() {
        return this.server.getPort();
    }

    public synchronized String getServerID() {
        return this.server.getServerID();
    }

    public synchronized String getAuthID() {
        return this.user.getAuthID();
    }

    public Server.Type getConnectionType() {
        return this.server.getConnectionType();
    }

    public synchronized String getPasswd() {
        return this.user.getPasswd();
    }

    public synchronized LDAPUser.Type getAuthType() {
        return this.user.getAuthType();
    }

    public synchronized int getMinConnections() {
        return this.serverGroup.minConnPool;
    }

    public synchronized int getMaxConnections() {
        return this.serverGroup.maxConnPool;
    }

    public synchronized String getBaseDN() {
        return this.serverGroup.baseDN;
    }

    public synchronized int getIntValue(String string, int n) {
        if (this.serverGroup.miscConfig != null) {
            String string2 = (String)this.serverGroup.miscConfig.get(string);
            if (string2 == null) {
                return n;
            }
            try {
                int n2 = Integer.parseInt(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return n;
    }

    public synchronized String getStringValue(String string, String string2) {
        if (this.serverGroup.miscConfig == null) {
            return string2;
        }
        String string3 = (String)this.serverGroup.miscConfig.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public synchronized boolean getBooleanValue(String string, boolean bl) {
        if (this.serverGroup.miscConfig == null) {
            return bl;
        }
        String string2 = (String)this.serverGroup.miscConfig.get(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Server Group Name =");
        stringBuffer.append(this.serverGroup.serverGroupName());
        stringBuffer.append(" Server ID:=");
        stringBuffer.append(this.server.getServerID());
        stringBuffer.append(" LDAPUser=");
        stringBuffer.append(this.user.getUserID());
        stringBuffer.append(" Base DN=");
        stringBuffer.append(this.serverGroup.baseDN);
        return stringBuffer.toString();
    }
}

