/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.GenericNode;
import com.iplanet.services.util.ParseOutput;
import com.iplanet.services.util.XMLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public class ServerGroup
implements ParseOutput {
    String baseDN = null;
    int maxConnPool = -1;
    int minConnPool = -1;
    ArrayList servers = null;
    ArrayList users = null;
    HashMap miscConfig = null;
    private String groupName;

    public void process(String string, Vector vector, Hashtable hashtable, String string2) throws XMLException {
        if (DSConfigMgr.debugger.messageEnabled()) {
            DSConfigMgr.debugger.message("in ServerGroup.process()");
        }
        if (string.equals("ServerGroup")) {
            String string3;
            Object object;
            this.groupName = (String)hashtable.get("name");
            int n = 0;
            while (n < vector.size()) {
                object = vector.elementAt(n);
                if (DSConfigMgr.debugger.messageEnabled()) {
                    DSConfigMgr.debugger.message("Object of type:" + object.getClass().getName());
                }
                if (object instanceof Server) {
                    if (this.servers == null) {
                        if (DSConfigMgr.debugger.messageEnabled()) {
                            DSConfigMgr.debugger.message("Initializing servers list.");
                        }
                        this.servers = new ArrayList();
                    }
                    this.servers.add(object);
                } else if (object instanceof LDAPUser) {
                    if (this.users == null) {
                        this.users = new ArrayList();
                    }
                    this.users.add(object);
                } else if (object instanceof GenericNode) {
                    string3 = (GenericNode)object;
                    if (((GenericNode)string3)._name.equals("BaseDN")) {
                        if (((GenericNode)string3)._pcdata != null && !DN.isDN((String)((GenericNode)string3)._pcdata)) {
                            throw new XMLException(DSConfigMgr.getString("dscfg-invalid_base_dn") + ((GenericNode)string3)._pcdata);
                        }
                        this.baseDN = LDAPDN.normalize((String)((GenericNode)string3)._pcdata);
                    } else if (((GenericNode)string3)._name.equals("MiscConfig")) {
                        String string4 = (String)((GenericNode)string3)._atts.get("name");
                        String string5 = (String)((GenericNode)string3)._atts.get("value");
                        if (string != null && string.length() > 0) {
                            if (this.miscConfig == null) {
                                this.miscConfig = new HashMap();
                            }
                            this.miscConfig.put(string4, string5);
                        }
                    }
                }
                ++n;
            }
            if (this.servers == null || this.baseDN == null) {
                object = null;
                if (this.servers == null) {
                    object = "No server object found in the server group:" + this.groupName;
                }
                if (this.baseDN == null) {
                    object = "No base DN string defined in the server group:" + this.groupName;
                }
                throw new XMLException(object);
            }
            object = System.getProperty("max_conn_pool");
            if (object == null) {
                object = (String)hashtable.get("maxConnPool");
            }
            if ((string3 = System.getProperty("min_conn_pool")) == null) {
                string3 = (String)hashtable.get("minConnPool");
            }
            try {
                this.maxConnPool = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.maxConnPool = 10;
            }
            try {
                this.minConnPool = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.minConnPool = 1;
            }
        } else {
            throw new XMLException(DSConfigMgr.getString("dscfg-servergroup_node_expected"));
        }
        DSConfigMgr.thisInstance.groupHash.put(this.groupName, this);
    }

    public ServerInstance getServerInstance(LDAPUser.Type type) {
        Object var2_2 = null;
        Server server = null;
        int n = 0;
        while (n < this.servers.size()) {
            server = (Server)this.servers.get(n);
            if (server != null && server.getActiveStatus()) break;
            ++n;
        }
        LDAPUser lDAPUser = null;
        int n2 = 0;
        while (n2 < this.users.size()) {
            lDAPUser = (LDAPUser)this.users.get(n2);
            if (lDAPUser != null && lDAPUser.getAuthType().equals(type)) break;
            ++n2;
        }
        if (server == null) {
            return null;
        }
        if (lDAPUser != null) {
            return new ServerInstance(this, server, lDAPUser);
        }
        return null;
    }

    public String serverGroupName() {
        return this.groupName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Server Group Name=");
        stringBuffer.append(this.groupName);
        int n = 0;
        while (n < this.users.size()) {
            stringBuffer.append('\n');
            stringBuffer.append(' ');
            stringBuffer.append(this.users.get(n).toString());
            ++n;
        }
        int n2 = 0;
        while (n2 < this.servers.size()) {
            stringBuffer.append('\n');
            stringBuffer.append(' ');
            stringBuffer.append(this.servers.get(n2).toString());
            ++n2;
        }
        stringBuffer.append("Min Connection Pool=");
        stringBuffer.append(this.minConnPool);
        stringBuffer.append(" Max Connection Pool=");
        stringBuffer.append(this.maxConnPool);
        return stringBuffer.toString();
    }

    Collection getServersList() {
        return this.servers;
    }
}

