/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.https.ApprovalCallback;
import com.iplanet.services.comm.https.JSSPasswordCallback;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Provider;
import java.security.Security;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.util.PasswordCallback;

public class JSSSocketFactory
implements Serializable,
LDAPSocketFactory {
    static final long serialVersionUID = -6926469178017736902L;
    public static final String defaultDBdir = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.dir");
    public static final String defaultDBPrefix = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.prefix");
    private static Debug debug = Debug.getInstance((String)"amJSS");
    private static String dbdir;
    private static String moddb;
    private static String keydbPrefix;
    private static String certdbPrefix;
    private static boolean initialized;

    public JSSSocketFactory() throws LDAPException {
        if (!initialized) {
            JSSSocketFactory.initialize(defaultDBdir, defaultDBPrefix, defaultDBPrefix, "");
        }
    }

    public static void initialize(String string) throws LDAPException {
        JSSSocketFactory.initialize(string, "", "", "");
    }

    public static void initialize(String string, String string2, String string3, String string4) throws LDAPException {
        JSSSocketFactory.initialize(string, string2, string3, string4, false);
    }

    public static void initialize(String string, String string2, String string3, String string4, boolean bl) throws LDAPException {
        BufferedReader bufferedReader;
        if (initialized) {
            throw new LDAPException("JSSSocketFactory is already initialized", 80);
        }
        String string5 = SystemProperties.get((String)"com.iplanet.am.admin.cli.certdb.passfile");
        String string6 = null;
        if (string5 != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string5);
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                string6 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                debug.message("JSSSocketFactory.initialize: Unable to read JSS password file " + string5);
            }
        }
        try {
            CryptoManager.getInstance();
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            debug.message("Start JSS initialization");
            if (string == null) {
                string = defaultDBdir;
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string3 == null) {
                string3 = "";
            }
            if (string4 == null) {
                // empty if block
            }
            string4 = "";
            dbdir = string;
            moddb = string4;
            keydbPrefix = string3;
            certdbPrefix = string2;
            bufferedReader = null;
            bufferedReader = string2.equals("") ? new CryptoManager.InitializationValues(string) : new CryptoManager.InitializationValues(string, string2, string3, string4);
            ((CryptoManager.InitializationValues)bufferedReader).removeSunProvider = false;
            ((CryptoManager.InitializationValues)bufferedReader).readOnly = bl;
            try {
                boolean bl2 = Boolean.valueOf(SystemProperties.get((String)"com.sun.identity.jss.donotInstallAtHighestPriority", (String)"false"));
                if (bl2) {
                    ((CryptoManager.InitializationValues)bufferedReader).installJSSProvider = false;
                }
                CryptoManager.initialize((CryptoManager.InitializationValues)bufferedReader);
                if (bl2) {
                    Provider provider = null;
                    try {
                        provider = (Provider)Class.forName("org.mozilla.jss.JSSProvider").newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        provider = (Provider)Class.forName("org.mozilla.jss.provider.Provider").newInstance();
                    }
                    Security.addProvider(provider);
                }
                if (string6 != null) {
                    CryptoManager.getInstance().setPasswordCallback((PasswordCallback)new JSSPasswordCallback(string6));
                }
                initialized = true;
            }
            catch (Exception exception) {
                debug.error("JSS initialize", (Throwable)exception);
                throw new LDAPException(exception.getMessage(), 80);
            }
        }
    }

    public static String getDBDir() {
        return dbdir;
    }

    public static String getModDB() {
        return moddb;
    }

    public static String getKeydbPrefix() {
        return keydbPrefix;
    }

    public static String getCertdbPrefix() {
        return certdbPrefix;
    }

    public Socket makeSocket(String string, int n) throws LDAPException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = new SSLSocket(InetAddress.getByName(string), n, null, 0, (SSLCertificateApprovalCallback)new ApprovalCallback(string), null);
            sSLSocket.forceHandshake();
        }
        catch (Exception exception) {
            debug.error("SSLSocket dbdir=" + dbdir + " certdbPrefix=" + certdbPrefix + "  keydbPrefix=" + keydbPrefix, (Throwable)exception);
            throw new LDAPException("SSL connection to " + string + ":" + n + ", " + exception.getMessage(), 91);
        }
        return sSLSocket;
    }

    static {
        initialized = false;
    }
}

