/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVA;
import com.iplanet.security.x509.DirStrConverter;
import com.iplanet.security.x509.GeneralNameInterface;
import com.iplanet.security.x509.LdapDNStrConverter;
import com.iplanet.security.x509.PrintableConverter;
import com.iplanet.security.x509.RDN;
import com.iplanet.security.x509.X500NameAttrMap;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;

public class X500Name
implements Principal,
GeneralNameInterface {
    private String dn;
    private RDN[] names;
    public static final ObjectIdentifier commonName_oid = X500NameAttrMap.getDefault().getOid("CN");
    public static final ObjectIdentifier countryName_oid = X500NameAttrMap.getDefault().getOid("C");
    public static final ObjectIdentifier localityName_oid = X500NameAttrMap.getDefault().getOid("L");
    public static final ObjectIdentifier orgName_oid = X500NameAttrMap.getDefault().getOid("O");
    public static final ObjectIdentifier orgUnitName_oid = X500NameAttrMap.getDefault().getOid("OU");
    public static final ObjectIdentifier stateName_oid = X500NameAttrMap.getDefault().getOid("ST");
    public static final ObjectIdentifier streetAddress_oid = X500NameAttrMap.getDefault().getOid("STREET");
    public static final ObjectIdentifier title_oid = X500NameAttrMap.getDefault().getOid("TITLE");
    public static final ObjectIdentifier email_oid = X500NameAttrMap.getDefault().getOid("E");
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    public static final ObjectIdentifier ipAddress_oid = new ObjectIdentifier(ipAddress_data);

    public X500Name(String string) throws IOException {
        X500Name x500Name = LdapDNStrConverter.getDefault().parseDN(string);
        this.names = x500Name.getNames();
    }

    public X500Name(String string, byte[] byArray) throws IOException {
        X500Name x500Name = LdapDNStrConverter.getDefault().parseDN(string, byArray);
        this.names = x500Name.getNames();
    }

    public X500Name(String string, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        X500Name x500Name = ldapDNStrConverter.parseDN(string);
        this.names = x500Name.getNames();
    }

    public X500Name(String string, String string2, String string3, String string4) throws IOException {
        DirStrConverter dirStrConverter = new DirStrConverter();
        PrintableConverter printableConverter = new PrintableConverter();
        AVA[] aVAArray = new AVA[1];
        int n = 4;
        this.names = new RDN[n];
        aVAArray[0] = new AVA(commonName_oid, dirStrConverter.getValue(string));
        this.names[--n] = new RDN(aVAArray);
        aVAArray[0] = new AVA(orgUnitName_oid, dirStrConverter.getValue(string2));
        this.names[--n] = new RDN(aVAArray);
        aVAArray[0] = new AVA(orgName_oid, dirStrConverter.getValue(string3));
        this.names[--n] = new RDN(aVAArray);
        aVAArray[0] = new AVA(countryName_oid, printableConverter.getValue(string4));
        this.names[--n] = new RDN(aVAArray);
    }

    public X500Name(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        DirStrConverter dirStrConverter = new DirStrConverter();
        PrintableConverter printableConverter = new PrintableConverter();
        AVA[] aVAArray = new AVA[1];
        int n = 6;
        this.names = new RDN[n];
        aVAArray[0] = new AVA(commonName_oid, dirStrConverter.getValue(string));
        this.names[--n] = new RDN(aVAArray);
        aVAArray[0] = new AVA(orgUnitName_oid, dirStrConverter.getValue(string2));
        this.names[--n] = new RDN(aVAArray);
        aVAArray[0] = new AVA(orgName_oid, dirStrConverter.getValue(string3));
        this.names[--n] = new RDN(aVAArray);
        aVAArray[0] = new AVA(localityName_oid, dirStrConverter.getValue(string4));
        this.names[--n] = new RDN(aVAArray);
        aVAArray[0] = new AVA(stateName_oid, dirStrConverter.getValue(string5));
        this.names[--n] = new RDN(aVAArray);
        aVAArray[0] = new AVA(countryName_oid, printableConverter.getValue(string6));
        this.names[--n] = new RDN(aVAArray);
    }

    public X500Name(DerValue derValue) throws IOException {
        this(derValue.toDerInputStream());
    }

    public X500Name(DerInputStream derInputStream) throws IOException {
        this.parseDER(derInputStream);
    }

    public X500Name(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.parseDER(derInputStream);
    }

    public X500Name(RDN[] rDNArray) throws IOException {
        this.names = (RDN[])rDNArray.clone();
    }

    public X500Name(Vector vector) throws IOException {
        int n = vector.size();
        this.names = new RDN[n];
        for (int i = 0; i < n; ++i) {
            this.names[i] = (RDN)vector.elementAt(i);
        }
    }

    public synchronized boolean equals(X500Name x500Name) {
        if (this == x500Name) {
            return true;
        }
        if (this.names.length != x500Name.names.length) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i].equals(x500Name.names[i])) continue;
            return false;
        }
        return true;
    }

    private String getString(DerValue derValue) throws IOException {
        if (derValue == null) {
            return null;
        }
        String string = derValue.getAsString();
        if (string == null) {
            throw new IOException("not a DER string encoding, " + derValue.tag);
        }
        return string;
    }

    public int getType() {
        return 4;
    }

    public String getCountry() throws IOException {
        DerValue derValue = this.findAttribute(countryName_oid);
        return this.getString(derValue);
    }

    public String getOrganization() throws IOException {
        DerValue derValue = this.findAttribute(orgName_oid);
        return this.getString(derValue);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue derValue = this.findAttribute(orgUnitName_oid);
        return this.getString(derValue);
    }

    public String getCommonName() throws IOException {
        DerValue derValue = this.findAttribute(commonName_oid);
        return this.getString(derValue);
    }

    public String getLocality() throws IOException {
        DerValue derValue = this.findAttribute(localityName_oid);
        return this.getString(derValue);
    }

    public String getState() throws IOException {
        DerValue derValue = this.findAttribute(stateName_oid);
        return this.getString(derValue);
    }

    public String getEmail() throws IOException {
        DerValue derValue = this.findAttribute(email_oid);
        if (derValue == null) {
            return null;
        }
        return this.getString(derValue);
    }

    public String getAttributeValue(String string) throws IOException {
        ObjectIdentifier objectIdentifier = X500NameAttrMap.getDefault().getOid(string);
        return this.getString(this.findAttribute(objectIdentifier));
    }

    public String toLdapDNString() throws IOException {
        if (this.dn == null) {
            this.generateDN(LdapDNStrConverter.getDefault());
        }
        return this.dn;
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        if (this.dn == null) {
            this.generateDN(ldapDNStrConverter);
        }
        return this.dn;
    }

    public String toString() {
        String string;
        try {
            string = this.toLdapDNString();
        }
        catch (IOException iOException) {
            return null;
        }
        return string;
    }

    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        DerValue derValue = null;
        for (int i = 0; i < this.names.length && (derValue = this.names[i].findAttribute(objectIdentifier)) == null; ++i) {
        }
        return derValue;
    }

    public Enumeration getRDNs() {
        return new RDNEnumerator();
    }

    public RDN[] getNames() {
        return (RDN[])this.names.clone();
    }

    public int getNamesLength() {
        return this.names.length;
    }

    private void parseDER(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSequence(5);
        this.names = new RDN[derValueArray.length];
        for (int i = 0; i < derValueArray.length; ++i) {
            this.names[i] = new RDN(derValueArray[i]);
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i].encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public byte[] getEncoded() throws IOException {
        if (this.names == null) {
            return null;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i].encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    private void generateDN(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        this.dn = ldapDNStrConverter.encodeDN(this);
    }

    static ObjectIdentifier intern(ObjectIdentifier objectIdentifier) throws IOException {
        return X500NameAttrMap.getDefault().getOid(objectIdentifier);
    }

    private class RDNEnumerator
    implements Enumeration {
        private int index = 0;

        public boolean hasMoreElements() {
            return this.index < X500Name.this.names.length;
        }

        public Object nextElement() {
            if (this.index >= X500Name.this.names.length) {
                return null;
            }
            return X500Name.this.names[this.index++];
        }
    }
}

