/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.GeneralNamesException;
import com.iplanet.security.x509.IssuingDistributionPoint;
import com.iplanet.security.x509.RDN;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.PKIXExtensions;

public class IssuingDistributionPointExtension
extends Extension
implements CertAttrSet {
    public static final String OID = "2.5.29.28";
    public static final String NAME = "IssuingDistributionPoint";
    public static final String ISSUING_DISTRIBUTION_POINT = "issuing_distribution_point";
    private IssuingDistributionPoint issuingDistributionPoint = null;
    private byte[] cachedEncoding = null;

    private IssuingDistributionPointExtension() {
    }

    public IssuingDistributionPointExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = bl;
        byte[] byArray = this.extensionValue = (byte[])((byte[])object).clone();
        this.issuingDistributionPoint = new IssuingDistributionPoint();
        sun.security.util.DerValue derValue = new sun.security.util.DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding of IssuingDistributionPoint");
        }
        while (derValue.data.available() != 0) {
            sun.security.util.DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2 != null) {
                for (int i = 0; i < 5; ++i) {
                    if (!derValue2.isContextSpecific((byte)i)) continue;
                    if (i == 0 && derValue2.isConstructed() && derValue2.data.available() != 0 || i != 0 && !derValue2.isConstructed() && derValue2.data.available() != 0) {
                        Object object2;
                        if (i == 0) {
                            sun.security.util.DerValue derValue3 = derValue2.data.getDerValue();
                            if (derValue3 == null) continue;
                            if (derValue3.isContextSpecific((byte)0)) {
                                if (derValue3.isConstructed() && derValue3.data.available() != 0) {
                                    derValue3.resetTag((byte)48);
                                    try {
                                        object2 = new GeneralNames(derValue3);
                                        if (object2 == null) continue;
                                        this.issuingDistributionPoint.setFullName((GeneralNames)object2);
                                        continue;
                                    }
                                    catch (GeneralNamesException generalNamesException) {
                                        throw new IOException("Invalid encoding of IssuingDistributionPoint " + generalNamesException);
                                    }
                                    catch (IOException iOException) {
                                        throw new IOException("Invalid encoding of IssuingDistributionPoint " + iOException);
                                    }
                                }
                                throw new IOException("Invalid encoding of IssuingDistributionPoint");
                            }
                            if (!derValue3.isContextSpecific((byte)1)) continue;
                            if (derValue3.isConstructed() && derValue3.data.available() != 0) {
                                derValue3.resetTag((byte)49);
                                try {
                                    object2 = new DerValue(derValue3.getDataBytes());
                                    RDN rDN = new RDN((DerValue)object2);
                                    if (rDN == null) continue;
                                    this.issuingDistributionPoint.setRelativeName(rDN);
                                    continue;
                                }
                                catch (IOException iOException) {
                                    throw new IOException("Invalid encoding of IssuingDistributionPoint " + iOException);
                                }
                            }
                            throw new IOException("Invalid encoding of IssuingDistributionPoint");
                        }
                        if (i == 3) {
                            derValue2.resetTag((byte)3);
                            try {
                                BitArray bitArray = derValue2.getUnalignedBitString();
                                this.issuingDistributionPoint.setOnlySomeReasons(bitArray);
                                object2 = bitArray.toByteArray();
                                continue;
                            }
                            catch (IOException iOException) {
                                throw new IOException("Invalid encoding of IssuingDistributionPoint " + iOException);
                            }
                        }
                        derValue2.resetTag((byte)1);
                        try {
                            boolean bl2 = derValue2.getBoolean();
                            if (i == 1) {
                                this.issuingDistributionPoint.setOnlyContainsUserCerts(bl2);
                                continue;
                            }
                            if (i == 2) {
                                this.issuingDistributionPoint.setOnlyContainsCACerts(bl2);
                                continue;
                            }
                            if (i != 4) continue;
                            this.issuingDistributionPoint.setIndirectCRL(bl2);
                            continue;
                        }
                        catch (IOException iOException) {
                            throw new IOException("Invalid encoding of IssuingDistributionPoint " + iOException);
                        }
                    }
                    throw new IOException("Invalid encoding of IssuingDistributionPoint");
                }
                continue;
            }
            throw new IOException("Invalid encoding of IssuingDistributionPoint");
        }
    }

    public IssuingDistributionPointExtension(IssuingDistributionPoint issuingDistributionPoint) {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        this.issuingDistributionPoint = issuingDistributionPoint;
    }

    public IssuingDistributionPoint getIssuingDistributionPoint() {
        return this.issuingDistributionPoint;
    }

    public void setCritical(boolean bl) {
        this.critical = bl;
    }

    public boolean getCritical(boolean bl) {
        return this.critical;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.extensionValue = ASN1Util.encode((ASN1Value)this.issuingDistributionPoint);
        super.encode(derOutputStream);
    }

    public void flushCachedEncoding() {
        this.cachedEncoding = null;
    }

    public String toString() {
        return NAME;
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        if (this.cachedEncoding == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            this.cachedEncoding = derOutputStream.toByteArray();
        }
        outputStream.write(this.cachedEncoding);
    }

    public void decode(InputStream inputStream) throws CertificateException, IOException {
        throw new IOException("Not supported");
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        if (string.equalsIgnoreCase(ISSUING_DISTRIBUTION_POINT)) {
            if (!(object instanceof IssuingDistributionPoint)) {
                throw new IOException("Attribute value should be of type IssuingDistributionPoint.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPointExtension");
        }
        this.issuingDistributionPoint = (IssuingDistributionPoint)object;
    }

    public Object get(String string) throws CertificateException, IOException {
        if (string.equalsIgnoreCase(ISSUING_DISTRIBUTION_POINT)) {
            return this.issuingDistributionPoint;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPointExtension");
    }

    public void delete(String string) throws CertificateException, IOException {
        if (!string.equalsIgnoreCase(ISSUING_DISTRIBUTION_POINT)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPointExtension");
        }
        this.issuingDistributionPoint = null;
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)ISSUING_DISTRIBUTION_POINT);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

