/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.x509.CRLDistributionPoint;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import sun.security.util.DerOutputStream;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class CRLDistributionPointsExtension
extends Extension
implements CertAttrSet {
    private SEQUENCE distributionPoints = new SEQUENCE();
    private byte[] cachedEncoding = null;
    public static final String OID = "2.5.29.31";
    public static final String NAME = "CRLDistributionPoints";

    private CRLDistributionPointsExtension() {
    }

    public CRLDistributionPointsExtension(Boolean bl, Object object) {
        try {
            this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
            this.critical = bl;
            this.extensionValue = (byte[])((byte[])object).clone();
            try {
                SEQUENCE.OF_Template oF_Template = new SEQUENCE.OF_Template((ASN1Template)CRLDistributionPoint.getTemplate());
                this.distributionPoints = (SEQUENCE)ASN1Util.decode((ASN1Template)oF_Template, (byte[])this.extensionValue);
            }
            catch (InvalidBERException invalidBERException) {
                throw new IOException("Invalid BER-encoding: " + invalidBERException.toString());
            }
        }
        catch (IOException iOException) {
            System.out.println("Big error");
            System.out.println(iOException);
            iOException.printStackTrace();
        }
    }

    public CRLDistributionPointsExtension(CRLDistributionPoint cRLDistributionPoint) {
        this.extensionId = PKIXExtensions.CRLDistributionPoints_Id;
        this.critical = false;
        this.distributionPoints.addElement((ASN1Value)cRLDistributionPoint);
    }

    public void addPoint(CRLDistributionPoint cRLDistributionPoint) {
        this.distributionPoints.addElement((ASN1Value)cRLDistributionPoint);
        this.cachedEncoding = null;
    }

    public int getNumPoints() {
        return this.distributionPoints.size();
    }

    public CRLDistributionPoint getPointAt(int n) {
        return (CRLDistributionPoint)this.distributionPoints.elementAt(n);
    }

    public void setCritical(boolean bl) {
        this.critical = bl;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.extensionValue = ASN1Util.encode((ASN1Value)this.distributionPoints);
        super.encode(derOutputStream);
    }

    public void flushCachedEncoding() {
        this.cachedEncoding = null;
    }

    public String toString() {
        return NAME;
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        if (this.cachedEncoding == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            this.cachedEncoding = derOutputStream.toByteArray();
        }
        outputStream.write(this.cachedEncoding);
    }

    public void decode(InputStream inputStream) throws CertificateException, IOException {
        throw new IOException("Not supported");
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension");
    }

    public Object get(String string) throws CertificateException, IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension");
    }

    public void delete(String string) throws CertificateException, IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLDistributionPointsExtension");
    }

    public Enumeration getElements() {
        return new Vector().elements();
    }

    public String getName() {
        return NAME;
    }

    public static class Reason {
        private String name;
        private byte bitMask;
        private static Hashtable map = new Hashtable();
        private static Vector list = new Vector();
        public static final Reason UNUSED = new Reason("unused", -128);
        public static final Reason KEY_COMPROMISE = new Reason("keyCompromise", 64);
        public static final Reason CA_COMPROMISE = new Reason("cACompromise", 32);
        public static final Reason AFFILIATION_CHANGED = new Reason("affiliationChanged", 16);
        public static final Reason SUPERSEDED = new Reason("superseded", 8);
        public static final Reason CESSATION_OF_OPERATION = new Reason("cessationOfOperation", 4);
        public static final Reason CERTIFICATE_HOLD = new Reason("certificateHold", 2);

        private Reason() {
        }

        private Reason(String string, byte by) {
            this.name = string;
            this.bitMask = by;
            map.put(string, this);
            list.addElement(this);
        }

        public static Reason fromString(String string) {
            return (Reason)map.get(string);
        }

        public String getName() {
            return this.name;
        }

        public byte getBitMask() {
            return this.bitMask;
        }

        public static Reason[] bitArrayToReasonArray(byte by) {
            return Reason.bitArrayToReasonArray(new byte[]{by});
        }

        public static Reason[] bitArrayToReasonArray(byte[] byArray) {
            byte by = byArray[0];
            int n = list.size();
            Vector<Reason> vector = new Vector<Reason>();
            for (int i = 0; i < n; ++i) {
                Reason reason = (Reason)list.elementAt(i);
                byte by2 = reason.getBitMask();
                if ((by & by2) == 0) continue;
                vector.addElement(reason);
            }
            n = vector.size();
            Reason[] reasonArray = new Reason[n];
            for (int i = 0; i < n; ++i) {
                reasonArray[i] = (Reason)vector.elementAt(i);
            }
            return reasonArray;
        }
    }
}

