/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.remote;

import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.IdRepoListener;
import com.iplanet.am.sdk.remote.DirectoryManager;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.jaxrpc.SOAPClient;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.SMSSchema;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import netscape.ldap.util.DN;

class EventListener {
    private static Debug debug = DirectoryManager.debug;
    private static boolean initialized;
    private static Set listeners;
    private static SOAPClient client;
    private static String notificationID;
    private static String idRepoNotificationID;
    static final String METHOD = "method";
    static final String ENTITY_NAME = "entityName";
    static final String EVENT_TYPE = "eventType";
    static final String ATTR_NAMES = "attrNames";
    static final String OBJECT_CHANGED = "objectChanged";
    static final String OBJECTS_CHANGED = "objectsChanged";
    static final String PERMISSIONS_CHANGED = "permissionsChanged";
    static final String ALL_OBJECTS_CHANGED = "allObjectsChanged";

    public EventListener() {
        if (!initialized) {
            Debug debug = EventListener.debug;
            synchronized (debug) {
                if (!initialized) {
                    client = new SOAPClient(DirectoryManager.SDK_SERVICE);
                    try {
                        URL uRL = WebtopNaming.getNotificationURL();
                        notificationID = (String)client.send("registerNotificationURL", uRL.toString(), null);
                        PLLClient.addNotificationHandler((String)DirectoryManager.SDK_SERVICE, (NotificationHandler)new EventNotificationHandler());
                        idRepoNotificationID = (String)client.send("registerNotificationURL_idrepo", uRL.toString(), null);
                        PLLClient.addNotificationHandler((String)DirectoryManager.IDREPO_SERVICE, (NotificationHandler)new IdRepoEventNotificationHandler());
                        if (EventListener.debug.messageEnabled()) {
                            EventListener.debug.message("EventService: Using notification mechanism for cache updates: " + uRL.toString());
                        }
                    }
                    catch (Exception exception) {
                        if (EventListener.debug.warningEnabled()) {
                            EventListener.debug.warning("EventService: Registering for notification via URL failed: " + exception.getMessage() + "\nUsing polling mechanism for updates");
                        }
                        NotificationThread notificationThread = new NotificationThread();
                        notificationThread.start();
                    }
                    initialized = true;
                }
            }
        }
    }

    public void addListener(SSOToken sSOToken, AMObjectListener aMObjectListener) throws AMEventManagerException {
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new AMEventManagerException(sSOException.getMessage(), "902");
        }
        Set set = listeners;
        synchronized (set) {
            listeners.add(aMObjectListener);
        }
    }

    static void sendNotification(String string) {
        block31: {
            if (debug.messageEnabled()) {
                debug.message("EventListener::sendNotification: Received notification: " + string);
            }
            StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(string);
            try {
                String string2;
                String string3;
                Map map = CreateServiceConfig.getAttributeValuePairs(SMSSchema.getXMLDocument(stringBuffer.toString(), false).getDocumentElement());
                if (debug.messageEnabled()) {
                    debug.message("EventListener::sendNotification Decoded Event: " + map);
                }
                if ((string3 = EventListener.getAttributeValue(map, METHOD)) == null) {
                    EventListener.handleError("invalid method name: " + map.get(METHOD));
                }
                if ((string2 = EventListener.getAttributeValue(map, ENTITY_NAME)) == null) {
                    EventListener.handleError("invalid entity Name: " + map.get(ENTITY_NAME));
                }
                if (string3.equalsIgnoreCase(OBJECT_CHANGED)) {
                    int n = EventListener.getEventType((Set)map.get(EVENT_TYPE));
                    Set set = listeners;
                    synchronized (set) {
                        Iterator iterator = listeners.iterator();
                        while (iterator.hasNext()) {
                            AMObjectListener aMObjectListener = (AMObjectListener)iterator.next();
                            aMObjectListener.objectChanged(string2, n, null);
                        }
                    }
                } else if (string3.equalsIgnoreCase(OBJECTS_CHANGED)) {
                    int n = EventListener.getEventType((Set)map.get(EVENT_TYPE));
                    Set set = (Set)map.get(map.get(ATTR_NAMES));
                    Set set2 = listeners;
                    synchronized (set2) {
                        Iterator iterator = listeners.iterator();
                        while (iterator.hasNext()) {
                            AMObjectListener aMObjectListener = (AMObjectListener)iterator.next();
                            aMObjectListener.objectsChanged(string2, n, set, null);
                        }
                    }
                } else if (string3.equalsIgnoreCase(PERMISSIONS_CHANGED)) {
                    Set set = listeners;
                    synchronized (set) {
                        Iterator iterator = listeners.iterator();
                        while (iterator.hasNext()) {
                            AMObjectListener aMObjectListener = (AMObjectListener)iterator.next();
                            aMObjectListener.permissionsChanged(string2, null);
                        }
                    }
                } else if (string3.equalsIgnoreCase(ALL_OBJECTS_CHANGED)) {
                    Set set = listeners;
                    synchronized (set) {
                        Iterator iterator = listeners.iterator();
                        while (iterator.hasNext()) {
                            AMObjectListener aMObjectListener = (AMObjectListener)iterator.next();
                            aMObjectListener.allObjectsChanged();
                        }
                    }
                } else {
                    EventListener.handleError("invalid method name: " + string3);
                }
                if (debug.messageEnabled()) {
                    debug.warning("EventListener::sendNotification: Sent notification: " + string);
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block31;
                debug.warning("EventListener::sendNotification: Unable to send notification: " + string, (Throwable)exception);
            }
        }
    }

    static void sendIdRepoNotification(String string) {
        block16: {
            if (debug.messageEnabled()) {
                debug.message("EventListener::sendIdRepoNotification: Received notification: " + string);
            }
            StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(string);
            try {
                Map map = CreateServiceConfig.getAttributeValuePairs(SMSSchema.getXMLDocument(stringBuffer.toString(), false).getDocumentElement());
                if (map == null || map.isEmpty()) {
                    if (debug.warningEnabled()) {
                        debug.warning("EventListener::sendIdRepoNotification: Invalid event: " + map);
                    }
                    return;
                }
                if (debug.messageEnabled()) {
                    debug.message("EventListener::sendIdRepoNotification Decoded Event: " + map);
                }
                String string2 = EventListener.getAttributeValue(map, ENTITY_NAME);
                String string3 = EventListener.getAttributeValue(map, METHOD);
                if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
                    if (debug.warningEnabled()) {
                        debug.warning("EventListener::sendIdRepoNotification: Invalid universalID or method: " + string2 + " method");
                    }
                    return;
                }
                String string4 = string2;
                String string5 = null;
                int n = string2.indexOf(",amsdkdn=");
                if (n > 0) {
                    string4 = string2.substring(0, n);
                    string5 = string2.substring(n + 9);
                }
                DN dN = new DN(string4);
                DN dN2 = dN.getParent().getParent();
                String string6 = string5 == null ? "false" : "true";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("realm", dN2.toRFCString());
                hashMap.put("amsdk", string6);
                IdRepoListener idRepoListener = new IdRepoListener();
                idRepoListener.setConfigMap(hashMap);
                if (string3.equalsIgnoreCase(OBJECT_CHANGED)) {
                    int n2 = EventListener.getEventType((Set)map.get(EVENT_TYPE));
                    idRepoListener.objectChanged(string2, n2, null);
                } else if (string3.equalsIgnoreCase(OBJECTS_CHANGED)) {
                    int n3 = EventListener.getEventType((Set)map.get(EVENT_TYPE));
                    Set set = (Set)map.get(map.get(ATTR_NAMES));
                } else if (!string3.equalsIgnoreCase(PERMISSIONS_CHANGED)) {
                    if (string3.equalsIgnoreCase(ALL_OBJECTS_CHANGED)) {
                        idRepoListener.allObjectsChanged();
                    } else {
                        EventListener.handleError("invalid method name: " + string3);
                    }
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block16;
                debug.warning("EventListener::sendIdRepoNotification: Unable to send notification: " + string, (Throwable)exception);
            }
        }
    }

    static void handleError(String string) throws Exception {
        debug.error("EventListener::sendNotification: " + string);
        throw new Exception(string);
    }

    static String getAttributeValue(Map map, String string) {
        String string2 = null;
        Set set = (Set)map.get(string);
        if (set != null && set.size() == 1) {
            string2 = (String)set.iterator().next();
        }
        return string2;
    }

    static int getEventType(Set set) throws Exception {
        if (set == null || set.size() != 1) {
            throw new Exception("EventListener::sendNotification: invalid event type: " + set);
        }
        String string = (String)set.iterator().next();
        return Integer.parseInt(string);
    }

    static {
        listeners = new HashSet();
    }

    static class IdRepoEventNotificationHandler
    implements NotificationHandler {
        IdRepoEventNotificationHandler() {
        }

        public void process(Vector vector) {
            int n = 0;
            while (n < vector.size()) {
                Notification notification = (Notification)vector.elementAt(n);
                String string = notification.getContent();
                if (debug.messageEnabled()) {
                    debug.message("EventListener:IdRepoEventNotificationHandler:  received notification: " + string);
                }
                EventListener.sendIdRepoNotification(string);
                ++n;
            }
        }
    }

    static class EventNotificationHandler
    implements NotificationHandler {
        EventNotificationHandler() {
        }

        public void process(Vector vector) {
            int n = 0;
            while (n < vector.size()) {
                Notification notification = (Notification)vector.elementAt(n);
                String string = notification.getContent();
                if (debug.messageEnabled()) {
                    debug.message("EventListener:EventNotificationHandler:  received notification: " + string);
                }
                EventListener.sendNotification(string);
                ++n;
            }
        }
    }

    static class NotificationThread
    extends Thread {
        static final String CACHE_TIME_PROPERTY = "com.iplanet.am.sdk.remote.pollingTime";
        static int pollingTime = 1;
        static int sleepTime = 60000;

        NotificationThread() {
            this.setDaemon(true);
            String string = SystemProperties.get((String)CACHE_TIME_PROPERTY);
            if (string != null) {
                try {
                    pollingTime = Integer.parseInt(string);
                    if (pollingTime > 0) {
                        sleepTime = pollingTime * 1000 * 60;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("EventListener::NotificationThread:: Invalid Polling Time: " + string, (Throwable)numberFormatException);
                }
            }
        }

        public void run() {
            if (debug.messageEnabled()) {
                debug.message("EventListener:NotificationThread Polling Time: " + sleepTime);
            }
            boolean bl = false;
            while (true) {
                try {
                    while (true) {
                        if (bl) {
                            Thread.sleep(sleepTime);
                        }
                        Object[] objectArray = new Object[]{new Integer(pollingTime)};
                        Set set = (Set)client.send(EventListener.OBJECTS_CHANGED, objectArray, (String)null);
                        if (debug.messageEnabled()) {
                            debug.message("EventListener:NotificationThread retrived changes: " + set);
                        }
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            EventListener.sendNotification((String)iterator.next());
                        }
                        set = (Set)client.send("objectsChanged_idrepo", objectArray, (String)null);
                        if (debug.messageEnabled()) {
                            debug.message("EventListener:NotificationThread retrived idrepo changes: " + set);
                        }
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            EventListener.sendIdRepoNotification((String)iterator.next());
                        }
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    debug.warning("EventListener::NotificationThread:run Number Format Exception for polling Time: " + pollingTime, (Throwable)numberFormatException);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                    debug.warning("EventListener::NotificationThread:run Interrupted Exception", (Throwable)interruptedException);
                    continue;
                }
                catch (Exception exception) {
                    bl = true;
                    debug.warning("EventListener::NotificationThread:run Exception", (Throwable)exception);
                    continue;
                }
                break;
            }
        }
    }
}

