/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.remote;

import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.IdRepoListener;
import com.iplanet.am.sdk.ldap.Compliance;
import com.iplanet.am.sdk.ldap.DCTree;
import com.iplanet.am.sdk.remote.AMRemoteException;
import com.iplanet.am.sdk.remote.DirectoryManager;
import com.iplanet.am.sdk.remote.DirectoryManagerIF;
import com.iplanet.am.sdk.remote.IdRepoEventListener;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.server.SendNotificationException;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SortKey;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirectoryManagerImpl
implements DirectoryManagerIF,
AMObjectListener {
    protected static AMDirectoryManager dMgr = AMDirectoryWrapper.getInstance();
    protected static DCTree dcTree = new DCTree();
    protected static Compliance compl = new Compliance();
    protected static Debug debug = Debug.getInstance((String)"amProfile_Server");
    protected static SSOTokenManager tm;
    protected static boolean initialized;
    static int cacheSize;
    static LinkedList cacheIndices;
    static LinkedList idrepoCacheIndices;
    static HashMap cache;
    static HashMap idrepoCache;
    static HashMap notificationURLs;
    static String serverURL;

    public DirectoryManagerImpl() {
        if (initialized) {
            return;
        }
        serverURL = SystemProperties.get((String)"com.iplanet.am.server.protocol") + "://" + SystemProperties.get((String)"com.iplanet.am.server.host") + ":" + SystemProperties.get((String)"com.iplanet.am.server.port");
        try {
            tm = SSOTokenManager.getInstance();
            dMgr.addListener((SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()), this);
            IdRepoListener.addRemoteListener(new IdRepoEventListener());
            initialized = true;
            if (debug.messageEnabled()) {
                debug.message("DirectoryManagerImpl::init success: " + serverURL);
            }
        }
        catch (Exception exception) {
            debug.error("DirectoryManagerImpl::init ERROR", (Throwable)exception);
        }
    }

    public String createAMTemplate(String string, String string2, int n, String string3, Map map, int n2) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.createAMTemplate(sSOToken, string2, n, string3, map, n2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void createEntry(String string, String string2, int n, String string3, Map map) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.createEntry(sSOToken, string2, n, string3, map);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public boolean doesEntryExists(String string, String string2) throws AMRemoteException, SSOException, RemoteException {
        SSOToken sSOToken = tm.createSSOToken(string);
        return dMgr.doesEntryExists(sSOToken, string2);
    }

    public String getAMTemplateDN(String string, String string2, int n, String string3, int n2) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getAMTemplateDN(sSOToken, string2, n, string3, n2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Map getAttributes3(String string, String string2, boolean bl, boolean bl2, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getAttributes(sSOToken, string2, bl, bl2, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Map getAttributes1(String string, String string2, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getAttributes(sSOToken, string2, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Map getAttributes2(String string, String string2, Set set, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getAttributes(sSOToken, string2, set, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Map getAttributesByteValues1(String string, String string2, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getAttributesByteValues(sSOToken, string2, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Map getAttributesByteValues2(String string, String string2, Set set, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getAttributesByteValues(sSOToken, string2, set, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Set getAttributesForSchema(String string) throws RemoteException {
        return dMgr.getAttributesForSchema(string);
    }

    public String getCreationTemplateName(int n) throws RemoteException {
        com.iplanet.am.sdk.ldap.DirectoryManager directoryManager = com.iplanet.am.sdk.ldap.DirectoryManager.getInstance();
        return directoryManager.getCreationTemplateName(n);
    }

    public Map getDCTreeAttributes(String string, String string2, Set set, boolean bl, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getDCTreeAttributes(sSOToken, string2, set, bl, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public String getDeletedObjectFilter(int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            return compl.getDeletedObjectFilter(n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Map getExternalAttributes(String string, String string2, Set set, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getExternalAttributes(sSOToken, string2, set, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public LinkedList getGroupFilterAndScope(String string, String string2, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            String[] stringArray = dMgr.getGroupFilterAndScope(sSOToken, string2, n);
            LinkedList<String> linkedList = new LinkedList<String>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                linkedList.add(stringArray[n2]);
                ++n2;
            }
            return linkedList;
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Set getMembers(String string, String string2, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getMembers(sSOToken, string2, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public String getNamingAttr(int n, String string) throws RemoteException {
        com.iplanet.am.sdk.ldap.DirectoryManager directoryManager = com.iplanet.am.sdk.ldap.DirectoryManager.getInstance();
        return directoryManager.getNamingAttr(n, string);
    }

    public String getObjectClassFromDS(int n) throws RemoteException {
        com.iplanet.am.sdk.ldap.DirectoryManager directoryManager = com.iplanet.am.sdk.ldap.DirectoryManager.getInstance();
        return directoryManager.getObjectClassFromDS(n);
    }

    public int getObjectType(String string, String string2) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getObjectType(sSOToken, string2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public String getOrganizationDN(String string, String string2) throws AMRemoteException, RemoteException, SSOException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getOrganizationDN(sSOToken, string2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public String verifyAndGetOrgDN(String string, String string2, String string3) throws AMRemoteException, RemoteException, SSOException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.verifyAndGetOrgDN(sSOToken, string2, string3);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public String getOrgDNFromDomain(String string, String string2) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dcTree.getOrganizationDN(sSOToken, string2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public String getOrgSearchFilter(String string) throws RemoteException {
        return dMgr.getOrgSearchFilter(string);
    }

    public Set getRegisteredServiceNames(String string, String string2) throws AMRemoteException, SSOException, RemoteException {
        try {
            return dMgr.getRegisteredServiceNames(null, string2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public String getSearchFilterFromTemplate(int n, String string, String string2) throws RemoteException {
        com.iplanet.am.sdk.ldap.DirectoryManager directoryManager = com.iplanet.am.sdk.ldap.DirectoryManager.getInstance();
        return directoryManager.getSearchFilterFromTemplate(n, string, string2);
    }

    public Set getTopLevelContainers(String string) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getTopLevelContainers(sSOToken);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public boolean isAncestorOrgDeleted(String string, String string2, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return compl.isAncestorOrgDeleted(sSOToken, string2, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void modifyMemberShip(String string, Set set, String string2, int n, int n2) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.modifyMemberShip(sSOToken, set, string2, n, n2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void registerService(String string, String string2, String string3) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.registerService(sSOToken, string2, string3);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void removeAdminRole(String string, String string2, boolean bl) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.removeAdminRole(sSOToken, string2, bl);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void removeEntry(String string, String string2, int n, boolean bl, boolean bl2) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.removeEntry(sSOToken, string2, n, bl, bl2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public String renameEntry(String string, int n, String string2, String string3, boolean bl) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.renameEntry(sSOToken, n, string2, string3, bl);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Set search1(String string, String string2, String string3, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.search(sSOToken, string2, string3, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Map search2(String string, String string2, String string3, List list, int n, int n2, int n3, String string4, int n4, int n5, int n6, boolean bl, String[] stringArray) throws AMRemoteException, SSOException, RemoteException {
        Object object;
        SortKey[] sortKeyArray = null;
        int n7 = 0;
        if (list != null && (n7 = list.size()) != 0) {
            sortKeyArray = new SortKey[n7];
            int n8 = 0;
            while (n8 < n7) {
                object = (String)list.get(n8);
                sortKeyArray[n8] = new SortKey();
                sortKeyArray[n8].reverse = ((String)object).startsWith("true:");
                sortKeyArray[n8].attributeName = ((String)object).substring(5);
                ++n8;
            }
        }
        SearchControl searchControl = new SearchControl();
        if (sortKeyArray != null) {
            searchControl.setSortKeys(sortKeyArray);
        }
        if (string4 == null) {
            searchControl.setVLVRange(n, n2, n3);
        } else {
            searchControl.setVLVRange(string4, n2, n3);
        }
        searchControl.setTimeOut(n4);
        searchControl.setMaxResults(n5);
        searchControl.setSearchScope(n6);
        searchControl.setAllReturnAttributes(bl);
        try {
            object = dMgr.search(tm.createSSOToken(string), string2, string3, searchControl, stringArray);
            HashMap<String, String> hashMap = ((AMSearchResults)object).getResultAttributes();
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            hashMap.put("__count", Integer.toString(((AMSearchResults)object).getTotalResultCount()));
            hashMap.put("__results", (String)((Object)((AMSearchResults)object).getSearchResults()));
            hashMap.put("__errorCode", Integer.toString(((AMSearchResults)object).getErrorCode()));
            return hashMap;
        }
        catch (AMException aMException) {
            debug.error("DMI::search(with SearchControl):  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void setAttributes(String string, String string2, int n, Map map, Map map2, boolean bl) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.setAttributes(sSOToken, string2, n, map, map2, bl);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void setGroupFilter(String string, String string2, String string3) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.setGroupFilter(sSOToken, string2, string3);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void unRegisterService(String string, String string2, int n, String string3, int n2) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.unRegisterService(sSOToken, string2, n, string3, null, n2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void updateUserAttribute(String string, Set set, String string2, boolean bl) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            dMgr.updateUserAttribute(sSOToken, set, string2, bl);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public void verifyAndDeleteObject(String string, String string2) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            compl.verifyAndDeleteObject(sSOToken, string2);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    private AMRemoteException convertException(AMException aMException) {
        boolean bl = false;
        Object var3_3 = null;
        String string = null;
        string = aMException.getLDAPErrorCode();
        if (string == null) {
            return new AMRemoteException(aMException.getMessage(), aMException.getErrorCode(), 0, (String[])aMException.getMessageArgs());
        }
        return new AMRemoteException(aMException.getMessage(), aMException.getErrorCode(), Integer.parseInt(string), (String[])aMException.getMessageArgs());
    }

    public Map getAttributes4(String string, String string2, Set set, boolean bl, boolean bl2, int n) throws AMRemoteException, SSOException, RemoteException {
        try {
            SSOToken sSOToken = tm.createSSOToken(string);
            return dMgr.getAttributes(sSOToken, string2, set, bl, bl2, n);
        }
        catch (AMException aMException) {
            debug.error("Caught Exception:  " + aMException);
            throw this.convertException(aMException);
        }
    }

    public Set objectsChanged(int n) throws RemoteException {
        HashSet hashSet = new HashSet();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, 1);
        int n2 = 0;
        while (n2 < n + 3) {
            calendar.add(12, -1);
            String string = DirectoryManagerImpl.calendarToString(calendar);
            Set set = (Set)cache.get(string);
            if (set != null) {
                hashSet.addAll(set);
            }
            ++n2;
        }
        if (debug.messageEnabled()) {
            debug.message("DirectoryManagerImpl:objectsChanged in time: " + n + " minutes:\n" + hashSet);
        }
        return hashSet;
    }

    public String registerNotificationURL(String string) throws RemoteException {
        String string2;
        block5: {
            string2 = SMSUtils.getUniqueID();
            try {
                if (!string.startsWith(serverURL)) {
                    notificationURLs.put(string2, new URL(string));
                    if (debug.messageEnabled()) {
                        debug.message("DirectoryManagerImpl:register for notification URL: " + string);
                    }
                    break block5;
                }
                if (debug.warningEnabled()) {
                    debug.warning("DirectoryManagerImpl:registerURL cannot add local server: " + string);
                }
                throw new RemoteException("invalid-notification-URL");
            }
            catch (MalformedURLException malformedURLException) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("DirectoryManagerImpl:registerNotificationURL  invalid URL: " + string, (Throwable)malformedURLException);
            }
        }
        return string2;
    }

    public void deRegisterNotificationURL(String string) throws RemoteException {
        notificationURLs.remove(string);
    }

    public void assignService_idrepo(String string, String string2, String string3, String string4, String string5, Map map, String string6, String string7) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        SchemaType schemaType = new SchemaType(string5);
        dMgr.assignService(sSOToken, idType, string3, string4, schemaType, map, string6, string7);
    }

    public String create_idrepo(String string, String string2, String string3, Map map, String string4) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        return IdUtils.getUniversalId(dMgr.create(sSOToken, idType, string3, map, string4));
    }

    public void delete_idrepo(String string, String string2, String string3, String string4, String string5) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        dMgr.delete(sSOToken, idType, string3, string4, string5);
    }

    public Set getAssignedServices_idrepo(String string, String string2, String string3, Map map, String string4, String string5) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        return dMgr.getAssignedServices(sSOToken, idType, string3, map, string4, string5);
    }

    public Map getAttributes1_idrepo(String string, String string2, String string3, Set set, String string4, String string5) throws RemoteException, IdRepoException, SSOException {
        IdType idType;
        SSOToken sSOToken = tm.createSSOToken(string);
        HashMap hashMap = dMgr.getAttributes(sSOToken, idType = IdUtils.getType(string2), string3, set, string4, string5, true);
        if (hashMap != null && hashMap instanceof CaseInsensitiveHashMap) {
            HashMap hashMap2 = new HashMap();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                hashMap2.put(k, hashMap.get(k));
            }
            hashMap = hashMap2;
        }
        return hashMap;
    }

    public Map getAttributes2_idrepo(String string, String string2, String string3, String string4, String string5) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        HashMap hashMap = dMgr.getAttributes(sSOToken, idType, string3, string4, string5);
        DirectoryManager.debug.error("Obtained map from server: " + hashMap.getClass().getName());
        if (hashMap != null && hashMap instanceof CaseInsensitiveHashMap) {
            HashMap hashMap2 = new HashMap();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                hashMap2.put(k, hashMap.get(k));
            }
            hashMap = hashMap2;
        }
        return hashMap;
    }

    public Set getMembers_idrepo(String string, String string2, String string3, String string4, String string5, String string6) throws RemoteException, IdRepoException, SSOException {
        IdType idType;
        IdType idType2;
        HashSet<String> hashSet = new HashSet<String>();
        SSOToken sSOToken = tm.createSSOToken(string);
        Set set = dMgr.getMembers(sSOToken, idType2 = IdUtils.getType(string2), string3, string4, idType = IdUtils.getType(string5), string6);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMIdentity aMIdentity = (AMIdentity)iterator.next();
                hashSet.add(IdUtils.getUniversalId(aMIdentity));
            }
        }
        return hashSet;
    }

    public Set getMemberships_idrepo(String string, String string2, String string3, String string4, String string5, String string6) throws RemoteException, IdRepoException, SSOException {
        IdType idType;
        IdType idType2;
        HashSet<String> hashSet = new HashSet<String>();
        SSOToken sSOToken = tm.createSSOToken(string);
        Set set = dMgr.getMemberships(sSOToken, idType2 = IdUtils.getType(string2), string3, idType = IdUtils.getType(string4), string5, string6);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMIdentity aMIdentity = (AMIdentity)iterator.next();
                hashSet.add(IdUtils.getUniversalId(aMIdentity));
            }
        }
        return hashSet;
    }

    public Map getServiceAttributes_idrepo(String string, String string2, String string3, String string4, Set set, String string5, String string6) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        return dMgr.getServiceAttributes(sSOToken, idType, string3, string4, set, string5, string6);
    }

    public Set getSupportedOperations_idrepo(String string, String string2, String string3) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        Set set = dMgr.getSupportedOperations(sSOToken, idType, string3);
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IdOperation idOperation = (IdOperation)iterator.next();
                String string4 = idOperation.getName();
                hashSet.add(string4);
            }
        }
        return hashSet;
    }

    public Set getSupportedTypes_idrepo(String string, String string2) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        Set set = dMgr.getSupportedTypes(sSOToken, string2);
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IdType idType = (IdType)iterator.next();
                String string3 = idType.getName();
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    public boolean isExists_idrepo(String string, String string2, String string3, String string4) throws RemoteException, SSOException, IdRepoException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        return dMgr.isExists(sSOToken, idType, string3, string4);
    }

    public boolean isActive_idrepo(String string, String string2, String string3, String string4, String string5) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        return dMgr.isActive(sSOToken, idType, string3, string4, string5);
    }

    public void modifyMemberShip_idrepo(String string, String string2, String string3, Set set, String string4, int n, String string5) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        IdType idType2 = IdUtils.getType(string4);
        dMgr.modifyMemberShip(sSOToken, idType, string3, set, idType2, n, string5);
    }

    public void modifyService_idrepo(String string, String string2, String string3, String string4, String string5, Map map, String string6, String string7) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        SchemaType schemaType = new SchemaType(string5);
        dMgr.modifyService(sSOToken, idType, string3, string4, schemaType, map, string6, string7);
    }

    public void removeAttributes_idrepo(String string, String string2, String string3, Set set, String string4, String string5) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        dMgr.removeAttributes(sSOToken, idType, string3, set, string4, string5);
    }

    public Map search1_idrepo(String string, String string2, String string3, Map map, boolean bl, int n, int n2, Set set, String string4) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        IdSearchResults idSearchResults = dMgr.search(sSOToken, idType, string3, map, bl, n, n2, set, string4);
        return this.IdSearchResultsToMap(idSearchResults);
    }

    public Map search2_idrepo(String string, String string2, String string3, int n, int n2, Set set, boolean bl, int n3, Map map, boolean bl2, String string4) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        IdSearchControl idSearchControl = new IdSearchControl();
        idSearchControl.setAllReturnAttributes(bl);
        idSearchControl.setMaxResults(n2);
        idSearchControl.setRecursive(bl2);
        idSearchControl.setReturnAttributes(set);
        idSearchControl.setTimeOut(n);
        IdSearchOpModifier idSearchOpModifier = n3 == 0 ? IdSearchOpModifier.OR : IdSearchOpModifier.AND;
        idSearchControl.setSearchModifiers(idSearchOpModifier, map);
        IdSearchResults idSearchResults = dMgr.search(sSOToken, idType, string3, idSearchControl, string4);
        return this.IdSearchResultsToMap(idSearchResults);
    }

    public void setAttributes_idrepo(String string, String string2, String string3, Map map, boolean bl, String string4, String string5) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        dMgr.setAttributes(sSOToken, idType, string3, map, bl, string4, string5, true);
    }

    public void unassignService_idrepo(String string, String string2, String string3, String string4, Map map, String string5, String string6) throws RemoteException, IdRepoException, SSOException {
        SSOToken sSOToken = tm.createSSOToken(string);
        IdType idType = IdUtils.getType(string2);
        dMgr.unassignService(sSOToken, idType, string3, string4, map, string5, string6);
    }

    public void objectChanged(String string, int n, Map map) {
        DirectoryManagerImpl.processEntryChanged("objectChanged", string, n, null, true);
    }

    public void objectsChanged(String string, int n, Set set, Map map) {
        DirectoryManagerImpl.processEntryChanged("objectsChanged", string, n, set, true);
    }

    public void permissionsChanged(String string, Map map) {
        DirectoryManagerImpl.processEntryChanged("permissionsChanged", string, 0, null, true);
    }

    public void allObjectsChanged() {
        DirectoryManagerImpl.processEntryChanged("allObjectsChanged", "", 0, null, true);
    }

    public void deRegisterNotificationURL_idrepo(String string) throws RemoteException {
        notificationURLs.remove(string);
    }

    public Set objectsChanged_idrepo(int n) throws RemoteException {
        HashSet hashSet = new HashSet();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, 1);
        int n2 = 0;
        while (n2 < n + 3) {
            calendar.add(12, -1);
            String string = DirectoryManagerImpl.calendarToString(calendar);
            Set set = (Set)idrepoCache.get(string);
            if (set != null) {
                hashSet.addAll(set);
            }
            ++n2;
        }
        if (debug.messageEnabled()) {
            debug.message("DirectoryManagerImpl:objectsChanged in time: " + n + " minutes:\n" + hashSet);
        }
        return hashSet;
    }

    public String registerNotificationURL_idrepo(String string) throws RemoteException {
        String string2;
        block5: {
            string2 = SMSUtils.getUniqueID();
            try {
                if (!string.startsWith(serverURL)) {
                    notificationURLs.put(string2, new URL(string));
                    if (debug.messageEnabled()) {
                        debug.message("DirectoryManagerImpl:register for notification URL: " + string);
                    }
                    break block5;
                }
                if (debug.warningEnabled()) {
                    debug.warning("DirectoryManagerImpl:registerURL cannot add local server: " + string);
                }
                throw new RemoteException("invalid-notification-URL");
            }
            catch (MalformedURLException malformedURLException) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("DirectoryManagerImpl:registerNotificationURL  invalid URL: " + string, (Throwable)malformedURLException);
            }
        }
        return string2;
    }

    protected static synchronized void processEntryChanged(String string, String string2, int n, Set set, boolean bl) {
        String string3;
        Object object;
        HashMap hashMap = bl ? cache : idrepoCache;
        LinkedList linkedList = bl ? cacheIndices : idrepoCacheIndices;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        String string4 = DirectoryManagerImpl.calendarToString(calendar);
        HashSet<String> hashSet = (HashSet<String>)hashMap.get(string4);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            hashMap.put(string4, hashSet);
            cacheIndices.addFirst(string4);
            if (linkedList.size() > cacheSize) {
                linkedList.removeLast();
            }
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<EventNotification><AttributeValuePair>").append("<Attribute name=\"method\" /><Value>").append(string).append("</Value></AttributeValuePair>").append("<AttributeValuePair><Attribute name=\"entityName\" />").append("<Value>").append(string2).append("</Value></AttributeValuePair>");
        if (string.equalsIgnoreCase("objectChanged") || string.equalsIgnoreCase("objectsChanged")) {
            stringBuffer.append("<AttributeValuePair><Attribute name=\"eventType\" />").append("<Value>").append(n).append("</Value></AttributeValuePair>");
            if (string.equalsIgnoreCase("objectsChanged")) {
                stringBuffer.append("<AttributeValuePair><Attribute ").append("name=\"attrNames\"/>");
                object = set.iterator();
                while (object.hasNext()) {
                    string3 = (String)object.next();
                    stringBuffer.append("<Value>").append(string3).append("</Value>");
                }
                stringBuffer.append("</AttributeValuePair>");
            }
        }
        stringBuffer.append("</EventNotification>");
        hashSet.add(stringBuffer.toString());
        if (debug.messageEnabled()) {
            debug.message("DirectoryManagerImpl::processing entry change: " + stringBuffer.toString());
        }
        object = new HashMap(notificationURLs);
        string3 = null;
        Iterator iterator = notificationURLs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string5 = (String)entry.getKey();
            URL uRL = (URL)entry.getValue();
            if (string3 == null) {
                Notification notification = new Notification(stringBuffer.toString());
                string3 = bl ? new NotificationSet(DirectoryManager.SDK_SERVICE) : new NotificationSet(DirectoryManager.IDREPO_SERVICE);
                string3.addNotification(notification);
            }
            try {
                PLLServer.send(uRL, (NotificationSet)string3);
                if (!debug.messageEnabled()) continue;
                debug.message("DirectorManagerImpl:sentNotification URL: " + uRL + " Data: " + string3);
            }
            catch (SendNotificationException sendNotificationException) {
                if (debug.warningEnabled()) {
                    debug.warning("DirectoryManagerImpl: failed sending notification to: " + uRL + "\nRemoving " + "URL from notification list.", (Throwable)sendNotificationException);
                }
                notificationURLs.remove(string5);
            }
        }
    }

    private static String calendarToString(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(10);
        int n5 = calendar.get(12);
        calendar.clear();
        calendar.set(n, n2, n3, n4, n5);
        return serverURL + calendar.toString();
    }

    private Map IdSearchResultsToMap(IdSearchResults idSearchResults) {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        Map map = idSearchResults.getResultAttributes();
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        HashMap<String, Map> hashMap2 = new HashMap<String, Map>();
        Set set = idSearchResults.getSearchResults();
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMIdentity aMIdentity = (AMIdentity)iterator.next();
                String string = IdUtils.getUniversalId(aMIdentity);
                hashSet.add(string);
                Map map2 = (Map)map.get(aMIdentity);
                if (map2 == null) continue;
                hashMap2.put(string, map2);
            }
        }
        hashMap.put("__results", hashSet);
        hashMap.put("__errorCode", new Integer(idSearchResults.getErrorCode()));
        hashMap.put("__attrs", hashMap2);
        return hashMap;
    }

    public Map getConfigMap() {
        return null;
    }

    public void setConfigMap(Map map) {
    }

    static {
        cacheSize = 30;
        cacheIndices = new LinkedList();
        idrepoCacheIndices = new LinkedList();
        cache = new HashMap(cacheSize);
        idrepoCache = new HashMap(cacheSize);
        notificationURLs = new HashMap();
    }
}

