/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.remote;

import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.DirectoryManagerInterface;
import com.iplanet.am.sdk.remote.AMRemoteException;
import com.iplanet.am.sdk.remote.EventListener;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SortKey;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.jaxrpc.SOAPClient;
import com.sun.identity.sm.SchemaType;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DirectoryManager
implements DirectoryManagerInterface {
    private static String AM_SDK_DEBUG_FILE = "amProfile_Client";
    protected static String SDK_SERVICE = "DirectoryManagerIF";
    protected static String IDREPO_SERVICE = "IdRepoServiceIF";
    protected static Debug debug = Debug.getInstance((String)AM_SDK_DEBUG_FILE);
    private Properties props = new Properties();
    protected SOAPClient client;
    protected EventListener eventListener;
    protected static DirectoryManager instance;
    protected static final String AMSR_COUNT = "__count";
    protected static final String AMSR_RESULTS = "__results";
    protected static final String AMSR_CODE = "__errorCode";
    protected static final String AMSR_ATTRS = "__attrs";

    public DirectoryManager() {
        if (this.client == null) {
            this.client = new SOAPClient(SDK_SERVICE);
        }
    }

    public static synchronized DirectoryManager getInstance() {
        if (instance == null) {
            debug.message("DirectoryManager.getInstance(): Creating a new Instance of DirectoryManager()");
            instance = new DirectoryManager();
        }
        return instance;
    }

    public boolean doesEntryExists(SSOToken sSOToken, String string) {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string};
            Boolean bl = (Boolean)this.client.send(this.client.encodeMessage("doesEntryExists", objectArray), null);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getObjectType(SSOToken sSOToken, String string) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string};
            Integer n = (Integer)this.client.send(this.client.encodeMessage("getObjectType", objectArray), null);
            return n;
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getObjectType: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getObjectType: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getObjectType: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getObjectType: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public int getObjectType(SSOToken sSOToken, String string, Map map) throws AMException, SSOException {
        return this.getObjectType(sSOToken, string);
    }

    public Map getDCTreeAttributes(SSOToken sSOToken, String string, Set set, boolean bl, int n) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, set, new Boolean(bl), new Integer(n)};
            return (Map)this.client.send(this.client.encodeMessage("getDCTreeAttributes", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getDCTreeAttributes: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getDCTreeAttributes: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getDCTreeAttributes: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getDCTreeAttributes: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n)};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes1", objectArray), null);
            AMHashMap aMHashMap = new AMHashMap();
            aMHashMap.copy(map);
            return aMHashMap;
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getAttributes: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, set, new Integer(n)};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes2", objectArray), null);
            AMHashMap aMHashMap = new AMHashMap();
            aMHashMap.copy(map);
            return aMHashMap;
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getAttributes: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n)};
            return (Map)this.client.send(this.client.encodeMessage("getAttributesByteValues1", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getAttributesByteValues: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributesByteValues: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getAttributesByteValues: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributesByteValues: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, set, new Integer(n)};
            return (Map)this.client.send(this.client.encodeMessage("getAttributesByteValues2", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getAttributesByteValues: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributesByteValues: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getAttributesByteValues: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributesByteValues: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken sSOToken, String string, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Boolean(bl), new Boolean(bl2), new Integer(n)};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes3", objectArray), null);
            AMHashMap aMHashMap = new AMHashMap();
            aMHashMap.copy(map);
            return aMHashMap;
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getAttributes: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, set, new Boolean(bl), new Boolean(bl2), new Integer(n)};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes4", objectArray), null);
            AMHashMap aMHashMap = new AMHashMap();
            aMHashMap.copy(map);
            return aMHashMap;
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getAttributes: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributes: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String getOrgSearchFilter(String string) {
        try {
            Object[] objectArray = new Object[]{string};
            return (String)this.client.send(this.client.encodeMessage("getOrgSearchFilter", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getOrgSearchFilter: caught exception=", (Throwable)aMRemoteException);
            return "";
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getOrgSearchFilter: caught exception=", (Throwable)remoteException);
            return "";
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getOrgSearchFilter: caught exception=", (Throwable)exception);
            return "";
        }
    }

    public String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string};
            return (String)this.client.send(this.client.encodeMessage("getOrganizationDN", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getOrganizationDN: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getOrganizationDN: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getOrganizationDN: caught SSOException=", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getOrganizationDN: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String verifyAndGetOrgDN(SSOToken sSOToken, String string, String string2) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, string2};
            return (String)this.client.send(this.client.encodeMessage("verifyAndGetOrgDN", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.verifyAndGetOrgDN: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.verifyAndGetOrgDN: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.verifyAndGetOrgDN: caught SSOException=", (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.verifyAndGetOrgDN: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getExternalAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, set, new Integer(n)};
            return (Map)this.client.send(this.client.encodeMessage("getExternalAttributes", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getExternalAttributes: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getExternalAttributes: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getExternalAttributes: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void updateUserAttribute(SSOToken sSOToken, Set set, String string, boolean bl) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), set, string, new Boolean(bl)};
            this.client.send(this.client.encodeMessage("updateUserAttribute", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.updateUserAttribute: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.updateUserAttribute: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.updateUserAttribute: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void createEntry(SSOToken sSOToken, String string, int n, String string2, Map map) throws AMEntryExistsException, AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n), string2, map};
            this.client.send(this.client.encodeMessage("createEntry", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.createEntry: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.createEntry: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.createEntry: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void removeEntry(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n), new Boolean(bl), new Boolean(bl2)};
            this.client.send(this.client.encodeMessage("removeEntry", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.removeEntry: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.removeEntry: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.removeEntry: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.removeEntry: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void removeAdminRole(SSOToken sSOToken, String string, boolean bl) throws SSOException, AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Boolean(bl)};
            this.client.send(this.client.encodeMessage("removeAdminRole", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.removeAdminRole: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.removeAdminRole: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.removeAdminRole: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.removeAdminRole: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set search(SSOToken sSOToken, String string, String string2, int n) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, string2, new Integer(n)};
            return (Set)this.client.send(this.client.encodeMessage("search1", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.search: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.search: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.search: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public AMSearchResults search(SSOToken sSOToken, String string, String string2, SearchControl searchControl, String[] stringArray) throws AMException {
        try {
            SortKey[] sortKeyArray = searchControl.getSortKeys();
            LinkedList<String> linkedList = new LinkedList<String>();
            int n = 0;
            while (sortKeyArray != null && n < sortKeyArray.length) {
                if (sortKeyArray[n].reverse) {
                    linkedList.add("true:" + sortKeyArray[n].attributeName);
                } else {
                    linkedList.add("fals:" + sortKeyArray[n].attributeName);
                }
                ++n;
            }
            int[] nArray = searchControl.getVLVRange();
            if (nArray == null) {
                nArray = new int[3];
            }
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, string2, linkedList, new Integer(nArray[0]), new Integer(nArray[1]), new Integer(nArray[2]), searchControl.getVLVJumpTo(), new Integer(searchControl.getTimeOut()), new Integer(searchControl.getMaxResults()), new Integer(searchControl.getSearchScope()), new Boolean(searchControl.isGetAllReturnAttributesEnabled()), stringArray};
            Map map = (Map)this.client.send("search2", objectArray, (String)null);
            String string3 = (String)map.remove(AMSR_COUNT);
            Set set = (Set)map.remove(AMSR_RESULTS);
            String string4 = (String)map.remove(AMSR_CODE);
            int n2 = 0;
            int n3 = 0;
            try {
                n2 = Integer.parseInt(string3);
                n3 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                debug.error("DirectoryManager.search: caught number format error", (Throwable)numberFormatException);
            }
            return new AMSearchResults(n2, set, n3, map);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.search: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.search: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.search: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getMembers(SSOToken sSOToken, String string, int n) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n)};
            return (Set)this.client.send(this.client.encodeMessage("getMembers", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getMembers: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getMembers: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getMembers: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String renameEntry(SSOToken sSOToken, int n, String string, String string2, boolean bl) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), new Integer(n), string, string2, new Boolean(bl)};
            return (String)this.client.send(this.client.encodeMessage("renameEntry", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.renameEntry: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.renameEntry: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.renameEntry: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void setAttributes(SSOToken sSOToken, String string, int n, Map map, Map map2, boolean bl) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n), map, map2, new Boolean(bl)};
            this.client.send(this.client.encodeMessage("setAttributes", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.setAttributes: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.setAttributes: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.setAttributes: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.setAttributes: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String[] getGroupFilterAndScope(SSOToken sSOToken, String string, int n) throws SSOException, AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n)};
            LinkedList linkedList = (LinkedList)this.client.send(this.client.encodeMessage("getGroupFilterAndScope", objectArray), null);
            String[] stringArray = new String[linkedList.size()];
            linkedList.toArray(stringArray);
            return stringArray;
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getGroupFilterAndScope: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getGroupFilterAndScope: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getGroupFilterAndScope: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getGroupFilterAndScope: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void setGroupFilter(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, string2};
            this.client.send(this.client.encodeMessage("setGroupFilter", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.setGroupFilter: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.setGroupFilter: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.setGroupFilter: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.setGroupFilter: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void modifyMemberShip(SSOToken sSOToken, Set set, String string, int n, int n2) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), set, string, new Integer(n), new Integer(n2)};
            this.client.send(this.client.encodeMessage("modifyMemberShip", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.modifyMemberShip: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.modifyMemberShip: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.modifyMemberShip: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getRegisteredServiceNames(SSOToken sSOToken, String string) throws AMException {
        try {
            Object[] objectArray = new Object[]{null, string};
            return (Set)this.client.send(this.client.encodeMessage("getRegisteredServiceNames", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getRegisteredServiceNames: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getRegisteredServiceNames: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getRegisteredServiceNames: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void registerService(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, string2};
            this.client.send(this.client.encodeMessage("registerService", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.registerService: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.registerService: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.registerService: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.registerService: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void unRegisterService(SSOToken sSOToken, String string, int n, String string2, AMTemplate aMTemplate, int n2) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n), string2, new Integer(n2)};
            this.client.send(this.client.encodeMessage("unRegisterService", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.unRegisterService: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.unRegisterService: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.unRegisterService: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String getAMTemplateDN(SSOToken sSOToken, String string, int n, String string2, int n2) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n), string2, new Integer(n2)};
            return (String)this.client.send(this.client.encodeMessage("getAMTemplateDN", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getAMTemplateDN: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAMTemplateDN: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAMTemplateDN: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String createAMTemplate(SSOToken sSOToken, String string, int n, String string2, Map map, int n2) throws AMException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string, new Integer(n), string2, map, new Integer(n2)};
            return (String)this.client.send(this.client.encodeMessage("createAMTemplate", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.createAMTemplate: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.createAMTemplate: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.createAMTemplate: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public String getNamingAttr(int n, String string) {
        try {
            Object[] objectArray = new Object[]{new Integer(n), string};
            return (String)this.client.send(this.client.encodeMessage("getNamingAttr", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getNamingAttr: caught exception=", (Throwable)remoteException);
            return null;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getNamingAttr: caught exception=", (Throwable)exception);
            return null;
        }
    }

    public String getCreationTemplateName(int n) {
        try {
            Object[] objectArray = new Object[]{new Integer(n)};
            return (String)this.client.send(this.client.encodeMessage("getCreationTemplateName", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getCreationTemplateName: caught exception=", (Throwable)remoteException);
            return null;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getCreationTemplateName: caught exception=", (Throwable)exception);
            return null;
        }
    }

    public String getObjectClassFromDS(int n) {
        try {
            Object[] objectArray = new Object[]{new Integer(n)};
            return (String)this.client.send(this.client.encodeMessage("getObjectClassFromDS", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getObjectClassFromDS: caught exception=", (Throwable)remoteException);
            return null;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getObjectClassFromDS: caught exception=", (Throwable)exception);
            return null;
        }
    }

    public Set getAttributesForSchema(String string) {
        try {
            Object[] objectArray = new Object[]{string};
            return (Set)this.client.send(this.client.encodeMessage("getAttributesForSchema", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributesForSchema: caught exception=", (Throwable)remoteException);
            return Collections.EMPTY_SET;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributesForSchema: caught exception=", (Throwable)exception);
            return Collections.EMPTY_SET;
        }
    }

    public String getSearchFilterFromTemplate(int n, String string, String string2) {
        try {
            Object[] objectArray = new Object[]{new Integer(n), string};
            return (String)this.client.send(this.client.encodeMessage("getSearchFilterFromTemplate", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getSearchFilterFromTemplate: caught exception=", (Throwable)remoteException);
            return null;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getSearchFilterFromTemplate: caught exception=", (Throwable)exception);
            return null;
        }
    }

    public Set getTopLevelContainers(SSOToken sSOToken) throws AMException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString()};
            return (Set)this.client.send(this.client.encodeMessage("getTopLevelContainers", objectArray), null);
        }
        catch (AMRemoteException aMRemoteException) {
            debug.error("DirectoryManager.getTopLevelContainers: caught exception=", (Throwable)aMRemoteException);
            throw DirectoryManager.convertException(aMRemoteException);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getTopLevelContainers: caught exception=", (Throwable)remoteException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (SSOException sSOException) {
            debug.error("DirectoryManager.getTopLevelContainers: caught SSOException=", (Throwable)sSOException);
            throw sSOException;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getTopLevelContainers: caught exception=", (Throwable)exception);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    protected static AMException convertException(AMRemoteException aMRemoteException) {
        return new AMException(aMRemoteException.getMessage(), aMRemoteException.getErrorCode(), aMRemoteException.getMessageArgs());
    }

    public void addListener(SSOToken sSOToken, AMObjectListener aMObjectListener, Map map) throws AMEventManagerException {
        if (this.eventListener == null) {
            this.eventListener = new EventListener();
        }
        this.eventListener.addListener(sSOToken, aMObjectListener);
    }

    public AMIdentity create(SSOToken sSOToken, IdType idType, String string, Map map, String string2) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, map, string2};
            String string3 = (String)this.client.send(this.client.encodeMessage("create_idrepo", objectArray), null);
            return IdUtils.getIdentity(sSOToken, string3);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.create_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.create_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void delete(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, string2, string3};
            this.client.send(this.client.encodeMessage("delete_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.create_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.create_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, set, string2, string3};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes1_idrepo", objectArray), null);
            if (map != null) {
                AMHashMap aMHashMap = new AMHashMap();
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    aMHashMap.put(k, map.get(k));
                }
                map = aMHashMap;
            }
            return map;
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributes1_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributes1_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, string2, string3};
            Map map = (Map)this.client.send(this.client.encodeMessage("getAttributes2_idrepo", objectArray), null);
            if (map != null) {
                AMHashMap aMHashMap = new AMHashMap();
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    aMHashMap.put(k, map.get(k));
                }
                map = aMHashMap;
            }
            return map;
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAttributes2_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAttributes2_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void removeAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, set, string2, string3};
            this.client.send(this.client.encodeMessage("removeAttributes_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.removeAttributes_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.removeAttributes_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public IdSearchResults search(SSOToken sSOToken, IdType idType, String string, IdSearchControl idSearchControl, String string2) throws IdRepoException, SSOException {
        IdSearchOpModifier idSearchOpModifier = idSearchControl.getSearchModifier();
        Map map = idSearchControl.getSearchModifierMap();
        int n = idSearchOpModifier.equals(IdSearchOpModifier.AND) ? 1 : 0;
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, new Integer(idSearchControl.getTimeOut()), new Integer(idSearchControl.getMaxResults()), idSearchControl.getReturnAttributes(), new Boolean(idSearchControl.isGetAllReturnAttributesEnabled()), new Integer(n), map, new Boolean(idSearchControl.isRecursive()), string2};
            Map map2 = (Map)this.client.send(this.client.encodeMessage("search2_idrepo", objectArray), null);
            return this.mapToIdSearchResults(sSOToken, idType, string2, map2);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.search2_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.search2_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public IdSearchResults search(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, int n, int n2, Set set, String string2) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, map, new Boolean(bl), new Integer(n), new Integer(n2), set, string2};
            Map map2 = (Map)this.client.send(this.client.encodeMessage("search1_idrepo", objectArray), null);
            return this.mapToIdSearchResults(sSOToken, idType, string2, map2);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.search1_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.search1_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, String string2, String string3) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, map, new Boolean(bl), string2, string3};
            this.client.send(this.client.encodeMessage("setAttributes_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.setAttributes_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.setAttributes_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void assignService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map, String string3, String string4) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, string2, schemaType.getType(), map, string3, string4};
            this.client.send(this.client.encodeMessage("assignService_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.assignService_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.assignService_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getAssignedServices(SSOToken sSOToken, IdType idType, String string, Map map, String string2, String string3) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, map, string2, string3};
            return (Set)this.client.send(this.client.encodeMessage("getAssignedServices_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getAssignedServices_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getAssignedServices_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Map getServiceAttributes(SSOToken sSOToken, IdType idType, String string, String string2, Set set, String string3, String string4) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, string2, set, string3, string4};
            return (Map)this.client.send(this.client.encodeMessage("getServiceAttributes_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getServiceAttributes_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getServiceAttributes_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void unassignService(SSOToken sSOToken, IdType idType, String string, String string2, Map map, String string3, String string4) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, string2, map, string3, string4};
            this.client.send(this.client.encodeMessage("unassignService_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.unassignService_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.unassignService_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void modifyService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map, String string3, String string4) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, string2, schemaType.getType(), map, string3, string4};
            this.client.send(this.client.encodeMessage("modifyService_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.modifyService_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.modifyService_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getMembers(SSOToken sSOToken, IdType idType, String string, String string2, IdType idType2, String string3) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, string2, idType2.getName(), string3};
            Set set = (Set)this.client.send(this.client.encodeMessage("getMembers_idrepo", objectArray), null);
            HashSet<AMIdentity> hashSet = new HashSet<AMIdentity>();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string4);
                    hashSet.add(aMIdentity);
                }
            }
            return hashSet;
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getMembers_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getMembers_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getMemberships(SSOToken sSOToken, IdType idType, String string, IdType idType2, String string2, String string3) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, idType2.getName(), string2, string3};
            Set set = (Set)this.client.send(this.client.encodeMessage("getMemberships_idrepo", objectArray), null);
            HashSet<AMIdentity> hashSet = new HashSet<AMIdentity>();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string4);
                    hashSet.add(aMIdentity);
                }
            }
            return hashSet;
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getMemberships_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getMemberships_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public void modifyMemberShip(SSOToken sSOToken, IdType idType, String string, Set set, IdType idType2, int n, String string2) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, set, idType2.getName(), new Integer(n), string2};
            this.client.send(this.client.encodeMessage("modifyMemberShip_idrepo", objectArray), null);
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.modifyMemberShip_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.modifyMemberShip_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getSupportedOperations(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string};
            Set set = (Set)this.client.send(this.client.encodeMessage("getSupportedOperations_idrepo", objectArray), null);
            HashSet<IdOperation> hashSet = new HashSet<IdOperation>();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    IdOperation idOperation = new IdOperation(string2);
                    hashSet.add(idOperation);
                }
            }
            return hashSet;
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getSupportedOperations_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getSupportedOperations_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public Set getSupportedTypes(SSOToken sSOToken, String string) throws IdRepoException, SSOException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), string};
            Set set = (Set)this.client.send(this.client.encodeMessage("getSupportedTypes_idrepo", objectArray), null);
            HashSet<IdType> hashSet = new HashSet<IdType>();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    IdType idType = IdUtils.getType(string2);
                    hashSet.add(idType);
                }
            }
            return hashSet;
        }
        catch (RemoteException remoteException) {
            debug.error("DirectoryManager.getSupportedTypes_idrepo: caught exception=", (Throwable)remoteException);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getSupportedTypes_idrepo: caught exception=", (Throwable)exception);
            throw new IdRepoException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    public boolean isExists(SSOToken sSOToken, IdType idType, String string, String string2) throws SSOException, IdRepoException {
        return false;
    }

    public boolean isActive(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws SSOException, IdRepoException {
        try {
            Object[] objectArray = new Object[]{sSOToken.getTokenID().toString(), idType.getName(), string, string2, string3};
            Boolean bl = (Boolean)this.client.send(this.client.encodeMessage("isActive_idrepo", objectArray), null);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private IdSearchResults mapToIdSearchResults(SSOToken sSOToken, IdType idType, String string, Map map) throws IdRepoException {
        IdSearchResults idSearchResults = new IdSearchResults(idType, string);
        Set set = (Set)map.get(AMSR_RESULTS);
        Map map2 = (Map)map.get(AMSR_ATTRS);
        Integer n = (Integer)map.get(AMSR_CODE);
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                AMIdentity aMIdentity = IdUtils.getIdentity(sSOToken, string2);
                Map map3 = (Map)map2.get(string2);
                idSearchResults.addResult(aMIdentity, map3);
            }
        }
        if (n != null) {
            idSearchResults.setErrorCode(n);
        }
        return idSearchResults;
    }
}

