/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMEntryExistsException;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMInvalidDNException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMObjectClassManager;
import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.AMPreCallBackException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserEntryProcessed;
import com.iplanet.am.sdk.DirectoryManagerInterface;
import com.iplanet.am.sdk.ldap.AMCallBackImpl;
import com.iplanet.am.sdk.ldap.AMEmailNotification;
import com.iplanet.am.sdk.ldap.AMEventManager;
import com.iplanet.am.sdk.ldap.AMUserPasswordValidationImpl;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.Compliance;
import com.iplanet.am.sdk.ldap.DCTree;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.AssignableDynamicGroup;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.DynamicGroup;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.FilteredRole;
import com.iplanet.ums.Guid;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.ManagedRole;
import com.iplanet.ums.Organization;
import com.iplanet.ums.OrganizationalUnit;
import com.iplanet.ums.PeopleContainer;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.Resource;
import com.iplanet.ums.SchemaManager;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.SortKey;
import com.iplanet.ums.StaticGroup;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.cos.COSManager;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.DirectCOSDefinition;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class DirectoryManager
implements AMConstants,
DirectoryManagerInterface {
    private static final String DEFAULT_USER_NAMING_ATTR = "uid";
    private static final String DEFAULT_RESOURCE_NAMING_ATTR = "uid";
    private static final String DEFAULT_ROLE_NAMING_ATTR = "cn";
    private static final String DEFAULT_GROUP_NAMING_ATTR = "cn";
    private static final String DEFAULT_ORG_NAMING_ATTR = "o";
    private static final String DEFAULT_ORG_UNIT_NAMING_ATTR = "ou";
    private static final String DEFAULT_PEOPLE_CONTAINER_NAMING_ATTR = "ou";
    private static final String DEFAULT_GROUP_CONTAINER_NAMING_ATTR = "ou";
    private static final String DEFAULT_DYNAMIC_GROUP_NAMING_ATTR = "cn";
    private static final String DEFAULT_FILTERED_ROLE_NAMING_ATTR = "cn";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_NAMING_ATTR = "cn";
    private static final String LDAP_CONNECTION_ERROR_CODES = "com.iplanet.am.ldap.connection.ldap.error.codes.retries";
    private static HashSet retryErrorCodes = new HashSet();
    private static final String USER_CREATION_TEMPLATE = "BasicUser";
    private static final String GROUP_CREATION_TEMPLATE = "BasicGroup";
    private static final String MANAGED_ROLE_CREATION_TEMPLATE = "BasicManagedRole";
    private static final String RESOURCE_CREATION_TEMPLATE = "BasicResource";
    private static final String FILTERED_ROLE_CREATION_TEMPLATE = "BasicFilteredRole";
    private static final String ASSIGANABLE_DYNAMIC_GROUP_CREATION_TEMPLATE = "BasicAssignableDynamicGroup";
    private static final String DYNAMIC_GROUP_CREATION_TEMPLATE = "BasicDynamicGroup";
    private static final String ORGANIZATION_CREATION_TEMPLATE = "BasicOrganization";
    private static final String PEOPLE_CONTAINTER_CREATION_TEMPLATE = "BasicPeopleContainer";
    private static final String ORGANIZATIONAL_UNIT_CREATION_TEMPLATE = "BasicOrganizationalUnit";
    private static final String GROUP_CONTAINER_CREATION_TEMPLATE = "BasicGroupContainer";
    private static TemplateManager templateMgr = null;
    private static final String DEFAULT_USER_OBJECT_CLASS = "inetorgperson";
    private static final String DEFAULT_RESOURCE_OBJECT_CLASS = "inetcalresource";
    private static final String DEFAULT_ROLE_OBJECT_CLASS = "nsmanagedroledefinition";
    private static final String DEFAULT_FILTERED_ROLE_OBJECT_CLASS = "nsfilteredroledefinition";
    private static final String DEFAULT_ORGANIZATION_OBJECT_CLASS = "organization";
    private static final String DEFAULT_ORGANIZATIONAL_UNIT_OBJECT_CLASS = "organizationalunit";
    private static final String DEFAULT_GROUP_OBJECT_CLASS = "iplanet-am-managed-group";
    private static final String DEFAULT_DYNAMIC_GROUP_OBJECT_CLASS = "groupofurls";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_OBJECT_CLASS = "iplanet-am-managed-assignable-group";
    private static final String DEFAULT_GROUP_CONTAINER_OBJECT_CLASS = "iplanet-am-managed-group-container";
    private static final String DEFAULT_PEOPLE_CONTAINER_OBJECT_CLASS = "nsManagedPeopleContainer";
    private static final String USER_SEARCH_TEMPLATE = "BasicUserSearch";
    private static final String ROLE_SEARCH_TEMPLATE = "BasicManagedRoleSearch";
    private static final String FILTERED_ROLE_SEARCH_TEMPLATE = "BasicFilteredRoleSearch";
    private static final String GROUP_SEARCH_TEMPLATE = "BasicGroupSearch";
    private static final String DYNAMIC_GROUP_SEARCH_TEMPLATE = "BasicDynamicGroupSearch";
    private static final String ORGANIZATION_SEARCH_TEMPLATE = "BasicOrganizationSearch";
    private static final String PEOPLE_CONTAINER_SEARCH_TEMPLATE = "BasicPeopleContainerSearch";
    private static final String ORGANIZATIONAL_UNIT_SEARCH_TEMPLATE = "BasicOrganizationalUnitSearch";
    private static final String ASSIGNABLE_DYNAMIC_GROUP_SEARCH_TEMPLATE = "BasicAssignableDynamicGroupSearch";
    private static final String GROUP_CONTAINER_SEARCH_TEMPLATE = "BasicGroupContainerSearch";
    private static final String RESOURCE_SEARCH_TEMPLATE = "BasicResourceSearch";
    private static final String DEFAULT_USER_SEARCH_FILTER = "(objectclass=inetorgperson)";
    private static final String DEFAULT_ROLE_SEARCH_FILTER = "(objectclass=nsmanagedroledefinition)";
    private static final String DEFAULT_FILTERED_ROLE_SEARCH_FILTER = "(&(objectclass=nsfilteredroledefinition)(!(cn=ContainerDefaultTemplateRole)))";
    private static final String DEFAULT_GROUP_SEARCH_FILTER = "(objectclass=groupofuniquenames)";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_SEARCH_FILTER = "(objectclass=iplanet-am-managed-assignable-group)";
    private static final String DEFAULT_DYNAMIC_GROUP_SEARCH_FILTER = "(objectclass=groupofurls)";
    private static final String DEFAULT_ORGANIZATION_SEARCH_FILTER = "(objectclass=organization)";
    private static final String DEFAULT_PEOPLE_CONTAINER_SEARCH_FILTER = "(objectclass=nsManagedPeopleContainer)";
    private static final String DEFAULT_ORGANIZATIONAL_UNIT_SEARCH_FILTER = "(objectclass=organizationalunit)";
    private static final String DEFAULT_GROUP_CONTAINER_SEARCH_FILTER = "(objectclass=iplanet-am-managed-group-container)";
    public static Debug debug = CommonUtils.debug;
    public static boolean isUserPluginInitialized = false;
    private static AMUserEntryProcessed userEntry = null;
    private String[] aName = new String[]{"objectclass"};
    private SearchControl scontrol = new SearchControl();
    private static DirectoryManager instance;
    private static AMEventManager eventManager;
    private static Map listeners;
    protected DCTree dcTree = new DCTree();
    protected Compliance compl = new Compliance();
    protected SSOToken internalToken = CommonUtils.getInternalToken();
    private AMDirectoryManager amdm;

    public DirectoryManager() {
        this.scontrol.setSearchScope(0);
    }

    public static synchronized DirectoryManager getInstance() {
        if (instance == null) {
            debug.message("DirectoryManager.getInstance(): Creating a new Instance of DirectoryManager()");
            instance = new DirectoryManager();
        }
        return instance;
    }

    protected String getEntryName(UMSException uMSException) {
        DN dN = this.getExceptionDN(uMSException);
        String string = "";
        if (dN != null) {
            string = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
        }
        return string;
    }

    private DN getExceptionDN(UMSException uMSException) {
        String string;
        int n;
        DN dN = null;
        String string2 = uMSException.getMessage();
        if (string2 != null && (n = string2.indexOf("::")) != -1 && DN.isDN((String)(string = string2.substring(0, n)))) {
            dN = new DN(string);
        }
        return dN;
    }

    private String getEntryNotFoundMsgID(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                return "465";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "466";
            }
            case 2: {
                return "467";
            }
            case 1: {
                return "468";
            }
            case 3: {
                return "469";
            }
            case 5: {
                return "470";
            }
            case 4: {
                return "471";
            }
        }
        return "461";
    }

    private String getEntryExistsMsgID(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: {
                return "472";
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return "473";
            }
            case 2: {
                return "474";
            }
            case 1: {
                return "475";
            }
            case 3: {
                return "476";
            }
            case 5: {
                return "477";
            }
            case 4: {
                return "483";
            }
        }
        return "462";
    }

    private void processInternalException(SSOToken sSOToken, UMSException uMSException, String string) throws AMException {
        try {
            LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
            int n = lDAPException.getLDAPResultCode();
            switch (n) {
                case 19: {
                    throw new AMException(sSOToken, "19", uMSException);
                }
                case 3: {
                    throw new AMException(sSOToken, "3", uMSException);
                }
                case 4: {
                    throw new AMException(sSOToken, "4", uMSException);
                }
                case 67: {
                    throw new AMException(sSOToken, "967", uMSException);
                }
                case 11: {
                    throw new AMException(sSOToken, "968", uMSException);
                }
            }
            throw new AMException(sSOToken, string, uMSException);
        }
        catch (Exception exception) {
            throw new AMException(sSOToken, string);
        }
    }

    public static AMUserEntryProcessed getUserPostPlugin() {
        if (!isUserPluginInitialized) {
            String string = SystemProperties.get((String)"com.iplanet.am.sdk.userEntryProcessingImpl");
            if (string != null && string.length() != 0) {
                try {
                    userEntry = (AMUserEntryProcessed)Class.forName(string).newInstance();
                    if (debug.messageEnabled()) {
                        debug.message("DirectoryManager.getUserPostPlugin: Class " + string + " instantiated.");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    debug.error("DirectoryManager.getUserPostPlugin(): Class not found: " + string, (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    debug.error("DirectoryManager.getUserPostPlugin(): Unable to instantiate: " + string, (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    debug.error("DirectoryManager.getUserPostPlugin(): IllegalAccessException: " + string, (Throwable)illegalAccessException);
                }
            }
            isUserPluginInitialized = true;
        }
        return userEntry;
    }

    public boolean doesEntryExists(SSOToken sSOToken, String string) {
        try {
            PersistentObject persistentObject = UMSObject.getObject(this.internalToken, new Guid(string));
        }
        catch (UMSException uMSException) {
            if (string.indexOf("agents") < 0 && debug.messageEnabled()) {
                debug.message("DirectoryManager.doesProfileExist(): + Exception caught: ", (Throwable)uMSException);
            }
            return false;
        }
        return true;
    }

    public int getObjectType(SSOToken sSOToken, String string) throws AMException, SSOException {
        return this.getObjectType(sSOToken, string, null);
    }

    public int getObjectType(SSOToken sSOToken, String string, Map map) throws AMException, SSOException {
        Object object;
        Object object2;
        if (debug.messageEnabled()) {
            debug.message("DirectoryManager.getObjectType() Getting object type for: " + string);
        }
        if (!DN.isDN((String)string)) {
            throw new AMInvalidDNException(AMSDKBundle.getString("157"), "157");
        }
        SSOTokenManager.getInstance().validateToken(sSOToken);
        Set set = null;
        if (map == null || (set = (Set)map.get("objectclass")) == null) {
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.getObjectType() Making LDAP call to get objectclass attributes");
            }
            object2 = new String[]{"objectClass"};
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add("objectclass");
            object = this.getAttributes(sSOToken, string, hashSet, -9999);
            if (object.size() == 1) {
                set = (Set)object.get("objectclass");
            }
        }
        if (set != null) {
            object2 = set.iterator();
            int n = -1;
            while (object2.hasNext()) {
                object = (String)object2.next();
                int n2 = AMObjectClassManager.getObjectType((String)object);
                if (n2 == 6) {
                    n = n2;
                    continue;
                }
                if (n2 == -1) continue;
                return n2;
            }
            if (n != -1) {
                return n;
            }
            throw new AMException(AMSDKBundle.getString("156"), "156");
        }
        throw new AMException(AMSDKBundle.getString("151"), "151");
    }

    public Map getDCTreeAttributes(SSOToken sSOToken, String string, Set set, boolean bl, int n) throws AMException, SSOException {
        String string2;
        String string3 = AMStoreConnection.rootSuffix;
        if (this.dcTree.isRequired() && n == 2 && !CommonUtils.formatToRFC(string).equalsIgnoreCase(string3) && (string2 = this.dcTree.getCanonicalDomain(this.internalToken, string)) != null) {
            String[] stringArray = set == null ? null : set.toArray(new String[set.size()]);
            AttrSet attrSet = this.dcTree.getDomainAttributes(this.internalToken, string, stringArray);
            return CommonUtils.attrSetToMap(attrSet, bl);
        }
        return null;
    }

    private void checkComplianceAttributes(AttrSet attrSet, boolean bl) throws AMException {
        if (!bl && this.compl.isComplianceUserDeletionEnabled()) {
            this.compl.verifyAttributes(attrSet);
        }
    }

    public Map getAttributes(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = false;
        return this.getAttributes(sSOToken, string, bl, bl2, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = false;
        return this.getAttributes(sSOToken, string, set, bl, bl2, n);
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = true;
        return this.getAttributes(sSOToken, string, bl2, bl, n);
    }

    public Map getAttributesByteValues(SSOToken sSOToken, String string, Set set, int n) throws AMException, SSOException {
        boolean bl = true;
        boolean bl2 = true;
        return this.getAttributes(sSOToken, string, set, bl2, bl, n);
    }

    public Map getAttributes(SSOToken sSOToken, String string, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            AttrSet attrSet = persistentObject.getAttributes(persistentObject.getAttributeNames());
            this.checkComplianceAttributes(attrSet, bl);
            AMHashMap aMHashMap = (AMHashMap)CommonUtils.attrSetToMap(attrSet, bl2);
            Map map = this.getDCTreeAttributes(sSOToken, string, null, bl2, n);
            aMHashMap.copy(map);
            return aMHashMap;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.getProfileAttribute(): Unable to get attributes: ", (Throwable)illegalArgumentException);
            }
            String string2 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("330", string2), "330");
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.getProfileAttribute(): Unable to get attributes: ", (Throwable)uMSException);
            }
            String string3 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("330", string3), "330");
        }
    }

    public Map getAttributes(SSOToken sSOToken, String string, Set set, boolean bl, boolean bl2, int n) throws AMException, SSOException {
        if (set == null) {
            return this.getAttributes(sSOToken, string, bl, bl2, n);
        }
        try {
            String[] stringArray = set.toArray(new String[set.size()]);
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            AttrSet attrSet = !bl && this.compl.isComplianceUserDeletionEnabled() ? this.compl.verifyAndGetAttributes(persistentObject, stringArray) : persistentObject.getAttributes(stringArray);
            AMHashMap aMHashMap = (AMHashMap)CommonUtils.attrSetToMap(attrSet, bl2);
            Iterator iterator = set.iterator();
            Map map = this.getDCTreeAttributes(sSOToken, string, set, bl2, n);
            aMHashMap.copy(map);
            return aMHashMap;
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.getProfileAttribute(): Unable to get attributes: ", (Throwable)uMSException);
            }
            String string2 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("330", string2), "330");
        }
    }

    public String getOrgSearchFilter(String string) {
        String string2 = AMSearchFilterManager.getSearchFilter(2, string, null, true);
        String string3 = AMSearchFilterManager.getSearchFilter(3, string, null, true);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(|").append(string2).append(string3);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        if (string.equals("") || !DN.isDN((String)string)) {
            debug.error("DirectoryManager.getOrganizationDN() Invalid DN: " + string);
            throw new AMException(sSOToken, "157");
        }
        DN dN = new DN(string);
        String string2 = null;
        while (string2 == null || string2.length() == 0) {
            String string3 = dN.toString();
            string2 = this.verifyAndGetOrgDN(sSOToken, string, string3);
            dN = dN.getParent();
        }
        return string2;
    }

    public Map getExternalAttributes(SSOToken sSOToken, String string, Set set, int n) throws AMException {
        SSOToken sSOToken2 = CommonUtils.getInternalToken();
        String string2 = n == 1 ? new DN(string).getParent().toString() : string;
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string3 = this.amdm.getOrganizationDN(sSOToken2, string2);
        return AMCallBackImpl.getAttributes(sSOToken, string, set, string3);
    }

    public void updateUserAttribute(SSOToken sSOToken, Set set, String string, boolean bl) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("DirectoryManager.updateUserAttribute(): groupDN:" + string + ", toAdd: " + bl + " members: " + set);
        }
        Attr attr = new Attr("iplanet-am-static-group-dn", string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            try {
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string2));
                if (bl) {
                    persistentObject.modify(attr, 0);
                } else {
                    persistentObject.modify(attr, 1);
                }
                persistentObject.save();
            }
            catch (UMSException uMSException) {
                debug.error("DirectoryManager.updateUserAttribute(): Failed while trying to set the static groupDN " + string + " for user: " + string2, (Throwable)uMSException);
                throw new AMException(sSOToken, "351", uMSException);
            }
        }
    }

    private void makeNamingFirst(AttrSet attrSet, String string, String string2) {
        int n = attrSet.indexOf(string);
        if (n == -1) {
            attrSet.add(new Attr(string, string2));
        } else {
            Attr attr = attrSet.elementAt(n);
            attr.removeValue(string2);
            String[] stringArray = attr.getStringValues();
            attr = new Attr(string, string2);
            attr.addValues(stringArray);
            attrSet.replace(attr);
        }
    }

    private AttrSet combineOCs(CreationTemplate creationTemplate, AttrSet attrSet) {
        Attr attr = attrSet.getAttribute("objectclass");
        Attr attr2 = creationTemplate.getAttribute("objectclass");
        Set set = attr != null ? CommonUtils.stringArrayToSet(attr.getStringValues()) : new HashSet();
        Set set2 = CommonUtils.stringArrayToSet(attr2.getStringValues());
        Set set3 = CommonUtils.combineOCs(set, set2);
        attrSet.remove("objectclass");
        Attr attr3 = new Attr("objectclass", set3.toArray(new String[set3.size()]));
        attrSet.add(attr3);
        return attrSet;
    }

    private void createUser(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMEntryExistsException, AMException {
        Object object;
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(1) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 1, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(1), string);
        AMUserPasswordValidationImpl aMUserPasswordValidationImpl = new AMUserPasswordValidationImpl(sSOToken, string2);
        try {
            aMUserPasswordValidationImpl.validate(CommonUtils.attrSetToMap(attrSet));
        }
        catch (AMException aMException) {
            debug.error("DirectoryManager.createUser(): Invalid characters for user", (Throwable)aMException);
            throw aMException;
        }
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(USER_CREATION_TEMPLATE, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        PersistentObject persistentObject2 = new PersistentObject(creationTemplate, attrSet);
        try {
            persistentObject.addChild(persistentObject2);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createUser(): Insufficient Access rights to create user", (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (this.compl.isComplianceUserDeletionEnabled()) {
                this.compl.checkIfDeletedUser(sSOToken, persistentObject2.getDN());
            }
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createUser() User already exists: ", (Throwable)entryAlreadyExistsException);
            }
            throw new AMEntryExistsException(sSOToken, "328", (UMSException)entryAlreadyExistsException);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createUser(): Internal Error occurred. Unable to create User Entry", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "324");
        }
        AMCallBackImpl.postProcess(sSOToken, persistentObject2.getDN(), string2, null, map, 1, 1, false);
        AMUserEntryProcessed aMUserEntryProcessed = DirectoryManager.getUserPostPlugin();
        if (aMUserEntryProcessed != null) {
            object = CommonUtils.attrSetToMap(attrSet);
            aMUserEntryProcessed.processUserAdd(sSOToken, persistentObject2.getDN(), (Map)object);
        }
        object = new AMEmailNotification(persistentObject2.getDN());
        ((AMEmailNotification)object).setUserCreateNotificationList();
        ((AMEmailNotification)object).sendUserCreateNotification(map);
    }

    private void createEntity(SSOToken sSOToken, PersistentObject persistentObject, int n, Map map, String string) throws UMSException, AMEntryExistsException, AMException {
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(n) + "=" + string + "," + persistentObject.getDN();
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(n), string);
        String string4 = this.getCreationTemplateName(n);
        if (string4 == null) {
            string4 = USER_CREATION_TEMPLATE;
        }
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(string4, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        PersistentObject persistentObject2 = new PersistentObject(creationTemplate, attrSet);
        try {
            persistentObject.addChild(persistentObject2);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createEntity(): Insufficient Access rights to create entity", (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (this.compl.isComplianceUserDeletionEnabled()) {
                this.compl.checkIfDeletedUser(sSOToken, persistentObject2.getDN());
            }
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createEntity() Entity already exists: ", (Throwable)entryAlreadyExistsException);
            }
            throw new AMEntryExistsException(sSOToken, "462", (UMSException)entryAlreadyExistsException);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createEntity(): Internal Error occurred. Unable to create User Entry", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "324");
        }
    }

    private void createResource(PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(21), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(RESOURCE_CREATION_TEMPLATE, new Guid(string2), 1);
        Resource resource = new Resource(creationTemplate, attrSet);
        persistentObject.addChild(resource);
    }

    private void createRole(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(6) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 6, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(6), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(MANAGED_ROLE_CREATION_TEMPLATE, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        ManagedRole managedRole = new ManagedRole(creationTemplate, attrSet);
        persistentObject.addChild(managedRole);
        AMCallBackImpl.postProcess(sSOToken, managedRole.getDN(), string2, null, map, 1, 6, false);
    }

    private void createOrganization(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        Organization organization;
        String string2;
        block18: {
            Object object;
            String string3;
            block17: {
                if (this.amdm == null) {
                    this.amdm = AMDirectoryWrapper.getInstance();
                }
                string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
                string3 = AMNamingAttrManager.getNamingAttr(2) + "=" + string + "," + persistentObject.getDN();
                map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 2, false);
                AttrSet attrSet = CommonUtils.mapToAttrSet(map);
                this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(2), string);
                TemplateManager templateManager = TemplateManager.getTemplateManager();
                organization = null;
                CreationTemplate creationTemplate = templateManager.getCreationTemplate(ORGANIZATION_CREATION_TEMPLATE, new Guid(string2), 1);
                attrSet = this.combineOCs(creationTemplate, attrSet);
                if (this.dcTree.isRequired()) {
                    object = this.dcTree.splitAttrSet(persistentObject.getDN(), attrSet);
                    organization = new Organization(creationTemplate, object[0]);
                    this.dcTree.createDomain(sSOToken, new Guid(string3), attrSet);
                } else {
                    organization = new Organization(creationTemplate, attrSet);
                }
                try {
                    persistentObject.addChild(organization);
                }
                catch (UMSException uMSException) {
                    if (this.dcTree.isRequired()) {
                        this.dcTree.removeDomain(sSOToken, string3);
                    }
                    if (this.compl.isComplianceUserDeletionEnabled()) {
                        this.compl.checkIfDeletedOrg(sSOToken, organization.getDN());
                    }
                    throw uMSException;
                }
                if (this.compl.isAdminGroupsEnabled(organization.getDN())) {
                    this.compl.createAdminGroups(sSOToken, organization);
                }
                if (ServiceManager.isCoexistenceMode() && ServiceManager.isRealmEnabled()) {
                    try {
                        new OrganizationConfigManager(sSOToken, string3);
                    }
                    catch (SMSException sMSException) {
                        if (debug.messageEnabled()) {
                            debug.message("DirectoryManager::createOrganization creating realm: " + organization.getDN());
                        }
                        try {
                            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string2);
                            organizationConfigManager.createSubOrganization(string, null);
                        }
                        catch (SMSException sMSException2) {
                            if (!debug.messageEnabled()) break block17;
                            debug.message("DirectoryManager::createOrganization unable to create realm: " + organization.getDN(), (Throwable)sMSException2);
                        }
                    }
                }
            }
            if (ServiceManager.isCoexistenceMode()) {
                try {
                    object = new OrganizationConfigManager(sSOToken, string3);
                    OrganizationConfigManager.loadDefaultServices(sSOToken, (OrganizationConfigManager)object);
                }
                catch (SMSException sMSException) {
                    if (!debug.warningEnabled()) break block18;
                    debug.warning("DirectoryManager::createOrganization Unable to load services: " + organization.getDN());
                }
            }
        }
        AMCallBackImpl.postProcess(sSOToken, organization.getDN(), string2, null, map, 1, 2, false);
    }

    private void createGroup(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 9, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(9), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(GROUP_CREATION_TEMPLATE, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        StaticGroup staticGroup = new StaticGroup(creationTemplate, attrSet);
        persistentObject.addChild(staticGroup);
        Attr attr = attrSet.getAttribute("uniquemember");
        if (attr != null) {
            String[] stringArray = attr.getStringValues();
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
            this.updateUserAttribute(sSOToken, hashSet, staticGroup.getDN(), true);
        }
        AMCallBackImpl.postProcess(sSOToken, staticGroup.getDN(), string2, null, map, 1, 9, false);
    }

    private void createAssignDynamicGroup(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 12, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(12), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(ASSIGANABLE_DYNAMIC_GROUP_CREATION_TEMPLATE, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        AssignableDynamicGroup assignableDynamicGroup = new AssignableDynamicGroup(creationTemplate, attrSet);
        assignableDynamicGroup.setSearchFilter("(memberof=" + string3 + ")");
        assignableDynamicGroup.setSearchScope(2);
        assignableDynamicGroup.setSearchBase(new Guid(string2));
        persistentObject.addChild(assignableDynamicGroup);
        AMCallBackImpl.postProcess(sSOToken, assignableDynamicGroup.getDN(), string2, null, map, 1, 12, false);
    }

    private void createDynamicGroup(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(9) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 11, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(11), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(DYNAMIC_GROUP_CREATION_TEMPLATE, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        DynamicGroup dynamicGroup = new DynamicGroup(creationTemplate, attrSet);
        String string4 = persistentObject.getDN();
        String string5 = dynamicGroup.getSearchFilter();
        if (LDAPUrl.defaultFilter.equalsIgnoreCase(string5)) {
            dynamicGroup.setSearchFilter(AMSearchFilterManager.getSearchFilter(1, string2));
        }
        dynamicGroup.setSearchScope(2);
        dynamicGroup.setSearchBase(new Guid(string2));
        persistentObject.addChild(dynamicGroup);
        AMCallBackImpl.postProcess(sSOToken, dynamicGroup.getDN(), string2, null, map, 1, 11, false);
    }

    private void createPeopleContainer(PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(5), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(PEOPLE_CONTAINTER_CREATION_TEMPLATE, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        PeopleContainer peopleContainer = new PeopleContainer(creationTemplate, attrSet);
        persistentObject.addChild(peopleContainer);
    }

    private void createOrganizationalUnit(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(3) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 3, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(3), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(ORGANIZATIONAL_UNIT_CREATION_TEMPLATE, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        OrganizationalUnit organizationalUnit = new OrganizationalUnit(creationTemplate, attrSet);
        persistentObject.addChild(organizationalUnit);
        AMCallBackImpl.postProcess(sSOToken, organizationalUnit.getDN(), string2, null, map, 1, 3, false);
    }

    private void createGroupContainer(PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(4), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(GROUP_CONTAINER_CREATION_TEMPLATE, new Guid(string2), 1);
        OrganizationalUnit organizationalUnit = new OrganizationalUnit(creationTemplate, attrSet);
        persistentObject.addChild(organizationalUnit);
    }

    private void createFilteredRole(SSOToken sSOToken, PersistentObject persistentObject, Map map, String string) throws UMSException, AMException {
        Serializable serializable;
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(this.internalToken, persistentObject.getDN());
        String string3 = AMNamingAttrManager.getNamingAttr(8) + "=" + string + "," + persistentObject.getDN();
        map = AMCallBackImpl.preProcess(sSOToken, string3, string2, null, map, 1, 8, false);
        AttrSet attrSet = CommonUtils.mapToAttrSet(map);
        this.makeNamingFirst(attrSet, AMNamingAttrManager.getNamingAttr(8), string);
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate(FILTERED_ROLE_CREATION_TEMPLATE, new Guid(string2), 1);
        attrSet = this.combineOCs(creationTemplate, attrSet);
        if (!attrSet.contains("nsRoleFilter")) {
            serializable = new Attr("nsRoleFilter", AMSearchFilterManager.getSearchFilter(1, string2));
            attrSet.add((Attr)serializable);
        }
        serializable = new FilteredRole(creationTemplate, attrSet);
        persistentObject.addChild((PersistentObject)serializable);
        AMCallBackImpl.postProcess(sSOToken, ((PersistentObject)serializable).getDN(), string2, null, map, 1, 8, false);
    }

    public void createEntry(SSOToken sSOToken, String string, int n, String string2, Map map) throws AMEntryExistsException, AMException {
        try {
            if (string == null || string.equals("")) {
                throw new AMException(sSOToken, "320");
            }
            if (string2 == null) {
                throw new AMException(sSOToken, "322");
            }
            String string3 = AMNamingAttrManager.getNamingAttr(n) + "=" + string + "," + string2;
            this.validateAttributeUniqueness(string3, n, true, map);
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string2));
            switch (n) {
                case 1: {
                    this.createUser(sSOToken, persistentObject, map, string);
                    break;
                }
                case 6: 
                case 7: {
                    this.createRole(sSOToken, persistentObject, map, string);
                    break;
                }
                case 2: {
                    this.createOrganization(sSOToken, persistentObject, map, string);
                    break;
                }
                case 9: 
                case 10: {
                    this.createGroup(sSOToken, persistentObject, map, string);
                    break;
                }
                case 12: {
                    this.createAssignDynamicGroup(sSOToken, persistentObject, map, string);
                    break;
                }
                case 11: {
                    this.createDynamicGroup(sSOToken, persistentObject, map, string);
                    break;
                }
                case 5: {
                    this.createPeopleContainer(persistentObject, map, string);
                    break;
                }
                case 3: {
                    this.createOrganizationalUnit(sSOToken, persistentObject, map, string);
                    break;
                }
                case 4: {
                    this.createGroupContainer(persistentObject, map, string);
                    break;
                }
                case 8: {
                    this.createFilteredRole(sSOToken, persistentObject, map, string);
                    break;
                }
                case 21: {
                    this.createResource(persistentObject, map, string);
                    break;
                }
                case -9999: 
                case -1: {
                    throw new AMException(sSOToken, "326");
                }
                default: {
                    this.createEntity(sSOToken, persistentObject, n, map, string);
                    break;
                }
            }
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createEntry() Insufficient access rights to create entry: " + string, (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createEntry() Entry: " + string + "already exists: ", (Throwable)entryAlreadyExistsException);
            }
            String string4 = this.getEntryExistsMsgID(n);
            String string5 = this.getEntryName(entryAlreadyExistsException);
            Object[] objectArray = new Object[]{string5};
            throw new AMException(AMSDKBundle.getString(string4, objectArray), string4, objectArray);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createEntry() Unable to create entry: " + string, (Throwable)uMSException);
            }
            throw new AMException(sSOToken, "324", uMSException);
        }
    }

    private void processPreDeleteCallBacks(SSOToken sSOToken, String string, Map map, String string2, int n, boolean bl) throws AMException, SSOException {
        if (n != 5 && n != 4) {
            DN dN;
            DN dN2;
            String string3 = string2;
            if (!(n != 2 && n != 3 || (dN2 = new DN(AMStoreConnection.rootSuffix)).equals(dN = new DN(string2)))) {
                String string4 = new DN(string2).getParent().toString();
                if (this.amdm == null) {
                    this.amdm = AMDirectoryWrapper.getInstance();
                }
                string3 = this.amdm.getOrganizationDN(this.internalToken, string4);
            }
            if (map == null) {
                map = this.getAttributes(sSOToken, string, n);
            }
            AMCallBackImpl.preProcess(sSOToken, string, string3, map, null, 2, n, bl);
        }
    }

    private void processPostDeleteCallBacks(SSOToken sSOToken, String string, Map map, String string2, int n, boolean bl) throws AMException {
        if (n != 5 && n != 4) {
            DN dN;
            DN dN2;
            String string3 = string2;
            if (!(n != 2 && n != 3 || (dN2 = new DN(AMStoreConnection.rootSuffix)).equals(dN = new DN(string2)))) {
                String string4 = new DN(string2).getParent().toString();
                if (this.amdm == null) {
                    this.amdm = AMDirectoryWrapper.getInstance();
                }
                string3 = this.amdm.getOrganizationDN(this.internalToken, string4);
            }
            AMCallBackImpl.postProcess(sSOToken, string, string3, map, null, 2, n, bl);
        }
    }

    public void removeEntry(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2) throws AMException, SSOException {
        block6: {
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.removeEntry(): Removing: " + string + " & recursive: " + bl);
            }
            if (bl) {
                this.removeSubtree(sSOToken, string, bl2);
            } else {
                this.removeSingleEntry(sSOToken, string, n, bl2);
            }
            if (n == 2 && ServiceManager.isCoexistenceMode() && ServiceManager.isRealmEnabled()) {
                try {
                    OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, string);
                    organizationConfigManager.deleteSubOrganization(null, bl);
                }
                catch (SMSException sMSException) {
                    if (!debug.messageEnabled()) break block6;
                    debug.message("DirectoryManager::removeEntry unable to delete corresponding realm: " + string);
                }
            }
        }
    }

    private void removeSingleEntry(SSOToken sSOToken, String string, int n, boolean bl) throws AMException, SSOException {
        Object object;
        Map map = null;
        AMEmailNotification aMEmailNotification = null;
        String string2 = string;
        if (n == 1) {
            string2 = new DN(string).getParent().toRFCString();
        }
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string3 = this.amdm.getOrganizationDN(this.internalToken, string2);
        try {
            if (n == 1) {
                aMEmailNotification = new AMEmailNotification(string);
                aMEmailNotification.setUserDeleteNotificationList();
            }
            if (DirectoryManager.getUserPostPlugin() != null || aMEmailNotification != null && aMEmailNotification.isPresentUserDeleteNotificationList()) {
                map = this.getAttributes(sSOToken, string, n);
            }
            this.processPreDeleteCallBacks(sSOToken, string, map, string3, n, bl);
            if (this.dcTree.isRequired()) {
                object = CommonUtils.formatToRFC(string);
                this.dcTree.removeDomain(this.internalToken, (String)object);
            }
            object = new Guid(string);
            UMSObject.removeObject(sSOToken, (Guid)object);
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("DirectoryManager.removeEntry() Insufficient access rights to remove entry: " + string, (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            String string4 = this.getEntryName(entryNotFoundException);
            debug.error("DirectoryManager.removeEntry() Entry not found: " + string4, (Throwable)entryNotFoundException);
            String string5 = this.getEntryNotFoundMsgID(n);
            Object[] objectArray = new Object[]{string4};
            String string6 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString(string5, objectArray, string6), string5, objectArray);
        }
        catch (UMSException uMSException) {
            debug.error("DirectoryManager.removeEntry() Unable to remove:  Internal error occurred: ", (Throwable)uMSException);
            throw new AMException(sSOToken, "325", uMSException);
        }
        this.processPostDeleteCallBacks(sSOToken, string, map, string3, n, bl);
        if (n == 1) {
            object = DirectoryManager.getUserPostPlugin();
            if (object != null) {
                object.processUserDelete(sSOToken, string, map);
            }
            if (aMEmailNotification != null && aMEmailNotification.isPresentUserDeleteNotificationList()) {
                aMEmailNotification.sendUserDeleteNotification(map);
            }
        }
    }

    private void removeSubtree(SSOToken sSOToken, String string, boolean bl) throws AMException, SSOException {
        int n = -1;
        try {
            int n2;
            int n3;
            Guid guid = new Guid(string);
            PersistentObject persistentObject = UMSObject.getObjectHandle(this.internalToken, guid);
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(2);
            String string2 = "(|(objectclass=*)(objectclass=ldapsubEntry))";
            ArrayList<DN> arrayList = new ArrayList<DN>();
            int n4 = n3 = new DN(string).countRDNs();
            SearchResults searchResults = persistentObject.getChildren(string2, searchControl);
            while (searchResults.hasMoreElements()) {
                PersistentObject persistentObject2 = searchResults.next();
                DN dN = new DN(persistentObject2.getDN());
                if (debug.messageEnabled()) {
                    debug.message("DirectoryManager.removeEntry(): found child: " + persistentObject2.getDN());
                }
                if ((n2 = dN.countRDNs()) > n4) {
                    n4 = n2;
                }
                arrayList.add(dN);
            }
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.removeEntry(): max RDNs: " + n4);
            }
            int n5 = arrayList.size();
            int n6 = n4;
            while (n6 >= n3) {
                n2 = 0;
                while (n2 < n5) {
                    DN dN = (DN)arrayList.get(n2);
                    if (dN.countRDNs() == n6) {
                        if (debug.messageEnabled()) {
                            debug.message("DirectoryManager.removeEntry(): del " + dN.toRFCString());
                        }
                        String string3 = dN.toRFCString();
                        n = -1;
                        try {
                            n = this.getObjectType(this.internalToken, string3);
                        }
                        catch (AMException aMException) {
                            Guid guid2 = new Guid(string3);
                            UMSObject.removeObject(sSOToken, guid2);
                        }
                        if (n != -1 && n != -9999) {
                            try {
                                this.removeSingleEntry(sSOToken, string3, n, bl);
                            }
                            catch (AMPreCallBackException aMPreCallBackException) {
                                debug.error("DirectoryManager.removeSubTree: Aborting delete of: " + string3 + " due to pre-callback exception", (Throwable)aMPreCallBackException);
                            }
                        }
                        arrayList.remove(n2);
                        --n2;
                        --n5;
                    }
                    ++n2;
                }
                --n6;
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("DirectoryManager.removeEntry() Insufficient access rights to remove entry: " + string, (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            String string4 = this.getEntryName(entryNotFoundException);
            debug.error("DirectoryManager.removeEntry() Entry not found: " + string4, (Throwable)entryNotFoundException);
            String string5 = this.getEntryNotFoundMsgID(n);
            Object[] objectArray = new Object[]{string4};
            String string6 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString(string5, objectArray, string6), string5, objectArray);
        }
        catch (UMSException uMSException) {
            debug.error("DirectoryManager.removeEntry() Unable to remove:  Internal error occurred: ", (Throwable)uMSException);
            throw new AMException(sSOToken, "325", uMSException);
        }
    }

    public void removeAdminRole(SSOToken sSOToken, String string, boolean bl) throws SSOException, AMException {
        CharSequence charSequence;
        Object object;
        SSOTokenManager.getInstance().validateToken(sSOToken);
        if (debug.messageEnabled()) {
            debug.message("DirectoryManager.removeAdminRole() dn: " + string + " recursive: " + bl);
        }
        DN dN = new DN(string);
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string2 = this.amdm.getOrganizationDN(sSOToken, dN.getParent().toString());
        String string3 = string.replace(',', '_');
        String string4 = AMNamingAttrManager.getNamingAttr(6);
        String string5 = string4 + "=" + string3 + "," + string2;
        Set<String> set = Collections.EMPTY_SET;
        if (bl) {
            object = AMSearchFilterManager.getSearchFilter(6, string2);
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("(&").append((String)object).append("(");
            ((StringBuffer)charSequence).append(string4).append("=*").append(string3).append("))");
            set = this.search(sSOToken, string2, ((StringBuffer)charSequence).toString(), 1);
        } else {
            set = new HashSet<String>();
            set.add(string5);
        }
        object = set.iterator();
        while (object.hasNext()) {
            charSequence = (String)object.next();
            try {
                ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid((String)charSequence));
                managedRole.removeAllMembers();
                AMStoreConnection aMStoreConnection = new AMStoreConnection(this.internalToken);
                AMRole aMRole = aMStoreConnection.getRole((String)charSequence);
                aMRole.delete(bl);
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) continue;
                debug.message("DirectoryManager.removeAdminRole() Unable to  admin roles:", (Throwable)exception);
            }
        }
    }

    private Set searchResultsToSet(SearchResults searchResults) throws UMSException {
        OrderedSet orderedSet = new OrderedSet();
        if (searchResults != null) {
            while (searchResults.hasMoreElements()) {
                PersistentObject persistentObject = searchResults.next();
                orderedSet.add(persistentObject.getGuid().toString());
            }
        }
        return orderedSet;
    }

    public Set search(SSOToken sSOToken, String string, String string2, int n) throws AMException {
        Set set = Collections.EMPTY_SET;
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(n);
            SearchResults searchResults = persistentObject.search(string2, searchControl);
            set = this.searchResultsToSet(searchResults);
        }
        catch (UMSException uMSException) {
            LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
            int n2 = lDAPException.getLDAPResultCode();
            if (retryErrorCodes.contains("" + n2)) {
                throw new AMException(sSOToken, Integer.toString(n2));
            }
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.search(token:, entryDN: " + string + ", searchFilter: " + string2 + "searchScope: " + n + " error occurred: ", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "341");
        }
        return set;
    }

    private AMSearchResults getSearchResults(SearchResults searchResults, SortKey sortKey, String[] stringArray, Collator collator, boolean bl) throws UMSException {
        TreeSet<Object> treeSet;
        Object object;
        Serializable serializable;
        TreeMap<Object, Object> treeMap = null;
        TreeSet<String> treeSet2 = null;
        if (sortKey != null) {
            treeMap = new TreeMap<Object, Object>(collator);
            treeSet2 = new TreeSet<String>();
        }
        OrderedSet orderedSet = new OrderedSet();
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        int n = 0;
        try {
            if (searchResults != null) {
                while (searchResults.hasMoreElements()) {
                    serializable = searchResults.next();
                    String string = ((PersistentObject)serializable).getGuid().toString();
                    if (treeMap != null) {
                        object = ((PersistentObject)serializable).getAttribute(sortKey.attributeName);
                        if (object != null) {
                            String string2 = object.getStringValues()[0];
                            Object v = treeMap.get(string2);
                            if (v == null) {
                                treeMap.put(string2, string);
                            } else if (v instanceof String) {
                                treeSet = new TreeSet<Object>();
                                treeSet.add(v);
                                treeSet.add(string);
                                treeMap.put(string2, treeSet);
                            } else {
                                ((TreeSet)v).add(string);
                            }
                        } else {
                            treeSet2.add(string);
                        }
                    } else {
                        orderedSet.add(string);
                    }
                    object = new AttrSet();
                    if (stringArray != null) {
                        object = ((PersistentObject)serializable).getAttributes(stringArray, true);
                    } else if (bl) {
                        object = ((PersistentObject)serializable).getAttributes(((PersistentObject)serializable).getAttributeNames(), true);
                    }
                    hashMap.put(string, CommonUtils.attrSetToMap((AttrSet)object));
                }
            }
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            n = 1;
        }
        catch (TimeLimitExceededException timeLimitExceededException) {
            n = 2;
        }
        serializable = (Integer)searchResults.get("vlvContentCount");
        int n2 = serializable == null ? -1 : (Integer)serializable;
        if (treeMap != null) {
            int n3;
            object = treeMap.values().toArray();
            int n4 = ((Object[])object).length;
            if (sortKey.reverse) {
                n3 = n4 - 1;
                while (n3 >= 0) {
                    treeSet = object[n3];
                    if (treeSet instanceof String) {
                        orderedSet.add(treeSet);
                    } else {
                        orderedSet.addAll((Collection)treeSet);
                    }
                    --n3;
                }
            } else {
                n3 = 0;
                while (n3 < n4) {
                    treeSet = object[n3];
                    if (treeSet instanceof String) {
                        orderedSet.add(treeSet);
                    } else {
                        orderedSet.addAll((Collection)treeSet);
                    }
                    ++n3;
                }
            }
            Iterator iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                orderedSet.add(iterator.next());
            }
        }
        object = new AMSearchResults(n2, (Set)orderedSet, n, hashMap);
        return object;
    }

    public AMSearchResults search(SSOToken sSOToken, String string, String string2, SearchControl searchControl, String[] stringArray) throws AMException {
        AMSearchResults aMSearchResults = null;
        try {
            SearchResults searchResults;
            SearchControl searchControl2;
            SortKey[] sortKeyArray = searchControl.getSortKeys();
            SortKey sortKey = null;
            if (sortKeyArray != null && sortKeyArray.length > 0 && sortKeyArray[0].attributeName != null) {
                sortKey = sortKeyArray[0];
            }
            String string3 = CommonUtils.getUserLocale(sSOToken);
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.search() search with searchcontrol locale = " + string3);
            }
            Collator collator = Collator.getInstance(Locale.getLocale((String)string3));
            if (sortKey != null) {
                searchControl2 = new SearchControl();
                searchControl2.setMaxResults(searchControl.getMaxResults());
                searchControl2.setSearchScope(searchControl.getSearchScope());
                searchControl2.setTimeOut(searchControl.getTimeOut());
            } else {
                searchControl2 = searchControl;
            }
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            if (stringArray == null) {
                if (sortKey == null) {
                    searchResults = persistentObject.search(string2, searchControl2);
                } else {
                    String[] stringArray2 = new String[]{sortKey.attributeName};
                    searchResults = persistentObject.search(string2, stringArray2, searchControl2);
                }
            } else if (sortKey == null) {
                searchResults = persistentObject.search(string2, stringArray, searchControl2);
            } else {
                String[] stringArray3 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                stringArray3[stringArray.length] = sortKey.attributeName;
                searchResults = persistentObject.search(string2, stringArray3, searchControl2);
            }
            aMSearchResults = this.getSearchResults(searchResults, sortKey, stringArray, collator, searchControl2.isGetAllReturnAttributesEnabled());
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.search() with search control entryDN: " + string + " Search Filter: " + string2 + " Error occurred: ", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "341");
        }
        return aMSearchResults;
    }

    public Set getMembers(SSOToken sSOToken, String string, int n) throws AMException {
        try {
            switch (n) {
                case 6: 
                case 7: {
                    ManagedRole managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = managedRole.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
                case 8: {
                    FilteredRole filteredRole = (FilteredRole)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = filteredRole.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
                case 9: 
                case 10: {
                    StaticGroup staticGroup = (StaticGroup)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = staticGroup.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
                case 11: {
                    DynamicGroup dynamicGroup = (DynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = dynamicGroup.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
                case 12: {
                    AssignableDynamicGroup assignableDynamicGroup = new AssignableDynamicGroup();
                    AssignableDynamicGroup assignableDynamicGroup2 = (AssignableDynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
                    SearchResults searchResults = assignableDynamicGroup2.getMemberIDs();
                    return this.searchResultsToSet(searchResults);
                }
            }
            throw new AMException(sSOToken, "114");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            debug.error("DirectoryManager.getMembers() entryDN " + string + " objectType: " + n + " Unable to get members: ", (Throwable)entryNotFoundException);
            String string2 = this.getEntryNotFoundMsgID(n);
            String string3 = this.getEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string3};
            throw new AMException(AMSDKBundle.getString(string2, objectArray), string2, objectArray);
        }
        catch (UMSException uMSException) {
            debug.error("DirectoryManager.getMembers() entryDN " + string + " objectType: " + n + " Unable to get members: ", (Throwable)uMSException);
            LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
            if (lDAPException != null && (lDAPException.getLDAPResultCode() == 4 || lDAPException.getLDAPResultCode() == 11)) {
                throw new AMException(sSOToken, "505", uMSException);
            }
            throw new AMException(sSOToken, "454", uMSException);
        }
    }

    public String renameEntry(SSOToken sSOToken, int n, String string, String string2, boolean bl) throws AMException {
        try {
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            String string3 = AMNamingAttrManager.getNamingAttr(n) + "=" + string2;
            persistentObject.rename(string3, bl);
            return persistentObject.getDN();
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.renameEntry(): User does not have sufficient access rights ", (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.renameEntry(): Entry not found: ", (Throwable)entryNotFoundException);
            }
            String string4 = this.getEntryNotFoundMsgID(n);
            String string5 = this.getEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string5};
            throw new AMException(AMSDKBundle.getString(string4, objectArray), string4, objectArray);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.renameEntry(): Unable to rename entry: ", (Throwable)uMSException);
            }
            throw new AMException(sSOToken, "360");
        }
    }

    private Map setDCTreeAttributes(SSOToken sSOToken, String string, Map map, int n) throws AMException {
        if (n == 2 && this.dcTree.isRequired() && !string.equals(AMStoreConnection.rootSuffix)) {
            AttrSet attrSet = CommonUtils.mapToAttrSet(map);
            String string2 = attrSet.getValue("inetdomainstatus");
            if (string2 != null) {
                this.dcTree.updateDomainStatus(sSOToken, string, string2);
            }
            AttrSet[] attrSetArray = this.dcTree.splitAttrSet(string, attrSet);
            attrSet = attrSetArray[0];
            map = CommonUtils.attrSetToMap(attrSet);
            AttrSet attrSet2 = attrSetArray[1];
            this.dcTree.setDomainAttributes(sSOToken, string, attrSet2);
        }
        return map;
    }

    private void processPostModifyCallBacks(SSOToken sSOToken, String string, Map map, Map map2, String string2, int n) throws AMException {
        if (n != 5 && n != 4) {
            DN dN;
            DN dN2;
            String string3 = string2;
            if (!(n != 2 && n != 3 || (dN2 = new DN(AMStoreConnection.rootSuffix)).equals(dN = new DN(string2)))) {
                String string4 = new DN(string2).getParent().toString();
                if (this.amdm == null) {
                    this.amdm = AMDirectoryWrapper.getInstance();
                }
                string3 = this.amdm.getOrganizationDN(this.internalToken, string4);
            }
            AMCallBackImpl.postProcess(sSOToken, string, string3, map, map2, 3, n, false);
        }
    }

    private Map processPreModifyCallBacks(SSOToken sSOToken, String string, Map map, Map map2, String string2, int n) throws AMException, SSOException {
        if (n != 5 && n != 4) {
            DN dN;
            Object object;
            String string3 = string2;
            if (!(n != 2 && n != 3 || (object = new DN(AMStoreConnection.rootSuffix)).equals(dN = new DN(string2)))) {
                String string4 = new DN(string2).getParent().toString();
                if (this.amdm == null) {
                    this.amdm = AMDirectoryWrapper.getInstance();
                }
                string3 = this.amdm.getOrganizationDN(this.internalToken, string4);
            }
            if (map == null) {
                object = map2.keySet();
                map = this.getAttributes(sSOToken, string, (Set)object, n);
            }
            map2 = AMCallBackImpl.preProcess(sSOToken, string, string3, map, map2, 3, n, false);
        }
        return map2;
    }

    private void modifyPersistentObject(PersistentObject persistentObject, Attr attr, boolean bl, boolean bl2) {
        if (bl) {
            persistentObject.modify(attr, 0);
        } else if (bl2) {
            persistentObject.modify(attr, 1);
        } else {
            persistentObject.modify(attr, 2);
        }
    }

    private void modifyAndSaveEntry(SSOToken sSOToken, String string, Map map, Map map2, boolean bl) throws AccessRightsException, EntryNotFoundException, UMSException {
        String[] stringArray;
        Object object;
        String string2;
        Iterator iterator;
        PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
        if (map != null && !map.isEmpty()) {
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                object = (Set)map.get(string2);
                stringArray = object == null ? null : object.toArray(new String[object.size()]);
                Attr attr = new Attr(string2, stringArray);
                this.modifyPersistentObject(persistentObject, attr, bl, object == AMConstants.REMOVE_ATTRIBUTE);
            }
        }
        if (map2 != null && !map2.isEmpty()) {
            iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                object = (byte[][])map2.get(string2);
                stringArray = new Attr(string2, (byte[][])object);
                this.modifyPersistentObject(persistentObject, (Attr)stringArray, bl, false);
            }
        }
        persistentObject.save();
    }

    public void setAttributes(SSOToken sSOToken, String string, int n, Map map, Map map2, boolean bl) throws AMException, SSOException {
        Object object;
        Map map3 = null;
        AMEmailNotification aMEmailNotification = null;
        this.validateAttributeUniqueness(string, n, false, map);
        String string2 = string;
        if (n == 1) {
            string2 = new DN(string).getParent().toString();
        }
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        String string3 = this.amdm.getOrganizationDN(this.internalToken, string2);
        try {
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.setAttributes() entryDN: " + string);
            }
            if (n == 1) {
                object = new AMUserPasswordValidationImpl(sSOToken, string3);
                try {
                    ((AMUserPasswordValidationImpl)object).validate(map);
                }
                catch (AMException aMException) {
                    debug.error("DirectoryManager.setAttributes(): Invalid characters for user", (Throwable)aMException);
                    throw aMException;
                }
                aMEmailNotification = new AMEmailNotification(string);
                aMEmailNotification.setUserModifyNotificationList();
            }
            if (DirectoryManager.getUserPostPlugin() != null || aMEmailNotification != null && aMEmailNotification.isPresentUserModifyNotificationList()) {
                object = map.keySet();
                map3 = this.getAttributes(sSOToken, string, (Set)object, n);
            }
            map = this.processPreModifyCallBacks(sSOToken, string, map3, map, string3, n);
            this.setDCTreeAttributes(sSOToken, string, map, n);
            this.modifyAndSaveEntry(sSOToken, string, map, map2, bl);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.setAttributes() User does not have sufficient access rights: ", (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.setAttributes() Entry not found: ", (Throwable)entryNotFoundException);
            }
            String string4 = this.getEntryNotFoundMsgID(n);
            String string5 = this.getEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string5};
            throw new AMException(AMSDKBundle.getString(string4, objectArray), string4, objectArray);
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.setAttributes() Internal error occurred", (Throwable)uMSException);
            }
            this.processInternalException(sSOToken, uMSException, "452");
        }
        this.processPostModifyCallBacks(sSOToken, string, map3, map, string3, n);
        if (n == 1) {
            object = DirectoryManager.getUserPostPlugin();
            if (object != null) {
                object.processUserModify(sSOToken, string, map3, map);
            }
            if (aMEmailNotification != null && aMEmailNotification.isPresentUserModifyNotificationList()) {
                aMEmailNotification.sendUserModifyNotification(sSOToken, map, map3);
            }
        }
    }

    public String[] getGroupFilterAndScope(SSOToken sSOToken, String string, int n) throws SSOException, AMException {
        String[] stringArray = new String[3];
        try {
            DynamicGroup dynamicGroup = (DynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
            int n2 = dynamicGroup.getSearchScope();
            String string2 = dynamicGroup.getSearchBase().getDn();
            String string3 = dynamicGroup.getSearchFilter();
            stringArray[0] = Integer.toString(n2);
            stringArray[1] = string2;
            stringArray[2] = string3;
        }
        catch (EntryNotFoundException entryNotFoundException) {
            debug.error("AMGroupImpl.searchUsers", (Throwable)entryNotFoundException);
            String string4 = this.getEntryNotFoundMsgID(n);
            String string5 = this.getEntryName(entryNotFoundException);
            Object[] objectArray = new Object[]{string5};
            throw new AMException(AMSDKBundle.getString(string4, objectArray), string4, objectArray);
        }
        catch (UMSException uMSException) {
            debug.message("AMGroupImpl.searchUsers", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("341"), "341");
        }
        return stringArray;
    }

    public void setGroupFilter(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        try {
            DynamicGroup dynamicGroup = (DynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
            dynamicGroup.setSearchFilter(string2);
            dynamicGroup.save();
        }
        catch (UMSException uMSException) {
            debug.message("AMDynamicGroup.setSearchFilter() - Unable to setFilter()", (Throwable)uMSException);
            throw new AMException(sSOToken, "352", uMSException);
        }
    }

    private void modifyRoleMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        String string2;
        ManagedRole managedRole;
        try {
            managedRole = (ManagedRole)UMSObject.getObject(sSOToken, new Guid(string));
        }
        catch (ClassCastException classCastException) {
            debug.message("DirectoryManager.modifyRoleMembership() - Unable to modify role membership", (Throwable)classCastException);
            throw new AMException(sSOToken, "350");
        }
        String string3 = managedRole.getParentGuid().getDn();
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string2 = this.amdm.getOrganizationDN(sSOToken, string3)) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string2, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                Guid[] guidArray = CommonUtils.toGuidArray(set);
                managedRole.addMembers(guidArray);
                Iterator iterator = set.iterator();
                if (!this.compl.isAdminGroupsEnabled(string3)) break;
                this.compl.verifyAndLinkRoleToGroup(sSOToken, guidArray, string);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    managedRole.removeMember(new Guid((String)objectArray[n3]));
                    ++n3;
                }
                if (!this.compl.isAdminGroupsEnabled(string3)) break;
                this.compl.verifyAndUnLinkRoleToGroup(sSOToken, set, string);
                break;
            }
            default: {
                throw new AMException(sSOToken, "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string2)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string2, set, n, n2);
        }
    }

    private void modifyGroupMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        String string2;
        StaticGroup staticGroup = (StaticGroup)UMSObject.getObject(sSOToken, new Guid(string));
        String string3 = staticGroup.getParentGuid().getDn();
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string2 = this.amdm.getOrganizationDN(sSOToken, string3)) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string2, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                staticGroup.addMembers(CommonUtils.toGuidArray(set));
                this.updateUserAttribute(sSOToken, set, string, true);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    staticGroup.removeMember(new Guid((String)objectArray[n3]));
                    ++n3;
                }
                this.updateUserAttribute(sSOToken, set, string, false);
                break;
            }
            default: {
                throw new AMException(sSOToken, "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string2)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string2, set, n, n2);
        }
    }

    private void modifyAssignDynamicGroupMembership(SSOToken sSOToken, String string, Set set, int n, int n2) throws UMSException, AMException {
        String string2;
        AssignableDynamicGroup assignableDynamicGroup = new AssignableDynamicGroup();
        AssignableDynamicGroup assignableDynamicGroup2 = (AssignableDynamicGroup)UMSObject.getObject(sSOToken, new Guid(string));
        String string3 = assignableDynamicGroup2.getParentGuid().getDn();
        if (this.amdm == null) {
            this.amdm = AMDirectoryWrapper.getInstance();
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string2 = this.amdm.getOrganizationDN(sSOToken, string3)) && ((set = AMCallBackImpl.preProcessModifyMemberShip(sSOToken, string, string2, set, n, n2)) == null || set.isEmpty())) {
            return;
        }
        switch (n) {
            case 1: {
                Guid[] guidArray = CommonUtils.toGuidArray(set);
                assignableDynamicGroup2.addMembers(CommonUtils.toGuidArray(set));
                if (!this.compl.isAdminGroupsEnabled(AMStoreConnection.rootSuffix)) break;
                this.compl.verifyAndLinkGroupToRole(sSOToken, guidArray, string);
                break;
            }
            case 2: {
                Object[] objectArray = set.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    assignableDynamicGroup2.removeMember(new Guid((String)objectArray[n3]));
                    ++n3;
                }
                if (!this.compl.isAdminGroupsEnabled(AMStoreConnection.rootSuffix)) break;
                this.compl.verifyAndUnLinkGroupToRole(sSOToken, set, string);
                break;
            }
            default: {
                throw new AMException(sSOToken, "114");
            }
        }
        if (AMCallBackImpl.isExistsPrePostPlugins(string2)) {
            AMCallBackImpl.postProcessModifyMemberShip(sSOToken, string, string2, set, n, n2);
        }
    }

    private AMException generateMemberShipException(SSOToken sSOToken, String string, int n, EntryNotFoundException entryNotFoundException) {
        DN dN = this.getExceptionDN(entryNotFoundException);
        DN dN2 = new DN(string);
        if (dN == null) {
            debug.error("DirectoryManager.modMemberShip", (Throwable)entryNotFoundException);
            Object[] objectArray = new Object[]{string};
            String string2 = CommonUtils.getUserLocale(sSOToken);
            return new AMException(AMSDKBundle.getString("461", objectArray, string2), "461", objectArray);
        }
        String string3 = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
        String string4 = null;
        if (dN.equals(dN2)) {
            switch (n) {
                case 6: 
                case 7: {
                    string4 = "465";
                    break;
                }
                case 9: 
                case 10: 
                case 12: {
                    string4 = "466";
                }
            }
        } else {
            string4 = "468";
        }
        debug.error("DirectoryManager.modMemberShip() - Entry not found " + string, (Throwable)entryNotFoundException);
        Object[] objectArray = new Object[]{string3};
        return new AMException(AMSDKBundle.getString(string4, objectArray), string4, objectArray);
    }

    public void modifyMemberShip(SSOToken sSOToken, Set set, String string, int n, int n2) throws AMException {
        if (debug.messageEnabled()) {
            debug.message("DirectoryManager.modifyMemberShip: targetDN = <" + string + ">, Members: " + set + ", object Type = " + n + "Operation = " + n2);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals("") && DN.isDN((String)string2)) continue;
            debug.error("DirectoryManager.modifyMemberShip() Invalid DN: " + string2);
            throw new AMException(sSOToken, "157");
        }
        try {
            switch (n) {
                case 6: 
                case 7: {
                    this.modifyRoleMembership(sSOToken, string, set, n2, n);
                    break;
                }
                case 9: 
                case 10: {
                    this.modifyGroupMembership(sSOToken, string, set, n2, n);
                    break;
                }
                case 12: {
                    this.modifyAssignDynamicGroupMembership(sSOToken, string, set, n2, n);
                    break;
                }
                default: {
                    throw new AMException(sSOToken, "114");
                }
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("DirectoryManager.modMemberShip() - Insufficient access rights: ", (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (EntryNotFoundException entryNotFoundException) {
            throw this.generateMemberShipException(sSOToken, string, n, entryNotFoundException);
        }
        catch (UMSException uMSException) {
            debug.message("DirectoryManager.modMemberShip() - Unable to modify membership", (Throwable)uMSException);
            throw new AMException(sSOToken, "350", uMSException);
        }
    }

    public Set getRegisteredServiceNames(SSOToken sSOToken, String string) throws AMException {
        try {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add("sunRegisteredServiceName");
            Map map = this.getAttributes(this.internalToken, string, hashSet, -9999);
            Set set = Collections.EMPTY_SET;
            if (map.size() == 1) {
                set = (Set)map.get("sunRegisteredServiceName");
            }
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.getRegisteredServiceNames() Registered Service Names for entryDN: " + string + " are: " + set);
            }
            return set;
        }
        catch (Exception exception) {
            debug.error("DirectoryManager.getRegisteredService", (Throwable)exception);
            throw new AMException(sSOToken, "455");
        }
    }

    public void registerService(SSOToken sSOToken, String string, String string2) throws AMException, SSOException {
        try {
            Set set = this.getServiceAttributesWithQualifier(sSOToken, string2);
            if (set != null && !set.isEmpty()) {
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                DirectCOSDefinition directCOSDefinition = this.createCOSDefinition(string2, set);
                COSManager cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
                cOSManager.addDefinition(directCOSDefinition);
            }
        }
        catch (AccessRightsException accessRightsException) {
            debug.error("DirectoryManager.registerService() Insufficient access rights to register service: " + string2, (Throwable)accessRightsException);
            throw new AMException(sSOToken, "460");
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            debug.error("DirectoryManager.registerService() Service " + string2 + " already registered", (Throwable)entryAlreadyExistsException);
            Object[] objectArray = new Object[]{string2};
            String string3 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("464", objectArray, string3), "464", objectArray);
        }
        catch (SMSException sMSException) {
            debug.error("DirectoryManager.registerService() Unable to register service: " + string2, (Throwable)sMSException);
            throw new AMException(sSOToken, "914");
        }
        catch (UMSException uMSException) {
            debug.error("DirectoryManager.registerService() Unable to register service: " + string2, (Throwable)uMSException);
            throw new AMException(sSOToken, "914", uMSException);
        }
    }

    private Set getServiceAttributesWithQualifier(SSOToken sSOToken, String string) throws SMSException, SSOException {
        ServiceSchema serviceSchema;
        block4: {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(string, sSOToken);
            serviceSchema = null;
            try {
                serviceSchema = serviceSchemaManager.getSchema(SchemaType.DYNAMIC);
            }
            catch (SMSException sMSException) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("DirectoryManager.getServiceNames(): No schema defined for SchemaType.DYNAMIC type");
            }
        }
        if (serviceSchema == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = serviceSchema.getAttributeSchemaNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            AttributeSchema attributeSchema = serviceSchema.getAttributeSchema(string2);
            String string3 = string2 + " " + attributeSchema.getCosQualifier();
            hashSet.add(string3);
        }
        return hashSet;
    }

    private DirectCOSDefinition createCOSDefinition(String string, Set set) throws UMSException {
        AttrSet attrSet = new AttrSet();
        Attr attr = new Attr("cn", string);
        attrSet.add(attr);
        attr = new Attr("cosSpecifier", "nsrole");
        attrSet.add(attr);
        attr = new Attr("cosAttribute");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            attr.addValue(string2);
        }
        attrSet.add(attr);
        return new DirectCOSDefinition(attrSet);
    }

    public void unRegisterService(SSOToken sSOToken, String string, int n, String string2, AMTemplate aMTemplate, int n2) throws AMException {
        if (n2 == 301) {
            try {
                DirectCOSDefinition directCOSDefinition;
                PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                COSManager cOSManager = null;
                switch (n) {
                    case 6: 
                    case 8: {
                        cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getParentGuid());
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
                        break;
                    }
                    default: {
                        throw new AMException(sSOToken, "450");
                    }
                }
                try {
                    directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
                }
                catch (COSNotFoundException cOSNotFoundException) {
                    if (debug.messageEnabled()) {
                        debug.message("DirectoryManager.unRegisterService() No COSDefinition found for service: " + string2);
                    }
                    Object[] objectArray = new Object[]{string2};
                    String string3 = CommonUtils.getUserLocale(sSOToken);
                    throw new AMException(AMSDKBundle.getString("463", objectArray, string3), "463", objectArray);
                }
                directCOSDefinition.removeCOSTemplates();
                cOSManager.removeDefinition(string2);
            }
            catch (AccessRightsException accessRightsException) {
                debug.error("DirectoryManager.unRegisterService() Insufficient Access rights to unRegister service: ", (Throwable)accessRightsException);
                throw new AMException(sSOToken, "460");
            }
            catch (UMSException uMSException) {
                debug.error("DirectoryManager.unRegisterService: Unable to unregister service ", (Throwable)uMSException);
                throw new AMException(sSOToken, "855", uMSException);
            }
        }
        if (n2 == 302) {
            try {
                aMTemplate.delete();
            }
            catch (SSOException sSOException) {
                debug.error("DirectoryManager.unRegisterService: Unable to unregister service ", (Throwable)sSOException);
                throw new AMException(sSOToken, "855");
            }
        }
    }

    public String getAMTemplateDN(SSOToken sSOToken, String string, int n, String string2, int n2) throws AMException {
        String string3 = null;
        try {
            switch (n) {
                case 6: 
                case 8: {
                    string3 = string;
                    PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
                    return "cn=\"" + string3 + "\",cn=" + string2 + "," + persistentObject.getParentGuid().toString();
                }
                case 2: 
                case 3: 
                case 5: {
                    string3 = "cn=ContainerDefaultTemplateRole," + string;
                    return "cn=\"" + string3 + "\",cn=" + string2 + "," + string;
                }
            }
            throw new AMException(sSOToken, "450");
        }
        catch (UMSException uMSException) {
            debug.error("DirectoryManager.getAMTemplateDN() Unable to get AMTemplate DN for service: " + string2 + " entryDN: " + string, (Throwable)uMSException);
            throw new AMException(sSOToken, "349", uMSException);
        }
    }

    public String createAMTemplate(SSOToken sSOToken, String string, int n, String string2, Map map, int n2) throws AMException {
        COSManager cOSManager = null;
        DirectCOSDefinition directCOSDefinition = null;
        String string3 = null;
        try {
            Serializable serializable;
            PersistentObject persistentObject = UMSObject.getObjectHandle(sSOToken, new Guid(string));
            switch (n) {
                case 6: 
                case 8: {
                    string3 = string;
                    cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getParentGuid());
                    directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string3 = "cn=ContainerDefaultTemplateRole," + string;
                    cOSManager = COSManager.getCOSManager(sSOToken, persistentObject.getGuid());
                    directCOSDefinition = (DirectCOSDefinition)cOSManager.getDefinition(string2);
                    break;
                }
                default: {
                    throw new AMException(sSOToken, "450");
                }
            }
            AttrSet attrSet = CommonUtils.mapToAttrSet(map);
            if (n2 != -1) {
                serializable = new Attr("cospriority");
                ((Attr)serializable).addValue("" + n2);
                attrSet.add((Attr)serializable);
            }
            serializable = this.createCOSTemplate(string2, attrSet, string3);
            directCOSDefinition.addCOSTemplate((COSTemplate)serializable);
            return ((PersistentObject)serializable).getGuid().toString();
        }
        catch (COSNotFoundException cOSNotFoundException) {
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.createAMTemplate() COSDefinition for service: " + string2 + " not found: ", (Throwable)cOSNotFoundException);
            }
            Object[] objectArray = new Object[]{string2};
            String string4 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("459", string4), "459", objectArray);
        }
        catch (EntryAlreadyExistsException entryAlreadyExistsException) {
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.createAMTemplate: template already exists for " + string2, (Throwable)entryAlreadyExistsException);
            }
            Object[] objectArray = new String[]{string2};
            String string5 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("854", objectArray, string5), "854", objectArray);
        }
        catch (AccessRightsException accessRightsException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createAMTemplate() Insufficient access rights to create template for: " + string2 + " & entryDN: " + string, (Throwable)accessRightsException);
            }
            throw new AMException(sSOToken, "460");
        }
        catch (UMSException uMSException) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createAMTemplate() Unable to create AMTemplate for: " + string2 + " & entryDN: " + string, (Throwable)uMSException);
            }
            Object[] objectArray = new Object[]{string2};
            String string6 = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("459", string6), "459", objectArray, uMSException);
        }
        catch (Exception exception) {
            if (debug.warningEnabled()) {
                debug.warning("DirectoryManager.createAMTemplate", (Throwable)exception);
            }
            throw new AMException(sSOToken, "451");
        }
    }

    private COSTemplate createCOSTemplate(String string, AttrSet attrSet, String string2) throws UMSException {
        TemplateManager templateManager = TemplateManager.getTemplateManager();
        CreationTemplate creationTemplate = templateManager.getCreationTemplate("BasicCOSTemplate", null);
        COSTemplate cOSTemplate = new COSTemplate(creationTemplate, "\"" + string2 + "\"");
        cOSTemplate.addTemplateAttribute("objectclass", "extensibleObject");
        if (debug.messageEnabled()) {
            debug.message("DirectoryManager.newCOSTemplate: cn = " + string2 + " COSTemplate = " + cOSTemplate);
        }
        int n = attrSet.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = attrSet.elementAt(n2);
            cOSTemplate.modify(attr, 0);
            ++n2;
        }
        return cOSTemplate;
    }

    public String getNamingAttr(int n, String string) {
        try {
            String string2;
            if (templateMgr == null) {
                templateMgr = TemplateManager.getTemplateManager();
            }
            if ((string2 = this.getCreationTemplateName(n)) == null) {
                debug.warning("AMNamingAttrMgr.getNamingAttr(objectType, orgDN): (" + n + "," + string + ")Could not " + "determine creation template name. Returning <empty> " + "value");
                return "";
            }
            Guid guid = string == null ? null : new Guid(string);
            CreationTemplate creationTemplate = templateMgr.getCreationTemplate(string2, guid, 1);
            String string3 = creationTemplate.getNamingAttribute();
            if (string3 == null) {
                debug.error("AMNamingAttrManager.getNamingAttr() Naming attribute for Object Type:" + n + " Org DN: " + string + " is null");
            } else if (debug.messageEnabled()) {
                debug.message("AMNamingAttrManager.getNamingAttr(): Naming attribute for Object type= " + n + ": " + string3);
            }
            return string3;
        }
        catch (UMSException uMSException) {
            String string4 = this.getDefaultNamingAttr(n);
            debug.warning("Unable to get the naming attribute for " + n + " Using default " + string4);
            return string4;
        }
    }

    private String getDefaultNamingAttr(int n) {
        switch (n) {
            case 1: {
                return "uid";
            }
            case 6: {
                return "cn";
            }
            case 8: {
                return "cn";
            }
            case 9: {
                return "cn";
            }
            case 12: {
                return "cn";
            }
            case 11: {
                return "cn";
            }
            case 2: {
                return DEFAULT_ORG_NAMING_ATTR;
            }
            case 5: {
                return "ou";
            }
            case 3: {
                return "ou";
            }
            case 4: {
                return "ou";
            }
            case 21: {
                return "uid";
            }
        }
        debug.warning("AMNamingAttrMgr.getDefaultNamingAttr(): Unknown object type is passed. Returning <empty> value");
        return "";
    }

    public String getCreationTemplateName(int n) {
        String string = (String)CommonUtils.creationtemplateMap.get(Integer.toString(n));
        if (string != null) {
            return string;
        }
        switch (n) {
            case 1: {
                return USER_CREATION_TEMPLATE;
            }
            case 6: {
                return MANAGED_ROLE_CREATION_TEMPLATE;
            }
            case 8: {
                return FILTERED_ROLE_CREATION_TEMPLATE;
            }
            case 9: {
                return GROUP_CREATION_TEMPLATE;
            }
            case 12: {
                return ASSIGANABLE_DYNAMIC_GROUP_CREATION_TEMPLATE;
            }
            case 11: {
                return DYNAMIC_GROUP_CREATION_TEMPLATE;
            }
            case 2: {
                return ORGANIZATION_CREATION_TEMPLATE;
            }
            case 5: {
                return PEOPLE_CONTAINTER_CREATION_TEMPLATE;
            }
            case 3: {
                return ORGANIZATIONAL_UNIT_CREATION_TEMPLATE;
            }
            case 4: {
                return GROUP_CONTAINER_CREATION_TEMPLATE;
            }
            case 21: {
                return RESOURCE_CREATION_TEMPLATE;
            }
        }
        debug.warning("AMNamingAttrMgr.getCreationTemplateName(): Unknown object type is passed. Returning null value");
        return null;
    }

    public String getObjectClassFromDS(int n) {
        String string = AMSearchFilterManager.getGlobalSearchFilter(n);
        String string2 = "objectclass=";
        int n2 = string.indexOf(string2);
        String string3 = null;
        if (n2 != -1) {
            int n3 = n2 + string2.length();
            int n4 = string.indexOf(41, n3);
            if (n4 != -1) {
                string3 = string.substring(n3, n4);
            }
        } else {
            string3 = DirectoryManager.getDefaultObjectClass(n);
        }
        return string3.toLowerCase();
    }

    private static String getDefaultObjectClass(int n) {
        switch (n) {
            case 1: {
                return DEFAULT_USER_OBJECT_CLASS;
            }
            case 6: {
                return DEFAULT_ROLE_OBJECT_CLASS;
            }
            case 8: {
                return DEFAULT_FILTERED_ROLE_OBJECT_CLASS;
            }
            case 9: {
                return DEFAULT_GROUP_OBJECT_CLASS;
            }
            case 12: {
                return DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_OBJECT_CLASS;
            }
            case 11: {
                return DEFAULT_DYNAMIC_GROUP_OBJECT_CLASS;
            }
            case 2: {
                return DEFAULT_ORGANIZATION_OBJECT_CLASS;
            }
            case 5: {
                return DEFAULT_PEOPLE_CONTAINER_OBJECT_CLASS;
            }
            case 3: {
                return DEFAULT_ORGANIZATIONAL_UNIT_OBJECT_CLASS;
            }
            case 4: {
                return DEFAULT_GROUP_CONTAINER_OBJECT_CLASS;
            }
            case 21: {
                return DEFAULT_RESOURCE_OBJECT_CLASS;
            }
        }
        return "";
    }

    public Set getAttributesForSchema(String string) {
        try {
            SchemaManager schemaManager = SchemaManager.getSchemaManager(this.internalToken);
            return new HashSet(schemaManager.getAttributes(string));
        }
        catch (UMSException uMSException) {
            return Collections.EMPTY_SET;
        }
    }

    public String getSearchFilterFromTemplate(int n, String string, String string2) {
        String string3;
        SearchTemplate searchTemplate = null;
        try {
            String string4;
            String string5 = string4 = string2 == null ? DirectoryManager.getSearchTemplateName(n) : string2;
            if (string4 == null) {
                debug.warning("AMSearchFilterManager.getSearchFilterFromTemplate(): Search template name is nullUnable to retrieve search filter. Returning <empty> value.");
                return "";
            }
            TemplateManager templateManager = TemplateManager.getTemplateManager();
            Guid guid = string == null ? null : new Guid(string);
            searchTemplate = templateManager.getSearchTemplate(string4, guid, 2);
            string3 = searchTemplate.getSearchFilter();
        }
        catch (UMSException uMSException) {
            string3 = "(objectclass=*)";
        }
        if (!string3.startsWith("(") || !string3.endsWith(")")) {
            string3 = "(" + string3 + ")";
        }
        if (debug.messageEnabled()) {
            debug.message("AMSearchFilterManager.getSearchFilterFromTemplate() SearchTemplate Name = " + searchTemplate.getName() + ", objectType = " + n + ", orgDN = " + string + ", Obtained Filter = " + searchTemplate.getSearchFilter() + ", Modified Filter = " + string3);
        }
        return string3;
    }

    private static String modifyFilter(String string, int n) {
        switch (n) {
            case 6: 
            case 8: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(&").append(string);
                stringBuffer.append("(objectClass=ldapsubentry)").append("(!(cn=");
                stringBuffer.append("ContainerDefaultTemplateRole");
                stringBuffer.append(")))");
                return stringBuffer.toString();
            }
        }
        return string;
    }

    private static String getDefaultSearchFilter(int n) {
        switch (n) {
            case 1: {
                return DEFAULT_USER_SEARCH_FILTER;
            }
            case 6: {
                return DEFAULT_ROLE_SEARCH_FILTER;
            }
            case 8: {
                return DEFAULT_FILTERED_ROLE_SEARCH_FILTER;
            }
            case 9: {
                return DEFAULT_GROUP_SEARCH_FILTER;
            }
            case 12: {
                return DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_SEARCH_FILTER;
            }
            case 11: {
                return DEFAULT_DYNAMIC_GROUP_SEARCH_FILTER;
            }
            case 2: {
                return DEFAULT_ORGANIZATION_SEARCH_FILTER;
            }
            case 5: {
                return DEFAULT_PEOPLE_CONTAINER_SEARCH_FILTER;
            }
            case 3: {
                return DEFAULT_ORGANIZATIONAL_UNIT_SEARCH_FILTER;
            }
            case 4: {
                return DEFAULT_GROUP_CONTAINER_SEARCH_FILTER;
            }
        }
        debug.warning("AMSearchFilterManager.getDefaultSearchFilter(): Unknown object type is passed. Returning <empty> value");
        return "";
    }

    private static String getSearchTemplateName(int n) {
        String string = (String)CommonUtils.searchtemplateMap.get(Integer.toString(n));
        if (string != null) {
            return string;
        }
        switch (n) {
            case 1: {
                return USER_SEARCH_TEMPLATE;
            }
            case 6: {
                return ROLE_SEARCH_TEMPLATE;
            }
            case 8: {
                return FILTERED_ROLE_SEARCH_TEMPLATE;
            }
            case 9: {
                return GROUP_SEARCH_TEMPLATE;
            }
            case 11: {
                return DYNAMIC_GROUP_SEARCH_TEMPLATE;
            }
            case 2: {
                return ORGANIZATION_SEARCH_TEMPLATE;
            }
            case 5: {
                return PEOPLE_CONTAINER_SEARCH_TEMPLATE;
            }
            case 3: {
                return ORGANIZATIONAL_UNIT_SEARCH_TEMPLATE;
            }
            case 12: {
                return ASSIGNABLE_DYNAMIC_GROUP_SEARCH_TEMPLATE;
            }
            case 4: {
                return GROUP_CONTAINER_SEARCH_TEMPLATE;
            }
            case 21: {
                return RESOURCE_SEARCH_TEMPLATE;
            }
        }
        debug.warning("AMSearchFilterManager.getSearchTemplateName(): Unknown object type is passed. Returning null value");
        return null;
    }

    void validateAttributeUniqueness(String string, int n, boolean bl, Map map) throws AMException {
        block32: {
            boolean bl2 = false;
            if (map == null || map.isEmpty()) {
                return;
            }
            try {
                if (n == 301 || n == 302 || n == 300) {
                    return;
                }
                DN dN = new DN(string);
                String string2 = ((RDN)dN.getRDNs().firstElement()).getValues()[0];
                String[] stringArray = dN.explodeDN(false);
                int n2 = stringArray.length;
                if (n2 < 2) {
                    return;
                }
                String string3 = stringArray[n2 - 1];
                AMStoreConnection aMStoreConnection = new AMStoreConnection(CommonUtils.getInternalToken());
                DN dN2 = new DN(AMStoreConnection.rootSuffix);
                DN dN3 = new DN(string3);
                int n3 = n2 - 2;
                while (n3 >= 0) {
                    Object object;
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.validateAttributeUniqueness: try DN = " + string3);
                    }
                    int n4 = -1;
                    if (!dN2.isDescendantOf(dN3)) {
                        try {
                            n4 = aMStoreConnection.getAMObjectType(string3);
                        }
                        catch (AMException aMException) {
                            if (debug.warningEnabled()) {
                                debug.warning("AMObjectImpl.validateAttributeUniqueness: Unable to determine object type of " + string3 + " :Attribute uniqueness check aborted..", (Throwable)aMException);
                            }
                            return;
                        }
                    }
                    Set set = null;
                    AMObject aMObject = null;
                    if (n4 == 2) {
                        object = aMStoreConnection.getOrganization(string3);
                        set = object.getAttribute("sunnamespaceuniqueattrs");
                        aMObject = object;
                    } else if (n4 == 3) {
                        object = aMStoreConnection.getOrganizationalUnit(string3);
                        set = object.getAttribute("sunnamespaceuniqueattrs");
                        aMObject = object;
                    }
                    if (set != null && !set.isEmpty()) {
                        Object object2;
                        Object object3;
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.validateAttributeUniqueness: list = " + set);
                        }
                        object = set.iterator();
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        stringBuffer.append("(|");
                        while (object.hasNext()) {
                            object3 = this.getAttrList((String)object.next());
                            object2 = this.getAttrValues((String[])object3, map);
                            int n5 = 0;
                            while (n5 < ((String[])object3).length) {
                                String string4 = object3[n5];
                                if (string4.equals(AMNamingAttrManager.getNamingAttr(n)) && bl) {
                                    if (n == 6 || n == 7 || n == 8) {
                                        stringBuffer2.append("(&");
                                        stringBuffer2.append("(objectclass=ldapsubentry)");
                                        stringBuffer2.append("(objectclass=nsroledefinition)");
                                        bl2 = true;
                                    } else if (n == 9 || n == 10 || n == 12 || n == 11) {
                                        stringBuffer2.append("(&");
                                        stringBuffer2.append("(objectclass=iplanet-am-managed-group)");
                                        stringBuffer2.append(DEFAULT_GROUP_SEARCH_FILTER);
                                        bl2 = true;
                                    } else if (n == 2) {
                                        stringBuffer2.append("(&(!");
                                        stringBuffer2.append("(objectclass=");
                                        stringBuffer2.append("sunRealmService");
                                        stringBuffer2.append("))");
                                        bl2 = true;
                                    }
                                    stringBuffer.append("(").append(stringArray[0]).append(")");
                                }
                                if (object2 != null && !object2.isEmpty()) {
                                    Iterator iterator = object2.iterator();
                                    while (iterator.hasNext()) {
                                        stringBuffer.append("(").append(string4);
                                        stringBuffer.append("=").append((String)iterator.next());
                                        stringBuffer.append(")");
                                    }
                                }
                                ++n5;
                            }
                        }
                        if (stringBuffer.length() > 2) {
                            DN dN4;
                            if (bl2) {
                                stringBuffer2.append(stringBuffer.toString()).append("))");
                                stringBuffer = stringBuffer2;
                            } else {
                                stringBuffer.append(")");
                            }
                            if (debug.messageEnabled()) {
                                debug.message("AMObjectImpl.validateAttributeUniqueness: filter = " + stringBuffer.toString());
                            }
                            if ((object3 = aMObject.search(2, stringBuffer.toString())) != null && object3.size() == 1 && (dN4 = new DN((String)(object2 = (String)object3.iterator().next()))).equals(new DN(string))) {
                                return;
                            }
                            if (object3 != null && !object3.isEmpty()) {
                                throw new AMException(AMSDKBundle.getString("162"), "162");
                            }
                        }
                    }
                    string3 = stringArray[n3] + "," + string3;
                    dN3 = new DN(string3);
                    --n3;
                }
            }
            catch (SSOException sSOException) {
                if (!debug.warningEnabled()) break block32;
                debug.warning("Unable to validate attribute uniqneness", (Throwable)sSOException);
            }
        }
    }

    private String[] getAttrList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringTokenizer.nextToken();
            stringArray[n2] = string2.trim();
            ++n2;
        }
        return stringArray;
    }

    private Set getAttrValues(String[] stringArray, Map map) {
        HashSet hashSet = new HashSet();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set set = (Set)map.get(stringArray[n2]);
            if (set != null && !set.isEmpty()) {
                hashSet.addAll(set);
            }
            ++n2;
        }
        return hashSet;
    }

    public Set getTopLevelContainers(SSOToken sSOToken) throws AMException, SSOException {
        Object object;
        Object object2;
        HashSet<Object> hashSet;
        String string = sSOToken.getPrincipal().getName();
        AMStoreConnection aMStoreConnection = new AMStoreConnection(this.internalToken);
        AMUser aMUser = aMStoreConnection.getUser(string);
        Set set = new HashSet();
        Set set2 = aMUser.getRoleDNs();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            hashSet = (String)iterator.next();
            if (debug.messageEnabled()) {
                debug.message("DirectoryManager.getTopLevelContainers: roleDN=" + (String)((Object)hashSet));
            }
            object2 = aMStoreConnection.getRole((String)((Object)hashSet));
            set.addAll(object2.getAttribute("iplanet-am-role-managed-container-dn"));
        }
        if (set.isEmpty()) {
            hashSet = "(|" + AMSearchFilterManager.getGlobalSearchFilter(2) + AMSearchFilterManager.getGlobalSearchFilter(3) + AMSearchFilterManager.getGlobalSearchFilter(5) + AMSearchFilterManager.getGlobalSearchFilter(11) + AMSearchFilterManager.getGlobalSearchFilter(12) + AMSearchFilterManager.getGlobalSearchFilter(9) + ")";
            set = this.search(sSOToken, AMStoreConnection.rootSuffix, (String)((Object)hashSet), 2);
        }
        hashSet = new HashSet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = new DN((String)object2);
            Iterator iterator2 = hashSet.iterator();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            boolean bl = true;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                DN dN = new DN(string2);
                if (object.isDescendantOf(dN)) {
                    bl = false;
                    hashSet2.add(string2);
                    break;
                }
                if (dN.isDescendantOf(object)) continue;
                hashSet2.add(string2);
            }
            if (bl) {
                hashSet2.add(object2);
            }
            hashSet = hashSet2;
        }
        if (debug.messageEnabled()) {
            debug.message("DirectoryManager.getTopLevelContainers");
            iterator = hashSet.iterator();
            object2 = new StringBuffer();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                ((StringBuffer)object2).append((String)object).append("\n");
            }
            debug.message("containerDNs\n" + ((StringBuffer)object2).toString());
        }
        return hashSet;
    }

    public String verifyAndGetOrgDN(SSOToken sSOToken, String string, String string2) throws AMException {
        Object object;
        boolean bl;
        String string3;
        block8: {
            if (string.equals("") || !DN.isDN((String)string)) {
                debug.error("DirectoryManager.verifyAndGetOrgDN() Invalid DN: " + string);
                throw new AMException(sSOToken, "157");
            }
            string3 = null;
            bl = false;
            try {
                object = UMSObject.getObjectHandle(this.internalToken, new Guid(string2));
                String string4 = this.getOrgSearchFilter(string);
                SearchResults searchResults = ((PersistentObject)object).search(string4, this.aName, this.scontrol);
                if (searchResults.hasMoreElements()) {
                    while (searchResults.hasMoreElements()) {
                        searchResults.next();
                    }
                    string3 = ((PersistentObject)object).getGuid().toString().toLowerCase();
                }
            }
            catch (InvalidSearchFilterException invalidSearchFilterException) {
                bl = true;
                debug.error("DirectoryManager.verifyAndGetOrgDN(): Invalid search filter, unable to get Parent Organization: ", (Throwable)invalidSearchFilterException);
            }
            catch (UMSException uMSException) {
                bl = true;
                if (debug.warningEnabled()) {
                    debug.warning("DirectoryManager.verifyAndGetOrgDN(): Unable to Obtain Parent Organization", (Throwable)uMSException);
                }
                LDAPException lDAPException = (LDAPException)uMSException.getRootCause();
                int n = lDAPException.getLDAPResultCode();
                if (!retryErrorCodes.contains("" + n)) break block8;
                throw new AMException(sSOToken, Integer.toString(n));
            }
        }
        if (bl) {
            object = CommonUtils.getUserLocale(sSOToken);
            throw new AMException(AMSDKBundle.getString("124", (String)object), "124");
        }
        return string3;
    }

    public void addListener(SSOToken sSOToken, AMObjectListener aMObjectListener, Map map) throws AMEventManagerException {
        try {
            SSOTokenManager.getInstance().validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new AMEventManagerException(sSOException.getMessage(), "902");
        }
        Map map2 = listeners;
        synchronized (map2) {
            listeners.put(aMObjectListener, map);
            if (eventManager == null) {
                eventManager = new AMEventManager(listeners);
                eventManager.start();
            }
        }
    }

    public void assignService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map, String string3, String string4) throws IdRepoException, SSOException {
    }

    public AMIdentity create(SSOToken sSOToken, IdType idType, String string, Map map, String string2) throws IdRepoException, SSOException {
        return null;
    }

    public void delete(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
    }

    public Set getAssignedServices(SSOToken sSOToken, IdType idType, String string, Map map, String string2, String string3) throws IdRepoException, SSOException {
        return null;
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3) throws IdRepoException, SSOException {
        return null;
    }

    public Map getAttributes(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws IdRepoException, SSOException {
        return null;
    }

    public Set getMembers(SSOToken sSOToken, IdType idType, String string, String string2, IdType idType2, String string3) throws IdRepoException, SSOException {
        return null;
    }

    public Set getMemberships(SSOToken sSOToken, IdType idType, String string, IdType idType2, String string2, String string3) throws IdRepoException, SSOException {
        return null;
    }

    public Map getServiceAttributes(SSOToken sSOToken, IdType idType, String string, String string2, Set set, String string3, String string4) throws IdRepoException, SSOException {
        return null;
    }

    public Set getSupportedOperations(SSOToken sSOToken, IdType idType, String string) throws IdRepoException, SSOException {
        return null;
    }

    public Set getSupportedTypes(SSOToken sSOToken, String string) throws IdRepoException, SSOException {
        return null;
    }

    public boolean isExists(SSOToken sSOToken, IdType idType, String string, String string2) throws SSOException, IdRepoException {
        return false;
    }

    public boolean isActive(SSOToken sSOToken, IdType idType, String string, String string2, String string3) throws SSOException, IdRepoException {
        return false;
    }

    public void modifyMemberShip(SSOToken sSOToken, IdType idType, String string, Set set, IdType idType2, int n, String string2) throws IdRepoException, SSOException {
    }

    public void modifyService(SSOToken sSOToken, IdType idType, String string, String string2, SchemaType schemaType, Map map, String string3, String string4) throws IdRepoException, SSOException {
    }

    public void removeAttributes(SSOToken sSOToken, IdType idType, String string, Set set, String string2, String string3) throws IdRepoException, SSOException {
    }

    public IdSearchResults search(SSOToken sSOToken, IdType idType, String string, IdSearchControl idSearchControl, String string2) throws IdRepoException, SSOException {
        return null;
    }

    public IdSearchResults search(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, int n, int n2, Set set, String string2) throws IdRepoException, SSOException {
        return null;
    }

    public void setAttributes(SSOToken sSOToken, IdType idType, String string, Map map, boolean bl, String string2, String string3) throws IdRepoException, SSOException {
    }

    public void unassignService(SSOToken sSOToken, IdType idType, String string, String string2, Map map, String string3, String string4) throws IdRepoException, SSOException {
    }

    static {
        listeners = new HashMap();
        String string = SystemProperties.get((String)LDAP_CONNECTION_ERROR_CODES);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                retryErrorCodes.add(stringTokenizer.nextToken().trim());
            }
        }
    }
}

