/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.DCTreeInterface;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.Compliance;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.Guid;
import com.iplanet.ums.Organization;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.dctree.DomainComponent;
import com.iplanet.ums.dctree.DomainComponentTree;
import com.iplanet.ums.dctree.InvalidDCRootException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class DCTree
implements AMConstants,
DCTreeInterface {
    private static String dcTreeStartDN = null;
    private static final String IPLANET_DOMAIN_NAME_ATTR = "sunPreferredDomain";
    private static final String INET_CANONICAL_DOMAIN = "inetcanonicaldomainname";
    private static final String DOMAIN_BASE_DN = "inetDomainBaseDN";
    private static Map domainMap;
    private static Map canonicalDomainMap;
    private static Debug debug;
    private static Object lock;

    public boolean isRequired() throws AMException {
        try {
            Object object;
            if (Compliance.gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", CommonUtils.getInternalToken());
                Compliance.gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            object = Compliance.gsc.getAttributeDefaults();
            Set set = (Set)object.get("iplanet-am-admin-console-dctree");
            boolean bl = false;
            if (set == null || set.isEmpty()) {
                bl = false;
            } else {
                String string = (String)set.iterator().next();
                bl = string.equalsIgnoreCase("true");
            }
            return bl;
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("354"), (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("354"), "354");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("345"), (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("354"), "354");
        }
    }

    protected void createDomain(SSOToken sSOToken, Guid guid, AttrSet attrSet) throws AMException {
        if (dcTreeStartDN == null) {
            throw new AMException(AMSDKBundle.getString("355"), "355");
        }
        String string = attrSet.getValue(IPLANET_DOMAIN_NAME_ATTR);
        attrSet.remove(IPLANET_DOMAIN_NAME_ATTR);
        if (string != null && string != "") {
            try {
                AttrSet[] attrSetArray;
                DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
                domainComponentTree.addDomain(string);
                domainComponentTree.setDomainMapping(string, guid);
                String string2 = attrSet.getValue("inetdomainstatus");
                if (string2 != null) {
                    domainComponentTree.setDomainStatus(string, string2);
                }
                if ((attrSetArray = this.splitAttrSet(guid.getDn(), attrSet))[1] != null) {
                    this.setDomainAttributes(sSOToken, guid.getDn(), attrSetArray[1]);
                }
            }
            catch (InvalidDCRootException invalidDCRootException) {
                debug.error("DCTree.createDomain(): ", (Throwable)invalidDCRootException);
                throw new AMException(AMSDKBundle.getString("343"), "343");
            }
            catch (UMSException uMSException) {
                debug.error("DCTree.createDomain(): ", (Throwable)uMSException);
                throw new AMException(AMSDKBundle.getString("344"), "344");
            }
        }
    }

    protected void createDomain(SSOToken sSOToken, Guid guid, String string, AttrSet attrSet) throws AMException {
        if (dcTreeStartDN == null) {
            throw new AMException(AMSDKBundle.getString("355"), "355");
        }
        if (string != null && string != "") {
            try {
                DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
                domainComponentTree.addDomain(string);
                domainComponentTree.setDomainMapping(string, guid);
                String string2 = attrSet.getValue("inetdomainstatus");
                if (string2 != null) {
                    domainComponentTree.setDomainStatus(string, string2);
                }
            }
            catch (InvalidDCRootException invalidDCRootException) {
                debug.error("DCTree.createDomain(): ", (Throwable)invalidDCRootException);
                throw new AMException(AMSDKBundle.getString("343"), "343");
            }
            catch (UMSException uMSException) {
                debug.error("DCTree.createDomain(): ", (Throwable)uMSException);
                throw new AMException(AMSDKBundle.getString("344"), "344");
            }
        }
    }

    protected void removeDomain(SSOToken sSOToken, String string) throws AMException {
        block9: {
            try {
                PersistentObject persistentObject = UMSObject.getObject(sSOToken, new Guid(string));
                if (!(persistentObject instanceof Organization)) {
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.removeDomain-> " + string + " is not an organization");
                    }
                    return;
                }
                String string2 = this.getCanonicalDomain(sSOToken, string);
                if (debug.messageEnabled()) {
                    debug.message("DCTree.removeDomain-> Obtained canon domain " + string2);
                }
                if (string2 != null && string2.length() > 0) {
                    DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.removeDomain: removing domain: " + string2);
                    }
                    domainComponentTree.removeDomain(string2);
                } else if (debug.warningEnabled()) {
                    debug.warning("DCTree.removeDomain():  unable to get domain for " + string);
                }
            }
            catch (UMSException uMSException) {
                if (!debug.warningEnabled()) break block9;
                debug.warning("DCTree.removeDomain(): ", (Throwable)uMSException);
            }
        }
    }

    protected void updateDomainStatus(SSOToken sSOToken, String string, String string2) throws AMException {
        String[] stringArray = new String[]{IPLANET_DOMAIN_NAME_ATTR};
        try {
            String string3 = this.getCanonicalDomain(sSOToken, string);
            if (string3 != null && string3.length() > 0) {
                DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
                domainComponentTree.setDomainStatus(string3, string2);
            } else {
                debug.warning("DCTree.updateDomainStatus(): value for sunPreferredDomain attribute null or empty");
            }
        }
        catch (UMSException uMSException) {
            debug.error("DCTree.removeDomain(): ", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("356"), "356");
        }
    }

    protected void setDomainAttributes(SSOToken sSOToken, String string, AttrSet attrSet) throws AMException {
        String string2 = null;
        try {
            string2 = this.getCanonicalDomain(sSOToken, string);
            DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
            if (string2 == null) {
                if (debug.messageEnabled()) {
                    debug.message("DCTree.setDomainAttrs: No domain found for org : " + string);
                }
                return;
            }
            DomainComponent domainComponent = domainComponentTree.getDomainComponent(string2);
            if (attrSet != null) {
                Attr attr;
                if (debug.messageEnabled()) {
                    debug.message("DCTree.setDomainAttrs:  setting attributes on domain " + string2 + ": " + attrSet.toString());
                }
                if ((attr = attrSet.getAttribute("objectclass")) != null) {
                    Attr attr2 = domainComponent.getAttribute("objectclass");
                    if (attr2 != null) {
                        attr.addValues(attr2.getStringValues());
                    }
                    if (debug.messageEnabled()) {
                        debug.message("DCTree.setDomainAttrs-> objectclasses to be set " + attr.toString());
                    }
                    if (attr.size() == 0) {
                        domainComponent.modify(attr, 1);
                    } else {
                        domainComponent.modify(attr, 2);
                    }
                    domainComponent.save();
                    attrSet.remove("objectclass");
                }
                int n = attrSet.size();
                int n2 = 0;
                while (n2 < n) {
                    Attr attr3 = attrSet.elementAt(n2);
                    if (attr3.size() == 0) {
                        domainComponent.modify(attr3, 1);
                    } else {
                        domainComponent.modify(attr3, 2);
                    }
                    ++n2;
                }
                domainComponent.save();
            }
        }
        catch (UMSException uMSException) {
            debug.error("DCTree.setDomainAttributes:  error setting  attribute for domain " + string2, (Throwable)uMSException);
        }
    }

    protected String getDCNodeDN(SSOToken sSOToken, String string) throws AMException {
        try {
            String string2 = this.getCanonicalDomain(sSOToken, string);
            if (string2 != null) {
                DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
                String string3 = domainComponentTree.mapDomainToDN(string2);
                return CommonUtils.formatToRFC(string3);
            }
            return null;
        }
        catch (InvalidDCRootException invalidDCRootException) {
            debug.error("DCTree.getDCNodeDN(): Invalid DC root ", (Throwable)invalidDCRootException);
            throw new AMException(AMSDKBundle.getString("343"), "343");
        }
        catch (UMSException uMSException) {
            debug.error("DCTree.getDCNodeDN(): Unable to get dc node dn for: " + string, (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("344"), "344");
        }
    }

    protected AttrSet getDomainAttributes(SSOToken sSOToken, String string, String[] stringArray) throws AMException {
        String string2 = null;
        try {
            string2 = this.getCanonicalDomain(sSOToken, string);
            if (string2 == null) {
                debug.error("DCTree.getDomainAttributes-> Domain not found for:  " + string);
                return null;
            }
            DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
            DomainComponent domainComponent = domainComponentTree.getDomainComponent(string2);
            AttrSet attrSet = stringArray != null ? domainComponent.getAttributes(stringArray) : domainComponent.getAttributes(domainComponent.getAttributeNames());
            AttrSet[] attrSetArray = this.splitAttrSet(null, attrSet);
            return attrSetArray[1];
        }
        catch (UMSException uMSException) {
            debug.error("DCTree.getDomainAttributes:  error getting attributes for domain " + string2);
            return null;
        }
    }

    public String getOrganizationDN(SSOToken sSOToken, String string) throws AMException {
        try {
            DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
            Hashtable hashtable = domainComponentTree.getChildDomainIDs();
            if (debug.messageEnabled()) {
                debug.message("DCTree:getOrgDN-> domain=" + string);
            }
            return (String)hashtable.get(string);
        }
        catch (UMSException uMSException) {
            debug.error("DCTree:getOrganizationDN: UMS Exception: ", (Throwable)uMSException);
            throw new AMException(AMSDKBundle.getString("1000"), "1000");
        }
    }

    protected AttrSet[] splitAttrSet(String string, AttrSet attrSet) throws AMException {
        AttrSet[] attrSetArray = new AttrSet[]{attrSet != null ? (AttrSet)attrSet.clone() : new AttrSet(), new AttrSet()};
        if (attrSet == null) {
            return attrSetArray;
        }
        Set set = this.dcNodeAttributes();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Attr attr;
            String string2 = (String)iterator.next();
            int n = string2.indexOf("objectclass=");
            if (n > -1) {
                attr = attrSet.getAttribute("objectclass");
                Attr attr2 = attr != null ? (Attr)attr.clone() : null;
                String string3 = string2.substring("objectclass=".length());
                Attr attr3 = new Attr("objectclass");
                if (attr2 == null || !attr2.contains(string3)) continue;
                attr2.removeValue(string3);
                attr3.addValue(string3);
                attrSetArray[0].replace(attr2);
                attrSetArray[1].add(attr3);
                continue;
            }
            attr = attrSet.getAttribute(string2);
            if (attr == null) continue;
            attrSetArray[1].add(attr);
            attrSetArray[0].remove(string2);
        }
        if (debug.messageEnabled()) {
            debug.message("Compliance.splitAttrSet: domain attrset = " + attrSetArray[1].toString());
            debug.message("Compliance.splitAttrSet: non-domain attrset = " + attrSetArray[0].toString());
        }
        return attrSetArray;
    }

    protected String getCanonicalDomain(SSOToken sSOToken, String string) throws AMException {
        String string2 = new DN(string).toRFCString().toLowerCase();
        return this.updateCacheAndReturnDomain(sSOToken, string2);
    }

    public void cleanDomainMap(String string) {
        Map map = canonicalDomainMap;
        synchronized (map) {
            canonicalDomainMap.remove(string);
        }
        Map map2 = domainMap;
        synchronized (map2) {
            domainMap.remove(string);
        }
    }

    private String updateCacheAndReturnDomain(SSOToken sSOToken, String string) throws AMException {
        try {
            DomainComponentTree domainComponentTree = new DomainComponentTree(sSOToken, new Guid(dcTreeStartDN));
            String[] stringArray = new String[]{INET_CANONICAL_DOMAIN, DOMAIN_BASE_DN};
            SearchControl searchControl = new SearchControl();
            searchControl.setSearchScope(2);
            PersistentObject persistentObject = UMSObject.getObject(sSOToken, new Guid(dcTreeStartDN));
            String string2 = "(inetDomainBaseDN=" + string + ")";
            if (debug.messageEnabled()) {
                debug.message("DCTree.updateCache-> searchFilter= " + string2);
            }
            SearchResults searchResults = persistentObject.search(string2, null);
            int n = 0;
            String string3 = null;
            String string4 = null;
            while (searchResults.hasMoreElements()) {
                Attr attr;
                DomainComponent domainComponent = (DomainComponent)searchResults.next();
                ++n;
                string3 = domainComponentTree.mapDCToDomainName(domainComponent);
                if (debug.messageEnabled()) {
                    debug.message("DCTree:updateCache-> domainName= " + string3);
                }
                if ((attr = domainComponent.getAttribute(INET_CANONICAL_DOMAIN)) == null) continue;
                string4 = string3;
            }
            searchResults.abandon();
            if (n == 1) {
                string4 = string3;
            }
            if (debug.messageEnabled()) {
                debug.message("DCTree.updateCache-> returning domain= " + string4);
            }
            return string4;
        }
        catch (UMSException uMSException) {
            debug.error("DCTree:updateCache: UMSException", (Throwable)uMSException);
            return null;
        }
    }

    private Set getDomains(SSOToken sSOToken, String string) throws SSOException, AMException {
        return null;
    }

    public Set dcNodeAttributes() throws AMException {
        try {
            Set set;
            Object object;
            if (Compliance.gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", CommonUtils.getInternalToken());
                Compliance.gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            if ((set = (Set)(object = Compliance.gsc.getAttributeDefaults()).get("iplanet-am-admin-console-dctree-attr-list")) == null) {
                if (debug.messageEnabled()) {
                    debug.message("DCTree.dcNodeAttributes = null");
                }
                return Collections.EMPTY_SET;
            }
            if (debug.messageEnabled()) {
                debug.message("DCTree.dcNodeAttributes = " + set.toString());
            }
            return set;
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("908"), (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("908"), "908");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("902"), (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("902"), "902");
        }
    }

    static {
        debug = CommonUtils.debug;
        dcTreeStartDN = SystemProperties.get((String)"com.iplanet.am.domaincomponent");
        domainMap = new HashMap();
        canonicalDomainMap = new HashMap();
        lock = new Object();
    }
}

