/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.ldap.AMACIEventListener;
import com.iplanet.am.sdk.ldap.AMEntryEventListener;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.event.EventService;
import java.util.Map;

class AMEventManager {
    protected static final int EVENT_SCOPE = 2;
    protected static String EVENT_BASE_NODE = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
    protected static Debug debug = Debug.getInstance((String)"amEventService");
    private EventService evtService = null;
    private AMACIEventListener aciListener = null;
    private AMEventManager instance = null;
    private AMEntryEventListener evtListener = null;
    private Map listeners;

    protected AMEventManager(Map map) throws AMEventManagerException {
        this.listeners = map;
    }

    protected void start() throws AMEventManagerException {
        try {
            if (debug.messageEnabled()) {
                debug.message("AMEventManager.start() - Getting EventService instance");
            }
            this.evtService = EventService.getEventService();
        }
        catch (Exception exception) {
            debug.error("AMEventManager.start() Unable to get EventService ", (Throwable)exception);
            throw new AMEventManagerException(AMSDKBundle.getString("501"), "501");
        }
        AMACIEventListener aMACIEventListener = (AMACIEventListener)this.evtService.getIDSListeners("com.iplanet.am.sdk.ldap.AMACIEventListener");
        AMEntryEventListener aMEntryEventListener = (AMEntryEventListener)this.evtService.getIDSListeners("com.iplanet.am.sdk.ldap.AMEntryEventListener");
        if (aMACIEventListener == null) {
            debug.error("AMEventManager.start: l1 is null");
        }
        if (aMEntryEventListener == null) {
            debug.error("AMEventManager.start: l2 is null");
        }
        aMACIEventListener.setListeners(this.listeners);
        aMEntryEventListener.setListeners(this.listeners);
    }
}

