/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMCallBack;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class AMCallBackImpl
implements AMConstants {
    static Debug debug = CommonUtils.debug;
    private static final String PRE_POST_PROCESSING_MODULES_ATTR = "iplanet-am-admin-console-pre-post-processing-modules";
    private static final String EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR = "iplanet-am-admin-console-external-attribute-fetch-enabled";
    private static Hashtable callBackObjects = new Hashtable();
    private static DN rootDN = new DN(AMStoreConnection.rootSuffix);
    public static final int CREATE = 1;
    public static final int DELETE = 2;
    public static final int MODIFY = 3;
    public static SSOToken internalToken = CommonUtils.getInternalToken();

    private static Set getOrgConfigAttribute(String string, String string2) {
        try {
            ServiceConfig serviceConfig = AMServiceUtils.getOrgConfig(internalToken, string, "iPlanetAMAdminConsoleService");
            if (serviceConfig != null) {
                Map map = serviceConfig.getAttributes();
                return (Set)map.get(string2);
            }
            return AMCallBackImpl.getDefaultGlobalConfig(string2);
        }
        catch (Exception exception) {
            return AMCallBackImpl.getDefaultGlobalConfig(string2);
        }
    }

    private static Set getDefaultGlobalConfig(String string) {
        block4: {
            if (debug.messageEnabled()) {
                debug.message("AMCallBackImpl.getPrePostImpls() Organization config for service (iPlanetAMAdminConsoleService," + string + ") not found. Obtaining default service " + "config values ..");
            }
            try {
                Map map = AMServiceUtils.getServiceConfig(CommonUtils.getInternalToken(), "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                if (map != null) {
                    return (Set)map.get(string);
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMCallBackImpl.getPrePostProcessClasses(): Unable to get Pre/Post Processing information", (Throwable)exception);
            }
        }
        return null;
    }

    private static Set getPrePostImpls(String string) {
        return AMCallBackImpl.getOrgConfigAttribute(string, PRE_POST_PROCESSING_MODULES_ATTR);
    }

    public static boolean isExistsPrePostPlugins(String string) {
        Set set = AMCallBackImpl.getPrePostImpls(string);
        return set != null && !set.isEmpty();
    }

    public static boolean isExternalGetAttributeEnabled(String string) {
        Set set = AMCallBackImpl.getOrgConfigAttribute(string, EXTERNAL_ATTRIBUTES_FETCH_ENABLED_ATTR);
        boolean bl = false;
        if (set != null && !set.isEmpty()) {
            String string2 = (String)set.iterator().next();
            bl = string2.equalsIgnoreCase("true");
        }
        debug.message("AMCallBackImpl.isExternalGetAttributeEnabled() = " + bl);
        return bl;
    }

    private static AMCallBack instantiateClass(String string) {
        try {
            return (AMCallBack)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.error("AMCallBackImpl.instantiateClass(): Unable to locate class " + string, (Throwable)classNotFoundException);
        }
        catch (Exception exception) {
            debug.error("AMCallBackImpl.instantiateClass(): Unable to instantiate class " + string, (Throwable)exception);
        }
        return null;
    }

    private static AMCallBack getCallBackObject(String string) {
        AMCallBack aMCallBack = (AMCallBack)callBackObjects.get(string);
        if (aMCallBack == null && (aMCallBack = AMCallBackImpl.instantiateClass(string)) != null) {
            callBackObjects.put(string, aMCallBack);
        }
        return aMCallBack;
    }

    public static Map getAttributes(SSOToken sSOToken, String string, Set set, String string2) {
        if (!AMCallBackImpl.isExternalGetAttributeEnabled(string2)) {
            return null;
        }
        Set set2 = AMCallBackImpl.getPrePostImpls(string2);
        if (set2 != null && !set2.isEmpty()) {
            Map map = new HashMap();
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                Map map2;
                String string3 = (String)iterator.next();
                AMCallBack aMCallBack = AMCallBackImpl.getCallBackObject(string3);
                if (aMCallBack == null || (map2 = aMCallBack.getAttributes(sSOToken, string, set)) == null || map2.isEmpty()) continue;
                map = CommonUtils.mergeMaps(map2, map);
            }
            return map;
        }
        return null;
    }

    public static Map preProcess(SSOToken sSOToken, String string, String string2, Map map, Map map2, int n, int n2, boolean bl) throws AMException {
        Set set = AMCallBackImpl.getPrePostImpls(string2);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                AMCallBack aMCallBack = AMCallBackImpl.getCallBackObject(string3);
                if (aMCallBack == null) continue;
                try {
                    switch (n) {
                        case 1: {
                            Map map3 = aMCallBack.preProcessCreate(sSOToken, string, map2, n2);
                            map2 = map3 == null ? map2 : map3;
                            break;
                        }
                        case 3: {
                            Map map3 = aMCallBack.preProcessModify(sSOToken, string, map, map2, n2);
                            map2 = map3 == null ? map2 : map3;
                            break;
                        }
                        case 2: {
                            aMCallBack.preProcessDelete(sSOToken, string, map, bl, n2);
                        }
                    }
                }
                catch (AMException aMException) {
                    debug.error("AMCallBackImpl.preProcess(): Preprocessingimpl " + string3 + " exception thrown by impl:", (Throwable)aMException);
                    throw aMException;
                }
            }
            return map2;
        }
        return map2 != null ? map2 : map;
    }

    public static AttrSet preProcess(SSOToken sSOToken, String string, String string2, AttrSet attrSet, AttrSet attrSet2, int n, int n2, boolean bl) throws AMException {
        Set set = AMCallBackImpl.getPrePostImpls(string2);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            Map map = CommonUtils.attrSetToMap(attrSet2);
            Map map2 = CommonUtils.attrSetToMap(attrSet);
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                AMCallBack aMCallBack = AMCallBackImpl.getCallBackObject(string3);
                if (aMCallBack == null) continue;
                try {
                    switch (n) {
                        case 1: {
                            Map map3 = aMCallBack.preProcessCreate(sSOToken, string, map, n2);
                            map = map3 == null ? map : map3;
                            break;
                        }
                        case 3: {
                            Map map3 = aMCallBack.preProcessModify(sSOToken, string, map2, map, n2);
                            map = map3 == null ? map : map3;
                            break;
                        }
                        case 2: {
                            aMCallBack.preProcessDelete(sSOToken, string, map2, bl, n2);
                        }
                    }
                }
                catch (AMException aMException) {
                    debug.error("AMCallBackImpl.preProcess(): Preprocessingimpl " + string3 + " exception thrown by impl:", (Throwable)aMException);
                    throw aMException;
                }
            }
            return CommonUtils.mapToAttrSet(map);
        }
        return attrSet2 != null ? attrSet2 : attrSet;
    }

    public static void postProcess(SSOToken sSOToken, String string, String string2, AttrSet attrSet, AttrSet attrSet2, int n, int n2, boolean bl) throws AMException {
        Set set = AMCallBackImpl.getPrePostImpls(string2);
        if (set != null && !set.isEmpty()) {
            Map map = CommonUtils.attrSetToMap(attrSet2);
            Map map2 = CommonUtils.attrSetToMap(attrSet);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                AMCallBack aMCallBack = AMCallBackImpl.getCallBackObject(string3);
                if (aMCallBack == null) continue;
                try {
                    switch (n) {
                        case 1: {
                            aMCallBack.postProcessCreate(sSOToken, string, map, n2);
                            break;
                        }
                        case 3: {
                            aMCallBack.postProcessModify(sSOToken, string, map2, map, n2);
                            break;
                        }
                        case 2: {
                            aMCallBack.postProcessDelete(sSOToken, string, map2, bl, n2);
                        }
                    }
                }
                catch (AMException aMException) {
                    debug.error("AMCallBackImpl.postProcess(): Preprocessingimpl " + aMCallBack.getClass().getName() + " exception thrown: ", (Throwable)aMException);
                }
            }
        }
    }

    public static void postProcess(SSOToken sSOToken, String string, String string2, Map map, Map map2, int n, int n2, boolean bl) throws AMException {
        Set set = AMCallBackImpl.getPrePostImpls(string2);
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                AMCallBack aMCallBack = AMCallBackImpl.getCallBackObject(string3);
                if (aMCallBack == null) continue;
                try {
                    switch (n) {
                        case 1: {
                            aMCallBack.postProcessCreate(sSOToken, string, map2, n2);
                            break;
                        }
                        case 3: {
                            aMCallBack.postProcessModify(sSOToken, string, map, map2, n2);
                            break;
                        }
                        case 2: {
                            aMCallBack.postProcessDelete(sSOToken, string, map, bl, n2);
                        }
                    }
                }
                catch (AMException aMException) {
                    debug.error("AMCallBackImpl.postProcess(): Preprocessingimpl " + aMCallBack.getClass().getName() + " exception thrown: ", (Throwable)aMException);
                }
            }
        }
    }

    public static Set preProcessModifyMemberShip(SSOToken sSOToken, String string, String string2, Set set, int n, int n2) throws AMException {
        Set set2 = AMCallBackImpl.getPrePostImpls(string2);
        if (set2 != null && !set2.isEmpty()) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                AMCallBack aMCallBack = AMCallBackImpl.getCallBackObject(string3);
                if (aMCallBack == null) continue;
                try {
                    switch (n) {
                        case 1: {
                            set = aMCallBack.preProcessAddUser(sSOToken, string, set, n2);
                            break;
                        }
                        case 2: {
                            set = aMCallBack.preProcessRemoveUser(sSOToken, string, set, n2);
                        }
                    }
                }
                catch (AMException aMException) {
                    debug.error("AMCallBackImpl.preProcessModifyMemberShip(): Preprocessing impl " + string3 + " exception " + "thrown by impl:", (Throwable)aMException);
                    throw aMException;
                }
            }
        }
        return set;
    }

    public static void postProcessModifyMemberShip(SSOToken sSOToken, String string, String string2, Set set, int n, int n2) throws AMException {
        Set set2 = AMCallBackImpl.getPrePostImpls(string2);
        if (set2 != null && !set2.isEmpty()) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                AMCallBack aMCallBack = AMCallBackImpl.getCallBackObject(string3);
                if (aMCallBack == null) continue;
                try {
                    switch (n) {
                        case 1: {
                            aMCallBack.postProcessAddUser(sSOToken, string, set, n2);
                            break;
                        }
                        case 2: {
                            aMCallBack.postProcessRemoveUser(sSOToken, string, set, n2);
                        }
                    }
                }
                catch (AMException aMException) {
                    debug.error("AMCallBackImpl.postProcessModifyMemberShip(): Preprocessing impl " + aMCallBack.getClass().getName() + " exception thrown: ", (Throwable)aMException);
                }
            }
        }
    }
}

