/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMObjectListener;
import com.iplanet.am.sdk.ldap.AMEventManager;
import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMACIEventListener
implements IDSEventListener {
    protected static final String SEARCH_FILTER = "(aci=*)";
    protected static final int OPERATIONS = 15;
    private Debug debug = AMEventManager.debug;
    private Map listeners = new HashMap();

    public void entryChanged(DSEvent dSEvent) {
        String string;
        if (this.debug.messageEnabled()) {
            this.debug.message("AMACIEventListener.entryChanged() DSEvent for dn: " + dSEvent.getID());
        }
        if ((string = dSEvent.getClassName()).indexOf("cosClassicDefinition") != -1 || string.indexOf("costemplate") != -1) {
            return;
        }
        Map map = this.listeners;
        synchronized (map) {
            Set set = this.listeners.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMObjectListener aMObjectListener = (AMObjectListener)iterator.next();
                aMObjectListener.permissionsChanged(dSEvent.getID(), (Map)this.listeners.get(aMObjectListener));
            }
        }
    }

    public void eventError(String string) {
        this.debug.error("AMACIEventListener.eventError(): " + string);
    }

    public void allEntriesChanged() {
    }

    public String getBase() {
        return AMEventManager.EVENT_BASE_NODE;
    }

    public String getFilter() {
        return SEARCH_FILTER;
    }

    public int getOperations() {
        return 15;
    }

    public int getScope() {
        return 2;
    }

    public void setListeners(Map map) {
        this.listeners = map;
    }
}

