/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.UMSException;
import com.sun.identity.common.L10NMessage;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import netscape.ldap.LDAPException;

public class AMException
extends Exception
implements L10NMessage {
    private String localizedMsg = null;
    private String errorCode = null;
    private Object[] args = null;
    private LDAPException rootCause = null;
    private String ldapErrorMsg = null;
    private String ldapErrCode = null;

    public AMException(String string, String string2) {
        super(string);
        this.localizedMsg = string;
        this.errorCode = string2;
    }

    public AMException(SSOToken sSOToken, String string) {
        this.localizedMsg = AMSDKBundle.getString(string, AMCommonUtils.getUserLocale(sSOToken));
        this.errorCode = string;
    }

    public AMException(String string, String string2, UMSException uMSException) {
        try {
            this.rootCause = (LDAPException)uMSException.getRootCause();
            this.ldapErrCode = Integer.toString(this.rootCause.getLDAPResultCode());
            this.ldapErrorMsg = AMSDKBundle.getString(this.ldapErrCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localizedMsg = this.ldapErrorMsg != null ? string + "::" + this.ldapErrorMsg : string;
        this.errorCode = string2;
    }

    public AMException(SSOToken sSOToken, String string, UMSException uMSException) {
        try {
            this.rootCause = (LDAPException)uMSException.getRootCause();
            this.ldapErrCode = Integer.toString(this.rootCause.getLDAPResultCode());
            this.ldapErrorMsg = AMSDKBundle.getString(this.ldapErrCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = AMSDKBundle.getString(string, AMCommonUtils.getUserLocale(sSOToken));
        this.localizedMsg = this.ldapErrorMsg != null ? string2 + "::" + this.ldapErrorMsg : string2;
        this.errorCode = string;
    }

    public AMException(String string, String string2, Object[] objectArray) {
        super(string);
        this.localizedMsg = string;
        this.errorCode = string2;
        this.args = objectArray;
    }

    public AMException(String string, String string2, Object[] objectArray, UMSException uMSException) {
        try {
            this.rootCause = (LDAPException)uMSException.getRootCause();
            this.ldapErrCode = Integer.toString(this.rootCause.getLDAPResultCode());
            this.ldapErrorMsg = AMSDKBundle.getString(this.ldapErrCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localizedMsg = this.ldapErrorMsg != null ? string + "::" + this.ldapErrorMsg : string;
        this.errorCode = string2;
        this.args = objectArray;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String getMessage() {
        return this.localizedMsg;
    }

    public String getLDAPErrorCode() {
        return this.ldapErrCode;
    }

    public LDAPException getLDAPException() {
        return this.rootCause;
    }

    public String getL10NMessage(java.util.Locale locale) {
        String string = this.errorCode;
        if (locale != null) {
            ResourceBundle resourceBundle = AMSDKBundle.getBundleFromHash(locale);
            String string2 = Locale.getString((ResourceBundle)resourceBundle, (String)this.errorCode, (Debug)AMCommonUtils.debug);
            string = this.args == null || this.args.length == 0 ? string2 : MessageFormat.format(string2, this.args);
        }
        return string;
    }

    public String getResourceBundleName() {
        return "amProfile";
    }
}

