/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMEventManagerException;
import com.iplanet.am.sdk.AMIdRepoListener;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;

class AMEventManager {
    protected static AMDirectoryManager instance;
    protected static Debug debug;

    protected AMEventManager(AMDirectoryManager aMDirectoryManager) throws AMEventManagerException {
        instance = aMDirectoryManager;
    }

    protected void start() throws AMEventManagerException {
        if (debug.messageEnabled()) {
            debug.message("In AMEventManager.start() Starting event service thread...");
        }
        try {
            SSOToken sSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (debug.messageEnabled()) {
                debug.message("AMEventManager.start() Adding EntryEvent & ACIEvent Listeners..");
            }
            instance.addListener(sSOToken, new AMIdRepoListener());
        }
        catch (Exception exception) {
            debug.error("AMEventManager.start() Exception occurred while starting event service thread", (Throwable)exception);
            throw new AMEventManagerException(AMSDKBundle.getString("502"), "502");
        }
    }

    static {
        debug = Debug.getInstance((String)"amProfileListener");
    }
}

