/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryManager;
import com.iplanet.am.sdk.AMDirectoryWrapper;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.ComplianceInterface;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class AMCompliance
implements AMConstants {
    private static ComplianceInterface compl = AMDirectoryManager.getInstance().compliance;
    private static Map deletedOrg = new HashMap();
    protected static final String ADMIN_GROUPS_ENABLED_ATTR = "iplanet-am-admin-console-compliance-admin-groups";
    protected static final String COMPLIANCE_USER_DELETION_ATTR = "iplanet-am-admin-console-compliance-user-deletion";
    private static String DEFAULT_DELETED_ORG_FILTER = "(&(sunPreferredDomain=%V)(inetDomainStatus=deleted)(objectclass=sunManagedOrganization))";
    private static String DEFAULT_DELETED_GROUP_FILTER = "(&(inetgroupstatus=deleted)(objectclass=iplanet-am-managed-group))";
    private static String DEFAULT_DELETED_USER_FILTER = "(&(inetUserStatus=deleted)(objectclass=inetorgperson))";
    private static String DEFAULT_DELETED_OBJECT_FILTER = "(|(objectclass=*)(objectclass=ldapsubentry))";
    private static String DEFAULT_DELETED_RESOURCE_FILTER = "(&(objectclass=icsCalendarResource)(icsStatus = deleted))";
    private static String rootSuffix;
    protected static ServiceSchema gsc;
    static Debug debug;
    static AMDirectoryManager dsManager;

    AMCompliance() {
    }

    protected static void init() {
        rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
        if (rootSuffix == null || rootSuffix == "") {
            debug.error("com.iplanet.am.rootsuffix property value should not be null");
            return;
        }
    }

    protected static boolean isAncestorOrgDeleted(SSOToken sSOToken, String string, int n) throws AMException {
        return compl.isAncestorOrgDeleted(sSOToken, string, n);
    }

    protected static void cleanDeletedOrgCache(String string) {
        Set set = deletedOrg.keySet();
        DN dN = new DN(string);
        String string2 = string;
        while (!string2.equalsIgnoreCase(rootSuffix)) {
            if (deletedOrg.containsKey(string2)) {
                Map map = deletedOrg;
                synchronized (map) {
                    deletedOrg.remove(string2);
                }
            }
            string2 = new DN(string2).getParent().toRFCString().toLowerCase();
        }
    }

    protected static boolean isAdminGroupsEnabled(String string) throws AMException {
        if (!AMCompliance.isUnderRootSuffix(string)) {
            return false;
        }
        try {
            Object object;
            if (AMDCTree.gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                AMDCTree.gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            object = AMDCTree.gsc.getReadOnlyAttributeDefaults();
            Set set = (Set)object.get(ADMIN_GROUPS_ENABLED_ATTR);
            boolean bl = false;
            if (set == null || set.isEmpty()) {
                bl = false;
            } else {
                String string2 = (String)set.iterator().next();
                bl = string2.equalsIgnoreCase("true");
            }
            if (debug.messageEnabled()) {
                debug.message("Compliance.isAdminGroupsEnabled = " + bl);
            }
            return bl;
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("357"), (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("357"), "357");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("357"), (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("357"), "357");
        }
    }

    protected static boolean isUnderRootSuffix(String string) {
        if (string == null || string.equals("")) {
            return true;
        }
        DN dN = new DN(AMStoreConnection.rootSuffix);
        DN dN2 = new DN(string);
        return dN.equals(dN2) || dN.equals(dN2.getParent());
    }

    protected static boolean isComplianceUserDeletionEnabled() throws AMException {
        try {
            Object object;
            if (AMDCTree.gsc == null) {
                object = new ServiceSchemaManager("iPlanetAMAdminConsoleService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                AMDCTree.gsc = ((ServiceSchemaManager)object).getGlobalSchema();
            }
            object = AMDCTree.gsc.getReadOnlyAttributeDefaults();
            Set set = (Set)object.get(COMPLIANCE_USER_DELETION_ATTR);
            boolean bl = false;
            if (set == null || set.isEmpty()) {
                bl = false;
            } else {
                String string = (String)set.iterator().next();
                bl = string.equalsIgnoreCase("true");
            }
            if (debug.messageEnabled()) {
                debug.message("Compliance.isComplianceUserDeletionEnabled = " + bl);
            }
            return bl;
        }
        catch (SMSException sMSException) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)sMSException);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
        catch (SSOException sSOException) {
            debug.error(AMSDKBundle.getString("359"), (Throwable)sSOException);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
    }

    protected static void verifyAndDeleteObject(SSOToken sSOToken, String string) throws AMException {
        compl.verifyAndDeleteObject(sSOToken, string);
    }

    protected static String getDeletedObjectFilter(int n) throws AMException, SSOException {
        return compl.getDeletedObjectFilter(n);
    }

    static {
        gsc = null;
        debug = AMCommonUtils.debug;
        AMCompliance.init();
        dsManager = AMDirectoryWrapper.getInstance();
    }
}

