/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.backup;

import com.iplanet.am.backup.BackupException;
import com.iplanet.am.backup.BackupResourceBundle;
import com.iplanet.am.backup.CommonUtils;
import com.iplanet.am.backup.IBackupConstants;
import com.iplanet.am.util.SystemProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;

class DoBackup
implements IBackupConstants {
    private static ResourceBundle bundle = null;
    private static final int INVALID = 0;
    private static final int VERBOSE = 1;
    private static final int BACKUP = 2;
    private static final int LOCATION = 3;
    private static final int CONFIG = 4;
    private static final int DEBUG = 5;
    private static final int LOG = 6;
    private static final int CERT = 7;
    private static final int DS = 8;
    private static final int ALL = 9;
    private static final int HELP = 10;
    private static final int VERSION = 11;
    private static Map arguments = new HashMap();
    private boolean verbose = false;
    private boolean config = false;
    private boolean debug = false;
    private boolean log = false;
    private boolean cert = false;
    private boolean ds = false;
    private boolean successFlag = false;
    private int all = 1;
    private int comptype;
    private String packageDir = null;
    private String webServerDir = null;
    private String dsServerLocation = null;
    private String amConfigPropertiesFile = null;
    private String backupName = null;
    private String backupDir = null;
    private String timeStamp = null;
    private String logLocation = null;
    private String debugLocation = null;
    private String infFileName = "backup.inf";
    private String fileSep = System.getProperty("file.separator");
    private String lineSep = System.getProperty("line.separator");
    private boolean obtainedDSLocation = false;
    private boolean validDSLocation = false;

    DoBackup() {
    }

    public static void main(String[] stringArray) throws BackupException {
        bundle = BackupResourceBundle.getResources();
        DoBackup doBackup = new DoBackup();
        try {
            doBackup.packageDir = stringArray[0];
            doBackup.webServerDir = stringArray[1];
            doBackup.amConfigPropertiesFile = doBackup.packageDir + "\\lib\\AMConfig.properties";
            doBackup.backupName = bundle.getString("default-backupname");
            doBackup.backupDir = doBackup.packageDir + doBackup.fileSep + bundle.getString("default-backupdir");
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("_yyyy_MM_dd_HHmmss");
            doBackup.timeStamp = simpleDateFormat.format(date);
            int n = stringArray.length;
            int n2 = n - 2;
            String[] stringArray2 = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray2[n3] = stringArray[n3 + 2];
                ++n3;
            }
            doBackup.parseCommandLine(stringArray2);
            doBackup.doProcessing();
            System.out.println(bundle.getString("success"));
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println(bundle.getString("operation-failed") + " " + exception.getLocalizedMessage());
            doBackup.doCleanup();
            System.exit(1);
        }
    }

    private void parseCommandLine(String[] stringArray) throws BackupException {
        int n;
        if (stringArray.length == 0 || stringArray.length == 1 && (stringArray[0].equalsIgnoreCase("--verbose") || stringArray[0].equalsIgnoreCase("-v"))) {
            System.out.println(bundle.getString("default-option-msg1"));
            System.out.println(bundle.getString("default-option-msg2"));
            System.out.println(bundle.getString("default-option-msg3") + this.backupDir);
            System.out.println(bundle.getString("default-option-msg4") + this.backupName + this.timeStamp);
            n = CommonUtils.readLocalizedYesNo(bundle.getString("do-you-want-to-continue-yes"), bundle.getString("yes-value"), bundle.getString("yes-value"), bundle.getString("no-value")) ? 1 : 0;
            if (n == 0) {
                this.displayUsage();
                System.exit(1);
            }
        }
        n = 0;
        while (n < stringArray.length) {
            int n2 = this.getToken(stringArray[n].toLowerCase());
            switch (n2) {
                case 1: {
                    this.verbose = true;
                    break;
                }
                case 2: {
                    if (++n >= stringArray.length) {
                        this.displayUsage();
                        System.exit(1);
                    }
                    this.backupName = stringArray[n];
                    if (this.backupName != null && (this.comptype = this.getToken(this.backupName.toLowerCase())) == 0) break;
                    throw new BackupException(bundle.getString("no-backup-name"));
                }
                case 3: {
                    if (++n >= stringArray.length) {
                        this.displayUsage();
                        System.exit(1);
                    }
                    this.backupDir = stringArray[n];
                    if (this.backupDir != null && (this.comptype = this.getToken(this.backupDir.toLowerCase())) == 0) break;
                    throw new BackupException(bundle.getString("no-backup-dir"));
                }
                case 4: {
                    this.config = true;
                    if (this.all != 1) break;
                    this.all = 0;
                    break;
                }
                case 5: {
                    this.debug = true;
                    if (this.all != 1) break;
                    this.all = 0;
                    break;
                }
                case 6: {
                    this.log = true;
                    if (this.all != 1) break;
                    this.all = 0;
                    break;
                }
                case 7: {
                    this.cert = true;
                    if (this.all != 1) break;
                    this.all = 0;
                    break;
                }
                case 8: {
                    this.ds = true;
                    if (this.all != 1) break;
                    this.all = 0;
                    break;
                }
                case 9: {
                    this.all = 2;
                    break;
                }
                case 10: {
                    this.displayHelp();
                    System.exit(0);
                    break;
                }
                case 11: {
                    this.displayVersion();
                    System.exit(0);
                    break;
                }
                default: {
                    System.err.println(bundle.getString("invalid-option") + stringArray[n]);
                    this.displayUsage();
                    System.exit(1);
                }
            }
            ++n;
        }
        if (this.all > 0) {
            this.config = true;
            this.debug = true;
            this.log = true;
            this.cert = true;
            this.ds = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doProcessing() throws BackupException {
        if (this.backupName.indexOf(47) > -1 || this.backupName.indexOf(92) > -1) {
            System.out.println(DoBackup.bundle.getString("invalid-backup-name"));
            System.exit(1);
        }
        if (!(var1_1 = new File(this.backupDir)).isAbsolute()) {
            try {
                this.backupDir = var1_1.getCanonicalPath();
            }
            catch (Exception var2_2) {
                throw new BackupException(var2_2.getMessage());
            }
        }
        if (!(var1_1 = new File(this.backupDir)).exists() || !var1_1.isDirectory()) {
            var2_3 = var1_1.getAbsolutePath() + " " + DoBackup.bundle.getString("backup-dir-not-exist-create");
            var3_6 = CommonUtils.readLocalizedYesNo(var2_3, DoBackup.bundle.getString("yes-value"), DoBackup.bundle.getString("yes-value"), DoBackup.bundle.getString("no-value"));
            if (var3_6) {
                if (!CommonUtils.makeDirs(this.backupDir)) {
                    throw new BackupException(DoBackup.bundle.getString("failed-to-create-backup-dir"));
                }
            } else {
                System.out.println(DoBackup.bundle.getString("can-not-proceed"));
                System.exit(1);
            }
        } else if (!var1_1.canWrite()) {
            System.out.println(var1_1.getAbsolutePath() + " " + DoBackup.bundle.getString("read-only-directory"));
            System.exit(1);
        }
        this.backupName = this.backupName + this.timeStamp;
        this.backupDir = var1_1.getAbsolutePath() + this.fileSep + this.backupName;
        System.out.println(DoBackup.bundle.getString("backup-in-progress"));
        CommonUtils.makeDirs(this.backupDir);
        this.infFileName = this.backupDir + this.fileSep + this.infFileName;
        this.writeToInfFile("Backup information file !!DO NOT EDIT!!");
        if (this.config) {
            this.writeToInfFile("config.backup.key=" + this.doBackupConfig());
            try {
                var2_4 = false;
                if (this.obtainedDSLocation && !this.validDSLocation) {
                    var2_4 = true;
                } else if (this.validDSLocation && !this.ds) {
                    var2_4 = true;
                }
                if (!var2_4) ** GOTO lbl49
                if (this.doServiceConfigurationBackup(this.backupDir + "\\config")) {
                    this.writeToInfFile("serviceconfiguration.backup.key=true");
                    System.out.println(DoBackup.bundle.getString("serviceconfig-backup-done"));
                }
                System.out.println(DoBackup.bundle.getString("serviceconfig-backup-failed"));
            }
            catch (Exception var2_5) {
                throw new BackupException();
            }
        } else {
            this.writeToInfFile("config.backup.key=" + this.config);
        }
lbl49:
        // 4 sources

        if (this.debug) {
            if (!this.setDebugLocation()) {
                System.out.println(DoBackup.bundle.getString("can-not-get-debug-location"));
                this.writeToInfFile("debug.backup.key=false");
            } else {
                this.writeToInfFile("debug.backup.key=" + this.doBackupDebug());
            }
        } else {
            this.writeToInfFile("debug.backup.key=" + this.debug);
        }
        if (this.log) {
            if (!this.setLogLocation()) {
                System.out.println(DoBackup.bundle.getString("can-not-get-log-location"));
                this.writeToInfFile("log.backup.key=false");
            } else {
                this.writeToInfFile("log.backup.key=" + this.doBackupLog());
            }
        } else {
            this.writeToInfFile("log.backup.key=" + this.log);
        }
        if (this.cert) {
            this.writeToInfFile("cert.backup.key=" + this.doBackupCert());
        } else {
            this.writeToInfFile("cert.backup.key=" + this.cert);
        }
        if (this.ds) {
            if (!this.obtainedDSLocation) {
                this.getDSLocation();
            }
            if (this.validDSLocation) {
                this.writeToInfFile("ds.backup.key=" + this.doBackupDS());
            } else {
                this.writeToInfFile("ds.backup.key=false");
            }
        } else {
            this.writeToInfFile("ds.backup.key=false");
        }
        if (!this.successFlag) {
            System.out.println(DoBackup.bundle.getString("backup-failed"));
            this.doCleanup();
            System.exit(1);
        }
        System.out.println(DoBackup.bundle.getString("backup-finished-msg") + this.backupDir);
    }

    private void writeToInfFile(String string) throws BackupException {
        try {
            FileWriter fileWriter = new FileWriter(this.infFileName, true);
            fileWriter.write(string);
            fileWriter.write(this.lineSep);
            fileWriter.close();
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("can-not-write-to-backup-inf"));
        }
    }

    private boolean setLogLocation() throws BackupException {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            Object object;
            try {
                object = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                System.out.println(bundle.getString("enter-log-location"));
                this.logLocation = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new BackupException(iOException);
            }
            object = new File(this.logLocation);
            if (this.logLocation.equals("$")) {
                bl = true;
            } else if (((File)object).exists() && ((File)object).isDirectory()) {
                bl = true;
            }
            bl2 = true;
        }
        return bl2;
    }

    private boolean setDebugLocation() {
        String string = null;
        string = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.services.debug.directory");
        if (string == null) {
            return false;
        }
        this.debugLocation = string;
        return true;
    }

    private boolean doBackupConfig() throws BackupException {
        System.out.println(bundle.getString("config-backup-progress"));
        try {
            String string = this.backupDir + "\\config";
            CommonUtils.makeDirs(string);
            String string2 = string + "\\SunONEIS";
            CommonUtils.makeDirs(string2);
            CommonUtils.makeDirs(string2 + "\\lib");
            CommonUtils.makeDirs(string2 + "\\config");
            CommonUtils.makeDirs(string2 + "\\Servers");
            this.writeToInfFile("configuration backup:");
            this.copyIt(this.packageDir + "\\config", string2 + "\\config");
            this.copyIt(this.packageDir + "\\locale", string2 + "\\locale");
            this.copyIt(this.webServerDir + "\\..\\httpacl", string2 + "\\Servers\\httpacl");
            this.copyIt(this.packageDir + "\\lib\\*.properties", string2 + "\\lib");
            this.copyIt(this.webServerDir + "\\*", string2 + "\\Servers\\https-host");
            this.copyIt(this.packageDir + "\\web-apps", string2 + "\\web-apps");
            if (!this.obtainedDSLocation) {
                this.getDSLocation();
            }
            if (this.validDSLocation) {
                String string3 = string + "\\ldap-host\\config";
                this.copyIt(this.dsServerLocation + "\\config\\schema", string3 + "\\schema");
                this.copyIt(this.dsServerLocation + "\\config\\dse.ldif", string3);
            }
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("config-backup-failed") + " " + exception.getLocalizedMessage());
        }
        System.out.println(bundle.getString("config-backup-finished"));
        this.successFlag = true;
        return true;
    }

    private boolean doServiceConfigurationBackup(String string) {
        String string2;
        String string3;
        Closeable closeable;
        ArrayList<String> arrayList;
        String[] stringArray;
        Object object;
        String string4;
        BufferedReader bufferedReader;
        String string5 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.directory.ssl.enabled");
        if (string5.equalsIgnoreCase("true")) {
            System.out.println(bundle.getString("ds-ssl-mode"));
            return false;
        }
        String string6 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.directory.host");
        String string7 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.directory.port");
        String string8 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.rootsuffix");
        String string9 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.sun.identity.authentication.super.user");
        boolean bl = false;
        String string10 = this.backupDir + "\\out";
        String string11 = this.backupDir + "\\error";
        String[] stringArray2 = new String[]{this.packageDir + "\\tools\\ldapsearch.exe", "-h", string6, "-p", string7, "-D", string9, "-w", "testdummystring", "-b", string8, "entrydn=ou=services,*"};
        if (CommonUtils.execute(stringArray2, string10, string11) == -1) {
            CommonUtils.deleteFileAndDir(string10);
            CommonUtils.deleteFileAndDir(string11);
            return false;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(string11));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.indexOf("Can't connect") == -1) continue;
                bl = true;
                System.out.println(bundle.getString("ds-not-running"));
                System.out.println(bundle.getString("start-ds"));
                try {
                    object = new BufferedReader(new InputStreamReader(System.in));
                    ((BufferedReader)object).readLine();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (bl) {
            if (CommonUtils.execute(stringArray2, string10, string11) == -1) {
                return false;
            }
            try {
                bufferedReader = new BufferedReader(new FileReader(string11));
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.indexOf("Can't connect") == -1) continue;
                    bl = true;
                    System.out.println(bundle.getString("ds-not-running"));
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        boolean bl2 = false;
        object = null;
        while (object == null || ((String)object).equals("")) {
            System.out.println(bundle.getString("enter-admin-password"));
            object = CommonUtils.readPassword();
            if (object != null && !((String)object).equals("")) continue;
            System.out.print(bundle.getString("password-cannotbe-empty") + " ");
        }
        String[] stringArray3 = new String[]{this.packageDir + "\\tools\\ldapsearch.exe", "-h", string6, "-p", string7, "-D", string9, "-w", object, "-b", string8, "entrydn=\"ou=services,*\""};
        if (CommonUtils.execute(stringArray3, string10, string11) == -1) {
            CommonUtils.deleteFileAndDir(string10);
            CommonUtils.deleteFileAndDir(string11);
            return false;
        }
        try {
            stringArray = new BufferedReader(new FileReader(string11));
            while ((string4 = stringArray.readLine()) != null) {
                if (string4.indexOf("Invalid credentials") == -1) continue;
                bl2 = true;
                System.out.println(bundle.getString("admin-password-wrong"));
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (bl2) {
            object = null;
            while (object == null || ((String)object).equals("")) {
                System.out.println(bundle.getString("enter-admin-password"));
                object = CommonUtils.readPassword();
                if (object != null && !((String)object).equals("")) continue;
                System.out.print(bundle.getString("password-cannotbe-empty") + " ");
            }
            stringArray3[8] = object;
            if (CommonUtils.execute(stringArray3, string10, string11) != 0) {
                return false;
            }
        }
        stringArray = new String[]{this.packageDir + "\\tools\\ldapsearch.exe", "-h", string6, "-p", string7, "-D", string9, "-w", object, "-b", string8, "entrydn=ou=services,*"};
        CommonUtils.deleteFileAndDir(string10);
        if (CommonUtils.executeCommand(stringArray3, string10) != 0) {
            CommonUtils.deleteFileAndDir(string10);
            return false;
        }
        try {
            arrayList = new ArrayList<String>();
            string8 = string8.toLowerCase();
            closeable = new BufferedReader(new FileReader(string10));
            string3 = null;
            boolean bl3 = false;
            while ((string3 = ((BufferedReader)closeable).readLine()) != null) {
                if (string3.trim().toLowerCase().indexOf(string8) == -1) continue;
                string2 = string3.substring(4, string3.length());
                arrayList.add(string2);
            }
            ((BufferedReader)closeable).close();
        }
        catch (IOException iOException) {
            return false;
        }
        Iterator iterator = arrayList.iterator();
        try {
            closeable = new BufferedWriter(new FileWriter(string + "\\updated_services.ldif"));
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                String[] stringArray4 = new String[]{this.packageDir + "\\tools\\ldapsearch.exe", "-h", string6, "-p", string7, "-D", string9, "-w", object, "-b", string3, "objectclass=*"};
                CommonUtils.deleteFileAndDir(string10);
                if (CommonUtils.executeCommand(stringArray4, string10) != 0) {
                    CommonUtils.deleteFileAndDir(string10);
                    CommonUtils.deleteFileAndDir(string11);
                    return false;
                }
                string2 = null;
                BufferedReader bufferedReader2 = new BufferedReader(new FileReader(string10));
                while ((string2 = bufferedReader2.readLine()) != null) {
                    ((Writer)closeable).write(string2 + "\n");
                }
                ((Writer)closeable).write("\n");
                bufferedReader2.close();
            }
            ((BufferedWriter)closeable).close();
        }
        catch (IOException iOException) {
            CommonUtils.deleteFileAndDir(string10);
            return false;
        }
        CommonUtils.deleteFileAndDir(string10);
        return true;
    }

    private boolean doBackupDebug() throws BackupException {
        System.out.println(bundle.getString("debug-backup-progress"));
        File file = new File(this.debugLocation);
        if (!file.exists() || !file.isDirectory()) {
            System.out.println(bundle.getString("debug-directory-does-not-exist"));
            return false;
        }
        try {
            String string = this.backupDir + "\\debug";
            CommonUtils.makeDirs(string);
            this.writeToInfFile("debug backup:");
            this.writeToInfFile("debug.location.key=" + this.debugLocation);
            this.copyIt(this.debugLocation.replace('/', '\\') + "\\*", string);
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("debug-backup-failed") + " " + exception.getLocalizedMessage());
        }
        System.out.println(bundle.getString("debug-backup-finished"));
        this.successFlag = true;
        return true;
    }

    private boolean doBackupLog() throws BackupException {
        System.out.println(bundle.getString("log-backup-progress"));
        File file = new File(this.logLocation);
        if (!file.exists() || !file.isDirectory()) {
            System.out.println(bundle.getString("log-directory-does-not-exist"));
            return false;
        }
        try {
            String string = this.backupDir + "\\log";
            CommonUtils.makeDirs(string);
            this.writeToInfFile("log backup:");
            this.writeToInfFile("log.location.key=" + this.logLocation);
            String string2 = this.logLocation.replace('/', '\\');
            if (string2.endsWith("\\")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this.copyIt(string2.replace('/', '\\') + "\\*", string);
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("log-backup-failed") + " " + exception.getLocalizedMessage());
        }
        System.out.println(bundle.getString("log-backup-finished"));
        this.successFlag = true;
        return true;
    }

    private boolean doBackupCert() throws BackupException {
        System.out.println(bundle.getString("cert-backup-progress"));
        try {
            String string = this.backupDir + "\\cert";
            CommonUtils.makeDirs(string);
            CommonUtils.makeDirs(string + "\\ws");
            this.writeToInfFile("cert db backup:");
            this.copyIt(this.webServerDir + "\\..\\alias", string + "\\ws\\alias");
            if (!this.obtainedDSLocation) {
                this.getDSLocation();
            }
            if (this.validDSLocation) {
                CommonUtils.makeDirs(string + "\\ds");
                String string2 = this.dsServerLocation.replace('/', '\\');
                this.copyIt(string2 + "\\..\\alias", string + "\\ds\\alias");
            }
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("cert-backup-failed") + " " + exception.getLocalizedMessage());
        }
        System.out.println(bundle.getString("cert-backup-finished"));
        this.successFlag = true;
        return true;
    }

    private boolean doBackupDS() throws BackupException {
        System.out.println(bundle.getString("ds-backup-progress"));
        try {
            String string = this.backupDir + "\\ds";
            CommonUtils.makeDirs(string);
            String string2 = string + this.fileSep + this.backupName + ".ldif";
            String string3 = null;
            string3 = CommonUtils.grepAndSed(this.amConfigPropertiesFile, "com.iplanet.am.rootsuffix");
            if (string3 == null) {
                throw new BackupException(bundle.getString("could-not-get-rootsuffix"));
            }
            this.writeToInfFile("ds backup:");
            this.writeToInfFile("ds.rootsuffix.key=" + string3);
            String string4 = this.dsServerLocation.replace('/', '\\');
            String string5 = this.dsServerLocation;
            String[] stringArray = new String[]{string4 + "\\..\\bin\\slapd\\server\\slapd.exe", "db2ldif", "-D", string5.replace('/', '\\'), "-a", string2, "-s", string3};
            String string6 = this.backupDir + "\\temp";
            if (CommonUtils.executeCommand(stringArray, string6) != 0) {
                CommonUtils.deleteFileAndDir(string6);
                throw new BackupException(bundle.getString("ds-import-failed"));
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string6));
            String string7 = null;
            while ((string7 = bufferedReader.readLine()) != null) {
                this.writeToInfFile(string7);
            }
            bufferedReader.close();
            CommonUtils.deleteFileAndDir(string6);
        }
        catch (Exception exception) {
            throw new BackupException(bundle.getString("ds-backup-failed"));
        }
        System.out.println(bundle.getString("ds-backup-finished"));
        this.successFlag = true;
        return true;
    }

    private void doCleanup() throws BackupException {
        try {
            CommonUtils.deleteFileAndDir(this.backupDir);
        }
        catch (Exception exception) {
            throw new BackupException(this.backupDir + "\t" + bundle.getString("could-not-do-cleanup"));
        }
    }

    private void copyIt(String string, String string2) throws BackupException {
        if (this.verbose) {
            System.out.println(bundle.getString("backing-up") + " " + string);
        }
        if (CommonUtils.executeXcopy(string, string2) != 0) {
            throw new BackupException(bundle.getString("copy-failed") + " " + string);
        }
        this.writeToInfFile("Backup from: " + string + " to: " + string2);
        if (this.verbose) {
            System.out.println(bundle.getString("backup-done") + " " + string);
        }
    }

    private int getToken(String string) {
        try {
            return (Integer)arguments.get(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void displayUsage() {
        System.out.println(bundle.getString("usage-am2bak"));
    }

    private void displayHelp() {
        this.displayUsage();
        System.out.println(bundle.getString("am2bak-help-where"));
        System.out.println(bundle.getString("am2bak-help-options"));
    }

    private void displayVersion() {
        String string = SystemProperties.get((String)"com.iplanet.am.version");
        System.out.println("\n" + bundle.getString("util-name") + " " + bundle.getString("util-name-value"));
        System.out.println(bundle.getString("prod-version") + " " + string);
        System.out.println(bundle.getString("product") + " " + bundle.getString("product-value"));
        System.out.println(bundle.getString("rel-state") + " " + bundle.getString("rel-state-value"));
        System.out.println(bundle.getString("legal-notice") + " " + bundle.getString("legal-notice-value"));
    }

    private void getDSLocation() throws BackupException {
        while (!this.obtainedDSLocation) {
            Object object;
            try {
                object = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                System.out.println(bundle.getString("enter-ds-location"));
                this.dsServerLocation = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new BackupException(iOException);
            }
            if (this.dsServerLocation.equals("$")) {
                this.obtainedDSLocation = true;
                this.validDSLocation = false;
                continue;
            }
            object = new File(this.dsServerLocation);
            if (!((File)object).exists() || !((File)object).isDirectory() || !new File(this.dsServerLocation + "\\config\\dse.ldif").exists()) continue;
            this.obtainedDSLocation = true;
            this.validDSLocation = true;
        }
        this.writeToInfFile("ds.location.key=" + this.dsServerLocation);
    }

    static {
        arguments.put("--verbose", new Integer(1));
        arguments.put("-v", new Integer(1));
        arguments.put("--backup", new Integer(2));
        arguments.put("-k", new Integer(2));
        arguments.put("--location", new Integer(3));
        arguments.put("-l", new Integer(3));
        arguments.put("--config", new Integer(4));
        arguments.put("-c", new Integer(4));
        arguments.put("--debug", new Integer(5));
        arguments.put("-b", new Integer(5));
        arguments.put("--log", new Integer(6));
        arguments.put("-g", new Integer(6));
        arguments.put("--cert", new Integer(7));
        arguments.put("-t", new Integer(7));
        arguments.put("--ds", new Integer(8));
        arguments.put("-d", new Integer(8));
        arguments.put("--all", new Integer(9));
        arguments.put("-a", new Integer(9));
        arguments.put("--help", new Integer(10));
        arguments.put("-h", new Integer(10));
        arguments.put("--version", new Integer(11));
        arguments.put("-n", new Integer(11));
    }
}

