/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class RoleGetNumOfUserReq
extends AdminReq {
    RoleGetNumOfUserReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Request Description: Get Num-Of-Users from Role " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("role") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("numberofusers"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("role") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("numberofusers"));
        long l = this.getNumberOfUsers(aMStoreConnection);
        AdminReq.writer.println(this.targetDN);
        AdminReq.writer.println(AdminReq.bundle.getString("numberofusers") + " " + l);
        AdminReq.writer.flush();
    }

    protected long getNumberOfUsers(AMStoreConnection aMStoreConnection) throws AdminException {
        try {
            AMRole aMRole = aMStoreConnection.getRole(this.targetDN);
            return aMRole.getNumberOfUsers();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

