/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;

class RealmUnassignServiceReq
extends AdminReq {
    private String serviceName = null;
    private String realmPath = null;

    RealmUnassignServiceReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription106") + " " + this.serviceName + " " + AdminReq.bundle.getString("fromrealm") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("realm") + "\n" + AdminReq.bundle.getString("realmUnassignSvc") + " " + this.serviceName + " " + AdminReq.bundle.getString("fromrealm") + " " + this.targetDN);
        String[] stringArray = new String[]{this.serviceName, this.realmPath};
        try {
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, this.realmPath);
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            AMIdentity aMIdentity = aMIdentityRepository.getRealmIdentity();
            Set set = organizationConfigManager.getAssignedServices(false);
            Set set2 = aMIdentity.getAssignedServices();
            boolean bl = true;
            if (set.contains(this.serviceName)) {
                this.doLog(stringArray, "UNASSIGN_SERVICE_FROM_ORGCONFIG_ATTEMPT");
                organizationConfigManager.unassignService(this.serviceName);
                this.doLog(stringArray, "UNASSIGN_SERVICE_FROM_ORGCONFIG");
                bl = false;
            }
            if (set2.contains(this.serviceName)) {
                this.doLog(stringArray, "UNASSIGN_SERVICE_FROM_REALM_ATTEMPT");
                aMIdentity.unassignService(this.serviceName);
                this.doLog(stringArray, "UNASSIGN_SERVICE_FROM_REALM");
                bl = false;
            }
            if (bl) {
                this.doLog(stringArray, "UNASSIGN_SERVICE_NOTIN_ORGCONFIG_OR_REALM");
            }
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

