/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class RealmAddAttrValsReq
extends AdminReq {
    private Set valueSet = null;
    private String realmPath = null;
    private String serviceName = null;
    private String attributeName = null;
    private Map avMap = new HashMap();

    RealmAddAttrValsReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    void setAttrName(String string) {
        this.attributeName = string;
    }

    void setValueSet(Set set) {
        this.valueSet = set;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription111") + " " + this.targetDN);
        this.avMap.put(this.attributeName, this.valueSet);
        if (this.avMap != null && !this.avMap.isEmpty()) {
            Set set = this.avMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                printWriter.println("  " + string + " =");
                Set set2 = (Set)this.avMap.get(string);
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    printWriter.println("    " + string2);
                }
            }
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("realm") + "\n" + AdminReq.bundle.getString("realmAddAttrVal") + " " + this.attributeName + " " + AdminReq.bundle.getString("inservice") + " " + this.serviceName + " " + AdminReq.bundle.getString("inrealm") + this.targetDN);
        String[] stringArray = new String[]{this.attributeName, this.serviceName, this.realmPath};
        try {
            this.doLog(stringArray, "ADD_ATTRVALS_REALM_ATTEMPT");
            OrganizationConfigManager organizationConfigManager = new OrganizationConfigManager(sSOToken, this.realmPath);
            organizationConfigManager.addAttributeValues(this.serviceName, this.attributeName, this.valueSet);
            this.doLog(stringArray, "ADD_ATTRVALS_REALM");
        }
        catch (SMSException sMSException) {
            throw new AdminException(sMSException);
        }
    }
}

