/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.SearchReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;

class OrgGetPCReq
extends SearchReq {
    private Set PCDNs = new HashSet();
    private boolean DNsOnly = true;

    public OrgGetPCReq(String string) {
        super(string);
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    boolean isDNsOnly() {
        return this.DNsOnly;
    }

    void addPCDNs(String string) {
        this.PCDNs.add(string);
    }

    Set getPCDNs() {
        return this.PCDNs;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription38") + " " + this.targetDN);
        printWriter.println("   DNsOnly = " + this.DNsOnly);
        printWriter.println("   filter = " + this.filter);
        printWriter.println("   sizeLimit = " + this.sizeLimit);
        printWriter.println("   timeLimit = " + this.timeLimit);
        if (this.PCDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.PCDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getpeoplecontainers"));
        try {
            Object object;
            Object object2;
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(this.targetDN);
            boolean bl = false;
            if (this.PCDNs.isEmpty()) {
                object2 = this.createSearchControl(2);
                object = aMOrganization.searchPeopleContainers(this.filter, (AMSearchControl)object2);
                this.PCDNs = ((AMSearchResults)object).getSearchResults();
                this.errorCode = ((AMSearchResults)object).getErrorCode();
            } else {
                bl = true;
            }
            object2 = this.PCDNs.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer((String)object);
                if (bl && (!aMPeopleContainer.isExists() || !AdminUtils.isDescendantOf(aMPeopleContainer, this.targetDN))) continue;
                AdminReq.writer.println("  " + (String)object);
                if (this.DNsOnly) continue;
                printUtils.printAVPairs(aMPeopleContainer.getAttributes(), 2);
            }
            this.printSearchLimitError();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException.toString());
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException.toString());
        }
    }
}

