/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AddDeleteReq;
import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;

class OrgDeleteSubOrgReq
extends AddDeleteReq {
    private boolean recursiveDelete = false;

    OrgDeleteSubOrgReq(String string) {
        super(string);
    }

    void setRecursiveDelete(boolean bl) {
        this.recursiveDelete = bl;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription41") + this.targetDN);
        if (this.DNSet.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.DNSet, 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        if (AdminUtils.logEnabled()) {
            AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deleteorganizations"));
        }
        AdminReq.writer.println(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deleteorganizations"));
        try {
            Iterator iterator = this.DNSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
                this.doLog(aMOrganization, "DELETE_SUBORG_ATTEMPT");
                aMOrganization.delete(this.recursiveDelete);
                AdminReq.writer.println(string);
                if (AdminUtils.logEnabled()) {
                    AdminUtils.log(AdminReq.bundle.getString("organization") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("deletedsuborganizations") + ": " + string);
                }
                this.doLog(aMOrganization, "DELETE_SUBORG");
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

