/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class IdSearchIdentitiesReq
extends AdminReq {
    private Set idPatternSet = null;
    private String realmPath = null;
    private String idPattern = null;
    private IdType idType;
    private boolean recursive = false;

    IdSearchIdentitiesReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setIdPatternSet(Set set) {
        this.idPatternSet = set;
    }

    void setIdPattern(String string) {
        this.idPattern = string;
    }

    void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription117") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("searchIdentities") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("withpattern") + " " + this.idPattern + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN);
        try {
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(this.recursive);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idPattern, idSearchControl);
            Set set = idSearchResults.getSearchResults();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMIdentity aMIdentity = (AMIdentity)iterator.next();
                AdminReq.writer.println(" " + aMIdentity.getName() + " (" + IdUtils.getUniversalId(aMIdentity) + ")");
            }
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

