/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class IdRemoveMemberReq
extends AdminReq {
    private String realmPath = null;
    private String idName = null;
    private IdType idType;
    private IdType subjectIdType;
    private String subjectIdName = null;

    IdRemoveMemberReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setSubjectIdType(IdType idType) {
        this.subjectIdType = idType;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    void setSubjectIdName(String string) {
        this.subjectIdName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription129") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("rmIdentity") + " " + this.subjectIdName + " " + AdminReq.bundle.getString("of") + " " + this.subjectIdType.toString() + " " + AdminReq.bundle.getString("asMemberOf") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN);
        String[] stringArray = new String[]{this.subjectIdName, this.subjectIdType.toString(), this.idName, this.idType.toString(), this.realmPath};
        try {
            AMIdentity aMIdentity;
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            Set set = this.idType.canAddMembers();
            if (set == null || set.size() <= 0 || !set.contains(this.subjectIdType)) {
                throw new AdminException(this.idType.toString() + " " + AdminReq.bundle.getString("canNotRemoveMembersOf") + " " + this.subjectIdType.toString());
            }
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.subjectIdType, this.subjectIdName, idSearchControl);
            Set set2 = idSearchResults.getSearchResults();
            if (set2.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.subjectIdName + " " + AdminReq.bundle.getString("of") + " " + this.subjectIdType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            AMIdentity aMIdentity2 = null;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                aMIdentity = (AMIdentity)iterator.next();
                if (aMIdentity2 != null) continue;
                aMIdentity2 = aMIdentity;
            }
            if (aMIdentity2 == null) {
                throw new AdminException(AdminReq.bundle.getString("couldNotFind") + " " + this.subjectIdName + " " + AdminReq.bundle.getString("of") + " " + this.subjectIdType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            set2 = idSearchResults.getSearchResults();
            if (set2.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            aMIdentity = null;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                AMIdentity aMIdentity3 = (AMIdentity)iterator2.next();
                if (aMIdentity != null) continue;
                aMIdentity = aMIdentity3;
            }
            if (aMIdentity == null) {
                throw new AdminException(AdminReq.bundle.getString("couldNotFind") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            this.doLog(stringArray, "REMOVE_MEMBER_IDENTITY_ATTEMPT");
            aMIdentity.removeMember(aMIdentity2);
            this.doLog(stringArray, "REMOVE_MEMBER_IDENTITY");
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

