/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class IdIsMemberReq
extends AdminReq {
    private String realmPath = null;
    private String idName = null;
    private IdType idType;
    private IdType targetIdType;
    private String targetIdName = null;

    IdIsMemberReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setTargetIdType(IdType idType) {
        this.targetIdType = idType;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    void setTargetIdName(String string) {
        this.targetIdName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription125") + " " + this.targetDN + "/" + this.targetIdName);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("identityname") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("idIsMember") + " " + this.targetIdName + " " + AdminReq.bundle.getString("of") + " " + this.targetIdType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
        Set set = this.idType.canBeMemberOf();
        if (!set.contains(this.targetIdType)) {
            throw new AdminException(this.idType.toString() + " " + AdminReq.bundle.getString("canNotBeMemberOf") + " " + this.targetIdType.toString());
        }
        try {
            AMIdentity aMIdentity;
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.targetIdType, this.targetIdName, idSearchControl);
            Set set2 = idSearchResults.getSearchResults();
            if (set2.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.targetIdName + " " + AdminReq.bundle.getString("of") + " " + this.targetIdType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            AMIdentity aMIdentity2 = null;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                aMIdentity = (AMIdentity)iterator.next();
                if (aMIdentity2 != null) continue;
                aMIdentity2 = aMIdentity;
            }
            idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            set2 = idSearchResults.getSearchResults();
            if (set2.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            aMIdentity = null;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                AMIdentity aMIdentity3 = (AMIdentity)iterator2.next();
                if (aMIdentity != null) continue;
                aMIdentity = aMIdentity3;
            }
            boolean bl = aMIdentity.isMember(aMIdentity2);
            AdminReq.writer.println(" " + bl);
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

