/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class IdGetMembersReq
extends AdminReq {
    private String realmPath = null;
    private String idName = null;
    private IdType idType;
    private IdType targetIdType;

    IdGetMembersReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setTargetIdType(IdType idType) {
        this.targetIdType = idType;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription127") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + this.targetIdType.toString() + " " + AdminReq.bundle.getString("getMembersId") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN);
        try {
            Object object;
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            Set set = this.idType.canHaveMembers();
            if (set == null || set.size() <= 0) {
                throw new AdminException(this.idType.toString() + " " + AdminReq.bundle.getString("canNotHaveMembers"));
            }
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            Set set2 = idSearchResults.getSearchResults();
            if (set2.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            Object object2 = null;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                object = (AMIdentity)iterator.next();
                if (object2 != null) continue;
                object2 = object;
            }
            if (object2 == null) {
                throw new AdminException(AdminReq.bundle.getString("couldNotFind") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            object = ((AMIdentity)object2).getMembers(this.targetIdType);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                AMIdentity aMIdentity = (AMIdentity)iterator2.next();
                String string = aMIdentity.getName();
                AdminReq.writer.println("  " + string);
            }
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

