/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class IdGetAttributesReq
extends AdminReq {
    private String realmPath = null;
    private String idName = null;
    private IdType idType;
    private Set attrSet = null;

    IdGetAttributesReq(String string) {
        super(string);
        this.realmPath = string;
        this.attrSet = new HashSet();
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    void addAttrName(String string) {
        this.attrSet.add(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription123") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("getAttrsId") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN);
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        try {
            Object object;
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            Set set = idSearchResults.getSearchResults();
            AMIdentity aMIdentity = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (AMIdentity)iterator.next();
                if (aMIdentity != null) continue;
                aMIdentity = object;
            }
            object = this.attrSet.isEmpty() ? aMIdentity.getAttributes() : aMIdentity.getAttributes(this.attrSet);
            System.out.println("  uuid = [" + IdUtils.getUniversalId(aMIdentity) + "]");
            printUtils.printAVPairs((Map)object, 1);
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

