/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

class IdGetAssignedServicesReq
extends AdminReq {
    private String realmPath = null;
    private String idName = null;
    private IdType idType = IdType.USER;

    IdGetAssignedServicesReq(String string) {
        super(string);
        this.realmPath = string;
    }

    void setIdType(IdType idType) {
        this.idType = idType;
    }

    void setIdName(String string) {
        this.idName = string;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription121") + " " + this.targetDN);
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(SSOToken sSOToken) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("identity") + "\n" + AdminReq.bundle.getString("getAssignedSvcId") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.targetDN);
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        try {
            Object object;
            AMIdentityRepository aMIdentityRepository = new AMIdentityRepository(sSOToken, this.realmPath);
            Set set = aMIdentityRepository.getAllowedIdOperations(this.idType);
            if (!set.contains(IdOperation.SERVICE)) {
                throw new AdminException(this.idType.toString() + " " + AdminReq.bundle.getString("doesNotSupportServices"));
            }
            IdSearchControl idSearchControl = new IdSearchControl();
            idSearchControl.setRecursive(false);
            IdSearchResults idSearchResults = aMIdentityRepository.searchIdentities(this.idType, this.idName, idSearchControl);
            Set set2 = idSearchResults.getSearchResults();
            if (set2.size() > 1) {
                throw new AdminException(AdminReq.bundle.getString("foundMult") + " " + this.idName + " " + AdminReq.bundle.getString("of") + " " + this.idType.toString() + " " + AdminReq.bundle.getString("inrealm") + " " + this.realmPath);
            }
            Object object2 = null;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                object = (AMIdentity)iterator.next();
                if (object2 != null) continue;
                object2 = object;
            }
            object = ((AMIdentity)object2).getAssignedServices();
            printUtils.printSet((Set)object, 1);
        }
        catch (IdRepoException idRepoException) {
            throw new AdminException(idRepoException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

