/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AddDeleteReq;
import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class GroupRemoveNestedGroupReq
extends AddDeleteReq {
    GroupRemoveNestedGroupReq(String string) {
        super(string);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription93") + " " + this.targetDN);
        if (this.DNSet.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.DNSet, 1);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        AdminReq.writer.println(AdminReq.bundle.getString("group") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("removenestedgroups"));
        try {
            AMObject aMObject = null;
            int n = aMStoreConnection.getAMObjectType(this.targetDN);
            switch (n) {
                case 12: {
                    aMObject = aMStoreConnection.getAssignableDynamicGroup(this.targetDN);
                    break;
                }
                case 10: {
                    aMObject = aMStoreConnection.getStaticGroup(this.targetDN);
                    break;
                }
                case 11: {
                    aMObject = aMStoreConnection.getDynamicGroup(this.targetDN);
                }
            }
            if (aMObject != null && aMObject.isExists()) {
                this.doLogStringSet(this.DNSet, aMObject, "REMOVE_NESTED_GROUP_FROM_GROUP_ATTEMPT");
                aMObject.removeNestedGroups(this.DNSet);
                this.doLogStringSet(this.DNSet, aMObject, "REMOVE_NESTED_GROUP_FROM_GROUP");
            }
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

