/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.admin.cli;

import com.iplanet.am.admin.cli.AdminException;
import com.iplanet.am.admin.cli.AdminReq;
import com.iplanet.am.admin.cli.AdminUtils;
import com.iplanet.am.admin.cli.SearchReq;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.PrintUtils;
import com.iplanet.sso.SSOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;

class ContGetSubContReq
extends SearchReq {
    private Set subContDNs = new HashSet();
    private boolean DNsOnly = true;

    ContGetSubContReq(String string) {
        super(string);
    }

    void setDNsOnly(boolean bl) {
        this.DNsOnly = bl;
    }

    boolean isDNsOnly() {
        return this.DNsOnly;
    }

    void addSubContDNs(String string) {
        this.subContDNs.add(string);
    }

    Set getSubContDNs() {
        return this.subContDNs;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PrintUtils printUtils = new PrintUtils(printWriter);
        printWriter.println(AdminReq.bundle.getString("requestdescription17") + " " + this.targetDN);
        printWriter.println("   DNsOnly = " + this.DNsOnly);
        printWriter.println("   filter = " + this.filter);
        printWriter.println("   sizeLimit = " + this.sizeLimit);
        printWriter.println("   timeLimit = " + this.timeLimit);
        if (this.subContDNs.isEmpty()) {
            printWriter.println("  DN set is empty");
        } else {
            printUtils.printSet(this.subContDNs, 2);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    void process(AMStoreConnection aMStoreConnection) throws AdminException {
        PrintUtils printUtils = new PrintUtils(AdminReq.writer);
        AdminReq.writer.println(AdminReq.bundle.getString("container") + " " + this.targetDN + "\n" + AdminReq.bundle.getString("getsubcontainers"));
        try {
            Object object;
            Object object2;
            boolean bl = false;
            AMOrganizationalUnit aMOrganizationalUnit = aMStoreConnection.getOrganizationalUnit(this.targetDN);
            if (this.subContDNs.isEmpty()) {
                object2 = this.createSearchControl(1);
                object = aMOrganizationalUnit.searchSubOrganizationalUnits(this.filter, (AMSearchControl)object2);
                this.subContDNs = ((AMSearchResults)object).getSearchResults();
                this.errorCode = ((AMSearchResults)object).getErrorCode();
            } else {
                bl = true;
            }
            object2 = this.subContDNs.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                AMOrganizationalUnit aMOrganizationalUnit2 = aMOrganizationalUnit.getSubOrganizationalUnit((String)object);
                if (bl && (!aMOrganizationalUnit2.isExists() || !AdminUtils.isChildOf(aMOrganizationalUnit2, this.targetDN))) continue;
                AdminReq.writer.println("  " + (String)object);
                if (this.DNsOnly) continue;
                printUtils.printAVPairs(aMOrganizationalUnit2.getAttributes(), 2);
            }
            this.printSearchLimitError();
        }
        catch (AMException aMException) {
            throw new AdminException(aMException);
        }
        catch (SSOException sSOException) {
            throw new AdminException(sSOException);
        }
    }
}

